/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bt.bh;
import bx.y;
import cn.dj;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ElliottWaveScanPattern;
import com.motivewave.platform.common.Enums$EvalMethod;
import com.motivewave.platform.common.Enums$GartleyScanPattern;
import com.motivewave.platform.common.Enums$ScanType;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.StudyCondition;
import com.motivewave.platform.databean.UpdateListener;
import com.motivewave.platform.databean.WatchListDirectory;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.an;
import com.motivewave.platform.databean.ao;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.study.Study;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import k.al;
import k.f;
import k.g;
import k.q;
import k.z;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScanInfo
extends a.b
implements o,
z {
    private int id;
    private Enums$ScanType type = Enums$ScanType.ELLIOTT_WAVE;
    private String name;
    private String config;
    private long modified;
    private List scanList = new ArrayList();
    private int minBars = 250;
    private int maxBars = 250;
    private boolean extendedData = false;
    private boolean useAllData = false;
    private boolean decomposeAll = false;
    private int decomposeLevels = 2;
    private int lookbackBars = 0;
    private List barSizes = new ArrayList();
    private Enums$ElliottWaveScanPattern ewPattern = Enums$ElliottWaveScanPattern.WAVE2;
    private Enums$GartleyScanPattern gartleyPattern = Enums$GartleyScanPattern.XABCD;
    private Enums$EvalMethod evalMethod = Enums$EvalMethod.ALL;
    private List studies = new ArrayList();
    private List conditions = new ArrayList();
    private static al listeners = new al();
    private static f allScans = new f();

    public ScanInfo() {
        this(-1);
    }

    public ScanInfo(String string) {
        this(-1);
        this.name = string;
    }

    public ScanInfo(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ScanInfo(int n2) {
        this.id = n2;
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        if (string.equals("type")) {
            return this.getType().toString();
        }
        if (string.equals("modified")) {
            return s.k(this.getModified(), b.a());
        }
        return super.format(string);
    }

    public boolean isSupported() {
        if (!com.motivewave.platform.common.an.G()) {
            return false;
        }
        if (this.getType() == Enums$ScanType.ELLIOTT_WAVE && !com.motivewave.platform.common.an.H()) {
            return false;
        }
        if (this.getType() == Enums$ScanType.GARTLEY && !com.motivewave.platform.common.an.L()) {
            return false;
        }
        return this.getType() != Enums$ScanType.STUDY || com.motivewave.platform.common.an.M();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public int getLookback() {
        return this.lookbackBars;
    }

    public void setLookback(int n2) {
        this.lookbackBars = n2;
    }

    public boolean isNew() {
        return this.id == -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Enums$ScanType getType() {
        return this.type;
    }

    public void setType(Enums$ScanType enums$ScanType) {
        this.type = enums$ScanType;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
        if (q.a(string)) {
            this.b(string);
        } else {
            this.loadFromXML(string);
        }
    }

    public long getModified() {
        return this.modified;
    }

    public void setModified(long l2) {
        this.modified = l2;
    }

    public List getScanList() {
        return this.scanList;
    }

    public void setScanList(List list) {
        this.scanList = list;
    }

    public int getMinBars() {
        return this.minBars;
    }

    public void setMinBars(int n2) {
        this.minBars = n2;
    }

    public int getMaxBars() {
        return this.maxBars;
    }

    public void setMaxBars(int n2) {
        this.maxBars = n2;
    }

    public boolean isExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(boolean bl2) {
        this.extendedData = bl2;
    }

    public boolean isUseAllData() {
        return this.useAllData;
    }

    public void setUseAllData(boolean bl2) {
        this.useAllData = bl2;
    }

    public boolean isDecomposeAll() {
        return this.decomposeAll;
    }

    public void setDecomposeAll(boolean bl2) {
        this.decomposeAll = bl2;
    }

    public int getDecomposeLevels() {
        return this.decomposeLevels;
    }

    public void setDecomposeLevels(int n2) {
        this.decomposeLevels = n2;
    }

    public List getBarSizes() {
        return this.barSizes;
    }

    public void setBarSizes(List list) {
        this.barSizes = new ArrayList(list);
    }

    public Enums$ElliottWaveScanPattern getEWPattern() {
        return this.ewPattern;
    }

    public void setEWPattern(Enums$ElliottWaveScanPattern enums$ElliottWaveScanPattern) {
        this.ewPattern = enums$ElliottWaveScanPattern;
    }

    public Enums$GartleyScanPattern getGartleyPattern() {
        return this.gartleyPattern;
    }

    public void setGartleyPattern(Enums$GartleyScanPattern enums$GartleyScanPattern) {
        this.gartleyPattern = enums$GartleyScanPattern;
    }

    public Enums$EvalMethod getEvalMethod() {
        return this.evalMethod;
    }

    public void setEvalMethod(Enums$EvalMethod enums$EvalMethod) {
        this.evalMethod = enums$EvalMethod;
    }

    public List getStudies() {
        return this.studies;
    }

    public void setStudies(List list) {
        this.studies = list;
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setConditions(List list) {
        this.conditions = list;
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.b("name", this.name), this.a("type", (Object)this.type)});
        list.add(this.a("scanList", (Collection)this.scanList));
        list.add(this.a("barSizes", (Collection)this.barSizes));
        list.add(this.a_("data", this.a(this.a("min", this.minBars, 250), this.a("max", this.maxBars, 250), this.a("ext", this.extendedData, false), this.a("useAll", this.useAllData, false))));
        if (this.type == Enums$ScanType.ELLIOTT_WAVE) {
            list.add(this.a("pattern", (Object)this.ewPattern));
            list.add(this.a_("decompose", this.a(this.a("all", this.decomposeAll, false), this.a("levels", this.decomposeLevels))));
        } else if (this.type == Enums$ScanType.GARTLEY) {
            list.add(this.a("pattern", (Object)this.gartleyPattern));
        } else if (this.type == Enums$ScanType.STUDY) {
            h.a((Collection)list, (Object[])new String[]{this.a("eval", (Object)this.evalMethod), this.a("lookback", this.lookbackBars)});
            List list2 = h.b(new String[0]);
            for (dj dj2 : this.studies) {
                list2.add(dj2.a().c_());
            }
            list.add(this.a("studies", (Collection)list2));
            list.add(this.a("conditions", (Collection)this.conditions));
        }
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.name = jSONObject.str("name");
        this.type = Enums$ScanType.valueOf(jSONObject.str("type"));
        this.scanList = new ArrayList();
        for (Object object : jSONObject.getStringList("scanList")) {
            Object object2 = WatchListDirectory.get((String)object);
            if (object2 == null) {
                object2 = MWInstrument.resolveExpiredContract(this.a((String)object));
            }
            if (object2 != null) {
                this.scanList.add(object2);
                continue;
            }
            h.a.warning("ScanInfo::fromJSON() unable to resolve instrument/watch list: " + (String)object);
        }
        this.barSizes.clear();
        for (Object object : jSONObject.getStringList("barSizes")) {
            this.barSizes.add(this.a((String)object));
        }
        JSONObject jSONObject2 = jSONObject.obj("data");
        if (jSONObject2 != null) {
            this.minBars = jSONObject2.getInt("min", 250);
            this.maxBars = jSONObject2.getInt("max", 250);
            this.extendedData = jSONObject2.is("ext", false);
            this.useAllData = jSONObject2.is("useAll", false);
        }
        if (this.type == Enums$ScanType.ELLIOTT_WAVE) {
            Object object;
            this.ewPattern = Enums$ElliottWaveScanPattern.valueOf(jSONObject.str("pattern"));
            object = jSONObject.obj("decompose");
            this.decomposeLevels = ((JSONObject)object).getInt("levels");
            this.decomposeAll = ((JSONObject)object).is("all", false);
        } else if (this.getType() == Enums$ScanType.GARTLEY) {
            this.gartleyPattern = Enums$GartleyScanPattern.valueOf(jSONObject.str("pattern"));
        } else if (this.getType() == Enums$ScanType.STUDY) {
            z z2;
            this.evalMethod = Enums$EvalMethod.valueOf(jSONObject.str("eval"));
            this.lookbackBars = jSONObject.getInt("lookback");
            this.studies.clear();
            for (Object object2 : jSONObject.getObjList("studies")) {
                z2 = new bh((JSONObject)object2);
                Study study = y.a(z2.a());
                if (study == null) {
                    h.a.warning("ScanInfo::fromJSON() unable to create study: " + z2.a());
                    continue;
                }
                this.studies.add(new dj(study, (bh)z2));
            }
            this.conditions.clear();
            for (Object object2 : jSONObject.getObjList("conditions")) {
                z2 = StudyCondition.fromJSON((JSONObject)object2, this.studies);
                if (z2 == null) continue;
                this.conditions.add(z2);
            }
        }
    }

    private void loadFromXML(String string) {
        if (h.g(string)) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            Element element = g.a(string).getDocumentElement();
            this.scanList = new ArrayList();
            for (Object object42 : g.a(g.b("scan_list", element))) {
                Object object5;
                if (h.a((Object)object42.getNodeName(), (Object)"instrument")) {
                    object3 = object42.getAttribute("symbol");
                    object5 = MWInstrument.get((String)object3, (String)(object2 = object42.getAttribute("exchange")));
                    if (object5 == null) {
                        h.a.warning("ScannerWizard::setScanInfo() unable to resolve instrument: " + (String)object3 + ":" + (String)object2);
                        continue;
                    }
                    this.scanList.add(object5);
                    continue;
                }
                if (!h.a((Object)object42.getNodeName(), (Object)"watchlist")) continue;
                int n2 = h.b(object42.getAttribute("id"));
                object2 = object42.getAttribute("name");
                object5 = WatchListDirectory.get((String)object2);
                if (object5 == null) {
                    object5 = WatchListDirectory.get(n2);
                }
                if (object5 == null) {
                    h.a.warning("ScannerWizard::setScanInfo() unable to resolve watch list: " + (String)object2);
                    continue;
                }
                this.scanList.add(object5);
            }
            if (this.getType() == Enums$ScanType.ELLIOTT_WAVE) {
                object = g.b("criteria", element);
                this.ewPattern = Enums$ElliottWaveScanPattern.valueOf(object.getAttribute("pattern"));
                object42 = g.b("data", (Node)object);
                this.minBars = h.b(object42.getAttribute("minBars"));
                this.maxBars = h.b(object42.getAttribute("maxBars"));
                this.decomposeAll = h.a((Object)object42.getAttribute("useAllData"));
                object3 = g.b("decompose", (Node)object);
                this.decomposeLevels = h.b(object3.getAttribute("levels"));
                this.decomposeAll = h.a((Object)object3.getAttribute("all"));
                object2 = object42.getAttribute("extendedData");
                if (!h.g((String)object2)) {
                    this.extendedData = h.a(object2);
                }
                this.readBarSizes((Element)object);
            } else if (this.getType() == Enums$ScanType.GARTLEY) {
                object = g.b("criteria", element);
                this.gartleyPattern = Enums$GartleyScanPattern.valueOf(object.getAttribute("pattern"));
                this.readBarSizes((Element)object);
                object42 = g.b("data", (Node)object);
                this.minBars = h.b(object42.getAttribute("minBars"));
                this.maxBars = h.b(object42.getAttribute("maxBars"));
                this.useAllData = h.a((Object)object42.getAttribute("useAllData"));
                object3 = object42.getAttribute("extendedData");
                if (!h.g((String)object3)) {
                    this.extendedData = h.a(object3);
                }
            } else if (this.getType() == Enums$ScanType.STUDY) {
                z z2;
                object = g.b("criteria", element);
                object42 = object.getAttribute("eval");
                if (!h.g((String)object42)) {
                    this.evalMethod = Enums$EvalMethod.valueOf((String)object42);
                }
                if (!h.g((String)(object42 = object.getAttribute("lookback")))) {
                    this.lookbackBars = h.b((String)object42);
                }
                if ((object3 = g.b("data", (Node)object)) != null) {
                    this.extendedData = h.a((Object)object3.getAttribute("extendedData"));
                    this.minBars = h.b(object3.getAttribute("minBars"));
                }
                this.readBarSizes((Element)object);
                this.studies = new ArrayList();
                for (Object object5 : g.c("study", g.b("studies", (Node)object))) {
                    z2 = bh.a((Element)object5);
                    if (z2 == null) continue;
                    Study study = y.a(z2.a());
                    if (study == null) {
                        h.a.warning("ScanInfo::loadFromXML() unable to create study: " + z2.a());
                        continue;
                    }
                    this.studies.add(new dj(study, (bh)z2));
                }
                this.conditions = new ArrayList();
                for (Object object5 : g.c("condition", g.b("conditions", (Node)object))) {
                    z2 = StudyCondition.read((Element)object5, this.studies);
                    if (z2 == null) continue;
                    this.conditions.add(z2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readBarSizes(Element element) {
        this.barSizes.clear();
        Node node = g.b("barSize", element);
        if (node != null) {
            this.barSizes.add(s.a((Element)node));
        } else {
            Node node2 = g.b("barSizes", element);
            for (Element element2 : g.c("barSize", node2)) {
                BarSize barSize = s.a(element2);
                if (this.barSizes.contains(barSize)) continue;
                this.barSizes.add(barSize);
            }
        }
    }

    public void update() {
        if (h.g(this.name)) {
            h.a.severe("ScanInfo::update() name is null!");
            return;
        }
        this.config = this.c_();
        ScanInfo._register(this);
        ScanInfo.notifyUpdated();
    }

    public void delete() {
        try {
            allScans.a(this);
            ScanInfo.notifyUpdated();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ScanInfo clone() {
        try {
            ScanInfo scanInfo = (ScanInfo)super.clone();
            scanInfo.studies = new ArrayList();
            if (!h.a((Collection)this.studies)) {
                for (z z2 : this.studies) {
                    scanInfo.studies.add(((dj)z2).a());
                }
            }
            scanInfo.conditions = new ArrayList();
            if (!h.a((Collection)this.conditions)) {
                for (z z2 : this.conditions) {
                    scanInfo.conditions.add(((StudyCondition)z2).clone());
                }
            }
            scanInfo.barSizes = new ArrayList(this.barSizes);
            scanInfo.scanList = new ArrayList(this.scanList);
            return scanInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ScanInfo scanInfo = (ScanInfo)object;
            if (scanInfo.type != this.type) {
                return false;
            }
            if (!h.a((Object)this.name, (Object)scanInfo.name)) {
                return false;
            }
            if (!h.c(this.scanList, scanInfo.scanList)) {
                return false;
            }
            if (this.minBars != scanInfo.minBars) {
                return false;
            }
            if (this.maxBars != scanInfo.maxBars) {
                return false;
            }
            if (this.extendedData != scanInfo.extendedData) {
                return false;
            }
            if (this.useAllData != scanInfo.useAllData) {
                return false;
            }
            if (this.decomposeAll != scanInfo.decomposeAll) {
                return false;
            }
            if (this.decomposeLevels != scanInfo.decomposeLevels) {
                return false;
            }
            if (h.c(this.barSizes, scanInfo.barSizes)) {
                return false;
            }
            if (this.ewPattern != scanInfo.ewPattern) {
                return false;
            }
            if (this.gartleyPattern != scanInfo.gartleyPattern) {
                return false;
            }
            if (this.evalMethod != scanInfo.evalMethod) {
                return false;
            }
            if (this.lookbackBars != scanInfo.lookbackBars) {
                return false;
            }
            if (!h.c(this.studies, scanInfo.studies)) {
                return false;
            }
            return h.c(this.conditions, scanInfo.conditions);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void addListener(UpdateListener updateListener) {
        listeners.a(updateListener);
    }

    public static void removeListener(UpdateListener updateListener) {
        listeners.b(updateListener);
    }

    private static void notifyUpdated() {
        for (UpdateListener updateListener : listeners.a()) {
            updateListener.updated();
        }
    }

    public static void read(File file) {
        allScans.b();
        String string = h.a(file);
        if (h.g(string)) {
            return;
        }
        try {
            if (q.a(string)) {
                ArrayList<ScanInfo> arrayList = new ArrayList<ScanInfo>();
                for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                    arrayList.add(new ScanInfo(jSONObject));
                }
                allScans.d(arrayList);
                ScanInfo.notifyUpdated();
            } else {
                ScanInfo.readScans(g.a(string));
            }
        }
        catch (Exception exception) {
            h.a.warning("ScanInfo::load() error reading scans: " + exception.getMessage() + " " + string);
            exception.printStackTrace();
        }
    }

    public static void readScans(Element element) {
        Node node = g.b("scans", element);
        if (node == null && h.a((Object)element.getTagName(), (Object)"scans")) {
            node = element;
        }
        if (node == null) {
            h.a.warning("MWUtil::readScans() scans tag not found");
            return;
        }
        List list = g.c("scan_wrapper", node);
        if (h.a((Collection)list)) {
            return;
        }
        for (Element element2 : list) {
            try {
                Node node2 = g.b("scan", element2);
                if (node2 == null) continue;
                String string = element2.getAttribute("name");
                ScanInfo scanInfo = ScanInfo.find(string);
                if (scanInfo == null) {
                    scanInfo = new ScanInfo(string);
                }
                Enums$ScanType enums$ScanType = Enums$ScanType.valueOf(node2.getAttribute("type"));
                scanInfo.setType(enums$ScanType);
                scanInfo.setConfig(g.a(node2));
                scanInfo.update();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void read() {
        allScans.b();
        File file = Workspace.findFile("scans");
        if (file != null) {
            ScanInfo.read(file);
        } else if (Workspace.hasDB()) {
            try {
                com.motivewave.common.command.b b2 = CommandFactory.createCmd("LOAD_SCANS");
                allScans.d((List)b2.a());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ScanInfo.notifyUpdated();
    }

    public static void saveAll() {
        h.c(new File(Workspace.findDir("scans"), "scans.json"), new an().b(ScanInfo.getAll()));
    }

    public static void saveAll(File file) {
        h.a(new File(file, "scans.json"), new ao().b(ScanInfo.getAll()));
    }

    public static void remove(ScanInfo scanInfo) {
        allScans.a(scanInfo);
        scanInfo.delete();
        ScanInfo.notifyUpdated();
    }

    public static ScanInfo find(String string) {
        for (ScanInfo scanInfo : allScans.a()) {
            if (!h.a((Object)scanInfo.getName(), (Object)string) || !scanInfo.isSupported()) continue;
            return scanInfo;
        }
        return null;
    }

    public static ScanInfo find(int n2) {
        for (ScanInfo scanInfo : allScans.a()) {
            if (n2 != scanInfo.getId() || !scanInfo.isSupported()) continue;
            return scanInfo;
        }
        return null;
    }

    public static void register(ScanInfo scanInfo) {
        if (ScanInfo._register(scanInfo)) {
            ScanInfo.notifyUpdated();
        }
    }

    private static boolean _register(ScanInfo scanInfo) {
        ScanInfo scanInfo2 = null;
        for (ScanInfo scanInfo3 : allScans.a()) {
            if (scanInfo3 == scanInfo) {
                return false;
            }
            if (!h.a((Object)scanInfo3.getName(), (Object)scanInfo.getName())) continue;
            scanInfo2 = scanInfo3;
        }
        if (scanInfo2 != null) {
            allScans.a(scanInfo2);
        }
        allScans.a(scanInfo);
        return true;
    }

    public static List getAll() {
        ArrayList<ScanInfo> arrayList = new ArrayList<ScanInfo>();
        for (ScanInfo scanInfo : allScans.a()) {
            if (!scanInfo.isSupported() || h.g(scanInfo.getName())) continue;
            arrayList.add(scanInfo);
        }
        return arrayList;
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScanInfo scanInfo : allScans.a()) {
            if (scanInfo == null) continue;
            arrayList.add(scanInfo.getName());
        }
        return arrayList;
    }

    public static void clear() {
        allScans.b();
    }
}

