/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ChartLink;
import com.motivewave.platform.common.Enums$ReplayData;
import com.motivewave.platform.common.an;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.service.ae;
import java.util.List;
import k.q;
import k.z;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class ReplaySettings
implements q,
z {
    public static final int MAX_TICK_BAR_SIZE = 1440;
    public static final int MAX_MINUTE_BAR_SIZE = 1440;
    private Enums$ReplayData sourceData = Enums$ReplayData.BAR;
    private boolean generateTicks = false;
    private boolean playTillPriceUpdate = true;
    private boolean realDelay = false;
    private double speedFactor = 1.0;
    private int tickDelay = 0;
    private int barDelay = 200;
    private Enums$ChartLink chartLink = Enums$ChartLink.LINK_ALL;
    private String accountID;
    private String baseCurrency = null;
    private double cashBalance = 100000.0;
    private boolean accountEnabled = true;
    private boolean includeCommission = true;
    private static int cAccountID = 1;

    public ReplaySettings(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ReplaySettings() {
    }

    public ReplaySettings(Element element) {
        this.read(element);
    }

    @Override
    public ReplaySettings clone() {
        try {
            ReplaySettings replaySettings = (ReplaySettings)super.clone();
            return replaySettings;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.a("chartLink", (Object)this.chartLink, (Object)Enums$ChartLink.LINK_ALL), this.a("sourceData", (Object)this.sourceData, (Object)Enums$ReplayData.BAR), this.a("tickDelay", this.tickDelay, 0), this.a("generateTicks", this.generateTicks, false), this.a("realDelay", this.realDelay, false), this.a("playTillPriceUpdate", this.playTillPriceUpdate, true), this.a("speedFactor", this.speedFactor, 1.0), this.a("barDelay", this.barDelay, 200), this.a("accountEnabled", this.accountEnabled, true), this.b("baseCurrency", this.baseCurrency), this.a("cashBalance", this.cashBalance, 100000.0), this.a("includeCommissions", this.includeCommission, true)});
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        try {
            this.chartLink = Enums$ChartLink.valueOf(jSONObject.str("chartLink"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sourceData = Enums$ReplayData.valueOf(jSONObject.str("sourceData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tickDelay = jSONObject.getInt("tickDelay", 0);
        this.generateTicks = jSONObject.is("generateTicks", false);
        this.playTillPriceUpdate = jSONObject.is("playTillPriceUpdate", true);
        this.realDelay = jSONObject.is("realDelay", false);
        this.speedFactor = jSONObject.getDouble("speedFactor", 1.0);
        this.barDelay = jSONObject.getInt("barDelay", 200);
        this.accountEnabled = jSONObject.is("accountEnabled", true);
        this.baseCurrency = jSONObject.str("baseCurrency");
        this.cashBalance = jSONObject.getDouble("cashBalance", 100000.0);
        this.includeCommission = jSONObject.is("includeCommissions", true);
    }

    public void read(Element element) {
        if (element == null) {
            return;
        }
        String string = element.getAttribute("useTickData");
        if (!h.g(string)) {
            boolean bl2 = h.a((Object)string);
            this.sourceData = bl2 ? Enums$ReplayData.TICK : Enums$ReplayData.MINUTE;
        }
        this.tickDelay = h.b(element.getAttribute("tickDelay"));
        this.barDelay = h.b(element.getAttribute("barDelay"));
        string = element.getAttribute("sourceData");
        if (!h.g(string)) {
            this.sourceData = Enums$ReplayData.valueOf(string);
        }
        if (!h.g(string = element.getAttribute("generateTicks"))) {
            this.generateTicks = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("realDelay"))) {
            this.realDelay = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("speedFactor"))) {
            this.speedFactor = h.a(h.a(string), 2);
        }
        if (!h.g(string = element.getAttribute("chartLink"))) {
            this.chartLink = Enums$ChartLink.valueOf(string);
        }
        if (!h.g(string = element.getAttribute("accountEnabled"))) {
            this.accountEnabled = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("baseCurrency"))) {
            this.baseCurrency = string;
        }
        if (!h.g(string = element.getAttribute("cashBalance"))) {
            this.cashBalance = h.a(string);
        }
        if (!h.g(string = element.getAttribute("includeCommissions"))) {
            this.includeCommission = h.a((Object)string);
        }
    }

    public Enums$ReplayData getSourceData(BarSize barSize) {
        if (barSize.getIntervalType() == Enums.IntervalType.SECOND) {
            return Enums$ReplayData.TICK;
        }
        int n2 = barSize.getIntervalMinutes();
        if (n2 > 1440) {
            return Enums$ReplayData.BAR;
        }
        if (n2 > 1440 && this.sourceData == Enums$ReplayData.TICK) {
            return Enums$ReplayData.MINUTE;
        }
        return this.sourceData;
    }

    public Enums$ReplayData getSourceData() {
        return this.sourceData;
    }

    public void setSourceData(Enums$ReplayData enums$ReplayData) {
        this.sourceData = enums$ReplayData;
    }

    public boolean isUseTickData() {
        return this.sourceData == Enums$ReplayData.TICK;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(int n2) {
        this.tickDelay = n2;
    }

    public int getBarDelay() {
        return this.barDelay;
    }

    public void setBarDelay(int n2) {
        this.barDelay = n2;
    }

    public boolean isGenerateTicks() {
        return this.generateTicks;
    }

    public void setGenerateTicks(boolean bl2) {
        this.generateTicks = bl2;
    }

    public boolean isRealDelay() {
        return this.realDelay;
    }

    public void setRealDelay(boolean bl2) {
        this.realDelay = bl2;
    }

    public double getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(double d2) {
        this.speedFactor = d2;
    }

    public Enums$ChartLink getChartLink() {
        return this.chartLink;
    }

    public void setChartLink(Enums$ChartLink enums$ChartLink) {
        this.chartLink = enums$ChartLink;
    }

    public boolean isPlayTillPriceUpdate() {
        return this.playTillPriceUpdate;
    }

    public void setPlayTillPriceUpdate(boolean bl2) {
        this.playTillPriceUpdate = bl2;
    }

    public String getAccountID() {
        if (h.g(this.accountID)) {
            this.accountID = "REPLAY-" + cAccountID;
            ++cAccountID;
        }
        return this.accountID;
    }

    public boolean isAccountEnabled() {
        return this.accountEnabled && an.k();
    }

    public void setAccountEnabled(boolean bl2) {
        this.accountEnabled = bl2;
    }

    public String getBaseCurrency() {
        if (h.g(this.baseCurrency)) {
            String string = ae.b();
            if (h.g(string)) {
                return "USD";
            }
            return string;
        }
        return this.baseCurrency;
    }

    public void setBaseCurrency(String string) {
        this.baseCurrency = string;
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double d2) {
        this.cashBalance = d2;
    }

    public boolean isIncludeCommission() {
        return this.includeCommission;
    }

    public void setIncludeCommission(boolean bl2) {
        this.includeCommission = bl2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReplaySettings)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReplaySettings replaySettings = (ReplaySettings)object;
        return replaySettings.sourceData == this.sourceData && replaySettings.tickDelay == this.tickDelay && replaySettings.generateTicks == this.generateTicks && replaySettings.realDelay == this.realDelay && replaySettings.speedFactor == this.speedFactor && replaySettings.barDelay == this.barDelay && replaySettings.chartLink == this.chartLink && replaySettings.accountEnabled == this.accountEnabled && h.a((Object)replaySettings.getBaseCurrency(), (Object)this.getBaseCurrency()) && replaySettings.cashBalance == this.cashBalance && replaySettings.includeCommission == this.includeCommission;
    }
}

