/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionSummary;
import com.motivewave.platform.databean.PositionTotal;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.am;
import com.motivewave.platform.service.ae;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import k.f;
import q.g;

public class PositionDirectory {
    private static Map directory = new HashMap();
    private static f allPositions = new f();
    private static Map summaryDirectory = new HashMap();
    private static Map instrument2Position = new HashMap();
    private static f listeners = new f();
    private static Map plListeners = new HashMap();
    private static InstrumentListener instrListener = new am();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByAccount(String string) {
        Iterator iterator2;
        for (Iterator iterator2 : PositionDirectory.getByAccount(string)) {
            PositionDirectory.remove((Position)((Object)iterator2));
        }
        ArrayList arrayList = new ArrayList();
        iterator2 = summaryDirectory;
        synchronized (iterator2) {
            for (Object object : new ArrayList(summaryDirectory.keySet())) {
                Object object2 = (PositionSummary)summaryDirectory.get(object);
                if (object2 == null || !h.a((Object)((PositionSummary)object2).getAccountId(), (Object)string)) continue;
                arrayList.add(object2);
                summaryDirectory.remove(object);
            }
        }
        iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            PositionSummary positionSummary = (PositionSummary)iterator2.next();
            for (Object object2 : listeners.a()) {
                try {
                    object2.b(positionSummary);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            positionSummary.destroy();
        }
    }

    public static void updateTickerPosition(Ticker ticker) {
        if (!(ticker instanceof LiveTicker)) {
            return;
        }
        LiveTicker liveTicker = (LiveTicker)ticker;
        List list = PositionDirectory.getByInstrument(liveTicker.getInstrument());
        if (h.a((Collection)list)) {
            liveTicker.setPosition(0.0f);
            liveTicker.setAvgPrice(0.0f);
            liveTicker.updateUnrealizedPnL();
        } else {
            float f2 = 0.0f;
            int n2 = 0;
            for (Position position : list) {
                if (position.isReplay() || !position.isOpen()) continue;
                n2 = (int)((float)n2 + position.getQuantity());
                f2 += position.getQuantity() * position.getAvgPrice();
            }
            if (f2 == 0.0f) {
                liveTicker.setPosition(0.0f);
                liveTicker.setAvgPrice(0.0f);
            } else {
                liveTicker.setPosition(n2);
                liveTicker.setAvgPrice(f2 / (float)n2);
            }
            liveTicker.updateUnrealizedPnL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getByInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        Map map = instrument2Position;
        synchronized (map) {
            f f2 = (f)instrument2Position.get(mWInstrument);
            if (f2 == null) {
                f2 = new f();
                instrument2Position.put(mWInstrument, f2);
            }
            return f2.a();
        }
    }

    public static List getByInstrument(MWInstrument mWInstrument, String string) {
        List list = PositionDirectory.getByInstrument(mWInstrument);
        if (h.a((Collection)list)) {
            return list;
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : list) {
            if (!h.a((Object)position.getAccountId(), (Object)string)) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    public static List getByAccount(String string) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : PositionDirectory.getAll()) {
            if (!h.a((Object)position.getAccountId(), (Object)string)) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    public static float getPosition(MWInstrument mWInstrument, Account account) {
        if (account == null) {
            account = ae.a(mWInstrument);
        }
        if (account == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        if (mWInstrument == null) {
            return 0.0f;
        }
        boolean bl2 = account.isGroupAccount();
        String string = account.getAccountID();
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || !position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            f2 += position.getQuantity();
        }
        return f2;
    }

    public static double getPL(MWInstrument mWInstrument, Account account) {
        if (mWInstrument == null || account == null) {
            return 0.0;
        }
        boolean bl2 = account.isGroupAccount();
        double d2 = 0.0;
        String string = account.getAccountID();
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || !position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            d2 += position.getUnrealizedPnL();
        }
        return h.a(d2, 4);
    }

    public static double getPL(MWInstrument mWInstrument, String string) {
        if (mWInstrument == null) {
            return 0.0;
        }
        Account account = ae.a(string);
        boolean bl2 = account != null && account.isGroupAccount();
        double d2 = 0.0;
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || !position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            d2 += position.getUnrealizedPnL();
        }
        return h.a(d2, 4);
    }

    public static double getRealizedPL(MWInstrument mWInstrument, Account account) {
        if (mWInstrument == null || account == null) {
            return 0.0;
        }
        boolean bl2 = account.isGroupAccount();
        double d2 = 0.0;
        String string = account.getAccountID();
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            d2 += position.getPnl();
        }
        return h.a(d2, 4);
    }

    public static double getRealizedPL(MWInstrument mWInstrument, String string) {
        if (mWInstrument == null) {
            return 0.0;
        }
        Account account = ae.a(string);
        boolean bl2 = account != null && account.isGroupAccount();
        double d2 = 0.0;
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            d2 += position.getPnl();
        }
        return h.a(d2, 4);
    }

    public static float getAvgPrice(MWInstrument mWInstrument, Account account) {
        if (mWInstrument == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = account != null && account.isGroupAccount();
        String string = account == null ? null : account.getAccountID();
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (position == null || !position.isOpen() || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !bl2 && !h.a((Object)position.getAccountId(), (Object)string) && !h.g(string)) continue;
            if (position.getQuantity() > 0.0f) {
                f2 += position.getQuantity() * position.getAvgPrice();
                n2 = (int)((float)n2 + position.getQuantity());
                continue;
            }
            f3 += position.getQuantity() * position.getAvgPrice();
            n3 = (int)((float)n3 + position.getQuantity());
        }
        if (n2 == 0 && n3 == 0) {
            return 0.0f;
        }
        if (n2 == 0) {
            return Math.abs(f3 / (float)n3);
        }
        if (n3 == 0) {
            return Math.abs(f2 / (float)n2);
        }
        double d2 = f2 / (float)n2;
        double d3 = f3 / (float)n3;
        double d4 = mWInstrument.calcPnL(d2, n2) + mWInstrument.calcPnL(d3, n3);
        return (float)mWInstrument.calcRawMove(d4, n2 + n3);
    }

    public static Position findByInstrument(MWInstrument mWInstrument, String string) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        Account account = ae.a(string);
        boolean bl2 = account != null && account.isGroupAccount();
        for (Position position : PositionDirectory.getAll()) {
            if (!position.isOpen() || position.getInstrument() != mWInstrument || position.isReplay() && !h.a((Object)position.getAccountId(), (Object)string) || !h.a((Object)position.getAccountId(), (Object)string) && !bl2) continue;
            arrayList.add(position);
        }
        if (h.a(arrayList)) {
            return null;
        }
        if (arrayList.size() > 1) {
            h.a.warning("PositionDirectory::findByInstrument() multiple positions found for: " + mWInstrument.getKey() + " acct: " + string);
        }
        return (Position)arrayList.get(0);
    }

    public static List getOpen(MWInstrument mWInstrument) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (mWInstrument == null) {
            for (Position position : PositionDirectory.getAll()) {
                if (!position.isOpen()) continue;
                arrayList.add(position);
            }
            return arrayList;
        }
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (arrayList.contains(position) || !position.isOpen()) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    public static List getOpen(MWInstrument mWInstrument, String string) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (mWInstrument == null) {
            for (Position position : PositionDirectory.getAll()) {
                if (!position.isOpen() || !h.a((Object)string, (Object)position.getAccountId())) continue;
                arrayList.add(position);
            }
            return arrayList;
        }
        for (Position position : PositionDirectory.getByInstrument(mWInstrument)) {
            if (arrayList.contains(position) || !position.isOpen() || !h.a((Object)string, (Object)position.getAccountId())) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    public static List getAll() {
        return allPositions.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllSummaries() {
        if (summaryDirectory == null) {
            return new ArrayList();
        }
        Map map = summaryDirectory;
        synchronized (map) {
            return new ArrayList(summaryDirectory.values());
        }
    }

    public static List getOpen() {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : PositionDirectory.getAll()) {
            if (!position.isOpen()) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    public static List getClosed() {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : PositionDirectory.getAll()) {
            if (!position.isClosed()) continue;
            arrayList.add(position);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Position find(String string) {
        Map map = directory;
        synchronized (map) {
            return (Position)directory.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePositions(List list, List list2) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        ArrayList<Position> arrayList3 = new ArrayList<Position>();
        ArrayList<Position> arrayList4 = new ArrayList<Position>();
        for (Position positionBase : list) {
            Position position = PositionDirectory.find(positionBase.getId());
            if (position == null) {
                arrayList.add(positionBase);
                continue;
            }
            if (position.isOpen() != positionBase.isOpen() || position.getQuantity() != positionBase.getQuantity() || position.getAvgPrice() != positionBase.getAvgPrice() || position.getClosedQuantity() != positionBase.getClosedQuantity() || position.getEntryPrice() != positionBase.getEntryPrice()) {
                arrayList2.add(positionBase);
            }
            if (!position.isOpen() || !positionBase.isClosed()) continue;
            arrayList4.add(positionBase);
        }
        for (Position position : PositionDirectory.getAll()) {
            if (!PositionDirectory.in(position.getAccountId(), list2)) continue;
            boolean bl2 = false;
            for (Position position2 : list) {
                if (!h.a((Object)position2.getId(), (Object)position.getId())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList3.add(position);
        }
        for (Position position : arrayList) {
            PositionDirectory.created(position);
        }
        for (Position position : arrayList2) {
            PositionDirectory.updated(position);
        }
        for (Position position : arrayList3) {
            PositionDirectory.remove(position);
        }
        for (Position position : arrayList4) {
            PositionDirectory.closed(position);
        }
        for (PositionSummary positionSummary : PositionDirectory.getAllSummaries()) {
            if (!PositionDirectory.in(positionSummary.getAccountId(), list2)) continue;
            positionSummary.refresh();
            if (positionSummary.hasPositions()) continue;
            Map map = summaryDirectory;
            synchronized (map) {
                summaryDirectory.remove(PositionDirectory.psKey(positionSummary));
            }
            for (Object object : listeners.a()) {
                try {
                    object.b(positionSummary);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            positionSummary.destroy();
        }
    }

    private static boolean in(String string, List list) {
        if (h.g(string) || h.a((Collection)list)) {
            return false;
        }
        for (Account account : list) {
            if (!h.a((Object)account.getAccountID(), (Object)string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void created(Position position) {
        if (position == null || directory == null) {
            return;
        }
        Position position2 = null;
        Map map = directory;
        synchronized (map) {
            position2 = (Position)directory.get(position.getId());
            if (position2 == null) {
                directory.put(position.getId(), position);
                allPositions.a(position);
            }
        }
        if (position2 != null) {
            PositionDirectory.updated(position2);
            return;
        }
        PositionDirectory.map2Instrument(position);
        PositionDirectory.updateTickerPosition(position.getTicker());
        position.resolveOrders();
        boolean bl2 = false;
        PositionSummary positionSummary = PositionDirectory.getSummary(position);
        if (position.isOpen()) {
            if (positionSummary == null) {
                bl2 = true;
                positionSummary = new PositionSummary(position.getTicker(), position.getAccountId());
                positionSummary.addOrUpdate(position);
                positionSummary.update();
                positionSummary.setNetLimitOrder(OrderDirectory.findNetLimitOrder(positionSummary.getInstrument(), position.getAccountId()));
                positionSummary.setNetStopTrailOrder(OrderDirectory.findNetStopOrder(positionSummary.getInstrument(), position.getAccountId()));
                Map map2 = summaryDirectory;
                synchronized (map2) {
                    summaryDirectory.put(PositionDirectory.psKey(positionSummary), positionSummary);
                }
                position.getInstrument().addListener(instrListener);
            } else {
                positionSummary.addOrUpdate(position);
                positionSummary.update();
            }
        }
        OrderDirectory.addListener(position);
        PositionTotal.getInstance().add(position);
        for (q.h h2 : listeners.a()) {
            try {
                h2.a(position);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl2) {
            OrderDirectory.addListener(positionSummary);
            for (q.h h2 : listeners.a()) {
                try {
                    h2.a(positionSummary);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Position position) {
        if (position == null) {
            return;
        }
        Position position2 = null;
        Object object = directory;
        synchronized (object) {
            position2 = (Position)directory.remove(position.getId());
            if (position2 != null && position2 != position) {
                allPositions.a(position2);
                PositionTotal.getInstance().remove(position2);
                position2.destroy();
            }
            allPositions.a(position);
        }
        if (position2 != null && position.getInstrument() != null) {
            object = instrument2Position;
            synchronized (object) {
                f f2 = (f)instrument2Position.get(position.getInstrument());
                if (f2 != null) {
                    for (Object object2 : f2.a()) {
                        if (object2 != position && !h.a((Object)((Position)object2).getId(), (Object)position.getId())) continue;
                        f2.a(position);
                    }
                }
            }
        }
        if (position2 == null) {
            PositionDirectory.updateTickerPosition(position.getTicker());
            return;
        }
        object = PositionDirectory.getSummary(position);
        boolean bl2 = false;
        if (object != null) {
            ((PositionSummary)object).remove(position);
            ((PositionSummary)object).update();
            if (!((PositionSummary)object).hasPositions()) {
                bl2 = true;
                Iterator iterator = summaryDirectory;
                synchronized (iterator) {
                    summaryDirectory.remove(PositionDirectory.psKey((PositionSummary)object));
                }
            }
        }
        PositionDirectory.updateTickerPosition(position.getTicker());
        PositionTotal.getInstance().remove(position);
        for (Object object2 : listeners.a()) {
            try {
                object2.d(position);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        position.destroy();
        if (bl2) {
            for (Object object2 : listeners.a()) {
                try {
                    object2.b((PositionSummary)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ((PositionSummary)object).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closed(Position position) {
        if (position == null) {
            return;
        }
        Object object = directory;
        synchronized (object) {
            Position position2 = directory.put(position.getId(), position);
            if (position2 != null && position2 != position) {
                allPositions.a(position2);
                PositionTotal.getInstance().remove(position2);
                position2.destroy();
                PositionTotal.getInstance().add(position);
            }
            allPositions.a(position);
        }
        object = PositionDirectory.getSummary(position);
        boolean bl2 = false;
        if (object != null) {
            ((PositionSummary)object).remove(position);
            ((PositionSummary)object).update();
            if (!((PositionSummary)object).hasPositions()) {
                bl2 = true;
                Iterator iterator = summaryDirectory;
                synchronized (iterator) {
                    summaryDirectory.remove(PositionDirectory.psKey((PositionSummary)object));
                }
            }
        }
        OrderDirectory.addListener(position);
        PositionDirectory.updateTickerPosition(position.getTicker());
        PositionTotal.getInstance().update();
        for (q.h h2 : listeners.a()) {
            try {
                h2.c(position);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl2) {
            for (q.h h2 : listeners.a()) {
                try {
                    h2.b((PositionSummary)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ((PositionSummary)object).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void map2Instrument(Position position) {
        if (position == null || position.getInstrument() == null) {
            return;
        }
        Map map = instrument2Position;
        synchronized (map) {
            f f2 = (f)instrument2Position.get(position.getInstrument());
            if (f2 == null) {
                f2 = new f();
                instrument2Position.put(position.getInstrument(), f2);
            }
            for (Position position2 : f2.a()) {
                if (!h.a((Object)position2.getId(), (Object)position.getId()) || position2 == position) continue;
                f2.a(position2);
            }
            if (!f2.b(position)) {
                f2.a(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updated(Position position) {
        if (position == null) {
            return;
        }
        Object object = directory;
        synchronized (object) {
            Position position2 = directory.put(position.getId(), position);
            if (position2 != null && position2 != position) {
                allPositions.a(position2);
                PositionTotal.getInstance().remove(position2);
                position2.destroy();
                PositionTotal.getInstance().add(position);
            }
            allPositions.a(position);
        }
        PositionDirectory.map2Instrument(position);
        PositionDirectory.updateTickerPosition(position.getTicker());
        position.resolveOrders();
        object = PositionDirectory.getSummary(position);
        if (object != null) {
            ((PositionSummary)object).addOrUpdate(position);
            ((PositionSummary)object).update();
        }
        OrderDirectory.addListener(position);
        PositionTotal.getInstance().update();
        for (q.h h2 : listeners.a()) {
            try {
                h2.b(position);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void addListener(q.h h2) {
        listeners.a(h2);
    }

    public static void removeListener(q.h h2) {
        listeners.a(h2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPLListener(MWInstrument mWInstrument, String string, g g2) {
        if (mWInstrument == null) {
            return;
        }
        f f2 = null;
        Map map = plListeners;
        synchronized (map) {
            f2 = (f)plListeners.get(mWInstrument.getKey() + ":" + string);
            if (f2 == null) {
                f2 = new f();
                plListeners.put(mWInstrument.getKey() + ":" + string, f2);
                mWInstrument.addListener(instrListener);
            }
        }
        f2.a(g2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePLListener(g g2) {
        Map map = plListeners;
        synchronized (map) {
            for (f f2 : plListeners.values()) {
                if (f2 == null) continue;
                f2.a(g2);
            }
        }
    }

    public static PositionSummary getSummary(Position position) {
        if (position == null) {
            return null;
        }
        return PositionDirectory.getSummary(position.getInstrument(), position.getAccountId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PositionSummary getSummary(MWInstrument mWInstrument, String string) {
        Map map = summaryDirectory;
        synchronized (map) {
            return (PositionSummary)summaryDirectory.get(mWInstrument.getKey() + ":" + string);
        }
    }

    private static String psKey(PositionSummary positionSummary) {
        if (positionSummary == null) {
            return null;
        }
        return positionSummary.getInstrument().getKey() + ":" + positionSummary.getAccountId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyPLUpdate(MWInstrument mWInstrument, String string) {
        if (mWInstrument == null) {
            return;
        }
        f f2 = null;
        Map map = plListeners;
        synchronized (map) {
            f2 = (f)plListeners.get(mWInstrument.getKey() + ":" + string);
        }
        if (f2 == null || f2.a()) {
            return;
        }
        double d2 = PositionDirectory.getPL(mWInstrument, string);
        for (g g2 : f2.a()) {
            g2.plUpdate(mWInstrument, string, d2);
        }
    }

    static /* synthetic */ Map access$000() {
        return plListeners;
    }

    static /* synthetic */ Map access$100() {
        return summaryDirectory;
    }
}

