/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.PositionBase;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.json.JSONObject;
import org.w3c.dom.Element;
import q.c;

public class Position
extends PositionBase
implements o,
PropertyChangeListener,
Comparable,
c {
    public static final String F_CLOSE_SELL_PRICE = "closeSellPrice";
    public static final String F_CLOSE_BUY_PRICE = "closeBuyPrice";
    public static final String F_UNREALIZED_PNL = "unrealizedPnL";
    public static final String F_PIPS = "pips";
    public static final String F_QUANTITY = "quantity";
    public static final String F_CLOSED_QUANTITY = "closedQuantity";
    public static final String F_AVG_PRICE = "avgPrice";
    public static final String F_MARKET_VALUE = "marketValue";
    public static final String F_PNL = "pnl";
    public static final String F_NET_PNL = "netPnl";
    private String positionId;
    private float quantity;
    private float closedQuantity;
    private float avgPrice;
    private double marketValue;
    private double rawMarketValue;
    private String accountId;
    private String openingOrderId;
    private String closeOrderId;
    private long openTime = 0L;
    private boolean open;
    private float avgClosePrice;
    private double pnl;
    private double unrealizedPnL;
    private double rawUnrealizedPnL;
    private double commission;
    private double initialMargin;
    private double maintenanceMargin;
    private double interest;
    private long closeTime = 0L;
    private String confirmationNumber;
    private String dealSequence;
    private String counter;
    private String transactionId;
    private float roll;
    private MWOrder stopTrailOrder;
    private MWOrder limitOrder;

    public Position(JSONObject jSONObject) {
        super(null);
        this.fromJSON(jSONObject);
    }

    public Position(String string, String string2, String string3, Ticker ticker, boolean bl2) {
        super(ticker);
        this.positionId = string;
        this.accountId = string2;
        this.openingOrderId = string3;
        this.open = bl2;
        this.openTime = ae.a();
        if (bl2) {
            if (ticker != null) {
                ticker.addPropertyChangeListener(this);
            } else {
                System.err.println("creating position (ticker is null) : " + string + " " + string2);
                h.c();
            }
            OrderDirectory.addListener(this);
            this.updateUnrealizedPnL();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        OrderDirectory.removeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (h.a(string, "bidPrice", "askPrice", "lastPrice", F_AVG_PRICE, "lastTimestamp", "high", "low", F_PIPS, "spread", "roll", "open", "close")) {
            this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (!this.isOpen()) {
            return;
        }
        if (this.ignorePLUpdate(string)) {
            return;
        }
        float f2 = this.getCurrentPrice();
        long l2 = (this.ticker == null ? System.currentTimeMillis() : this.ticker.getLastUpdate(propertyChangeEvent.getPropertyName())) / 200L * 200L;
        if (l2 - this.lastPlUpdate < 200L) {
            int n2 = (int)((double)Math.abs(this.lastPlPrice - f2) / this.ticker.getTickSize());
            if (this.plUpdateCount > 1 && n2 < 3) {
                return;
            }
            ++this.plUpdateCount;
            this.lastPlPrice = f2;
            this.updateUnrealizedPnL();
            this.updateMarketValue();
            return;
        }
        this.lastPlUpdate = l2;
        this.lastPlPrice = f2;
        this.plUpdateCount = 0;
        this.updateUnrealizedPnL();
        this.updateMarketValue();
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.b("id", this.positionId), this.b("accountId", this.accountId), this.a("instr", this.getInstrument()), this.a(F_QUANTITY, this.quantity), this.a(F_CLOSED_QUANTITY, this.closedQuantity), this.a(F_AVG_PRICE, this.avgPrice), this.a_("openTime", this.openTime), this.a_("closeTime", this.closeTime), this.a("avgClosePrice", this.avgClosePrice), this.a("commission", this.commission), this.a("open", this.open), this.a(F_PNL, this.pnl)});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        MWInstrument mWInstrument = this.a(jSONObject, "instr");
        this.ticker = LiveTicker.get(mWInstrument);
        this.positionId = jSONObject.str("id");
        this.accountId = jSONObject.str("accountId");
        this.quantity = jSONObject.getFloat(F_QUANTITY);
        this.closedQuantity = jSONObject.getFloat(F_CLOSED_QUANTITY);
        this.avgPrice = jSONObject.getFloat(F_AVG_PRICE);
        this.avgClosePrice = jSONObject.getFloat("avgClosePrice");
        this.pnl = jSONObject.getDouble(F_PNL);
        this.openTime = jSONObject.getLong("openTime");
        this.closeTime = jSONObject.getLong("closeTime");
        this.commission = jSONObject.getDouble("commission");
        boolean bl2 = jSONObject.is("open");
        if (bl2 && this.quantity == 0.0f) {
            bl2 = false;
        }
        this.setOpen(bl2);
        if (bl2) {
            this.updateUnrealizedPnL();
        }
    }

    public static Position read(Element element) {
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("accountId");
        String string4 = element.getAttribute("symbol");
        MWInstrument mWInstrument = MWInstrument.get(string4, string = element.getAttribute("exchange"));
        if (mWInstrument == null) {
            h.a.warning("Position::read() instrument not found: " + string4 + "." + string);
            return null;
        }
        LiveTicker liveTicker = LiveTicker.get(mWInstrument);
        Position position = new Position(string2, string3, null, liveTicker, true);
        position.setQuantity(h.b(element.getAttribute(F_QUANTITY)));
        position.setClosedQuantity(h.b(element.getAttribute(F_CLOSED_QUANTITY)));
        position.setAvgPrice(h.b(element.getAttribute(F_AVG_PRICE)));
        position.setOpenTime(h.b(element.getAttribute("openTime")));
        position.setOpen(true);
        position.setCommission(h.a(element.getAttribute("commission")));
        return position;
    }

    public String getAccountCurrency() {
        Account account = this.getAccount();
        if (account == null) {
            return "";
        }
        return account.getBaseCurrency();
    }

    public String toString() {
        return this.format("accountName") + " " + this.format("ticket") + " " + this.ticker.getSymbolDisplay() + " " + this.format(F_QUANTITY) + "@" + this.format(F_AVG_PRICE);
    }

    public int compareTo(Position position) {
        if (this == position) {
            return 0;
        }
        if (h.a((Object)this.positionId, (Object)position.positionId)) {
            return 0;
        }
        if (position.openTime > this.openTime) {
            return 1;
        }
        if (position.openTime < this.openTime) {
            return -1;
        }
        return this.positionId.compareTo(position.positionId);
    }

    public String getServiceName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getType().toString();
        }
        return "";
    }

    public String getConnectionName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getName();
        }
        return "";
    }

    private String formatPL(double d2) {
        if (d2 == 0.0) {
            return "";
        }
        return s.a(d2);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "quantity": 
            case "position": {
                float f2 = this.quantity;
                if (!this.isOpen()) {
                    f2 = this.closedQuantity;
                }
                if (f2 == 0.0f) {
                    return "";
                }
                return s.b(f2, this.getInstrument());
            }
            case "closedQuantity": {
                if (this.closedQuantity == 0.0f) {
                    return "";
                }
                return s.b(this.closedQuantity, this.getInstrument());
            }
            case "unrealizedPnL": {
                return s.a(this.unrealizedPnL);
            }
            case "pnl": {
                return s.a(this.pnl);
            }
            case "netPnl": {
                return s.a(this.getNetPnl());
            }
            case "rawUnrealizedPnL": {
                return s.a(this.rawUnrealizedPnL);
            }
            case "marketValue": {
                return s.a(this.getMarketValue());
            }
            case "rawMarketValue": {
                return s.a(this.getRawMarketValue());
            }
            case "commission": {
                return s.a(this.getCommission());
            }
            case "interest": {
                return s.a(this.getInterest());
            }
            case "stopOrderPL": {
                return this.formatPL(this.getStopOrderPL());
            }
            case "limitOrderPL": {
                return this.formatPL(this.getLimitOrderPL());
            }
            case "initialMargin": {
                return s.a(this.getInitialMargin());
            }
            case "maintenanceMargin": {
                return s.a(this.getMaintenanceMargin());
            }
            case "avgPrice": {
                return this.ticker.format(this.getAvgPrice());
            }
            case "openPrice": {
                return this.ticker.format(this.getOpenPrice());
            }
            case "avgClosePrice": {
                return this.getAvgClosePrice() == 0.0f ? "" : this.ticker.format(this.getAvgClosePrice());
            }
            case "entryPrice": {
                return this.ticker.format(this.getEntryPrice());
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
            case "pips": {
                float f3 = this.getPips();
                if (f3 == 0.0f) {
                    return "";
                }
                return h.c((double)f3, 1);
            }
            case "roll": {
                float f4 = this.getRoll();
                if (f4 == 0.0f) {
                    return "";
                }
                return h.c((double)f4, 2);
            }
            case "stopTrailPrice": {
                if (this.stopTrailOrder == null) {
                    return "";
                }
                if (this.stopTrailOrder.isUsePips()) {
                    return h.b(this.getStopTrailPrice(), 1);
                }
                return this.getInstrument().formatValue(this.getStopTrailPrice());
            }
            case "limitPrice": {
                if (this.limitOrder == null) {
                    return "";
                }
                if (this.limitOrder.isUsePips()) {
                    return h.b(this.getLimitPrice(), 1);
                }
                return this.getInstrument().formatValue(this.getLimitPrice());
            }
            case "ticket": {
                return this.getId();
            }
            case "open": {
                return "" + this.open;
            }
            case "closed": {
                return "" + !this.open;
            }
            case "close": {
                ai.a("LBL_CLOSE", new Object[0]);
            }
            case "openTime": {
                return this.openTime == 0L ? "" : s.a(this.openTime, b.a());
            }
            case "closeTime": {
                return this.closeTime == 0L ? "" : s.a(this.closeTime, b.a());
            }
            case "openingOrderId": {
                return this.openingOrderId;
            }
            case "confirmationNumber": {
                return this.confirmationNumber;
            }
            case "transactionId": {
                return this.transactionId;
            }
            case "dealSequence": {
                return this.dealSequence;
            }
            case "counter": {
                return this.counter;
            }
            case "lastPrice": 
            case "lastSize": 
            case "askPrice": 
            case "askSize": 
            case "bidPrice": 
            case "bidSize": 
            case "change": 
            case "high": 
            case "low": {
                return this.ticker.format(string);
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "lastTimestamp": {
                long l2 = this.ticker.getLastTimestamp();
                if (l2 == 0L) {
                    return "";
                }
                return s.a(l2, b.a());
            }
        }
        return this.ticker.format(string);
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "pips": {
                return Float.valueOf(this.getPips());
            }
            case "pnl": {
                return this.getPnl();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "unrealizedPnL": {
                return this.getUnrealizedPnL();
            }
            case "rawUnrealizedPnL": {
                return this.getRawUnrealizedPnL();
            }
            case "avgPrice": {
                return Float.valueOf(this.getAvgPrice());
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountCurrency": {
                return this.getAccountCurrency();
            }
            case "avgClosePrice": {
                return Float.valueOf(this.getAvgClosePrice());
            }
            case "low": 
            case "spread": 
            case "high": 
            case "lastPrice": 
            case "lastSize": 
            case "lastTimestamp": 
            case "askPrice": 
            case "askSize": 
            case "bidPrice": 
            case "bidSize": 
            case "change": {
                return this.ticker.getProperty(string);
            }
            case "close": {
                return ai.a("LBL_CLOSE", new Object[0]);
            }
            case "closeOrderId": {
                return this.getCloseOrderId();
            }
            case "closeTime": {
                return this.getCloseTime();
            }
            case "commission": {
                return this.getCommission();
            }
            case "initialMargin": {
                return this.getInitialMargin();
            }
            case "maintenanceMargin": {
                return this.getMaintenanceMargin();
            }
            case "confirmationNumber": {
                return this.getConfirmationNumber();
            }
            case "counter": {
                return this.getCounter();
            }
            case "currency": {
                return this.ticker.getInstrument().getCurrency();
            }
            case "dealSequence": {
                return this.getDealSequence();
            }
            case "entryPrice": {
                return Float.valueOf(this.getEntryPrice());
            }
            case "exchange": {
                return this.ticker.getInstrument().getExchange();
            }
            case "netPnl": {
                return this.getNetPnl();
            }
            case "id": {
                return this.getId();
            }
            case "interest": {
                return this.getInterest();
            }
            case "limitOrder": {
                return this.getLimitOrder();
            }
            case "limitOrderPL": {
                return this.getLimitOrderPL();
            }
            case "limitPrice": {
                return Float.valueOf(this.getLimitPrice());
            }
            case "marketValue": {
                return this.getMarketValue();
            }
            case "rawMarketValue": {
                return this.getRawMarketValue();
            }
            case "openingOrderId": {
                return this.getOpeningOrderId();
            }
            case "openPrice": {
                return Float.valueOf(this.getOpenPrice());
            }
            case "openTime": {
                return this.getOpenTime();
            }
            case "roll": {
                return Float.valueOf(this.getRoll());
            }
            case "stopOrderPL": {
                return this.getStopOrderPL();
            }
            case "stopTrailOrder": {
                return this.getStopTrailOrder();
            }
            case "symbolDisplay": {
                return this.ticker.getSymbolDisplay();
            }
            case "stopTrailPrice": {
                return Float.valueOf(this.getStopTrailPrice());
            }
            case "ticker": {
                return this.getTicker();
            }
            case "ticket": {
                return this.getTicket();
            }
            case "transactionId": {
                return this.getTransactionId();
            }
            case "underlying": {
                return this.ticker.getUnderlying();
            }
            case "closed": {
                return this.isClosed();
            }
            case "open": {
                return this.isOpen();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
        }
        return super.getProperty(string);
    }

    public String getTicket() {
        return this.positionId;
    }

    public String getId() {
        return this.positionId;
    }

    @Override
    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        float f3 = this.quantity;
        this.quantity = f2;
        this.firePropertyChange(F_QUANTITY, f3, this.quantity);
        if (this.quantity == 0.0f) {
            this.setOpen(false);
            this.setCloseTime(ae.a());
        }
    }

    public float getClosedQuantity() {
        return this.closedQuantity;
    }

    public void setClosedQuantity(float f2) {
        float f3 = this.closedQuantity;
        this.closedQuantity = f2;
        this.firePropertyChange(F_CLOSED_QUANTITY, f3, this.closedQuantity);
    }

    public float getOpenPrice() {
        return this.avgPrice;
    }

    public float getAvgPrice() {
        return this.avgPrice;
    }

    public float getEntryPrice() {
        return this.avgPrice;
    }

    public void setAvgPrice(float f2) {
        float f3 = this.avgPrice;
        this.avgPrice = f2;
        this.firePropertyChange(F_AVG_PRICE, f3, this.avgPrice);
    }

    public double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(double d2) {
        double d3 = this.marketValue;
        this.marketValue = d2;
        this.firePropertyChange(F_MARKET_VALUE, d3, this.marketValue);
    }

    public double getRawMarketValue() {
        return this.rawMarketValue;
    }

    public void setRawMarketValue(double d2) {
        double d3 = this.rawMarketValue;
        this.rawMarketValue = d2;
        this.firePropertyChange("rawMarketValue", d3, this.rawMarketValue);
    }

    public void updateUnrealizedPnL() {
        MWInstrument mWInstrument = this.getInstrument();
        float f2 = this.getQuantity();
        float f3 = this.getCurrentPrice();
        double d2 = 0.0;
        if (mWInstrument.isValueValid(f3)) {
            d2 = mWInstrument.calcPnL(this.getAvgPrice(), f3, f2);
        }
        if (h.a((Object)mWInstrument.getCurrency(), (Object)"JPY")) {
            this.setRawUnrealizedPnL(d2 * 100.0);
        } else {
            this.setRawUnrealizedPnL(d2);
        }
        Account account = this.getAccount();
        if (account == null) {
            return;
        }
        String string = account.getBaseCurrency();
        d2 = mWInstrument.convertTo(d2, string);
        if (h.a((Object)string, (Object)"JPY")) {
            d2 *= 100.0;
        }
        this.setUnrealizedPnL(d2);
        if (!this.ticker.isReplay()) {
            LiveTicker.get(mWInstrument).updateUnrealizedPnL();
        }
        PositionDirectory.notifyPLUpdate(mWInstrument, this.getAccountId());
    }

    public void updateMarketValue() {
        float f2;
        MWInstrument mWInstrument = this.getInstrument();
        if (!mWInstrument.isValueValid(f2 = this.getCurrentPrice())) {
            return;
        }
        double d2 = mWInstrument.calcPnL(f2, this.quantity);
        this.setMarketValue(mWInstrument.convertTo(d2, this.getAccount()));
        if (h.a((Object)mWInstrument.getCurrency(), (Object)"JPY")) {
            this.setRawMarketValue(d2 * 100.0);
        } else {
            this.setRawMarketValue(d2);
        }
    }

    public Account getAccount() {
        return ae.a(this.accountId);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        Account account = this.getAccount();
        if (account == null) {
            return "";
        }
        return account.getAccountName();
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        return account.isReplay();
    }

    public boolean isSimulated() {
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        return account.isSimulatedAccount();
    }

    public String getOpeningOrderId() {
        return this.openingOrderId;
    }

    public MWInstrument getInstrument() {
        return this.ticker.getInstrument();
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(long l2) {
        this.openTime = l2;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void setOpen(boolean bl2) {
        boolean bl3 = this.open;
        this.open = bl2;
        this.firePropertyChange("open", bl3, this.open);
        if (!this.open) {
            if (this.ticker != null) {
                this.ticker.removePropertyChangeListener(this);
            }
            OrderDirectory.removeListener(this);
        } else {
            if (this.ticker != null) {
                this.ticker.addPropertyChangeListener(this);
            }
            OrderDirectory.addListener(this);
        }
    }

    public float getAvgClosePrice() {
        return this.avgClosePrice;
    }

    public void setAvgClosePrice(float f2) {
        float f3 = this.avgClosePrice;
        this.avgClosePrice = f2;
        this.firePropertyChange("avgClosePrice", f3, this.avgClosePrice);
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(long l2) {
        long l3 = this.closeTime;
        this.closeTime = l2;
        this.firePropertyChange("closeTime", l3, this.closeTime);
    }

    public String getCloseOrderId() {
        return this.closeOrderId;
    }

    public void setCloseOrderId(String string) {
        this.closeOrderId = string;
    }

    public double getPnl() {
        return this.pnl;
    }

    public void setPnl(double d2) {
        double d3 = this.pnl;
        double d4 = this.getNetPnl();
        this.pnl = d2;
        this.firePropertyChange(F_PNL, d3, this.pnl);
        this.firePropertyChange(F_NET_PNL, d4, this.getNetPnl());
    }

    public double getNetPnl() {
        return this.pnl - this.commission + this.interest;
    }

    public double getUnrealizedPnL() {
        return this.unrealizedPnL;
    }

    public void setUnrealizedPnL(double d2) {
        double d3 = this.unrealizedPnL;
        this.unrealizedPnL = d2;
        this.firePropertyChange(F_UNREALIZED_PNL, d3, this.unrealizedPnL);
        this.firePropertyChange(F_PIPS, 0.0f, this.getPips());
    }

    public double getRawUnrealizedPnL() {
        return this.rawUnrealizedPnL;
    }

    public void setRawUnrealizedPnL(double d2) {
        double d3 = this.rawUnrealizedPnL;
        this.rawUnrealizedPnL = d2;
        this.firePropertyChange("rawUnrealizedPnL", d3, this.rawUnrealizedPnL);
    }

    public float getPips() {
        float f2 = 0.0f;
        if (this.isOpen()) {
            float f3 = this.getCurrentPrice();
            if (f3 == 0.0f) {
                return 0.0f;
            }
            f2 = (f3 - this.avgPrice) / (float)this.ticker.getPointSize();
            if (this.quantity > 0.0f) {
                return f2;
            }
            return -1.0f * f2;
        }
        f2 = (this.avgClosePrice - this.avgPrice) / (float)this.ticker.getPointSize();
        if (this.closedQuantity == 0.0f && this.getPnl() != 0.0) {
            f2 = Math.abs(f2);
            if (this.getPnl() > 0.0) {
                return f2;
            }
            return -1.0f * f2;
        }
        if (this.closedQuantity > 0.0f) {
            return f2;
        }
        return -1.0f * f2;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        double d3 = this.commission;
        this.commission = d2;
        this.firePropertyChange("commission", d3, this.commission);
    }

    public double getInitialMargin() {
        return this.initialMargin;
    }

    public void setInitialMargin(double d2) {
        double d3 = this.initialMargin;
        this.initialMargin = d2;
        this.firePropertyChange("initialMargin", d3, this.initialMargin);
    }

    public double getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(double d2) {
        double d3 = this.maintenanceMargin;
        this.maintenanceMargin = d2;
        this.firePropertyChange("maintenanceMargin", d3, this.maintenanceMargin);
    }

    public double getInterest() {
        return this.interest;
    }

    public void setInterest(double d2) {
        double d3 = this.interest;
        this.interest = d2;
        this.firePropertyChange("interest", d3, this.interest);
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float f2) {
        float f3 = this.roll;
        this.roll = f2;
        this.firePropertyChange("roll", f3, this.roll);
    }

    public void resolveOrders() {
        boolean bl2 = false;
        boolean bl3 = false;
        List list = OrderDirectory.findClosingOrders(this);
        for (MWOrder mWOrder : list) {
            if (mWOrder.isLimit()) {
                this.setLimitOrder(mWOrder);
                bl2 = true;
                continue;
            }
            if (!mWOrder.isStop() && !mWOrder.isTrail()) continue;
            this.setStopTrailOrder(mWOrder);
            bl3 = true;
        }
        if (!bl2 && this.limitOrder != null) {
            this.setLimitOrder(null);
        }
        if (!bl3 && this.stopTrailOrder != null) {
            this.setStopTrailOrder(null);
        }
    }

    public MWOrder getStopTrailOrder() {
        return this.stopTrailOrder;
    }

    public void setStopTrailOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (mWOrder == this.stopTrailOrder) {
            return;
        }
        MWOrder mWOrder2 = this.stopTrailOrder;
        this.stopTrailOrder = mWOrder;
        if (mWOrder2 != null) {
            mWOrder2.setPosition(null);
        }
        if (this.stopTrailOrder != null) {
            this.stopTrailOrder.setPosition(this);
        }
        this.firePropertyChange("stopTrailOrder", mWOrder2, this.stopTrailOrder);
        this.firePropertyChange("stopTrailPrice", -99999.0f, this.getStopTrailPrice());
        this.firePropertyChange("stopOrderPL", -99999.0, this.getStopOrderPL());
    }

    public float getStopTrailPrice() {
        if (this.stopTrailOrder == null) {
            return 0.0f;
        }
        return this.stopTrailOrder.getAdjustedAuxPrice();
    }

    public double getStopOrderPL() {
        if (this.stopTrailOrder == null) {
            return 0.0;
        }
        return this.stopTrailOrder.getOrderPL();
    }

    public MWOrder getLimitOrder() {
        return this.limitOrder;
    }

    public void setLimitOrder(MWOrder mWOrder) {
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            mWOrder = null;
        }
        if (mWOrder == this.limitOrder) {
            return;
        }
        MWOrder mWOrder2 = this.limitOrder;
        this.limitOrder = mWOrder;
        if (mWOrder2 != null) {
            mWOrder2.setPosition(null);
        }
        if (this.limitOrder != null) {
            this.limitOrder.setPosition(this);
        }
        this.firePropertyChange("limitOrder", mWOrder2, this.limitOrder);
        this.firePropertyChange("limitPrice", -99999.0f, this.getLimitPrice());
        this.firePropertyChange("limitOrderPL", -99999.0, this.getLimitOrderPL());
    }

    public float getLimitPrice() {
        if (this.limitOrder == null) {
            return 0.0f;
        }
        return this.limitOrder.getLimitPrice();
    }

    public double getLimitOrderPL() {
        if (this.limitOrder == null) {
            return 0.0;
        }
        return this.limitOrder.getOrderPL();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public String getConfirmationNumber() {
        return this.confirmationNumber;
    }

    public void setConfirmationNumber(String string) {
        this.confirmationNumber = string;
    }

    public String getDealSequence() {
        return this.dealSequence;
    }

    public void setDealSequence(String string) {
        this.dealSequence = string;
    }

    public String getCounter() {
        return this.counter;
    }

    public void setCounter(String string) {
        this.counter = string;
    }

    @Override
    public void orderCancelled(MWOrder mWOrder) {
        if (mWOrder == this.limitOrder) {
            this.setLimitOrder(null);
        }
        if (mWOrder == this.stopTrailOrder) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void orderCreated(MWOrder mWOrder) {
        if (!h.a((Object)mWOrder.getAccountID(), (Object)this.getAccountId())) {
            return;
        }
        if (!MWInstrument.isRelated(this.getInstrument(), mWOrder.getInstrument())) {
            return;
        }
        this.resolveOrders();
    }

    @Override
    public void orderFilled(MWOrder mWOrder) {
        if (mWOrder == this.limitOrder) {
            this.setLimitOrder(null);
        }
        if (mWOrder == this.stopTrailOrder) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void orderModified(MWOrder mWOrder) {
        if (mWOrder == this.limitOrder) {
            this.firePropertyChange("limitPrice", -99999.0f, mWOrder.getLimitPrice());
            this.firePropertyChange("limitOrderPL", -99999.0, this.getLimitOrderPL());
        } else if (mWOrder == this.stopTrailOrder) {
            this.firePropertyChange("stopTrailPrice", -99999.0f, mWOrder.getAuxPrice());
            this.firePropertyChange("stopOrderPL", -99999.0, this.getStopOrderPL());
        } else if (h.a((Object)mWOrder.getSymbol(), (Object)this.ticker.getSymbolDisplay())) {
            this.resolveOrders();
        }
    }

    @Override
    public void orderRejected(MWOrder mWOrder) {
        if (mWOrder == this.limitOrder) {
            this.setLimitOrder(null);
        }
        if (mWOrder == this.stopTrailOrder) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void orderRemoved(MWOrder mWOrder) {
        if (mWOrder == this.limitOrder) {
            this.setLimitOrder(null);
        }
        if (mWOrder == this.stopTrailOrder) {
            this.setStopTrailOrder(null);
        }
    }

    @Override
    public void removeAllOrders() {
        this.setLimitOrder(null);
        this.setStopTrailOrder(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            Position position = (Position)object;
            return h.a((Object)position.positionId, (Object)this.positionId);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

