/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cn.dr;
import com.motivewave.common.MWException;
import com.motivewave.common.c;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$JournalAction;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderCombo;
import com.motivewave.platform.common.Enums$OrderExpiry;
import com.motivewave.platform.common.Enums$OrderStatus;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.al;
import com.motivewave.platform.common.an;
import com.motivewave.platform.common.ao;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.common.themes.ChartTheme;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.ExitTrigger;
import com.motivewave.platform.databean.JournalDirectory;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.TradeHistory;
import com.motivewave.platform.databean.TradeHistoryDirectory;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.aj;
import com.motivewave.platform.databean.ak;
import com.motivewave.platform.service.ad;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import com.motivewave.platform.service.x;
import com.motivewave.platform.ui.console.Console;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import k.f;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OrderDirectory {
    private static Map ocoColors = new HashMap();
    private static Map directory = new HashMap();
    private static f listeners = new f();
    private static Map clientOCOOrderMap = new HashMap();
    private static Map clientAttachedOrderMap = new HashMap();
    private static long lastOrderId = 0L;
    private static int colorIndex = 0;
    private static int ocoTag = 0;
    private static int orderTag = 0;
    private static int osoTag = 0;
    private static String TAG_SYNC = new String("TAG_SYNC" + System.currentTimeMillis());
    private static List darkColors = new ArrayList();
    private static List lightColors = new ArrayList();
    private static Map exitTriggerOrders = new HashMap();

    public static void saveAll() {
        h.c(new File(Workspace.findDir("orders"), "orders.json"), OrderDirectory.write());
    }

    public static void write(File file) {
        h.a(file, OrderDirectory.write());
    }

    private static String write() {
        Object object3;
        Object object22;
        aj aj2 = new aj();
        List list = h.b(new String[0]);
        List list2 = h.b(new MWOrder[0]);
        for (Object object22 : OrderDirectory.getAllOrders()) {
            if (!((MWOrder)object22).isClientOrder() || ((MWOrder)object22).isFilled() || ((MWOrder)object22).isNew() || ((MWOrder)object22).isReplay()) continue;
            if (((MWOrder)object22).isSimulatedOrder()) {
                list2.add(object22);
                continue;
            }
            if (((MWOrder)object22).getType() == Enums$OrderType.MIT && !((MWOrder)object22).supportsMITOrders()) {
                list2.add(object22);
                continue;
            }
            if (((MWOrder)object22).getStatus() == Enums$OrderStatus.SUBMITTED || !((MWOrder)object22).hasParent() || ((MWOrder)object22).supportsAttachedOrders()) continue;
            list2.add(object22);
        }
        list.add(aj2.a("clientOrders", (Collection)list2));
        List list3 = h.b(new String[0]);
        for (Object object3 : clientOCOOrderMap.keySet()) {
            Iterator iterator = (List)clientOCOOrderMap.get(object3);
            for (Object object4 : new ArrayList(iterator)) {
                if (OrderDirectory.findOrder((String)object4) != null) continue;
                iterator.remove(object4);
            }
            if (h.a((Collection)((Object)iterator))) continue;
            list3.add(aj2.a(aj2.b("id", (String)object3), aj2.b("orders", h.a(iterator, ","))));
        }
        list.add(aj2.a("ocoOrders", (Collection)list3));
        object22 = h.b(new String[0]);
        for (Iterator iterator : clientAttachedOrderMap.keySet()) {
            Object object5 = (List)clientAttachedOrderMap.get(iterator);
            for (Object object6 : new ArrayList(object5)) {
                if (OrderDirectory.findOrder((String)object6) != null) continue;
                object5.remove(object6);
            }
            if (h.a((Collection)object5)) continue;
            object22.add(aj2.a(aj2.a_("id", (String)((Object)iterator)), aj2.a_("orders", h.a((Collection)object5, ","))));
        }
        list.add(aj2.a("attachedOrders", (Collection)object22));
        object3 = h.b(new q[0]);
        for (Object object5 : exitTriggerOrders.values()) {
            boolean bl2 = false;
            for (String string : ((ExitTrigger)object5).getAllEntryIds()) {
                if (!directory.containsKey(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                h.a.info("OrderDirectory::writeSettings() trigger is no longer valid: " + object5.c_());
                continue;
            }
            object3.add(object5);
        }
        list.add(aj2.a("triggers", (Collection)object3));
        list.add(aj2.a_("lastOrderId", lastOrderId));
        return aj2.a((Collection)list);
    }

    public static void read() {
        OrderDirectory.read(Workspace.findFile("orders"));
    }

    public static void read(File file) {
        if (!an.k()) {
            return;
        }
        if (file != null && file.exists()) {
            try {
                o o2;
                JSONObject jSONObject = new JSONObject(h.a(file));
                long l2 = jSONObject.getLong("lastOrderId");
                if (l2 > lastOrderId) {
                    lastOrderId = l2;
                }
                for (Object object : jSONObject.getObjList("clientOrders")) {
                    o2 = new MWOrder((JSONObject)object);
                    if (!((MWOrder)o2).isSimulatedOrder() && ((MWOrder)o2).getStatus() == Enums$OrderStatus.SUBMITTED && !((MWOrder)o2).isClientMITOrder()) continue;
                    OrderDirectory.createOrder((MWOrder)o2);
                    ((MWOrder)o2).createHandler();
                }
                clientOCOOrderMap.clear();
                for (Object object : jSONObject.getObjList("ocoOrders")) {
                    clientOCOOrderMap.put(((JSONObject)object).str("id"), h.a(((JSONObject)object).str("orders"), ','));
                }
                for (Object object : OrderDirectory.getValues()) {
                    OrderDirectory.resolveClientOCOId((MWOrder)object);
                }
                clientAttachedOrderMap.clear();
                for (Object object : jSONObject.getObjList("attachedOrders")) {
                    clientAttachedOrderMap.put(((JSONObject)object).str("id"), h.a(((JSONObject)object).str("orders"), ','));
                }
                exitTriggerOrders.clear();
                for (Object object : jSONObject.getObjList("triggers")) {
                    o2 = new ExitTrigger((JSONObject)object);
                    if (((ExitTrigger)o2).getStrategy() == null) {
                        h.a.warning("OrderDirectory::readSettings() strategy not found!: " + ((ExitTrigger)o2).getTicker().getSymbol());
                        continue;
                    }
                    OrderDirectory.createExitTrigger((ExitTrigger)o2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            Object object3;
            Iterator iterator;
            Object object2;
            String string;
            String string2 = Workspace.get("lastOrderId");
            if (!h.g(string2)) {
                lastOrderId = h.b(string2);
            }
            if (h.g(string = Workspace.get("clientOrders"))) {
                return;
            }
            Element element = g.a(string).getDocumentElement();
            if (element == null) {
                return;
            }
            Node node = g.b("child_orders", element);
            if (node != null) {
                object2 = g.c("order", node).iterator();
                while (object2.hasNext()) {
                    iterator = (Element)object2.next();
                    object3 = MWOrder.read((Element)((Object)iterator));
                    OrderDirectory.createOrder((MWOrder)object3);
                }
            }
            if ((object2 = g.b("oco_orders", element)) != null) {
                for (Object object3 : g.c("oco", (Node)object2)) {
                    clientOCOOrderMap.put(object3.getAttribute("id"), h.a(object3.getAttribute("orders"), ','));
                }
                iterator = OrderDirectory.getValues().iterator();
                while (iterator.hasNext()) {
                    object3 = (MWOrder)iterator.next();
                    OrderDirectory.resolveClientOCOId((MWOrder)object3);
                }
            }
            if ((iterator = g.b("attached_orders", element)) != null) {
                object3 = g.c("parent_order", (Node)((Object)iterator)).iterator();
                while (object3.hasNext()) {
                    Element element2 = (Element)object3.next();
                    clientAttachedOrderMap.put(element2.getAttribute("id"), h.a(element2.getAttribute("orders"), ','));
                }
            }
            if ((object3 = g.b("exit_triggers", element)) != null) {
                exitTriggerOrders.clear();
                for (Element element3 : g.c("exit_trigger", (Node)object3)) {
                    try {
                        ExitTrigger exitTrigger = new ExitTrigger();
                        exitTrigger.readXML(element3);
                        if (exitTrigger.getStrategy() == null) {
                            h.a.warning("OrderDirectory::readSettings() strategy not found!: " + exitTrigger.getTicker().getSymbol());
                            continue;
                        }
                        OrderDirectory.createExitTrigger(exitTrigger);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void refreshOrders() {
        MWOrder mWOrder;
        Object object3;
        Object object22;
        List list = h.b(new x[0]);
        for (Object object22 : ae.v()) {
            if (((as)object22).a() == null) continue;
            list.add(((as)object22).a());
        }
        if (h.a((Collection)list)) {
            return;
        }
        List list2 = h.b(new MWOrder[0]);
        for (Object object3 : OrderDirectory.getValues()) {
            if (!((MWOrder)object3).isClientOrder() || ((MWOrder)object3).isFilled()) continue;
            list2.add(object3);
        }
        directory.clear();
        OrderDirectory.notifyRemoveAll();
        for (Object object3 : list) {
            if (!((x)object3).f()) continue;
            try {
                ((x)object3).k();
            }
            catch (MWException mWException) {
                mWException.printStackTrace();
            }
        }
        object22 = OrderDirectory.getAllOrders();
        object3 = list2.iterator();
        while (object3.hasNext()) {
            mWOrder = (MWOrder)object3.next();
            mWOrder.setExists(false);
            OrderDirectory.register(mWOrder);
        }
        object3 = list2.iterator();
        while (object3.hasNext()) {
            mWOrder = (MWOrder)object3.next();
            mWOrder.resolveClosingOrders();
            OrderDirectory.resolveClientOCOId(mWOrder);
        }
        object3 = list2.iterator();
        while (object3.hasNext()) {
            mWOrder = (MWOrder)object3.next();
            OrderDirectory.createOrder(mWOrder);
        }
        object3 = object22.iterator();
        while (object3.hasNext()) {
            mWOrder = (MWOrder)object3.next();
            mWOrder.resolveClosingOrders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOrders(x x2) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        Map map = directory;
        synchronized (map) {
            for (MWOrder mWOrder : new ArrayList(directory.values())) {
                if (mWOrder == null || mWOrder.isFilled() || mWOrder.isClientOrder() || mWOrder.getPrimaryService() != x2) continue;
                directory.remove(mWOrder.getOrderId());
                arrayList.add(mWOrder);
            }
        }
        for (MWOrder mWOrder : arrayList) {
            OrderDirectory.notifyRemoved(mWOrder);
            mWOrder.destroy();
        }
    }

    public static void removeNonPositionOrders(Account account) {
        if (account == null) {
            return;
        }
        for (MWOrder mWOrder : OrderDirectory.getOpenOrders()) {
            if (!account.isAccount(mWOrder.getAccountID()) || mWOrder.getPosition() != null || mWOrder.isNetClose() || mWOrder.isSimulatedOrder() || mWOrder.isReplay()) continue;
            OrderDirectory.removeOrder(mWOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOrder(MWOrder mWOrder) {
        boolean bl2 = false;
        Map map = directory;
        synchronized (map) {
            bl2 = directory.remove(mWOrder.getOrderId()) != null;
        }
        if (mWOrder.exists()) {
            OrderDirectory.notifyRemoved(mWOrder);
        }
        if (bl2) {
            mWOrder.destroy();
        }
    }

    public static void removeFilledOrders(MWInstrument mWInstrument) {
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder == null || mWOrder.getInstrument() == null || !mWOrder.isFilled() || mWInstrument != null && mWInstrument != mWOrder.getInstrument()) continue;
            OrderDirectory.removeOrder(mWOrder);
        }
    }

    public static void removeByAccount(String string) {
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getAccountID(), (Object)string)) continue;
            OrderDirectory.removeOrder(mWOrder);
        }
    }

    public static List getOpenOrders(MWInstrument mWInstrument) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder == null || mWOrder.getInstrument() == null || mWInstrument != null && mWOrder.getInstrument() != mWInstrument || mWOrder.isFilled() || arrayList.contains(mWOrder)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List getOpenOrders() {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder == null || mWOrder.isFilled() || mWOrder.isCancelled() || arrayList.contains(mWOrder)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List getOpenOrders(String string) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder == null || !h.a((Object)mWOrder.getAccountID(), (Object)string) || mWOrder.isFilled() || mWOrder.isCancelled() || arrayList.contains(mWOrder)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List getAllOrders() {
        return OrderDirectory.getValues();
    }

    public static MWOrder findOrder(String string) {
        return (MWOrder)directory.get(string);
    }

    public static MWOrder findByTag(String string) {
        if (h.g(string)) {
            return null;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getTag(), (Object)string)) continue;
            return mWOrder;
        }
        return null;
    }

    public static List findOCOOrders(String string, MWInstrument mWInstrument) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        if (h.g(string)) {
            return arrayList;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getOCAId(), (Object)string) || mWOrder.getInstrument() != mWInstrument) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List findNetOrders(MWInstrument mWInstrument) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!mWOrder.isNetClose() || mWOrder.getInstrument() != mWInstrument) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List findOrders(MWInstrument mWInstrument) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder.getInstrument() != mWInstrument) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static MWOrder findActiveStopTrailOrder(String string) {
        if (h.g(string)) {
            return null;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getTradeId(), (Object)string) || !mWOrder.isStop() && !mWOrder.isTrail() || mWOrder.isFilled()) continue;
            return mWOrder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getValues() {
        Map map = directory;
        synchronized (map) {
            ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
            for (MWOrder mWOrder : directory.values()) {
                if (arrayList.contains(mWOrder)) continue;
                arrayList.add(mWOrder);
            }
            return arrayList;
        }
    }

    public static List findChildOrders(String string) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getParentId(), (Object)string)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static MWOrder findActiveLimitOrder(String string) {
        if (h.g(string)) {
            return null;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getTradeId(), (Object)string) || !mWOrder.isLimit() || mWOrder.isFilled()) continue;
            return mWOrder;
        }
        return null;
    }

    public static MWOrder findNetLimitOrder(MWInstrument mWInstrument, String string) {
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!mWOrder.isNetClose() || mWOrder.isFilled() || !h.a((Object)mWOrder.getInstrument(), (Object)mWInstrument) || !mWOrder.isLimit()) continue;
            if (h.g(string)) {
                return mWOrder;
            }
            if (!h.a((Object)mWOrder.getAccountID(), (Object)string)) continue;
            return mWOrder;
        }
        return null;
    }

    public static MWOrder findNetStopOrder(MWInstrument mWInstrument, String string) {
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!mWOrder.isNetClose() || mWOrder.isFilled() || !h.a((Object)mWOrder.getInstrument(), (Object)mWInstrument) || !mWOrder.isStop() && !mWOrder.isTrail()) continue;
            if (h.g(string)) {
                return mWOrder;
            }
            if (!h.a((Object)mWOrder.getAccountID(), (Object)string)) continue;
            return mWOrder;
        }
        return null;
    }

    public static List findActiveByTradeId(String string) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (mWOrder.isFilled() || mWOrder.isCancelInProgress() || mWOrder.isCancelled() || !h.a((Object)mWOrder.getTradeId(), (Object)string)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static List findClosingOrders(Position position) {
        List<MWOrder> list = new ArrayList();
        if (position == null) {
            return list;
        }
        if (ae.z(position.getAccount())) {
            list = OrderDirectory.findActiveByTradeId(position.getTicket());
            if (h.a(list) && !h.a((Object)position.getTicket(), (Object)position.getTransactionId())) {
                list = OrderDirectory.findActiveByTradeId(position.getTransactionId());
            }
            return list;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            Enums$ServiceType enums$ServiceType;
            MWOrder mWOrder2;
            if (!h.a((Object)position.getAccountId(), (Object)mWOrder.getAccountID()) || mWOrder.isFilled() || mWOrder.isCancelled() || mWOrder.isCancelInProgress() || mWOrder.hasParent() && ((mWOrder2 = mWOrder.getParentOrder()) != null && !mWOrder2.isFilled() || mWOrder.isPreSubmitted() && ((enums$ServiceType = mWOrder.getServiceType()) == null || !enums$ServiceType.isIB())) || !MWInstrument.isRelated(position.getInstrument(), mWOrder.getInstrument()) || position.getQuantity() > 0.0f && mWOrder.isBuy() || position.getQuantity() < 0.0f && mWOrder.isSell() || Math.abs(mWOrder.getQuantity()) > Math.abs(position.getQuantity())) continue;
            list.add(mWOrder);
        }
        return list;
    }

    public static List findDependentOrders(MWOrder mWOrder) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (mWOrder == null) {
            return arrayList;
        }
        if (!h.g(mWOrder.getParentId())) {
            Object object = OrderDirectory.findOrder(mWOrder.getParentId());
            if (object == null) {
                object = OrderDirectory.findByOrigId(mWOrder.getParentId());
            }
            if (object != null && !((MWOrder)object).isFilled()) {
                arrayList.add(object);
            }
        }
        for (MWOrder mWOrder2 : OrderDirectory.getValues()) {
            if (mWOrder == mWOrder2 || mWOrder2.isFilled()) continue;
            if (mWOrder.isNetClose() && mWOrder2.isNetClose() && mWOrder.getInstrument() == mWOrder2.getInstrument()) {
                arrayList.add(mWOrder2);
            }
            if (!h.g(mWOrder.getOCAId()) && h.a((Object)mWOrder.getOCAId(), (Object)mWOrder2.getOCAId())) {
                arrayList.add(mWOrder2);
                continue;
            }
            if (h.a((Object)mWOrder2.getParentId(), (Object)mWOrder.getOrderId())) {
                arrayList.add(mWOrder2);
                continue;
            }
            if (h.g(mWOrder.getOrigOrderId()) || !h.a((Object)mWOrder2.getParentId(), (Object)mWOrder.getOrigOrderId())) continue;
            arrayList.add(mWOrder2);
        }
        return arrayList;
    }

    private static void resolveStopLimit(MWOrder mWOrder) {
    }

    public static List findByOCAId(String string) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        if (h.g(string)) {
            return arrayList;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getOCAId(), (Object)string)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static MWOrder findByOrigId(String string) {
        if (h.g(string)) {
            return null;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getOrigOrderId(), (Object)string)) continue;
            return mWOrder;
        }
        return null;
    }

    public static MWOrder findByChainId(String string) {
        if (h.g(string)) {
            return null;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getChainId(), (Object)string)) continue;
            return mWOrder;
        }
        return null;
    }

    public static List findAllByChainId(String string) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        if (h.g(string)) {
            return arrayList;
        }
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            if (!h.a((Object)mWOrder.getChainId(), (Object)string)) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public static void resolveChildren(MWOrder mWOrder) {
        if (!mWOrder.exists()) {
            return;
        }
        mWOrder.removeAllChildren();
        for (MWOrder mWOrder2 : OrderDirectory.getValues()) {
            if (h.g(mWOrder2.getParentId())) continue;
            if (h.a((Object)mWOrder.getOrderId(), (Object)mWOrder2.getParentId())) {
                mWOrder.addChild(mWOrder2.getOrderId());
                continue;
            }
            if (h.g(mWOrder.getOrigOrderId()) || !h.a((Object)mWOrder.getOrigOrderId(), (Object)mWOrder2.getParentId())) continue;
            mWOrder.addChild(mWOrder2.getOrderId());
        }
    }

    public static void createOrder(MWOrder mWOrder) {
        if (mWOrder == null || directory.containsKey(mWOrder.getOrderId()) && mWOrder.exists()) {
            return;
        }
        OrderDirectory._createOrder(mWOrder);
        OrderDirectory.notifyCreated(mWOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, float f2, Enums$OrderType enums$OrderType, Enums$TIF enums$TIF) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, enums$OrderType);
        mWOrder.setFromDefaults();
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _createOrder(MWOrder mWOrder) {
        if (mWOrder == null || directory.containsKey(mWOrder.getOrderId()) && mWOrder.exists()) {
            return;
        }
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.resolveChildren(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
    }

    public static List createOCO(Enums$OrderCombo enums$OrderCombo, String string, MWInstrument mWInstrument, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, Enums$OrderExpiry enums$OrderExpiry, float f2, float f3, float f4, Ticker ticker) {
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        MWOrder mWOrder = null;
        switch (enums$OrderCombo) {
            case OCO_LIMIT: {
                mWOrder = OrderDirectory.createLimitOrder(string, ticker, enums$OrderAction, enums$TIF, f2, f3);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
                mWOrder = OrderDirectory.createLimitOrder(string, ticker, enums$OrderAction.reverse(), enums$TIF, f2, f4);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
                break;
            }
            case OCO_STOP: {
                mWOrder = OrderDirectory.createStopOrder(string, ticker, enums$OrderAction, enums$TIF, f2, f3);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
                mWOrder = OrderDirectory.createStopOrder(string, ticker, enums$OrderAction.reverse(), enums$TIF, f2, f4);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
                break;
            }
            case OCO_LIMIT_STOP: {
                mWOrder = OrderDirectory.createLimitOrder(string, ticker, enums$OrderAction, enums$TIF, f2, f3);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
                mWOrder = OrderDirectory.createStopOrder(string, ticker, enums$OrderAction, enums$TIF, f2, f4);
                if (enums$OrderExpiry != null) {
                    mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
                }
                arrayList.add(mWOrder);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createOrder(Enums$OrderCombo enums$OrderCombo, String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, Enums$OrderExpiry enums$OrderExpiry, float f2, float f3) {
        Enums$OrderType enums$OrderType = enums$OrderCombo.getPrimaryType();
        MWOrder mWOrder = null;
        if (enums$OrderType == Enums$OrderType.MKT) {
            mWOrder = OrderDirectory.createMarketOrder(string, ticker, enums$OrderAction, enums$TIF, f2);
        } else {
            mWOrder = new MWOrder(string, ticker, enums$OrderAction, enums$OrderType);
            mWOrder.setTif(enums$TIF);
            if (enums$OrderExpiry != null) {
                mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
            }
            mWOrder.setQuantity(f2);
            if (enums$OrderType == Enums$OrderType.STPLMT) {
                mWOrder.setStopLimitPrice(f3);
                mWOrder.setStopPrice(f3);
            } else if (enums$OrderType == Enums$OrderType.TRAIL) {
                boolean bl2 = false;
                bl2 = ae.a(mWOrder.getAccount()) ? b.bT() : ae.r(mWOrder.getAccount());
                float f4 = f3;
                if (bl2) {
                    f4 = ticker.round(Math.abs(f3 - ticker.getLastPrice()));
                }
                mWOrder.setAuxPrice(f4);
            } else if (enums$OrderType.isLimit()) {
                mWOrder.setLimitPrice(f3);
            } else if (enums$OrderType.isStop()) {
                mWOrder.setStopPrice(f3);
            }
        }
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        switch (enums$OrderCombo) {
            case MKT_S: 
            case STOP_S: 
            case LIMIT_S: {
                al.c(mWOrder);
                break;
            }
            case MKT_T: 
            case STOP_T: 
            case LIMIT_T: {
                al.e(mWOrder);
                break;
            }
            case MKT_SL: 
            case STOP_SL: 
            case LIMIT_SL: {
                al.e(mWOrder);
                break;
            }
            case MKT_TL: 
            case STOP_TL: 
            case LIMIT_TL: {
                al.d(mWOrder);
            }
        }
        return mWOrder;
    }

    public static MWOrder createLimitOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2, float f3) {
        return OrderDirectory.createLimitOrder(string, ticker, enums$OrderAction, enums$TIF, null, f2, f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createLimitOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, Enums$OrderExpiry enums$OrderExpiry, float f2, float f3) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.LMT);
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        mWOrder.setLimitPrice(f3);
        if (enums$OrderExpiry != null) {
            mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
        }
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    public static MWOrder createStopOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2, float f3) {
        return OrderDirectory.createStopOrder(string, ticker, enums$OrderAction, enums$TIF, null, f2, f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createStopOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, Enums$OrderExpiry enums$OrderExpiry, float f2, float f3) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STP);
        mWOrder.setTif(enums$TIF);
        if (enums$OrderExpiry != null) {
            mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
        }
        mWOrder.setQuantity(f2);
        mWOrder.setStopPrice(f3);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createMITOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, Enums$OrderExpiry enums$OrderExpiry, float f2, float f3) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.MIT);
        mWOrder.setTif(enums$TIF);
        if (enums$OrderExpiry != null) {
            mWOrder.setExpiryDate(enums$OrderExpiry.toLong());
        }
        mWOrder.setQuantity(f2);
        mWOrder.setAuxPrice(f3);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createStopLimitOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2, float f3) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STPLMT);
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        mWOrder.setStopPrice(f3);
        mWOrder.setLimitPrice(f3);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createTrailOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2, float f3) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.TRAIL);
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        boolean bl2 = false;
        bl2 = ae.a(mWOrder.getAccount()) ? b.bT() : ae.r(mWOrder.getAccount()) || mWOrder.getAccount().isSimulatedAccount();
        float f4 = f3;
        if (bl2) {
            f4 = ticker.round(Math.abs(f3 - ticker.getLastPrice()));
        }
        mWOrder.setAuxPrice(f4);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        return mWOrder;
    }

    public static MWOrder createMarketOrder(Account account, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2) {
        if (account == null) {
            account = ae.a(ticker.getInstrument());
        }
        if (account == null) {
            return null;
        }
        return OrderDirectory.createMarketOrder(account.getAccountID(), ticker, enums$OrderAction, enums$TIF, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createMarketOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.MKT);
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createCloseMarket(String string, Ticker ticker, String string2, Enums$OrderAction enums$OrderAction, Enums$TIF enums$TIF, float f2) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.MKT);
        mWOrder.setParentId(string2);
        mWOrder.setTradeId(string2);
        mWOrder.setTif(enums$TIF);
        mWOrder.setQuantity(f2);
        mWOrder.setEntryOrder(false);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createOrder(String string, Ticker ticker, String string2, Enums$OrderAction enums$OrderAction, float f2, float f3, float f4, Enums$OrderType enums$OrderType, Enums$TIF enums$TIF, Date date, boolean bl2) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, enums$OrderType);
        mWOrder.setParentId(string2);
        mWOrder.setTradeId(string2);
        mWOrder.setTif(enums$TIF);
        mWOrder.setGTD(date);
        mWOrder.setQuantity(f2);
        mWOrder.setLimitPrice(f3);
        mWOrder.setAuxPrice(f4);
        mWOrder.setUsePips(bl2);
        if (!h.g(string2)) {
            mWOrder.setEntryOrder(false);
        }
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWOrder createOrder(String string, Ticker ticker, String string2, Enums$OrderAction enums$OrderAction, float f2, float f3, float f4, Enums$OrderType enums$OrderType, Enums$TIF enums$TIF, Date date, boolean bl2, boolean bl3, boolean bl4) {
        MWOrder mWOrder = new MWOrder(string, ticker, enums$OrderAction, enums$OrderType);
        mWOrder.setParentId(string2);
        mWOrder.setTradeId(string2);
        mWOrder.setTif(enums$TIF);
        mWOrder.setGTD(date);
        mWOrder.setQuantity(f2);
        mWOrder.setLimitPrice(f3);
        mWOrder.setAuxPrice(f4);
        mWOrder.setUsePips(bl2);
        mWOrder.setEntryOrder(bl3);
        mWOrder.setNetClose(bl4);
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
            mWOrder.setExists(true);
        }
        OrderDirectory.notifyCreated(mWOrder);
        OrderDirectory.resolveStopLimit(mWOrder);
        return mWOrder;
    }

    static String getNextOrderId() {
        return "" + ++lastOrderId;
    }

    public static void assignNewOrderId(MWOrder mWOrder) {
        String string = OrderDirectory.getNextOrderId();
        OrderDirectory.assignNewOrderId(mWOrder, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignNewOrderId(MWOrder mWOrder, String string) {
        Object object7;
        Object object2;
        Object object3;
        Object object4;
        String string2 = mWOrder.getOrderId();
        if (h.a((Object)string2, (Object)string)) {
            return;
        }
        mWOrder.setOrderId(string);
        Object object5 = directory;
        synchronized (object5) {
            directory.remove(string2);
            directory.put(string, mWOrder);
            mWOrder.setExists(true);
        }
        object5 = mWOrder.getChildren();
        if (!h.a((Collection)object5)) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = OrderDirectory.findOrder((String)object3);
                if (object2 == null) continue;
                ((MWOrder)object2).setParentId(string);
                ((MWOrder)object2).setTradeId(string);
            }
        }
        object4 = mWOrder.getLimitOrder();
        object3 = mWOrder.getStopTrailOrder();
        if (object4 != null) {
            ((MWOrder)object4).setParentId(string);
            ((MWOrder)object4).setTradeId(string);
        }
        if (object3 != null) {
            ((MWOrder)object3).setParentId(string);
            ((MWOrder)object3).setTradeId(string);
        }
        object2 = clientOCOOrderMap;
        synchronized (object2) {
            for (Object object6 : clientOCOOrderMap.values()) {
                if (!object6.contains(string2)) continue;
                object6.remove(string2);
                object6.add(string);
            }
        }
        object2 = clientAttachedOrderMap;
        synchronized (object2) {
            for (Object object6 : clientAttachedOrderMap.values()) {
                if (!object6.contains(string2)) continue;
                object6.remove(string2);
                object6.add(string);
            }
        }
        object2 = clientAttachedOrderMap;
        synchronized (object2) {
            if (clientAttachedOrderMap.containsKey(string2)) {
                object7 = (List)clientAttachedOrderMap.remove(string2);
                clientAttachedOrderMap.put(string, object7);
            }
        }
        object2 = exitTriggerOrders;
        synchronized (object2) {
            object7 = (ExitTrigger)exitTriggerOrders.remove(string2);
            if (object7 != null) {
                exitTriggerOrders.put(string, object7);
                for (List list : ((ExitTrigger)object7).getEntryOrders()) {
                    if (!list.contains(string2)) continue;
                    list.remove(string2);
                    list.add(string);
                }
            }
        }
        for (Object object7 : listeners.a()) {
            object7.orderIdChanged(string2, mWOrder.getOrderId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelOrder(String string) {
        MWOrder mWOrder = null;
        Object object = directory;
        synchronized (object) {
            mWOrder = (MWOrder)directory.remove(string);
        }
        if (mWOrder == null) {
            return;
        }
        if (mWOrder.hasParent() && (object = mWOrder.getParentOrder()) != null) {
            if (mWOrder.isStop() || mWOrder.isTrail()) {
                ((MWOrder)object).setStopTrailOrder(null);
            } else if (mWOrder.isLimit()) {
                ((MWOrder)object).setLimitOrder(null);
            }
        }
        mWOrder.discardChanges();
        mWOrder.setStatus(Enums$OrderStatus.CANCELED);
        OrderDirectory.cancelAttachedOrders(mWOrder);
        OrderDirectory.removeAsChild(string);
        OrderDirectory.notifyCancelled(mWOrder);
        mWOrder.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAttachedOrders(MWOrder mWOrder) {
        if (mWOrder == null) {
            return;
        }
        String string = mWOrder.getOrderId();
        List list = null;
        Map map = clientAttachedOrderMap;
        synchronized (map) {
            list = (List)clientAttachedOrderMap.remove(string);
        }
        if (!h.a((Collection)list)) {
            for (String string2 : list) {
                OrderDirectory.cancelOrder(string2);
            }
        } else {
            if (mWOrder.getStopTrailOrder() != null && mWOrder.getStopTrailOrder().isNew()) {
                OrderDirectory.cancelOrder(mWOrder.getStopTrailOrder().getOrderId());
            }
            if (mWOrder.getLimitOrder() != null && mWOrder.getLimitOrder().isNew()) {
                OrderDirectory.cancelOrder(mWOrder.getLimitOrder().getOrderId());
            }
        }
    }

    public static void discardOrder(MWOrder mWOrder) {
        if (mWOrder == null) {
            return;
        }
        if (mWOrder.isNew()) {
            MWOrder mWOrder2;
            if (mWOrder.hasParent() && (mWOrder2 = mWOrder.getParentOrder()) != null) {
                if (mWOrder.isStop() || mWOrder.isTrail()) {
                    mWOrder2.setStopTrailOrder(null);
                } else if (mWOrder.isLimit()) {
                    mWOrder2.setLimitOrder(null);
                }
            }
            if (mWOrder.getStopTrailOrder() != null) {
                OrderDirectory.cancelOrder(mWOrder.getStopTrailOrder().getOrderId());
            }
            if (mWOrder.getLimitOrder() != null) {
                OrderDirectory.cancelOrder(mWOrder.getLimitOrder().getOrderId());
            }
            OrderDirectory.cancelOrder(mWOrder.getOrderId());
        } else {
            mWOrder.discardChanges();
            if (mWOrder.getStopTrailOrder() != null) {
                mWOrder.getStopTrailOrder().discardChanges();
            }
            if (mWOrder.getLimitOrder() != null) {
                mWOrder.getLimitOrder().discardChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasClientAttachedOrders(String string) {
        Map map = clientAttachedOrderMap;
        synchronized (map) {
            return clientAttachedOrderMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void submitAttachedOrders(String string) {
        Cloneable cloneable;
        List list = null;
        Object object2 = clientAttachedOrderMap;
        synchronized (object2) {
            list = (List)clientAttachedOrderMap.remove(string);
            if (h.a((Collection)list)) {
                return;
            }
        }
        h.a.info("OrderDirectory::submitAttachedOrders() parent order: " + string);
        object2 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object3 : list) {
            cloneable = OrderDirectory.findOrder(object3);
            if (cloneable == null) {
                h.a.warning("OrderDirectory::submitAttachedOrders() attached order not found: " + object3);
                continue;
            }
            if (((MWOrder)cloneable).isCancelled() || ((MWOrder)cloneable).isFilled() || ((MWOrder)cloneable).isRejected()) {
                h.a.warning("OrderDirectory::submitAttachedOrders() invalid order status: " + object3 + " status: " + ((MWOrder)cloneable).getStatus());
                continue;
            }
            object2.add(cloneable);
            if (h.g(((MWOrder)cloneable).getOCAId()) || arrayList.contains(((MWOrder)cloneable).getOCAId())) continue;
            arrayList.add(((MWOrder)cloneable).getOCAId());
        }
        if (h.a((Collection)object2)) {
            h.a.warning("OrderDirectory::submitAttachedOrders() no attached orders found: " + h.a((Collection)list, ","));
            return;
        }
        for (String string2 : arrayList) {
            cloneable = new ArrayList();
            for (MWOrder mWOrder : new ArrayList(object2)) {
                if (!h.a((Object)mWOrder.getOCAId(), (Object)string2)) continue;
                cloneable.add(mWOrder);
                object2.remove(mWOrder);
            }
            try {
                h.a.info("OrderDirectory::submitAttachedOrders() placing OCO orders: " + h.a(arrayList, ","));
                ae.c((List)((Object)cloneable), (dr)Console.a());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Console.a().b_("TITLE_E_SUBMIT_ATTACHED_ORDER", exception.getMessage());
            }
        }
        if (h.a((Collection)object2)) {
            return;
        }
        try {
            h.a.info("OrderDirectory::submitAttachedOrders() placing attached orders: " + h.a((Collection)list, ","));
            ae.b((List)object2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Console.a().b_("TITLE_E_SUBMIT_ATTACHED_ORDER", exception.getMessage());
        }
        Object object4 = "";
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            cloneable = (MWOrder)iterator.next();
            if (!((MWOrder)cloneable).isRejected()) continue;
            object4 = (String)object4 + "\n" + ((MWOrder)cloneable).getRejectReason();
        }
        if (!h.g((String)object4)) {
            Console.a().b_("TITLE_ERROR_PLACING_ORDERS", com.motivewave.platform.common.h.E_PLACE_ORDERS.a(object4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orderRejected(String string) {
        MWOrder mWOrder = null;
        Map map = directory;
        synchronized (map) {
            mWOrder = (MWOrder)directory.remove(string);
        }
        if (mWOrder == null) {
            return;
        }
        h.a.info("OrderDirectory::orderRejected() order: " + mWOrder);
        mWOrder.discardChanges();
        mWOrder.setRejected(true);
        OrderDirectory.cancelAttachedOrders(mWOrder);
        OrderDirectory.removeAsChild(string);
        OrderDirectory.notifyRejected(mWOrder);
        mWOrder.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(MWOrder mWOrder) {
        if (mWOrder == null) {
            return;
        }
        Map map = directory;
        synchronized (map) {
            directory.put(mWOrder.getOrderId(), mWOrder);
        }
    }

    public static void orderFilled(MWOrder mWOrder) {
        if (mWOrder == null) {
            return;
        }
        OrderDirectory._createOrder(mWOrder);
        String string = mWOrder.getOrderId();
        OrderDirectory.removeAsChild(string);
        if (mWOrder.isSimulatedOrder() || mWOrder.isReplay()) {
            OrderDirectory.processSimPosition(mWOrder);
        }
        OrderDirectory.cancelClientOCO(mWOrder);
        OrderDirectory.checkExitTriggers(mWOrder);
        for (q.c c2 : listeners.a()) {
            if (c2 instanceof ao) continue;
            try {
                c2.orderFilled(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        OrderDirectory.notifyParentModified(mWOrder);
        if (OrderDirectory.hasClientAttachedOrders(string)) {
            c.a(() -> OrderDirectory.submitAttachedOrders(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orderFilled(String string) {
        MWOrder mWOrder = null;
        Object object = directory;
        synchronized (object) {
            mWOrder = (MWOrder)directory.get(string);
        }
        if (mWOrder == null) {
            h.a.warning("OrderDirectory::orderFilled() order not found: " + string);
            return;
        }
        mWOrder.discardChanges();
        mWOrder.setStatus(Enums$OrderStatus.FILLED);
        h.a.info("OrderDirectory::orderFilled() order: " + mWOrder + " fill price: " + mWOrder.getAvgFillPrice() + " " + mWOrder.getFilled());
        OrderDirectory.removeAsChild(string);
        if (mWOrder.isSimulatedOrder() || mWOrder.isReplay()) {
            OrderDirectory.processSimPosition(mWOrder);
        }
        OrderDirectory.notifyFilled(mWOrder);
        if (OrderDirectory.hasClientAttachedOrders(string)) {
            c.a(() -> OrderDirectory.submitAttachedOrders(string));
        }
        if (mWOrder.isReplay() || mWOrder.isSimulatedOrder()) {
            return;
        }
        object = ae.a(mWOrder.getAccount());
        if (object == null) {
            return;
        }
        ad ad2 = ((as)object).a();
        x x2 = mWOrder.getPrimaryService();
        if (x2 == null) {
            return;
        }
        if (ad2.H() && ad2.H()) {
            c.a(() -> {
                x2.l();
                x2.o();
            });
        } else if (ad2.I()) {
            c.a(() -> x2.l());
        } else if (ad2.H()) {
            c.a(() -> x2.o());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orderModified(String string) {
        MWOrder mWOrder = null;
        Map map = directory;
        synchronized (map) {
            mWOrder = (MWOrder)directory.get(string);
        }
        if (mWOrder != null && !mWOrder.isCancelled()) {
            mWOrder.discardChanges();
            OrderDirectory.notifyModified(mWOrder);
        }
    }

    static Color getOCOColor(String string) {
        if (h.g(string)) {
            return null;
        }
        Color color = (Color)ocoColors.get(string);
        if (color == null) {
            color = OrderDirectory.getNextColor();
            ocoColors.put(string, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Color getNextColor() {
        if (ChartTheme.getTheme().isDark()) {
            List list = lightColors;
            synchronized (list) {
                if (h.a((Collection)lightColors)) {
                    lightColors.add(com.motivewave.common.o.LIGHT_GREEN);
                    lightColors.add(com.motivewave.common.o.PINK);
                    lightColors.add(com.motivewave.common.o.MEDIUM_TURQUOISE);
                    lightColors.add(com.motivewave.common.o.KHAKI);
                    lightColors.add(com.motivewave.common.o.SILVER);
                    lightColors.add(com.motivewave.common.o.VIOLET);
                    lightColors.add(com.motivewave.common.o.ORANGE_RED);
                    lightColors.add(com.motivewave.common.o.ROSY_BROWN);
                    lightColors.add(com.motivewave.common.o.PALE_GREEN);
                    lightColors.add(com.motivewave.common.o.LIGHT_BLUE);
                    lightColors.add(com.motivewave.common.o.LEMON_CHIFFON);
                    lightColors.add(com.motivewave.common.o.AQUAMARINE);
                    lightColors.add(com.motivewave.common.o.RED);
                }
                if (colorIndex >= lightColors.size()) {
                    colorIndex = 0;
                }
                int n2 = colorIndex++;
                return (Color)lightColors.get(n2);
            }
        }
        List list = darkColors;
        synchronized (list) {
            if (h.a((Collection)darkColors)) {
                darkColors.add(com.motivewave.common.o.GREEN);
                darkColors.add(com.motivewave.common.o.TOMATO);
                darkColors.add(com.motivewave.common.o.TURQUOISE);
                darkColors.add(com.motivewave.common.o.DARK_KHAKI);
                darkColors.add(com.motivewave.common.o.LIGHT_SLATE_GRAY);
                darkColors.add(com.motivewave.common.o.PURPLE);
                darkColors.add(com.motivewave.common.o.ORANGE_RED);
                darkColors.add(com.motivewave.common.o.SADDLE_BROWN);
                darkColors.add(com.motivewave.common.o.OLIVE);
                darkColors.add(com.motivewave.common.o.BLUE);
                darkColors.add(com.motivewave.common.o.GOLD);
                darkColors.add(com.motivewave.common.o.ORCHID);
                darkColors.add(com.motivewave.common.o.TEAL);
                darkColors.add(com.motivewave.common.o.ROSY_BROWN);
                darkColors.add(com.motivewave.common.o.STEEL_BLUE);
            }
            if (colorIndex >= darkColors.size()) {
                colorIndex = 0;
            }
            int n3 = colorIndex++;
            return (Color)darkColors.get(n3);
        }
    }

    private static void removeAsChild(String string) {
        for (MWOrder mWOrder : OrderDirectory.getValues()) {
            mWOrder.removeChild(string);
        }
    }

    public static long getLastOrderId() {
        return lastOrderId;
    }

    public static void setLastOrderId(long l2) {
        lastOrderId = l2;
    }

    public static void addListener(q.c c2) {
        listeners.a(c2);
    }

    public static void removeListener(q.c c2) {
        listeners.a(c2);
    }

    public static void notifyModified(MWOrder mWOrder) {
        if (mWOrder.getStatus() == Enums$OrderStatus.PARTIALLY_FILLED) {
            OrderDirectory.cancelClientOCO(mWOrder);
        }
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderModified(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JournalDirectory.order(mWOrder, Enums$JournalAction.ORDER_MODIFIED, s.a("JRNL_ORDER_MODIFIED", new Object[]{mWOrder.toString()}));
        OrderDirectory.notifyParentModified(mWOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createClientOCO(List list) {
        String string = OrderDirectory.genOCOID();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MWOrder mWOrder : list) {
            arrayList.add(mWOrder.getOrderId());
            mWOrder.setOCAId(string);
        }
        Map map = clientOCOOrderMap;
        synchronized (map) {
            clientOCOOrderMap.put(string, arrayList);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientOCO(String string) {
        if (h.g(string)) {
            return;
        }
        Map map = clientOCOOrderMap;
        synchronized (map) {
            List list = (List)clientOCOOrderMap.remove(string);
            if (h.a((Collection)list)) {
                return;
            }
            for (String string2 : list) {
                MWOrder mWOrder = OrderDirectory.findOrder(string2);
                if (mWOrder == null) continue;
                mWOrder.setOCAId(null);
                OrderDirectory.notifyModified(mWOrder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genOCOID() {
        String string = TAG_SYNC;
        synchronized (string) {
            String string2 = Long.toUnsignedString(System.currentTimeMillis(), 32).toUpperCase();
            if (string2.length() > 7) {
                string2 = string2.substring(string2.length() - 7);
            }
            return ("OCO-" + string2 + "-" + ocoTag++).intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genOSOID() {
        String string = TAG_SYNC;
        synchronized (string) {
            String string2 = Long.toUnsignedString(System.currentTimeMillis(), 32).toUpperCase();
            if (string2.length() > 7) {
                string2 = string2.substring(string2.length() - 7);
            }
            return ("OSO-" + string2 + "-" + osoTag++).intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genOrderTag(MWOrder mWOrder) {
        String string = TAG_SYNC;
        synchronized (string) {
            MWInstrument mWInstrument = mWOrder.getInstrument();
            String string2 = Long.toUnsignedString(System.currentTimeMillis(), 32).toUpperCase();
            if (string2.length() > 7) {
                string2 = string2.substring(string2.length() - 7);
            }
            String string3 = mWInstrument.getSymbol(mWOrder.getServiceType());
            string3 = h.b(string3, "!@#$%^&*()-_+=/?.><,\"';:|}{[]~`");
            String string4 = "MW-" + string3 + "-" + string2 + "-" + orderTag++;
            if (mWOrder.isNew()) {
                string4 = string4 + "-" + mWOrder.getOrderId();
            }
            return string4.intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachClientOrder(MWOrder mWOrder, MWOrder mWOrder2) {
        Map map = clientAttachedOrderMap;
        synchronized (map) {
            List<String> list = (List<String>)clientAttachedOrderMap.get(mWOrder.getOrderId());
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                clientAttachedOrderMap.put(mWOrder.getOrderId(), list);
            }
            if (!list.contains(mWOrder2.getOrderId())) {
                list.add(mWOrder2.getOrderId());
            }
        }
        mWOrder2.setStatus(Enums$OrderStatus.PRE_SUBMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unattachClientOrder(MWOrder mWOrder, MWOrder mWOrder2) {
        Map map = clientAttachedOrderMap;
        synchronized (map) {
            List list = (List)clientAttachedOrderMap.get(mWOrder.getOrderId());
            if (list == null) {
                return;
            }
            list.remove(mWOrder2.getOrderId());
        }
        mWOrder2.setStatus(Enums$OrderStatus.NEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isClientAttachedOrder(MWOrder mWOrder) {
        if (h.a(clientAttachedOrderMap)) {
            return false;
        }
        Map map = clientAttachedOrderMap;
        synchronized (map) {
            if (clientAttachedOrderMap.containsKey(mWOrder.getOrderId())) {
                return true;
            }
            for (List list : clientAttachedOrderMap.values()) {
                if (!list.contains(mWOrder.getOrderId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExitTrigger(ExitTrigger exitTrigger) {
        Object object;
        Object object2;
        if (exitTrigger == null) {
            return;
        }
        Map map = exitTriggerOrders;
        synchronized (map) {
            for (Object object3 : exitTrigger.getEntryOrders()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    exitTriggerOrders.put(object, exitTrigger);
                }
            }
        }
        for (Object object4 : exitTrigger.getEntryOrders()) {
            Object object3;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = OrderDirectory.findOrder((String)object2);
                if (object == null) {
                    System.err.println("OrderDirectory::createExitTrigger() order not found: " + (String)object2);
                    continue;
                }
                if (!((MWOrder)object).isFilled()) continue;
                OrderDirectory.checkExitTriggers((MWOrder)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTriggerOrder(MWOrder mWOrder) {
        String string = mWOrder.getOrderId();
        Map map = exitTriggerOrders;
        synchronized (map) {
            ExitTrigger exitTrigger = (ExitTrigger)exitTriggerOrders.remove(string);
            if (exitTrigger != null) {
                for (List list : new ArrayList(exitTrigger.getEntryOrders())) {
                    list.remove(string);
                    if (!h.a((Collection)list)) continue;
                    exitTrigger.getEntryOrders().remove(list);
                }
                if (h.a((Collection)exitTrigger.getEntryOrders())) {
                    OrderDirectory.removeExitTrigger(exitTrigger);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeExitTrigger(ExitTrigger exitTrigger) {
        if (exitTrigger == null) {
            return;
        }
        Map map = exitTriggerOrders;
        synchronized (map) {
            for (Map.Entry entry : new ArrayList(exitTriggerOrders.entrySet())) {
                if (entry.getValue() != exitTrigger) continue;
                exitTriggerOrders.remove(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveClientOCOId(MWOrder mWOrder) {
        Map map = clientOCOOrderMap;
        synchronized (map) {
            for (String string : clientOCOOrderMap.keySet()) {
                List list = (List)clientOCOOrderMap.get(string);
                if (!list.contains(mWOrder.getOrderId())) continue;
                mWOrder.setOCAId(string);
            }
        }
    }

    private static void notifyCreated(MWOrder mWOrder) {
        OrderDirectory.resolveClientOCOId(mWOrder);
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderCreated(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkExitTriggers(MWOrder mWOrder) {
        String string = mWOrder.getOrderId();
        Account account = mWOrder.getAccount();
        ExitTrigger exitTrigger = (ExitTrigger)exitTriggerOrders.get(string);
        if (exitTrigger == null) {
            return;
        }
        ExitTrigger exitTrigger2 = exitTrigger;
        synchronized (exitTrigger2) {
            float f2 = mWOrder.getFilled();
            if (mWOrder.isSell()) {
                f2 *= -1.0f;
            }
            float f3 = exitTrigger.getPosition();
            float f4 = mWOrder.getAvgFillPrice();
            exitTrigger.setPosition(f3 + f2);
            if (f3 == 0.0f) {
                exitTrigger.setAvgPrice(f4);
            } else {
                exitTrigger.setAvgPrice(Math.abs(mWOrder.getInstrument().round((exitTrigger.getAvgPrice() * f3 + f4 * f2) / (f3 + f2))));
            }
            for (List list : new ArrayList(exitTrigger.getEntryOrders())) {
                if (!list.contains(string)) continue;
                for (String string2 : list) {
                    exitTriggerOrders.remove(string2);
                }
                exitTrigger.getEntryOrders().remove(list);
            }
            if (h.a((Collection)exitTrigger.getEntryOrders())) {
                OrderDirectory.removeExitTrigger(exitTrigger);
                if (account.isHedging()) {
                    PositionDirectory.addListener(new ak(exitTrigger));
                } else {
                    c.a(() -> exitTrigger.activate());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelClientOCO(MWOrder mWOrder) {
        if (h.g(mWOrder.getOCAId())) {
            return;
        }
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        Map map = clientOCOOrderMap;
        synchronized (map) {
            for (String string : new ArrayList(clientOCOOrderMap.keySet())) {
                List list = (List)clientOCOOrderMap.get(string);
                if (!list.contains(mWOrder.getOrderId())) continue;
                clientOCOOrderMap.remove(string);
                for (String string2 : list) {
                    MWOrder mWOrder2;
                    if (h.a((Object)string2, (Object)mWOrder.getOrderId()) || (mWOrder2 = OrderDirectory.findOrder(string2)) == null || mWOrder2.isCancelled() || mWOrder2.isFilled() || mWOrder2.getStatus() == Enums$OrderStatus.PRE_SUBMITTED) continue;
                    arrayList.add(mWOrder2);
                }
            }
        }
        if (h.a(arrayList)) {
            return;
        }
        c.a(() -> {
            try {
                for (MWOrder mWOrder2 : arrayList) {
                    if (mWOrder.getStatus() == Enums$OrderStatus.NEW || mWOrder.isReplay()) {
                        OrderDirectory.cancelOrder(mWOrder2.getOrderId());
                        continue;
                    }
                    if (mWOrder2.isCancelInProgress() || mWOrder2.isCancelled()) continue;
                    ae.b(mWOrder2);
                }
            }
            catch (MWException mWException) {
                h.a.severe("OrderDirectory::cancelClientOCO() error cancelling dependent orders: " + mWException.getMessage());
                mWException.printStackTrace();
                Console.a().b_("TITLE_E_CANCEL_OCO_ORDER", mWException.getMessage());
            }
        });
    }

    private static void notifyCancelled(MWOrder mWOrder) {
        OrderDirectory.cancelClientOCO(mWOrder);
        OrderDirectory.removeTriggerOrder(mWOrder);
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderCancelled(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JournalDirectory.order(mWOrder, Enums$JournalAction.ORDER_CANCELLED, s.a("JRNL_ORDER_CANCELLED", new Object[]{mWOrder.toString()}));
        OrderDirectory.notifyParentModified(mWOrder);
    }

    private static void notifyRemoved(MWOrder mWOrder) {
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderRemoved(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void notifyRejected(MWOrder mWOrder) {
        OrderDirectory.cancelClientOCO(mWOrder);
        OrderDirectory.removeTriggerOrder(mWOrder);
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderRejected(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JournalDirectory.order(mWOrder, Enums$JournalAction.ORDER_REJECTED, s.a("JRNL_ORDER_REJECTED", new Object[]{mWOrder.getRejectReason()}));
        OrderDirectory.notifyParentModified(mWOrder);
        if (b.q() && !mWOrder.isReplay()) {
            if (h.g(b.i())) {
                h.a.warning("OrderDirectory::notifyRejected() unable to send email, email address is not configured");
                return;
            }
            h.a.warning("OrderDirectory::notifyRejected() sending email notification to: " + b.i() + " order: " + mWOrder);
            c.a(() -> {
                String string = "";
                string = mWOrder.isMarket() ? "MKT" : (mWOrder.isLimit() ? mWOrder.getInstrument().formatValue(mWOrder.getLimitPrice()) : mWOrder.getInstrument().formatValue(mWOrder.getAuxPrice()));
                String string2 = s.b(mWOrder.getFilled(), mWOrder.getInstrument());
                Object object = ai.a("EMAIL_ORDER_REJECTED_SUBJECT", new Object[0]);
                object = (String)object + " " + mWOrder.getInstrument().getSymbolDisplay() + " " + mWOrder.getAction() + " " + string2 + "@" + string;
                String string3 = "";
                Account account = mWOrder.getAccount();
                as as2 = ae.a(account);
                if (as2 != null) {
                    string3 = as2.a().l();
                }
                String string4 = h.g(ae.a());
                String string5 = ai.a("EMAIL_ORDER_REJECTED_BODY", new Object[]{string4, string3, mWOrder.getAccountID(), mWOrder.getOrderId(), mWOrder.getType(), mWOrder.getInstrument().getSymbolDisplay(), mWOrder.getAction(), string2, string, mWOrder.getTif()});
                String string6 = b.i();
                s.a(string6, (String)object, string5);
            });
        }
    }

    private static void notifyFilled(MWOrder mWOrder) {
        OrderDirectory.cancelClientOCO(mWOrder);
        OrderDirectory.checkExitTriggers(mWOrder);
        for (q.c c2 : listeners.a()) {
            try {
                c2.orderFilled(mWOrder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JournalDirectory.order(mWOrder, Enums$JournalAction.ORDER_FILLED, s.a("JRNL_ORDER_FILLED", mWOrder));
        OrderDirectory.notifyParentModified(mWOrder);
        if (b.p() && !mWOrder.isReplay()) {
            if (h.g(b.i())) {
                h.a.warning("OrderDirectory::notifyFilled() unable to send email, email address is not configured");
                return;
            }
            h.a.warning("OrderDirectory::notifyFilled() sending email notification to: " + b.i() + " order: " + mWOrder);
            c.a(() -> {
                long l2;
                String string = mWOrder.isBuy() ? ai.a("LBL_BOUGHT", new Object[0]) : ai.a("LBL_SOLD", new Object[0]);
                String string2 = mWOrder.getInstrument().formatValue(mWOrder.getAvgFillPrice());
                String string3 = s.b(mWOrder.getFilled(), mWOrder.getInstrument());
                Object object = ai.a("EMAIL_ORDER_FILLED_SUBJECT", new Object[0]);
                object = (String)object + " " + mWOrder.getInstrument().getSymbolDisplay() + " " + string + " " + string3 + "@" + string2;
                String string4 = "";
                Account account = mWOrder.getAccount();
                as as2 = ae.a(account);
                if (as2 != null) {
                    string4 = as2.a().l();
                }
                if ((l2 = mWOrder.getLastFillTime()) == 0L) {
                    l2 = ae.a();
                }
                if (!mWOrder.isReplay() && l2 < ae.a() - 86400000L) {
                    l2 = ae.a();
                }
                String string5 = h.g(l2);
                String string6 = ai.a("EMAIL_ORDER_FILLED_BODY", new Object[]{string5, string4, mWOrder.getAccountID(), mWOrder.getOrderId(), mWOrder.getType(), mWOrder.getInstrument().getSymbolDisplay(), mWOrder.getAction(), string3, string2, mWOrder.getTif()});
                String string7 = b.i();
                s.a(string7, (String)object, string6);
            });
        }
    }

    private static void notifyRemoveAll() {
        for (q.c c2 : listeners.a()) {
            try {
                c2.removeAllOrders();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void notifyParentModified(MWOrder mWOrder) {
        List list = listeners.a();
        for (String string : mWOrder.getChildren()) {
            MWOrder mWOrder2 = OrderDirectory.findOrder(string);
            if (mWOrder2 == null) {
                mWOrder2 = OrderDirectory.findByOrigId(string);
            }
            if (mWOrder2 == null) continue;
            for (q.c c2 : list) {
                try {
                    c2.a(mWOrder2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void processSimPosition(MWOrder mWOrder) {
        Account account = mWOrder.getAccount();
        float f2 = Math.abs(mWOrder.getFilled());
        if (mWOrder.isSell()) {
            f2 *= -1.0f;
        }
        Position position = PositionDirectory.findByInstrument(mWOrder.getInstrument(), mWOrder.getAccountID());
        String string = null;
        float f3 = f2;
        float f4 = 0.0f;
        double d2 = 0.0;
        boolean bl2 = account.isIncludeCommission();
        double d3 = bl2 ? mWOrder.getCommission() : 0.0;
        MWInstrument mWInstrument = mWOrder.getInstrument();
        account.adjustAccount(-d3);
        if (position == null) {
            position = new Position(mWOrder.isReplay() ? Account.genUniqueReplayID() : Account.genUniqueID(), mWOrder.getAccountID(), mWOrder.getOrderId(), mWOrder.getTicker(), true);
            position.setAvgPrice(mWOrder.getAvgFillPrice());
            position.setOpenTime(mWOrder.getLastFillTime());
            position.setQuantity(f2);
            position.setTransactionId(position.getId());
            position.setCommission(d3);
            position.updateUnrealizedPnL();
            position.updateMarketValue();
            string = position.getId();
            PositionDirectory.created(position);
            TradeHistoryDirectory.register(mWOrder.getOrderId(), string, mWOrder, true, f2, mWOrder.getAvgFillPrice(), 0.0);
            account.calcPnl();
            return;
        }
        if (position.getQuantity() < 0.0f && f2 > 0.0f || position.getQuantity() > 0.0f && f2 < 0.0f) {
            f4 = Math.abs(f2);
            if (position.getQuantity() < 0.0f) {
                f4 *= -1.0f;
            }
            if (Math.abs(f4) > Math.abs(position.getQuantity())) {
                f4 = position.getQuantity();
            }
            d2 = mWInstrument.calcPnLAndConvert(position.getAvgPrice(), mWOrder.getAvgFillPrice(), f4, account.getBaseCurrency());
        }
        f3 = position.getQuantity() + f2;
        string = position.getId();
        if (f3 == 0.0f || f4 != 0.0f && Math.abs(f2) > Math.abs(f4)) {
            float f5;
            try {
                position.resolveOrders();
                ae.b(position.getStopTrailOrder());
                ae.b(position.getLimitOrder());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            position.setPnl(position.getPnl() + d2);
            position.setQuantity(0.0f);
            if (f4 != 0.0f) {
                position.setClosedQuantity(position.getClosedQuantity() + f4);
            }
            position.setCloseTime(mWOrder.getLastFillTime());
            position.setCloseOrderId(mWOrder.getOrderId());
            position.setOpen(false);
            position.setAvgClosePrice(mWOrder.getAvgFillPrice());
            position.updateUnrealizedPnL();
            position.updateMarketValue();
            position.setCommission(position.getCommission() + d3 * (double)Math.abs(f4) / (double)Math.abs(f2));
            PositionDirectory.updated(position);
            PositionDirectory.closed(position);
            account.adjustAccount(d2);
            account.calcPnl();
            TradeHistory tradeHistory = TradeHistoryDirectory.register(mWOrder.getOrderId(), string, mWOrder, false, f4, mWOrder.getAvgFillPrice(), d2);
            List list = TradeHistoryDirectory.getByPosition(string);
            if (!h.a((Collection)list)) {
                f5 = f4 * -1.0f;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    float f6 = f5;
                    TradeHistory tradeHistory2 = (TradeHistory)iterator.next();
                    if (f6 != (f5 = tradeHistory2.fill(f5, mWOrder.getLastFillPrice()))) {
                        tradeHistory2.setLinkedTrade(tradeHistory);
                        tradeHistory.setLinkedTrade(tradeHistory2);
                    }
                    if (f5 != 0.0f) continue;
                    break;
                }
            }
            if (Math.abs(f2) > Math.abs(f4)) {
                f5 = Math.abs(f2) - Math.abs(f4);
                if (mWOrder.isSell()) {
                    f5 *= -1.0f;
                }
                position = new Position(mWOrder.isReplay() ? Account.genUniqueReplayID() : Account.genUniqueID(), mWOrder.getAccountID(), mWOrder.getOrderId(), mWOrder.getTicker(), true);
                position.setAvgPrice(mWOrder.getAvgFillPrice());
                position.setOpenTime(mWOrder.getLastFillTime());
                position.setQuantity(f5);
                position.setTransactionId(position.getId());
                position.setCommission(d3 * (double)Math.abs(f5) / (double)Math.abs(f2));
                position.updateUnrealizedPnL();
                position.updateMarketValue();
                string = position.getId();
                PositionDirectory.created(position);
                tradeHistory = TradeHistoryDirectory.register(mWOrder.getOrderId() + ":1", string, mWOrder, true, f5, mWOrder.getAvgFillPrice(), 0.0);
                return;
            }
        } else if (f2 < 0.0f && f3 < 0.0f || f2 > 0.0f && f3 > 0.0f) {
            double d4 = (position.getAvgPrice() * position.getQuantity() + mWOrder.getAvgFillPrice() * f2) / (position.getQuantity() + f2);
            position.setAvgPrice(mWOrder.getInstrument().round((float)d4));
            position.setQuantity(position.getQuantity() + f2);
            position.setCommission(position.getCommission() + d3);
            position.updateUnrealizedPnL();
            position.updateMarketValue();
            PositionDirectory.updated(position);
            TradeHistoryDirectory.register(mWOrder.getOrderId(), string, mWOrder, true, f2, mWOrder.getAvgFillPrice(), 0.0);
        } else {
            position.setPnl(position.getPnl() + d2);
            position.setQuantity(f3);
            if (f4 != 0.0f) {
                position.setClosedQuantity(position.getClosedQuantity() + f4);
            }
            position.setCommission(position.getCommission() + d3);
            position.updateUnrealizedPnL();
            position.updateMarketValue();
            PositionDirectory.updated(position);
            account.adjustAccount(d2);
            account.calcPnl();
            TradeHistory tradeHistory = TradeHistoryDirectory.register(mWOrder.getOrderId(), string, mWOrder, false, f2, mWOrder.getAvgFillPrice(), d2);
            List list = TradeHistoryDirectory.getByPosition(string);
            if (!h.a((Collection)list)) {
                float f7 = f2;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    float f8 = f7;
                    TradeHistory tradeHistory3 = (TradeHistory)iterator.next();
                    if (f8 != (f7 = tradeHistory3.fill(f7, mWOrder.getLastFillPrice()))) {
                        tradeHistory3.setLinkedTrade(tradeHistory);
                        tradeHistory.setLinkedTrade(tradeHistory3);
                    }
                    if (f7 != 0.0f) continue;
                    break;
                }
            }
        }
    }
}

