/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.c;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.News;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import com.motivewave.platform.service.n;
import com.motivewave.platform.service.x;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import k.f;
import k.i;

public class NewsDirectory {
    static final int MAX_HISTORY = 5000;
    private static Map storyIdMap = new HashMap();
    private static SortedSet allHistory = new TreeSet();
    private static f listeners = new f();
    private static long latest = 0L;
    private static boolean unsavedChanges = false;

    public static void save() {
        if (!unsavedChanges) {
            return;
        }
        unsavedChanges = false;
        try {
            long l2 = System.currentTimeMillis();
            List list = new ArrayList(allHistory);
            if (list.size() > 5000) {
                list = h.a(list, 0, 5000);
            }
            PrintWriter printWriter = new PrintWriter(new File(ae.a().getConfigDir(false), "news.csv"));
            int n2 = 1;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (News news : list) {
                n2 = News.addIds(news, linkedHashMap, n2);
            }
            a.a(printWriter, linkedHashMap);
            for (News news : list) {
                News.toCSV(news, linkedHashMap, printWriter);
            }
            printWriter.flush();
            printWriter.close();
            long l3 = System.currentTimeMillis() - l2;
            h.a.info("NewsDirectory::write() wrote: " + list.size() + " records elapsed time: " + l3 + " ms");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void load() {
        List<News> list = new ArrayList();
        File file = new File(ae.a().getConfigDir(false), "news.csv");
        if (!file.exists() && Workspace.hasDB()) {
            try {
                b b2 = CommandFactory.createCmd("LOAD_NEWS_HISTORY");
                list = (List)b2.a();
                if (list.size() > 0) {
                    h.a.info("NewsDirectory::load() migrated: " + list.size() + " news records from the database");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            unsavedChanges = true;
        } else {
            if (!file.exists()) {
                unsavedChanges = false;
                return;
            }
            long l2 = System.currentTimeMillis();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                if (string != null) {
                    Map map = a.a(string);
                    if (map != null) {
                        string = bufferedReader.readLine();
                    }
                    while (string != null) {
                        News news = News.fromCSV(string, map);
                        if (news != null) {
                            list.add(news);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l3 = System.currentTimeMillis() - l2;
            h.a.info("NewsDirectory::read() read: " + list.size() + " records elapsed time: " + l3 + " ms");
            unsavedChanges = false;
        }
        latest = 0L;
        for (News news : list) {
            NewsDirectory.register(news);
            if (news.getReleased() > latest) {
                latest = news.getReleased();
            }
            if (news.getUpdated() <= latest) continue;
            latest = news.getUpdated();
        }
        c.a(() -> {
            for (n n2 : listeners.a()) {
                try {
                    n2.a();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void requestLatest() {
        long l2 = latest;
        if (l2 == 0L) {
            l2 = System.currentTimeMillis() - 16070400000L;
        }
        for (i i2 : LiveTicker.getAllLoaded()) {
            if (((LiveTicker)i2).getInstrument().isLocalDataOnly()) continue;
            try {
                ae.a((LiveTicker)i2, l2);
            }
            catch (MWException mWException) {
                mWException.printStackTrace();
            }
        }
        for (i i2 : ae.v()) {
            x x2 = ((as)i2).d();
            if (x2 == null || x2.a().aI()) continue;
            try {
                x2.c(l2);
            }
            catch (MWException mWException) {
                mWException.printStackTrace();
            }
        }
    }

    public static void loadNewsHistory(LiveTicker liveTicker) {
        if (liveTicker == null || liveTicker.getInstrument().isLocalDataOnly()) {
            return;
        }
        x x2 = ae.b(liveTicker.getInstrument());
        if (x2 == null) {
            return;
        }
        long l2 = latest;
        long l3 = System.currentTimeMillis() - 2678400000L;
        long l4 = System.currentTimeMillis() - 432000000L;
        if (l2 == 0L) {
            l2 = l3;
        }
        long l5 = l2;
        ArrayList arrayList = NewsDirectory.getByInstrument(liveTicker.getInstrument());
        if (h.a((Collection)arrayList)) {
            l5 = l3;
        } else {
            arrayList = new ArrayList(arrayList);
            long l6 = System.currentTimeMillis();
            for (News news : arrayList) {
                if (news.getReleased() >= l6) continue;
                l6 = news.getReleased();
            }
            if (l6 > l4) {
                l5 = l3;
            }
        }
        if (l5 < System.currentTimeMillis() - 3600000L) {
            try {
                ae.a(liveTicker, l5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static News register(String string, String object, String string2, long l2, String string3, String string4, String string5, Enums$ServiceType enums$ServiceType) {
        boolean bl2 = false;
        if (h.g((String)object)) {
            object = "" + System.currentTimeMillis();
        }
        News news = null;
        Map map = storyIdMap;
        synchronized (map) {
            news = (News)storyIdMap.get(object);
        }
        if (news != null) {
            news.addSymbols(string);
            news.addSymbols(string5);
            news.setHeadline(string2);
            if (l2 > news.getReleased()) {
                news.setUpdated(l2);
                news.setViewed(false);
            }
            if (string3 != null) {
                news.setSource(string3);
            }
            if (!h.g(string4)) {
                news.setUrl(string4);
            }
            if (!h.g(string5)) {
                news.setKeywords(string5);
            }
        } else {
            news = new News((String)object, string3, string2, string4, string5, string, l2, enums$ServiceType);
            bl2 = true;
        }
        NewsDirectory.register(news);
        if (bl2) {
            NewsDirectory.notifyCreated(news);
        }
        unsavedChanges = true;
        return news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(News news) {
        Object object = storyIdMap;
        synchronized (object) {
            storyIdMap.put(news.getStoryId(), news);
        }
        object = allHistory;
        synchronized (object) {
            allHistory.remove(news);
            allHistory.add(news);
        }
    }

    public static void addListener(n n2) {
        listeners.a(n2);
    }

    public static void removeListener(n n2) {
        listeners.a(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        SortedSet sortedSet = allHistory;
        synchronized (sortedSet) {
            return new ArrayList(allHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static News get(String string) {
        if (h.g(string)) {
            return null;
        }
        Map map = storyIdMap;
        synchronized (map) {
            return (News)storyIdMap.get(string);
        }
    }

    public static List getByInstrument(MWInstrument mWInstrument) {
        List list = NewsDirectory.getAll();
        if (mWInstrument == null) {
            return list;
        }
        ArrayList<News> arrayList = new ArrayList<News>();
        for (News news : list) {
            if (!news.containsSymbol(mWInstrument.getSymbol())) continue;
            arrayList.add(news);
        }
        return arrayList;
    }

    private static void notifyCreated(News news) {
        if (news == null) {
            return;
        }
        c.a(() -> {
            for (n n2 : listeners.a()) {
                try {
                    n2.a(news);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }
}

