/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import com.motivewave.common.e;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderExpiry;
import com.motivewave.platform.common.Enums$OrderStatus;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.al;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.OrderPreset;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionBase;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.PositionSummary;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.ah;
import com.motivewave.platform.databean.ai;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import com.motivewave.platform.service.cw;
import com.motivewave.platform.service.x;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import k.f;
import o.p;
import org.json.JSONObject;
import org.w3c.dom.Element;
import q.c;

public class MWOrder
extends b
implements o,
PropertyChangeListener,
c {
    private boolean cancelReplaceInProgress = false;
    private String accountID;
    private Position position;
    private PositionSummary positionSummary;
    private Enums$OrderType orderType;
    private float quantity;
    private float limitPrice;
    private float auxPrice;
    private float trailStopPrice = 0.0f;
    private float lastMktPrice = 0.0f;
    private Enums$TIF tif;
    private boolean usePips = false;
    private Float adjustedQuantity = null;
    private Float adjustedLimitPrice = null;
    private Float adjustedAuxPrice = null;
    private Boolean adjustedUsePips = null;
    private Enums$TIF adjustedTif = null;
    private Boolean adjustedOutsideRTH = null;
    private Date adjustedGTD = null;
    private boolean adjusted = false;
    private Enums$OrderAction action;
    private String permanentId;
    private String orderId;
    private String origOrderId;
    private String parentId;
    private Color groupColor;
    private f childOrders = new f();
    private boolean forceClientAttached = false;
    private String clientId;
    private int ibOrderId;
    private String ocaId;
    private boolean outsideRTH;
    private Ticker ticker;
    private boolean destroyed = false;
    private String tag;
    private String ticket;
    private Enums$OrderStatus status;
    private float filled = 0.0f;
    private float remaining = 0.0f;
    private float avgFillPrice = 0.0f;
    private float lastFillPrice = 0.0f;
    private long created = 0L;
    private long lastFillTime = 0L;
    private String rejectReason;
    private Object rejectCode;
    private Date gTD;
    private Long expiryDate;
    private Long adjustedExpiryDate;
    private Date orderDate;
    private String chainId;
    private String statusCode;
    private String tradeId = "";
    private boolean netClose = false;
    private Boolean entryOrder;
    private String rateId;
    private float rate;
    private float marketRange;
    private boolean useMarketRange;
    private MWOrder stopTrailOrder;
    private MWOrder limitOrder;
    private int trailPoints = 1;
    private Integer adjustedTrailPoints = null;
    private boolean trailFixed = false;
    private Boolean adjustedTrailFixed = null;
    private double commission;
    private cw tradeRoute;
    private long lastCommit = 0L;
    private boolean cancelInProgress = false;
    private boolean waiting = false;
    private String failedMsg = null;
    private boolean simulatedOrder = false;
    private boolean rejected = false;
    private boolean exists = false;
    private boolean updateInProgress = false;
    private ai handler = null;
    private ah mitHandler = null;

    public MWOrder(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public MWOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType) {
        this(string, OrderDirectory.getNextOrderId(), ticker, enums$OrderAction, enums$OrderType, Enums$OrderStatus.NEW);
    }

    public MWOrder(String string, String string2, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType) {
        this(string, string2, ticker, enums$OrderAction, enums$OrderType, Enums$OrderStatus.NEW);
    }

    public MWOrder(String string, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType, float f2, Enums$TIF enums$TIF, float f3) {
        this(string, OrderDirectory.getNextOrderId(), ticker, enums$OrderAction, enums$OrderType, Enums$OrderStatus.NEW);
        if (f2 < 0.0f) {
            h.c();
            f2 = Math.abs(f2);
        }
        this.quantity = f2;
        this.tif = enums$TIF;
        if (enums$OrderType.isLimit()) {
            this.limitPrice = f3;
        }
        if (enums$OrderType.isStop()) {
            this.auxPrice = f3;
        }
    }

    public MWOrder(String string, String string2, Ticker ticker, Enums$OrderAction enums$OrderAction, Enums$OrderType enums$OrderType, Enums$OrderStatus enums$OrderStatus) {
        if (h.g(string)) {
            string = ae.a(ticker.getInstrument());
        }
        this.accountID = string;
        this.orderId = string2;
        this.action = enums$OrderAction;
        Account account = ae.a(string);
        if (!(ticker instanceof LiveTicker) && account != null && !account.isReplay()) {
            ticker = LiveTicker.get(ticker.getInstrument());
        }
        this.ticker = ticker;
        if (account == null) {
            if (ae.I()) {
                h.a.warning("MWOrder() account not found! " + string);
            }
        } else if (account.isReplay()) {
            this.orderId = "RPLY-" + this.orderId;
        } else if (account.isSimulatedAccount()) {
            this.simulatedOrder = true;
        }
        this.setType(enums$OrderType);
        this.setStatus(enums$OrderStatus);
        OrderPreset orderPreset = ticker.getInstrument().getOrderPreset();
        boolean bl2 = this.outsideRTH = orderPreset == null ? true : orderPreset.isTriggerOTH();
        if (orderPreset != null && !h.g(orderPreset.getTradeRoute())) {
            for (cw cw2 : this.getTradeRoutes()) {
                if (!h.a((Object)cw2.b(), (Object)orderPreset.getTradeRoute())) continue;
                this.setTradeRoute(cw2);
            }
        }
        this.orderDate = new Date(ae.a());
        this.addListeners(ticker);
        OrderDirectory.addListener(this);
    }

    public String getServiceName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getType().toString();
        }
        return "";
    }

    public String getConnectionName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getName();
        }
        return "";
    }

    public void copyFrom(MWOrder mWOrder) {
        this.accountID = mWOrder.accountID;
        this.orderType = mWOrder.orderType;
        this.action = mWOrder.action;
        this.adjusted = mWOrder.adjusted;
        this.adjustedUsePips = mWOrder.adjustedUsePips;
        this.adjustedAuxPrice = mWOrder.adjustedAuxPrice;
        this.adjustedExpiryDate = mWOrder.adjustedExpiryDate;
        this.adjustedGTD = mWOrder.adjustedGTD;
        this.adjustedLimitPrice = mWOrder.adjustedLimitPrice;
        this.adjustedOutsideRTH = mWOrder.adjustedOutsideRTH;
        this.adjustedQuantity = mWOrder.adjustedQuantity;
        this.adjustedTif = mWOrder.adjustedTif;
        this.adjustedTrailFixed = mWOrder.adjustedTrailFixed;
        this.adjustedTrailPoints = mWOrder.adjustedTrailPoints;
        this.auxPrice = mWOrder.auxPrice;
        this.entryOrder = mWOrder.entryOrder;
        this.gTD = mWOrder.gTD;
        this.expiryDate = mWOrder.expiryDate;
        this.limitPrice = mWOrder.limitPrice;
        this.outsideRTH = mWOrder.outsideRTH;
        this.marketRange = mWOrder.marketRange;
        this.netClose = mWOrder.netClose;
        this.quantity = mWOrder.quantity;
        this.tif = mWOrder.tif;
        this.rate = mWOrder.rate;
        this.rateId = mWOrder.rateId;
        this.trailFixed = mWOrder.trailFixed;
        this.trailPoints = mWOrder.trailPoints;
        this.tradeRoute = mWOrder.tradeRoute;
        this.useMarketRange = mWOrder.useMarketRange;
        this.usePips = mWOrder.usePips;
        this.ticker = mWOrder.ticker;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.handler != null) {
            this.ticker.removeTickListener(this.handler);
        }
        if (this.mitHandler != null) {
            this.ticker.removeTickListener(this.mitHandler);
        }
        this.removeListeners(this.ticker);
        OrderDirectory.removeOrder(this);
        OrderDirectory.removeListener(this);
        super.destroy();
    }

    public boolean exists() {
        return this.exists;
    }

    void setExists(boolean bl2) {
        this.exists = bl2;
    }

    public boolean supportsAttachedOrders() {
        if (this.getInstrument().isOption()) {
            return ae.k(this.getAccount());
        }
        return ae.j(this.getAccount());
    }

    public boolean supportsMITOrders() {
        return ae.i(this.getAccount());
    }

    public boolean supportsOTH() {
        as as2 = ae.a(this.getAccount());
        if (as2 == null) {
            return false;
        }
        return as2.a().a(this.getInstrument().getType(), this.getType());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isTrail() || this.isNew()) {
            return;
        }
        float f2 = this.ticker.getLastPrice();
        if (!ae.l(this.getInstrument())) {
            f2 = this.isBuy() ? this.ticker.getAskPrice() : this.ticker.getBidPrice();
        }
        if (this.lastMktPrice == 0.0f) {
            this.lastMktPrice = f2;
            return;
        }
        if (this.isBuy()) {
            if (f2 < this.lastMktPrice) {
                this.lastMktPrice = f2;
            }
        } else if (f2 > this.lastMktPrice) {
            this.lastMktPrice = f2;
        }
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "account": {
                return this.getAccount();
            }
            case "accountID": {
                return this.getAccountID();
            }
            case "accountName": {
                Account account = this.getAccount();
                return account == null ? "" : account.getAccountName();
            }
            case "action": {
                return this.getAction();
            }
            case "adjustedAuxPrice": {
                return Float.valueOf(this.getAdjustedAuxPrice());
            }
            case "adjustedExpiryDate": {
                return this.getAdjustedExpiryDate();
            }
            case "adjustedGTD": {
                return this.getAdjustedGTD();
            }
            case "adjustedLimitPrice": {
                return Float.valueOf(this.getAdjustedLimitPrice());
            }
            case "adjustedQuantity": {
                return Float.valueOf(this.getAdjustedQuantity());
            }
            case "adjustedTif": {
                return this.getAdjustedTif();
            }
            case "adjustedTrailPoints": {
                return this.getAdjustedTrailPoints();
            }
            case "adjustedTrailPrice": {
                return Float.valueOf(this.getAdjustedTrailPrice());
            }
            case "adjustedTriggerPrice": {
                return Float.valueOf(this.getAdjustedTriggerPrice());
            }
            case "auxPrice": {
                return Float.valueOf(this.getAuxPrice());
            }
            case "avgFillPrice": {
                return Float.valueOf(this.getAvgFillPrice());
            }
            case "basePrice": {
                return Float.valueOf(this.getBasePrice());
            }
            case "baseTrailPrice": {
                return Float.valueOf(this.getBaseTrailPrice());
            }
            case "clientId": {
                return this.getClientId();
            }
            case "chainId": {
                return this.getChainId();
            }
            case "commission": {
                return this.getCommission();
            }
            case "currency": {
                return this.getInstrument().getCurrency();
            }
            case "description": {
                return this.getInstrument().getDescription();
            }
            case "destination": {
                return this.getInstrument().getExchange();
            }
            case "exchange": {
                return this.getInstrument().getExchange();
            }
            case "exchangeSymbol": {
                return this.getInstrument().getExchange();
            }
            case "expiryDate": {
                return this.getExpiryDate();
            }
            case "failedMsg": {
                return this.getFailedMsg();
            }
            case "filled": {
                return Float.valueOf(this.getFilled());
            }
            case "groupColor": {
                return this.getGroupColor();
            }
            case "gTD": 
            case "GTD": {
                return this.getGTD();
            }
            case "iBOrderId": {
                return this.getIBOrderId();
            }
            case "label": {
                return this.getLabel();
            }
            case "lastFillPrice": {
                return Float.valueOf(this.getLastFillPrice());
            }
            case "lastFillTime": {
                return this.getLastFillTime();
            }
            case "limitOrder": {
                return this.getLimitOrder();
            }
            case "limitOrderPL": {
                return this.getLimitOrderPL();
            }
            case "limitPrice": {
                return Float.valueOf(this.getLimitPrice());
            }
            case "marketRange": {
                return Float.valueOf(this.getMarketRange());
            }
            case "mktPrice": {
                return Float.valueOf(this.getMktPrice());
            }
            case "oCAId": {
                return this.getOCAId();
            }
            case "orderDate": {
                return this.getOrderDate();
            }
            case "orderId": {
                return this.getOrderId();
            }
            case "orderPL": {
                return this.getOrderPL();
            }
            case "position": {
                return this.getPosition();
            }
            case "orderPrice": {
                return Float.valueOf(this.getOrderPrice());
            }
            case "origOrderId": {
                return this.getOrigOrderId();
            }
            case "parentId": {
                return this.getParentId();
            }
            case "parentOrder": {
                return this.getParentOrder();
            }
            case "permanentId": {
                return this.getPermanentId();
            }
            case "qualifiedSymbol": {
                if (h.g(this.getInstrument().getExchange())) {
                    return this.getSymbol();
                }
                return this.getInstrument().getSymbol() + "." + this.getInstrument().getExchange();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "rate": {
                return Float.valueOf(this.getRate());
            }
            case "rateId": {
                return this.getRateId();
            }
            case "rejectCode": {
                return this.getRejectCode();
            }
            case "rejectReason": {
                return this.getRejectReason();
            }
            case "remaining": {
                return Float.valueOf(this.getRemaining());
            }
            case "status": {
                return this.getStatus();
            }
            case "statusCode": {
                return this.getStatusCode();
            }
            case "stopOrderPL": {
                return this.getStopOrderPL();
            }
            case "stopTrailOrder": {
                return this.getStopTrailOrder();
            }
            case "stopTrailOrderPrice": {
                return Float.valueOf(this.getStopTrailOrderPrice());
            }
            case "limitOrderPrice": {
                return Float.valueOf(this.getLimitOrderPrice());
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "symbolDisplay": {
                return this.getInstrument().getSymbolDisplay();
            }
            case "symbolDisplay2": {
                return this.getInstrument().getSymbolDisplay();
            }
            case "tag": {
                return this.getTag();
            }
            case "tif": {
                return this.getTif();
            }
            case "tradeId": {
                return this.getTradeId();
            }
            case "trailPoints": {
                return this.getTrailPoints();
            }
            case "trailPrice": {
                return Float.valueOf(this.getTrailPrice());
            }
            case "trailStopPrice": {
                return Float.valueOf(this.getTrailStopPrice());
            }
            case "triggerPrice": {
                return Float.valueOf(this.getTriggerPrice());
            }
            case "type": {
                return this.getType();
            }
            case "ticker": {
                return this.getTicker();
            }
            case "underlying": {
                return this.getInstrument().getUnderlying();
            }
            case "tradeRoute": {
                return this.getTradeRoute();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "askPrice": 
            case "bidPrice": 
            case "lastPrice": 
            case "midpoint": 
            case "high": 
            case "low": {
                return this.ticker.getProperty(string);
            }
            case "ticket": {
                return this.getTicket();
            }
            case "adjustedExpires": {
                return this.getAdjustedExpires();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        float f2 = 0.0f;
        switch (string) {
            case "accountName": {
                Account account = this.getAccount();
                return account == null ? "" : account.getAccountName();
            }
            case "orderPrice": {
                float f3 = this.getOrderPrice();
                if ((double)f3 < this.getTicker().getTickSize() || this.isMarket()) {
                    return "";
                }
                return this.getInstrument().formatValue(f3);
            }
            case "stopTrailOrderPrice": {
                if (this.stopTrailOrder == null || this.isFilled()) {
                    return "";
                }
                f2 = this.getStopTrailOrderPrice();
                if (this.stopTrailOrder.isUsePips()) {
                    return h.c((double)f2, 1);
                }
                if ((double)f2 < this.getTicker().getTickSize()) {
                    return "";
                }
                return this.getInstrument().formatValue(f2);
            }
            case "limitOrderPrice": {
                if (this.limitOrder == null || this.isFilled()) {
                    return "";
                }
                f2 = this.getLimitOrderPrice();
                if (this.limitOrder.isUsePips()) {
                    return h.c((double)f2, 1);
                }
                if (!this.getInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.getInstrument().formatValue(f2);
            }
            case "triggerPrice": {
                float f4 = this.getTriggerPrice();
                if (!this.getInstrument().isValueValid(f4)) {
                    return "";
                }
                return this.getInstrument().formatValue(f4);
            }
            case "quantity": {
                float f5 = this.getQuantity();
                if (this.getRemaining() > 0.0f) {
                    f5 = this.getRemaining();
                }
                return s.b(Math.abs(f5), this.getInstrument());
            }
            case "remaining": {
                return s.b(Math.abs(this.getRemaining()), this.getInstrument());
            }
            case "filled": {
                float f6 = this.getFilled();
                if (f6 == 0.0f) {
                    return "";
                }
                return s.b(f6, this.getInstrument());
            }
            case "adjustedQuantity": {
                return s.b(Math.abs(this.getAdjustedQuantity()), this.getInstrument());
            }
            case "orderId": {
                return h.b((Object)this.getOrderId());
            }
            case "tradeId": {
                return h.b((Object)this.getTradeId());
            }
            case "chainId": {
                return h.b((Object)this.getChainId());
            }
            case "orderDate": {
                if (this.orderDate == null) {
                    return "";
                }
                return s.a(this.orderDate.getTime(), com.motivewave.platform.common.b.a());
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "expiryDate": {
                return h.a(this.getExpiryDate(), com.motivewave.platform.common.b.a());
            }
            case "adjustedExpiryDate": {
                return h.a(this.getAdjustedExpiryDate(), com.motivewave.platform.common.b.a());
            }
            case "adjustedExpires": {
                if (ae.C(this.getAccount())) {
                    return h.a(this.getAdjustedExpiryDate(), com.motivewave.platform.common.b.a());
                }
                if (this.getAdjustedTif() == null) {
                    return "";
                }
                return this.getAdjustedTif().toString();
            }
            case "tradeRoute": {
                if (this.getTradeRoute() == null) {
                    return "";
                }
                return this.getTradeRoute().b();
            }
            case "low": 
            case "high": {
                return this.ticker.format(string);
            }
            case "symbolDisplay": {
                return this.ticker.getInstrument().getSymbolDisplay();
            }
            case "underlying": {
                return this.ticker.getInstrument().getUnderlying();
            }
            case "currency": {
                return h.b((Object)this.ticker.getInstrument().getCurrency());
            }
            case "exchange": {
                return h.b((Object)this.ticker.getInstrument().getExchange());
            }
            case "symbolDisplay2": {
                return this.ticker.getInstrument().getSymbolDisplay();
            }
            case "commission": {
                return this.getCommission() == 0.0 ? "" : s.a(this.getCommission());
            }
            case "limitPrice": 
            case "auxPrice": {
                if (this.isUsePips()) {
                    return this.formatPips(h.a(this.getProperty(string)));
                }
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "adjustedLimitPrice": 
            case "adjustedAuxPrice": {
                if (this.isAdjustedUsePips()) {
                    return this.formatPips(h.a(this.getProperty(string)));
                }
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "stopOrderPL": 
            case "limitOrderPL": 
            case "orderPL": {
                if (this.isFilled()) {
                    return "";
                }
                return this.formatPL(h.a(this.getProperty(string)));
            }
            case "avgFillPrice": 
            case "lastFillPrice": {
                return this.formatValue(h.a(this.getProperty(string)));
            }
            case "groupColor": {
                return "";
            }
            case "lastFillTime": {
                return this.lastFillTime == 0L ? "" : s.a(this.lastFillTime, com.motivewave.platform.common.b.a());
            }
        }
        Object object = this.getProperty(string);
        if (object == null) {
            return "";
        }
        return h.b(object);
    }

    private String formatPips(float f2) {
        return f2 == 0.0f ? "" : h.b(f2, 1);
    }

    private String formatValue(float f2) {
        if ((double)f2 < this.getTicker().getTickSize()) {
            return "";
        }
        return this.getInstrument().formatValue(f2);
    }

    private String formatPL(double d2) {
        return d2 == 0.0 ? "" : s.a(d2);
    }

    public void setLastMktPrice(float f2) {
        this.lastMktPrice = f2;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date date) {
        Date date2 = this.orderDate;
        this.orderDate = date;
        this.firePropertyChange("orderDate", date2, this.orderDate);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String string) {
        String string2 = this.statusCode;
        this.statusCode = string;
        this.firePropertyChange("statusCode", string2, this.statusCode);
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(String string) {
        String string2 = this.tradeId;
        this.tradeId = string;
        this.firePropertyChange("tradeId", string2, this.tradeId);
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String string) {
        String string2 = this.chainId;
        this.chainId = string;
        this.firePropertyChange("chainId", string2, this.chainId);
    }

    public float getMktPrice() {
        if (this.ticker.getLastPrice() > 0.0f) {
            return this.ticker.getLastPrice();
        }
        if (this.isBuy()) {
            if (this.ticker.getAskPrice() > 0.0f) {
                return this.ticker.getAskPrice();
            }
            if (this.ticker.getBidPrice() > 0.0f) {
                return this.ticker.getBidPrice();
            }
            return this.ticker.getMidOrLast();
        }
        if (this.ticker.getBidPrice() > 0.0f) {
            return this.ticker.getBidPrice();
        }
        if (this.ticker.getAskPrice() > 0.0f) {
            return this.ticker.getAskPrice();
        }
        return this.ticker.getMidOrLast();
    }

    public float getBasePrice() {
        if (this.isTrail() || this.isStop()) {
            MWOrder mWOrder = this.getParentOrder();
            float f2 = 0.0f;
            f2 = mWOrder == null || mWOrder.getStatus() == Enums$OrderStatus.FILLED ? this.getMktPrice() : (mWOrder.isLimit() ? mWOrder.getLimitPrice() : (mWOrder.isTrail() ? mWOrder.getTrailPrice() : mWOrder.getAuxPrice()));
            if (this.isBuy()) {
                return f2 + (float)this.ticker.getTickSize();
            }
            return f2 - (float)this.ticker.getTickSize();
        }
        return 0.0f;
    }

    public float getTriggerPrice() {
        if (this.getType() == Enums$OrderType.MIT || this.getType() == Enums$OrderType.LIT) {
            return this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
        }
        boolean bl2 = this.isNew() ? this.isAdjustedUsePips() : this.isUsePips();
        float f2 = this.ticker.getMidOrLast();
        if (this.isLimit()) {
            float f3;
            float f4 = f3 = this.isNew() ? this.getAdjustedLimitPrice() : this.getLimitPrice();
            if (bl2) {
                float f5;
                f3 = (float)((double)f3 * this.getInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f3;
                }
                float f6 = f5 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f3 + f5;
                }
                return f5 - f3;
            }
            return f3;
        }
        if (this.isStop()) {
            float f7;
            float f8 = f7 = this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
            if (bl2) {
                float f9;
                f7 = (float)((double)f7 * this.getInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f7;
                }
                float f10 = f9 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f7 + f9;
                }
                return f9 - f7;
            }
            return f7;
        }
        boolean bl3 = ae.a(this.getAccount());
        if (this.isTrail()) {
            if (bl3 && !bl2) {
                return this.getAuxPrice();
            }
            if (this.trailStopPrice > 0.0f) {
                return this.trailStopPrice;
            }
            float f11 = Math.abs(this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice());
            if (ae.t(this.getAccount())) {
                return f11;
            }
            if (bl2) {
                f11 = (float)((double)f11 * this.getInstrument().getPointSize());
            }
            float f12 = this.getBaseTrailPrice();
            if (this.isSell()) {
                return this.round(f12 - f11);
            }
            return this.round(f12 + f11);
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                return this.getLastFillPrice();
            }
            return this.getMktPrice();
        }
        if (bl3 && !bl2) {
            return this.isNew() ? this.getAdjustedAuxPrice() : this.getAuxPrice();
        }
        return this.isNew() ? this.getAdjustedTrailPrice() : this.getTrailPrice();
    }

    public float getAdjustedTriggerPrice() {
        if (h.a((Object)this.getType(), new Object[]{Enums$OrderType.MIT, Enums$OrderType.LIT})) {
            return this.getAdjustedAuxPrice();
        }
        float f2 = this.ticker.getMidOrLast();
        if (this.isLimit()) {
            float f3 = this.getAdjustedLimitPrice();
            if (this.isAdjustedUsePips()) {
                float f4;
                f3 = (float)((double)f3 * this.getInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f3;
                }
                float f5 = f4 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f3 + f4;
                }
                return f4 - f3;
            }
            return f3;
        }
        if (this.isStop()) {
            float f6 = this.getAdjustedAuxPrice();
            if (this.isAdjustedUsePips()) {
                float f7;
                f6 = (float)((double)f6 * this.getInstrument().getPointSize());
                MWOrder mWOrder = this.getParentOrder();
                if (mWOrder == null) {
                    return f2 + f6;
                }
                float f8 = f7 = mWOrder.isFilled() ? mWOrder.getLastFillPrice() : mWOrder.getTriggerPrice();
                if (mWOrder.isBuy()) {
                    return f6 + f7;
                }
                return f7 - f6;
            }
            return f6;
        }
        boolean bl2 = ae.a(this.getAccount());
        if (this.isTrail()) {
            if (!this.isAdjusted()) {
                return this.getTriggerPrice();
            }
            if (bl2 && !this.isAdjustedUsePips()) {
                return this.getAdjustedAuxPrice();
            }
            float f9 = Math.abs(this.getAdjustedAuxPrice());
            float f10 = this.getBaseTrailPrice();
            if (this.isAdjustedUsePips()) {
                f9 = (float)((double)f9 * this.getInstrument().getPointSize());
                if (this.trailStopPrice > 0.0f) {
                    float f11 = Math.abs((float)((double)this.getAuxPrice() * this.getInstrument().getPointSize()));
                    f10 = this.isSell() ? this.trailStopPrice + f11 : this.trailStopPrice - f11;
                }
            } else if (this.trailStopPrice > 0.0f) {
                float f12 = Math.abs(this.getAuxPrice());
                float f13 = f10 = this.isSell() ? this.trailStopPrice + f12 : this.trailStopPrice - f12;
            }
            if (ae.t(this.getAccount())) {
                return f9;
            }
            if (this.isSell()) {
                return this.round(f10 - f9);
            }
            return this.round(f10 + f9);
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                return this.getLastFillPrice();
            }
            return this.getMktPrice();
        }
        if (bl2 && !this.isAdjustedUsePips()) {
            return this.getAdjustedAuxPrice();
        }
        return this.getAdjustedTrailPrice();
    }

    private void removeListeners(Ticker ticker) {
        if (ticker == null) {
            return;
        }
        ticker.removePropertyChangeListener("lastPrice", this);
        ticker.removePropertyChangeListener("bidPrice", this);
        ticker.removePropertyChangeListener("askPrice", this);
        ticker.removePropertyChangeListener(this);
    }

    private void addListeners(Ticker ticker) {
        if (ticker == null) {
            return;
        }
        ticker.addPropertyChangeListener("lastPrice", this);
        ticker.addPropertyChangeListener("bidPrice", this);
        ticker.addPropertyChangeListener("askPrice", this);
    }

    public MWInstrument getInstrument() {
        return this.ticker.getInstrument();
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        this.removeListeners(this.ticker);
        this.ticker = LiveTicker.get(mWInstrument);
        boolean bl2 = true;
        OrderPreset orderPreset = null;
        if (this.ticker != null) {
            orderPreset = this.ticker.getInstrument().getOrderPreset();
        }
        if (orderPreset != null) {
            bl2 = orderPreset.isTriggerOTH();
        }
        this.outsideRTH = bl2;
        if (!(this.isReplay() || h.a((Object)this.status, new Object[]{Enums$OrderStatus.CANCELED, Enums$OrderStatus.FILLED}) || this.isRejected())) {
            this.addListeners(this.ticker);
        }
        if (orderPreset != null && !h.g(orderPreset.getTradeRoute())) {
            for (cw cw2 : this.getTradeRoutes()) {
                if (!h.a((Object)cw2.b(), (Object)orderPreset.getTradeRoute())) continue;
                this.setTradeRoute(cw2);
            }
        }
    }

    public float getTrailPrice() {
        if (ae.t(this.getAccount())) {
            return this.getAuxPrice();
        }
        float f2 = this.getBaseTrailPrice();
        float f3 = this.getAuxPrice();
        if (ae.a(this.getAccount())) {
            if (this.isUsePips()) {
                f3 = (float)((double)f3 * this.getInstrument().getPointSize());
            }
            if (this.isBuy()) {
                return f2 - f3;
            }
            return f2 + f3;
        }
        if (this.isUsePips()) {
            f3 = (float)((double)f3 * this.getInstrument().getPointSize());
        }
        if (this.isBuy()) {
            return f2 + f3;
        }
        return f2 - f3;
    }

    public float getAdjustedTrailPrice() {
        if (ae.t(this.getAccount())) {
            return this.getAdjustedAuxPrice();
        }
        float f2 = this.getBaseTrailPrice();
        float f3 = this.getAdjustedAuxPrice();
        if (this.isAdjustedUsePips()) {
            f3 = (float)((double)f3 * this.getInstrument().getPointSize());
        }
        if (ae.a(this.getAccount()) || ae.d(this.getAccount())) {
            if (this.isBuy()) {
                return f2 - f3;
            }
            return f2 + f3;
        }
        if (this.isBuy()) {
            return f2 + f3;
        }
        return f2 - f3;
    }

    public void setAdjustedTrailPrice(float f2) {
        if (ae.t(this.getAccount())) {
            this.setAdjustedAuxPrice(f2);
        } else {
            float f3 = this.getBaseTrailPrice();
            if (this.isBuy()) {
                this.setAdjustedAuxPrice(f2 - f3);
            } else {
                this.setAdjustedAuxPrice(f3 - f2);
            }
        }
    }

    public float getBaseTrailPrice() {
        Position position;
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder == null && ae.z(this.getAccount()) && !ae.d(this.getAccount()) && (position = PositionDirectory.find(this.getTradeId())) != null) {
            return position.getAvgPrice();
        }
        if (mWOrder == null) {
            float f2 = this.getMktPrice();
            if (this.lastMktPrice != 0.0f) {
                f2 = this.lastMktPrice;
            }
            return f2;
        }
        if (mWOrder.isFilled()) {
            return mWOrder.getAvgFillPrice();
        }
        if (mWOrder.isLimit()) {
            return mWOrder.getLimitPrice();
        }
        if (mWOrder.isTrail()) {
            return mWOrder.getTrailPrice();
        }
        if (mWOrder.isMarket()) {
            return mWOrder.isBuy() ? this.ticker.getBuyPrice() : this.ticker.getSellPrice();
        }
        return mWOrder.getAuxPrice();
    }

    public boolean isBuy() {
        return h.a((Object)this.action, new Object[]{Enums$OrderAction.BUY, Enums$OrderAction.BUY_TO_COVER});
    }

    public boolean isSell() {
        return h.a((Object)this.action, new Object[]{Enums$OrderAction.SELL, Enums$OrderAction.SHORT});
    }

    public boolean isNew() {
        return this.status == Enums$OrderStatus.NEW && !this.isFilled();
    }

    public boolean isPreSubmitted() {
        return this.status == Enums$OrderStatus.PRE_SUBMITTED;
    }

    public boolean isCancelled() {
        return this.status == Enums$OrderStatus.CANCELED;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean bl2) {
        this.rejected = bl2;
    }

    public void clearRejectFlags() {
        this.rejected = false;
        this.rejectCode = null;
        this.rejectReason = "";
    }

    public boolean isAdjusted() {
        return this.adjusted;
    }

    public boolean isStopLimitAdjusted() {
        if (this.stopTrailOrder != null && (this.stopTrailOrder.isAdjusted() || this.stopTrailOrder.isNew())) {
            return true;
        }
        return this.limitOrder != null && (this.limitOrder.isAdjusted() || this.limitOrder.isNew());
    }

    public boolean isLimit() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.LMT, Enums$OrderType.ICEBERG});
    }

    public boolean isMarket() {
        if (this.orderType == null) {
            return true;
        }
        return this.orderType == Enums$OrderType.MKT || this.orderType == Enums$OrderType.MOC || this.orderType == Enums$OrderType.MKTCLS || this.orderType == Enums$OrderType.MKTOPEN || this.orderType == Enums$OrderType.MKTPITCLS || this.orderType == Enums$OrderType.MKTPITOPEN || this.orderType == Enums$OrderType.MKTLMT;
    }

    public boolean isTrail() {
        return this.orderType == Enums$OrderType.TRAIL;
    }

    public boolean isTrailPts() {
        if (this.orderType == null) {
            return false;
        }
        if (!this.orderType.isTrail()) {
            return false;
        }
        return ae.q(this.getAccount());
    }

    public boolean isTriggerLimit() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT});
    }

    public boolean isTrigger() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.MIT});
    }

    public boolean isStop() {
        return h.a((Object)this.orderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.STPLMT});
    }

    public boolean isOCO() {
        return !h.g(this.ocaId);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public boolean isModifiable() {
        return !h.g(this.orderId);
    }

    public Enums$OrderType getType() {
        return this.orderType;
    }

    public void setType(Enums$OrderType enums$OrderType) {
        Enums$OrderType enums$OrderType2 = this.orderType;
        this.orderType = enums$OrderType;
        if (enums$OrderType != null && enums$OrderType.isTrail()) {
            this.usePips = ae.r(this.getAccount());
            if (ae.a(this.getAccount())) {
                this.usePips = com.motivewave.platform.common.b.bT();
            }
        }
        this.firePropertyChange("type", (Object)enums$OrderType2, (Object)this.orderType);
    }

    public void setPrices(Enums$OrderType enums$OrderType) {
        MWInstrument mWInstrument = this.getInstrument();
        OrderPreset orderPreset = mWInstrument.getOrderPreset();
        int n2 = 10;
        if (orderPreset != null) {
            n2 = orderPreset.getTrailOffset();
        }
        int n3 = 10;
        if (orderPreset != null) {
            n3 = orderPreset.getStopOffset();
        }
        int n4 = 10;
        if (orderPreset != null) {
            n4 = orderPreset.getLimitOffset();
        }
        if (enums$OrderType == Enums$OrderType.MKT || enums$OrderType == Enums$OrderType.MOC) {
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.auxPrice = 0.0f;
            this.adjustedLimitPrice = null;
            this.limitPrice = 0.0f;
            return;
        }
        Ticker ticker = this.ticker;
        float f2 = ticker.getAskPrice();
        if (this.isSell()) {
            f2 = ticker.getBidPrice();
        }
        float f3 = (float)this.getTicker().getTickSize();
        if (enums$OrderType == Enums$OrderType.TRAIL) {
            this.usePips = ae.r(this.getAccount());
            if (ae.a(this.getAccount())) {
                this.usePips = this.isUsePips();
            }
            if (ae.t(this.getAccount())) {
                float f4 = (float)n2 * f3;
                f2 = this.isBuy() ? ticker.round(ticker.getAskPrice() + f4) : ticker.round(ticker.getBidPrice() - f4);
            } else {
                f2 = al.a(this, this.usePips);
            }
        }
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.STPLMT, Enums$OrderType.MIT})) {
            f2 = this.isSell() ? (f2 -= (float)n3 * f3) : (f2 += (float)n3 * f3);
        }
        if (this.isTrailPts()) {
            f2 = this.isSell() ? (f2 -= (float)n2 * f3) : (f2 += (float)n2 * f3);
        }
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.LMT, Enums$OrderType.ICEBERG})) {
            f2 = this.isSell() ? (f2 += (float)n4 * f3) : (f2 -= (float)n4 * f3);
        }
        f2 = mWInstrument.round(f2);
        if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STP, Enums$OrderType.MIT, Enums$OrderType.TRAIL})) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.limitPrice = 0.0f;
            this.adjustedLimitPrice = null;
            if (this.isTrailPts()) {
                this.trailPoints = n2;
                this.adjustedTrailPoints = null;
            }
        } else if (h.a((Object)enums$OrderType, new Object[]{Enums$OrderType.STPLMT, Enums$OrderType.LIT})) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
        } else if (enums$OrderType == Enums$OrderType.LMT) {
            this.limitPrice = f2;
            this.adjustedLimitPrice = Float.valueOf(f2);
            this.auxPrice = 0.0f;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
        }
    }

    public void setFromDefaults() {
        MWInstrument mWInstrument = this.getInstrument();
        OrderPreset orderPreset = mWInstrument.getOrderPreset();
        int n2 = 10;
        int n3 = 10;
        int n4 = 10;
        if (orderPreset != null) {
            this.setTif(mWInstrument.getDefaultTIF());
            n2 = orderPreset.getLimitOffset();
            n3 = orderPreset.getTrailOffset();
            n4 = orderPreset.getStopOffset();
            this.setQuantity(mWInstrument.getDefaultQuantity());
            if (!h.g(orderPreset.getTradeRoute())) {
                for (cw cw2 : this.getTradeRoutes()) {
                    if (!h.a((Object)cw2.b(), (Object)orderPreset.getTradeRoute())) continue;
                    this.setTradeRoute(cw2);
                }
            }
        } else {
            h.a.severe("MWOrder::setFromDefaults() OrderPreset not defined for instrument: " + this.ticker.getKey());
        }
        if (this.isMarket()) {
            this.adjustedAuxPrice = null;
            this.auxPrice = 0.0f;
            this.adjustedLimitPrice = null;
            this.limitPrice = 0.0f;
            this.adjustedUsePips = null;
            return;
        }
        float f2 = this.ticker.getBidPrice();
        if (this.isSell()) {
            f2 = this.ticker.getAskPrice();
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getMidOrLast();
        }
        float f3 = (float)this.getTicker().getTickSize();
        if (this.isTrail()) {
            f2 = (float)n3 * f3;
        }
        if (this.isStop() || this.getType() == Enums$OrderType.MIT) {
            f2 = this.isTrailPts() ? (this.isSell() ? (f2 -= (float)n3 * f3) : (f2 += (float)n3 * f3)) : (this.isSell() ? (f2 -= (float)n4 * f3) : (f2 += (float)n4 * f3));
        }
        if (this.isLimit()) {
            f2 = this.isSell() ? (f2 += (float)n2 * f3) : (f2 -= (float)n2 * f3);
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getLastPrice();
        }
        if (!mWInstrument.isValueValid(f2)) {
            f2 = this.ticker.getMidpoint();
        }
        if (this.isTrigger() || this.isTrail()) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.limitPrice = 0.0f;
            this.adjustedLimitPrice = null;
            if (this.isTrailPts()) {
                this.trailPoints = n3;
                this.adjustedTrailPoints = null;
            }
            this.adjustedUsePips = null;
        } else if (this.isTriggerLimit()) {
            this.auxPrice = f2;
            this.adjustedAuxPrice = null;
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
            this.adjustedUsePips = null;
        } else if (this.isLimit()) {
            this.limitPrice = f2;
            this.adjustedLimitPrice = null;
            this.auxPrice = 0.0f;
            this.adjustedAuxPrice = null;
            this.adjustedUsePips = null;
        }
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String string) {
        String string2 = this.accountID;
        Account account = this.getAccount();
        String string3 = this.format("accountName");
        this.accountID = string;
        Account account2 = ae.a(this.accountID);
        if (account2 != null) {
            this.simulatedOrder = account2.isSimulatedAccount();
        }
        this.firePropertyChange("accountID", string2, this.accountID);
        this.firePropertyChange("account", account, account2);
        this.firePropertyChange("accountName", string3, this.format("accountName"));
    }

    public Account getAccount() {
        return ae.a(this.accountID);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        Position position2 = this.position;
        this.position = position;
        this.firePropertyChange("position", position2, this.position);
    }

    public PositionSummary getPositionSummary() {
        return this.positionSummary;
    }

    public void setPositionSummary(PositionSummary positionSummary) {
        PositionSummary positionSummary2 = this.positionSummary;
        this.positionSummary = positionSummary;
        this.firePropertyChange("positionSummary", positionSummary2, this.positionSummary);
    }

    public boolean isUsePips() {
        return this.usePips;
    }

    public void setUsePips(boolean bl2) {
        boolean bl3 = this.usePips;
        if (bl3 == bl2) {
            return;
        }
        this.usePips = bl2;
        this.firePropertyChange("usePips", bl3, this.usePips);
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        float f3;
        if (f2 < 0.0f) {
            f2 = Math.abs(f2);
        }
        if ((f3 = this.quantity) == f2) {
            return;
        }
        this.quantity = f2;
        this.firePropertyChange("quantity", f3, this.quantity);
    }

    public float getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(float f2) {
        float f3 = this.limitPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        this.limitPrice = f2;
        this.firePropertyChange("limitPrice", f3, this.limitPrice);
        this.firePropertyChange("orderPrice", f3, this.limitPrice);
        this.firePropertyChange("triggerPrice", f3, this.limitPrice);
        this.firePropertyChange("adjustedTriggerPrice", f3, this.limitPrice);
        this.notifyAttachedOrders();
        if (this.isLimit() && this.hasParent()) {
            MWOrder mWOrder = this.getParentOrder();
            if (mWOrder != null) {
                mWOrder.firePropertyChange("limitOrderPL", null, (Object)this.getOrderPL());
            }
            if (this.position != null) {
                this.position.firePropertyChange("limitOrderPL", null, (Object)this.getOrderPL());
            }
            if (this.positionSummary != null) {
                this.positionSummary.firePropertyChange("netLimitOrderPL", null, (Object)this.getOrderPL());
            }
        }
    }

    private float round(float f2) {
        if (this.ticker != null) {
            return this.ticker.round(f2);
        }
        MWInstrument mWInstrument = this.getInstrument();
        return mWInstrument == null ? f2 : mWInstrument.round(f2);
    }

    public float getStopPrice() {
        return this.getAuxPrice();
    }

    public void setStopPrice(float f2) {
        this.setAuxPrice(f2);
    }

    public void setStopLimitPrice(float f2) {
        this.setLimitPrice(f2);
    }

    public float getAuxPrice() {
        return this.isLimit() ? 0.0f : this.auxPrice;
    }

    public void setAuxPrice(float f2) {
        float f3 = this.auxPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        double d2 = this.getOrderPL();
        this.auxPrice = f2;
        this.firePropertyChange("auxPrice", f3, f2);
        this.firePropertyChange("orderPrice", f3, f2);
        this.firePropertyChange("triggerPrice", f3, f2);
        this.notifyAttachedOrders();
        if ((this.isStop() || this.isTrail()) && this.hasParent()) {
            MWOrder mWOrder = this.getParentOrder();
            if (mWOrder != null) {
                mWOrder.firePropertyChange("stopOrderPL", d2, this.getOrderPL());
            }
            if (this.position != null) {
                this.position.firePropertyChange("stopOrderPL", d2, this.getOrderPL());
            }
            if (this.positionSummary != null) {
                this.positionSummary.firePropertyChange("netStopOrderPL", null, (Object)this.getOrderPL());
            }
        }
    }

    public float getTrailStopPrice() {
        return this.trailStopPrice;
    }

    public void setTrailStopPrice(float f2) {
        float f3 = this.trailStopPrice;
        if (f3 == (f2 = this.round(f2))) {
            return;
        }
        this.trailStopPrice = f2;
        this.firePropertyChange("trailStopPrice", f3, f2);
        this.firePropertyChange("orderPrice", f3, f2);
        this.firePropertyChange("triggerPrice", f3, f2);
    }

    public Enums$TIF getTif() {
        return this.tif;
    }

    public void setTif(Enums$TIF enums$TIF) {
        Enums$TIF enums$TIF2 = this.tif;
        this.tif = enums$TIF;
        this.firePropertyChange("tif", (Object)enums$TIF2, (Object)this.tif);
    }

    public void discardChanges() {
        MWOrder mWOrder;
        float f2 = this.getAdjustedQuantity();
        this.adjustedQuantity = null;
        this.firePropertyChange("adjustedQuantity", f2, this.getAdjustedQuantity());
        boolean bl2 = this.isAdjustedUsePips();
        this.adjustedUsePips = null;
        this.firePropertyChange("adjustedUsePips", bl2, this.isAdjustedUsePips());
        float f3 = this.getAdjustedLimitPrice();
        this.adjustedLimitPrice = null;
        this.firePropertyChange("adjustedLimitPrice", f3, this.getAdjustedLimitPrice());
        float f4 = this.getAdjustedAuxPrice();
        this.adjustedAuxPrice = null;
        this.firePropertyChange("adjustedAuxPrice", f4, this.getAdjustedAuxPrice());
        Enums$TIF enums$TIF = this.getAdjustedTif();
        this.adjustedTif = null;
        this.firePropertyChange("adjustedTif", (Object)enums$TIF, (Object)this.getAdjustedTif());
        Long l2 = this.getAdjustedExpiryDate();
        this.adjustedExpiryDate = null;
        this.firePropertyChange("adjustedExpiryDate", l2, this.getAdjustedExpiryDate());
        boolean bl3 = this.isAdjustedOutsideRTH();
        this.adjustedOutsideRTH = null;
        this.firePropertyChange("adjustedOutsideRTH", bl3, this.isOutsideRTH());
        Date date = this.getAdjustedGTD();
        this.adjustedGTD = null;
        this.firePropertyChange("adjustedGTD", date, this.getAdjustedGTD());
        bl3 = this.isAdjustedTrailFixed();
        this.adjustedTrailFixed = null;
        this.firePropertyChange("adjustedTrailFixed", bl3, this.isAdjustedTrailFixed());
        float f5 = this.getAdjustedTrailPoints();
        this.adjustedTrailPoints = null;
        this.firePropertyChange("adjustedTrailPoints", f5, (float)this.getAdjustedTrailPoints());
        this.updateAdjustedState();
        this.firePropertyChange("orderPrice", 0.0f, this.getOrderPrice());
        this.firePropertyChange("auxPrice", 0.0f, this.getAuxPrice());
        this.firePropertyChange("limitPrice", 0.0f, this.getLimitPrice());
        this.firePropertyChange("tif", null, (Object)this.getTif());
        this.firePropertyChange("quantity", 0.0f, this.getQuantity());
        this.firePropertyChange("trailPoints", 0, this.getTrailPoints());
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.firePropertyChange("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isLimit()) {
                mWOrder.firePropertyChange("limitOrderPrice", f3, this.getAdjustedLimitPrice());
            } else if (this.isStop() || this.isTrail()) {
                mWOrder.firePropertyChange("stopTrailOrderPrice", f4, this.getAdjustedAuxPrice());
            }
        }
    }

    public void commitChanges() {
        this.setQuantity(this.getAdjustedQuantity());
        this.setUsePips(this.isAdjustedUsePips());
        this.setLimitPrice(this.getAdjustedLimitPrice());
        this.setAuxPrice(this.getAdjustedAuxPrice());
        this.setTif(this.getAdjustedTif());
        this.setOutsideRTH(this.isAdjustedOutsideRTH());
        this.setGTD(this.getAdjustedGTD());
        this.setExpiryDate(this.getAdjustedExpiryDate());
        this.setTrailFixed(this.isAdjustedTrailFixed());
        this.setTrailPoints(this.getAdjustedTrailPoints());
        this.discardChanges();
        this.lastCommit = System.currentTimeMillis();
    }

    public long getLastCommit() {
        return this.lastCommit;
    }

    public boolean wasCommittedRecently() {
        return System.currentTimeMillis() - this.lastCommit < 1500L;
    }

    public float getAdjustedQuantity() {
        return this.adjustedQuantity == null ? this.quantity : this.adjustedQuantity.floatValue();
    }

    public void setAdjustedQuantity(float f2) {
        float f3;
        if (f2 < 0.0f) {
            h.c();
            f2 = Math.abs(f2);
        }
        if ((f3 = this.getAdjustedQuantity()) == f2) {
            return;
        }
        this.adjustedQuantity = Float.valueOf(f2);
        this.updateAdjustedState();
        this.firePropertyChange("adjustedQuantity", f3, f2);
        this.notifyAttachedOrders();
    }

    public float getAdjustedLimitPrice() {
        return this.adjustedLimitPrice == null || this.adjustedLimitPrice.floatValue() == 0.0f ? this.limitPrice : this.adjustedLimitPrice.floatValue();
    }

    public void setAdjustedLimitPrice(float f2) {
        MWOrder mWOrder;
        if (this.isAdjustedUsePips()) {
            f2 = h.a(f2, 1);
            if (this.isLimit() && f2 < 1.0f) {
                f2 = 1.0f;
            } else if (this.isStop() && f2 > -1.0f) {
                f2 = -1.0f;
            }
        } else {
            f2 = this.round(f2);
        }
        float f3 = this.getAdjustedLimitPrice();
        if (f3 == f2) {
            return;
        }
        this.adjustedLimitPrice = Float.valueOf(f2);
        this.updateAdjustedState();
        this.firePropertyChange("adjustedLimitPrice", f3, f2);
        this.firePropertyChange("orderPrice", f3, f2);
        if (this.isNew()) {
            this.setLimitPrice(f2);
        }
        this.firePropertyChange("triggerPrice", f3, f2);
        this.firePropertyChange("adjustedTriggerPrice", f3, f2);
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.firePropertyChange("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isLimit()) {
                mWOrder.firePropertyChange("limitOrderPrice", f3, f2);
            }
        }
        this.notifyAttachedOrders();
    }

    public float getAdjustedAuxPrice() {
        return this.adjustedAuxPrice == null || this.adjustedAuxPrice.floatValue() == 0.0f ? this.getAuxPrice() : this.adjustedAuxPrice.floatValue();
    }

    public void setAdjustedAuxPrice(float f2) {
        MWOrder mWOrder;
        float f3;
        if (this.isAdjustedUsePips()) {
            f2 = h.a(f2, 1);
            if (this.isStop() && f2 > -1.0f) {
                f2 = -1.0f;
            }
        } else {
            f2 = this.round(f2);
        }
        if ((f3 = this.getAdjustedAuxPrice()) == f2) {
            return;
        }
        this.adjustedAuxPrice = Float.valueOf(f2);
        this.updateAdjustedState();
        this.firePropertyChange("adjustedAuxPrice", f3, f2);
        if (this.isNew()) {
            this.setAuxPrice(f2);
        }
        this.firePropertyChange("orderPrice", f3, f2);
        this.firePropertyChange("triggerPrice", f3, f2);
        this.firePropertyChange("adjustedTriggerPrice", f3, f2);
        if (this.hasParent() && (mWOrder = this.getParentOrder()) != null) {
            mWOrder.firePropertyChange("stopLimitAdjusted", null, (Object)mWOrder.isStopLimitAdjusted());
            if (this.isStop() || this.isTrail()) {
                mWOrder.firePropertyChange("stopTrailOrderPrice", f3, f2);
            }
        }
        this.notifyAttachedOrders();
    }

    private void notifyAttachedOrders() {
        if (this.getLimitOrder() != null) {
            this.firePropertyChange("limitOrderPL", 0.0, this.getLimitOrderPL());
        }
        if (this.getStopTrailOrder() != null) {
            this.firePropertyChange("stopOrderPL", 0.0, this.getStopOrderPL());
        }
    }

    public Object getAdjustedExpires() {
        return ae.C(this.getAccount()) ? this.getAdjustedExpiryDate() : this.getAdjustedTif();
    }

    public void setAdjustedExpires(Object object) {
        if (ae.C(this.getAccount())) {
            Long l2 = null;
            if (object instanceof e) {
                l2 = (Long)((e)object).a();
            } else if (object instanceof Long) {
                l2 = (Long)object;
            } else if (object instanceof Enums$OrderExpiry) {
                l2 = ((Enums$OrderExpiry)((Object)object)).toLong();
            } else {
                return;
            }
            this.setAdjustedExpiryDate(l2);
        } else {
            if (object != null && !(object instanceof Enums$TIF)) {
                return;
            }
            this.setAdjustedTif((Enums$TIF)((Object)object));
        }
    }

    public Enums$TIF getAdjustedTif() {
        return this.adjustedTif == null ? this.tif : this.adjustedTif;
    }

    public void setAdjustedTif(Enums$TIF enums$TIF) {
        Enums$TIF enums$TIF2 = this.getAdjustedTif();
        if (enums$TIF == enums$TIF2) {
            return;
        }
        this.adjustedTif = enums$TIF;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedTif", (Object)enums$TIF2, (Object)this.adjustedTif);
        this.firePropertyChange("adjustedExpires", (Object)enums$TIF2, (Object)this.adjustedTif);
    }

    public Date getAdjustedGTD() {
        return this.adjustedGTD == null ? this.gTD : this.adjustedGTD;
    }

    public void setAdjustedGTD(Date date) {
        Date date2 = this.getAdjustedGTD();
        if (h.a((Object)date2, (Object)date)) {
            return;
        }
        this.adjustedGTD = date;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedGTD", date2, date);
        if (this.isNew()) {
            this.setGTD(date);
        }
    }

    public Long getAdjustedExpiryDate() {
        return this.adjustedExpiryDate == null ? this.expiryDate : this.adjustedExpiryDate;
    }

    public void setAdjustedExpiryDate(Long l2) {
        if (!ae.C(this.getAccount())) {
            return;
        }
        if (h.a((Object)l2, (Object)this.getAdjustedExpiryDate())) {
            return;
        }
        Long l3 = this.getAdjustedExpiryDate();
        this.adjustedExpiryDate = l2;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedExpiryDate", l3, l2);
        this.firePropertyChange("adjustedExpires", l3, l2);
        if (this.isNew()) {
            this.setExpiryDate(l2);
        }
    }

    public boolean isAdjustedOutsideRTH() {
        return this.adjustedOutsideRTH == null ? this.outsideRTH : this.adjustedOutsideRTH;
    }

    public void setAdjustedOutsideRTH(boolean bl2) {
        boolean bl3 = this.isAdjustedOutsideRTH();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedOutsideRTH = bl2;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedOutsideRTH", bl3, bl2);
    }

    public Enums$OrderAction getAction() {
        return this.action;
    }

    public void setAction(Enums$OrderAction enums$OrderAction) {
        Enums$OrderAction enums$OrderAction2 = this.action;
        if (enums$OrderAction2 == enums$OrderAction) {
            return;
        }
        this.action = enums$OrderAction;
        this.firePropertyChange("action", (Object)enums$OrderAction2, (Object)this.action);
    }

    public String getPermanentId() {
        return this.permanentId;
    }

    public void setPermanentId(String string) {
        String string2 = this.permanentId;
        this.permanentId = string;
        this.firePropertyChange("permanentId", string2, this.permanentId);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String string) {
        String string2 = this.orderId;
        this.orderId = string;
        if (h.g(this.origOrderId)) {
            this.origOrderId = string;
        }
        this.firePropertyChange("orderId", string2, string);
        if (h.g(this.ticket)) {
            this.firePropertyChange("ticket", string2, string);
        }
    }

    public boolean is(String ... stringArray) {
        for (String string : stringArray) {
            if (h.g(string)) {
                return false;
            }
            if (!h.a((Object)string, (Object)this.orderId) && !h.a((Object)string, (Object)this.origOrderId)) continue;
            return true;
        }
        return false;
    }

    public boolean is(List list) {
        for (String string : list) {
            if (h.g(string)) {
                return false;
            }
            if (!h.a((Object)string, (Object)this.orderId) && !h.a((Object)string, (Object)this.origOrderId)) continue;
            return true;
        }
        return false;
    }

    public String getOrigOrderId() {
        return this.origOrderId;
    }

    public void setOrigOrderId(String string) {
        this.origOrderId = string;
    }

    public String getLabel() {
        Object object = "";
        String string = "";
        if (this.isAdjusted()) {
            if (this.isTrigger() || this.isTrail()) {
                object = this.format("adjustedAuxPrice");
            } else if (this.isTriggerLimit()) {
                object = this.format("adjustedAuxPrice") + "(" + this.format("adjustedLimitPrice") + ")";
            } else if (this.isLimit()) {
                object = this.format("adjustedLimitPrice");
            }
            string = s.b(this.getAdjustedQuantity(), this.getInstrument());
        } else {
            if (this.isTrigger() || this.isTrail()) {
                object = this.format("auxPrice");
            } else if (this.isTriggerLimit()) {
                object = this.format("auxPrice") + "(" + this.format("limitPrice") + ")";
            } else if (this.isLimit()) {
                object = this.format("limitPrice");
            }
            string = this.isFilled() ? s.b(this.getFilled(), this.getInstrument()) : (this.getRemaining() > 0.0f ? s.b(this.getRemaining(), this.getInstrument()) : s.b(this.getQuantity(), this.getInstrument()));
        }
        Object object2 = "";
        if (ae.z(this.getAccount())) {
            object2 = this.isEntryOrder() && !this.isNetClose() ? "+" : "-";
        }
        if (this.isMarket()) {
            if (this.isFilled()) {
                object = this.format("lastFillPrice");
            } else {
                return (String)object2 + this.getType() + " " + string + "@" + this.getInstrument().formatValue(this.getMktPrice());
            }
        }
        if (this.isFilled()) {
            object = this.format("lastFillPrice");
            object2 = this.isBuy() ? (String)object2 + "BOT " : (String)object2 + "SLD ";
            return (String)object2 + this.getType() + " " + s.b(this.getFilled(), this.getInstrument()) + "@" + (String)object;
        }
        return (String)object2 + this.getType() + " " + string + "@" + (String)object;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String string) {
        String string2 = this.parentId;
        this.parentId = string;
        this.firePropertyChange("parentId", string2, this.parentId);
    }

    public boolean isParentEmpty() {
        if (h.g(this.parentId)) {
            return true;
        }
        return this.parentId.equals("0");
    }

    public MWOrder getParentOrder() {
        if (this.isParentEmpty()) {
            return null;
        }
        MWOrder mWOrder = OrderDirectory.findOrder(this.parentId);
        if (mWOrder == null && !h.g(this.parentId)) {
            mWOrder = OrderDirectory.findByOrigId(this.parentId);
        }
        return mWOrder;
    }

    public Color getGroupColor() {
        if (this.isNetClose()) {
            return null;
        }
        List list = OrderDirectory.findDependentOrders(this);
        if (h.a((Collection)list)) {
            return null;
        }
        if (!this.isParentEmpty() && this.getParentOrder() != null) {
            MWOrder mWOrder = this.getParentOrder();
            if (mWOrder == this) {
                return null;
            }
            for (int i2 = 0; i2 < 5 && mWOrder.getParentOrder() != null; ++i2) {
                if (!mWOrder.hasParent() || mWOrder.getParentOrder() == this) continue;
                mWOrder = mWOrder.getParentOrder();
            }
            if (mWOrder.groupColor != null) {
                return mWOrder.groupColor;
            }
            mWOrder.groupColor = OrderDirectory.getNextColor();
            return mWOrder.groupColor;
        }
        if (!h.g(this.getOCAId())) {
            for (MWOrder mWOrder : list) {
                if (!h.a((Object)this.getOCAId(), (Object)mWOrder.getOCAId())) continue;
                return OrderDirectory.getOCOColor(this.getOCAId());
            }
        }
        if (this.groupColor != null) {
            return this.groupColor;
        }
        this.groupColor = OrderDirectory.getNextColor();
        return this.groupColor;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String string) {
        String string2 = this.clientId;
        this.clientId = string;
        this.firePropertyChange("clientId", string2, this.clientId);
    }

    public String getTicket() {
        return h.g(this.ticket) ? this.orderId : this.ticket;
    }

    public void setTicket(String string) {
        String string2 = this.ticket;
        this.ticket = string;
        this.firePropertyChange("ticket", string2, this.ticket);
    }

    public int getIBOrderId() {
        return this.ibOrderId;
    }

    public void setIBOrderId(int n2) {
        int n3 = n2;
        this.ibOrderId = n2;
        this.firePropertyChange("iBOrderId", n3, this.ibOrderId);
    }

    public String getOCAId() {
        return this.ocaId;
    }

    public void setOCAId(String string) {
        String string2 = this.ocaId;
        this.ocaId = string;
        this.firePropertyChange("OACId", string2, this.ocaId);
        List list = OrderDirectory.findDependentOrders(this);
        if (!h.a((Collection)list)) {
            for (MWOrder mWOrder : list) {
                if (mWOrder == this) continue;
                mWOrder.firePropertyChange("groupColor", null, this.getGroupColor());
            }
        }
        this.firePropertyChange("groupColor", null, this.getGroupColor());
    }

    public boolean isOutsideRTH() {
        return this.outsideRTH;
    }

    public void setOutsideRTH(boolean bl2) {
        boolean bl3 = this.outsideRTH;
        this.outsideRTH = bl2;
        this.firePropertyChange("outsideRTH", bl3, this.outsideRTH);
    }

    public Enums$OrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(Enums$OrderStatus enums$OrderStatus) {
        if (this.getStatus() == enums$OrderStatus) {
            return;
        }
        if (this.getStatus() == Enums$OrderStatus.FILLED && enums$OrderStatus != Enums$OrderStatus.FILLED) {
            h.a.warning("MWOrder::setStatus() setting to submitted when it is already filled! (ignoring): " + enums$OrderStatus);
            return;
        }
        Enums$OrderStatus enums$OrderStatus2 = this.getStatus();
        this.status = enums$OrderStatus;
        this.firePropertyChange("status", (Object)enums$OrderStatus2, (Object)this.getStatus());
        if (this.status == Enums$OrderStatus.CANCELED || this.status == Enums$OrderStatus.FILLED || this.isRejected()) {
            this.removeListeners(this.ticker);
        }
    }

    public String getSymbol() {
        return this.ticker.getSymbol();
    }

    public boolean isFilled() {
        float f2 = Math.abs(this.filled);
        return this.status == Enums$OrderStatus.FILLED || f2 > 0.0f && f2 >= Math.abs(this.getQuantity());
    }

    public boolean isPartiallyFilled() {
        return this.status == Enums$OrderStatus.PARTIALLY_FILLED;
    }

    public boolean isActive() {
        return !this.isFilled() && !this.isCancelled() && !this.isRejected();
    }

    public float getFilled() {
        return this.filled;
    }

    public void setFilled(float f2) {
        float f3 = this.filled;
        this.filled = f2;
        this.firePropertyChange("filled", f3, this.filled);
    }

    public float getRemaining() {
        return this.remaining;
    }

    public void setRemaining(float f2) {
        float f3 = this.remaining;
        this.remaining = f2;
        this.firePropertyChange("remaining", f3, this.remaining);
    }

    public float getAvgFillPrice() {
        return this.avgFillPrice;
    }

    public void setAvgFillPrice(float f2) {
        float f3 = this.avgFillPrice;
        this.avgFillPrice = f2;
        this.firePropertyChange("avgFillPrice", f3, this.avgFillPrice);
    }

    public float getLastFillPrice() {
        if (this.lastFillPrice > 0.0f) {
            return this.lastFillPrice;
        }
        if (this.avgFillPrice > 0.0f) {
            return this.avgFillPrice;
        }
        return this.lastFillPrice;
    }

    public void setLastFillPrice(float f2) {
        float f3 = this.lastFillPrice;
        this.lastFillPrice = f2;
        this.firePropertyChange("lastFillPrice", f3, this.lastFillPrice);
    }

    public long getLastFillTime() {
        return this.lastFillTime;
    }

    public void setLastFillTime(long l2) {
        long l3 = this.lastFillTime;
        this.lastFillTime = l2;
        this.firePropertyChange("lastFillTime", l3, this.lastFillTime);
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(String string) {
        String string2 = this.rejectReason;
        this.rejectReason = string;
        this.firePropertyChange("rejectReason", string2, this.rejectReason);
    }

    public Object getRejectCode() {
        return this.rejectCode;
    }

    public void setRejectCode(Object object) {
        Object object2 = this.rejectCode;
        this.rejectCode = object;
        this.firePropertyChange("rejectCode", object2, this.rejectCode);
    }

    public Date getGTD() {
        return this.gTD;
    }

    public void setGTD(Date date) {
        Date date2 = this.gTD;
        this.gTD = date;
        this.firePropertyChange("GTD", date2, this.gTD);
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Long l2) {
        Long l3 = this.expiryDate;
        this.expiryDate = l2;
        this.firePropertyChange("expiryDate", l3, this.expiryDate);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MWOrder)) {
            return false;
        }
        MWOrder mWOrder = (MWOrder)object;
        return h.a((Object)this.orderId, (Object)mWOrder.orderId);
    }

    public String toString() {
        String string = "ID: " + this.orderId + " " + this.getAccountID() + " " + this.getSymbol() + " " + this.status + " " + this.action + " " + this.orderType;
        if (!h.g(this.ocaId)) {
            string = string + " " + this.ocaId;
        }
        if (!h.g(this.tag)) {
            string = string + " " + this.tag;
        }
        if (this.entryOrder != null) {
            string = this.isEntryOrder() ? string + " ENTRY" : string + " EXIT";
        }
        if (this.limitPrice != 0.0f) {
            string = string + " Limit:" + this.limitPrice;
        }
        if (this.auxPrice != 0.0f) {
            string = string + " Aux:" + this.auxPrice;
        }
        string = string + " Qty:" + this.quantity + " " + this.tif;
        if (!h.b((Object)this.adjustedLimitPrice)) {
            string = string + " Adj Limit:" + this.adjustedLimitPrice;
        }
        if (!h.b((Object)this.adjustedAuxPrice)) {
            string = string + " Adj Aux:" + this.adjustedAuxPrice;
        }
        if (!h.b((Object)this.adjustedQuantity)) {
            string = string + " Adj Qty:" + this.adjustedQuantity;
        }
        return string;
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.b("id", this.orderId), this.b("accountId", this.accountID), this.b("parentId", this.parentId), this.a("instr", this.getInstrument()), this.a("entry", this.isEntryOrder()), this.a("action", (Object)this.action), this.a("type", (Object)this.orderType), this.a("quantity", this.quantity), this.a("status", (Object)this.getStatus()), this.a("usePips", this.usePips, false), this.a("limitPrice", this.getLimitPrice(), 0.0f), this.a("auxPrice", this.getAuxPrice(), 0.0f), this.a("outsideRTH", this.outsideRTH), this.a("tif", (Object)this.tif), this.a("expiryDate", (Object)this.expiryDate), this.a("gtd", (Object)this.gTD), this.b("tag", this.tag), this.a("trailFixed", this.trailFixed, false), this.a("trailPoints", this.trailPoints, 0), this.a("trailStopPrice", this.trailStopPrice, 0.0f), this.a("orderDate", (Object)this.getOrderDate())});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.orderId = jSONObject.str("id");
        this.accountID = jSONObject.str("accountId");
        this.parentId = jSONObject.str("parentId");
        this.setInstrument(this.a(jSONObject, "instr"));
        this.setEntryOrder(jSONObject.is("entry"));
        try {
            this.orderType = Enums$OrderType.valueOf(jSONObject.str("type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.action = Enums$OrderAction.valueOf(jSONObject.str("action"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.status = Enums$OrderStatus.valueOf(jSONObject.str("status"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tif = Enums$TIF.valueOf(jSONObject.str("tif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.quantity = jSONObject.getFloat("quantity");
        this.usePips = jSONObject.is("usePips", false);
        this.limitPrice = jSONObject.getFloat("limitPrice");
        this.trailStopPrice = jSONObject.getFloat("trailStopPrice");
        this.auxPrice = jSONObject.getFloat("auxPrice");
        this.outsideRTH = jSONObject.is("outsideRTH");
        this.trailFixed = jSONObject.is("trailFixed", false);
        this.trailPoints = jSONObject.getInt("trailPoints");
        if (jSONObject.has("expiryDate")) {
            this.expiryDate = jSONObject.getLong("expiryDate");
        }
        if (jSONObject.has("gtd")) {
            this.gTD = new Date(jSONObject.getLong("gtd"));
        }
        if (jSONObject.has("orderDate")) {
            this.orderDate = new Date(jSONObject.getLong("orderDate"));
        }
        this.tag = jSONObject.str("tag");
        this.simulatedOrder = h.a((Object)this.accountID, (Object)"simulated");
    }

    public static MWOrder read(Element element) {
        String string;
        String string2;
        String string3 = element.getAttribute("id");
        String string4 = element.getAttribute("accountId");
        String string5 = element.getAttribute("parentId");
        String string6 = element.getAttribute("symbol");
        MWInstrument mWInstrument = MWInstrument.get(string6, string2 = element.getAttribute("exchange"));
        if (mWInstrument == null) {
            h.a.warning("MWOrder::read() instrument not found: " + string6 + "." + string2);
            return null;
        }
        Enums$OrderAction enums$OrderAction = Enums$OrderAction.valueOf(element.getAttribute("action"));
        Enums$OrderType enums$OrderType = Enums$OrderType.valueOf(element.getAttribute("type"));
        Enums$OrderStatus enums$OrderStatus = Enums$OrderStatus.valueOf(element.getAttribute("status"));
        int n2 = h.b(element.getAttribute("quantity"));
        float f2 = h.b(element.getAttribute("limitPrice"));
        float f3 = h.b(element.getAttribute("auxPrice"));
        long l2 = h.b(element.getAttribute("openTime"));
        MWOrder mWOrder = new MWOrder(string4, string3, LiveTicker.get(mWInstrument), enums$OrderAction, enums$OrderType, enums$OrderStatus);
        mWOrder.setQuantity(n2);
        mWOrder.setOrderDate(new Date(l2));
        mWOrder.setLimitPrice(f2);
        mWOrder.setAuxPrice(f3);
        if (!h.g(string5)) {
            mWOrder.setParentId(string5);
            mWOrder.setTradeId(string5);
        }
        if (!h.g(string = element.getAttribute("outsideRTH"))) {
            mWOrder.outsideRTH = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("tif"))) {
            mWOrder.tif = Enums$TIF.valueOf(string);
        }
        if (!h.g(string = element.getAttribute("expiryDate"))) {
            mWOrder.expiryDate = h.b(string);
        }
        if (!h.g(string = element.getAttribute("gtd"))) {
            mWOrder.gTD = new Date(h.b(string));
        }
        if (!h.g(string = element.getAttribute("tag"))) {
            mWOrder.tag = string;
        }
        if (!h.g(string = element.getAttribute("trailFixed"))) {
            mWOrder.trailFixed = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("trailPoints"))) {
            mWOrder.trailPoints = h.b(string);
        }
        if (!h.g(string = element.getAttribute("trailStopPrice"))) {
            mWOrder.trailStopPrice = h.b(string);
        }
        if (!h.g(string = element.getAttribute("usePips"))) {
            mWOrder.usePips = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("entry"))) {
            mWOrder.entryOrder = h.a((Object)string);
        }
        mWOrder.discardChanges();
        return mWOrder;
    }

    public void addChild(String string) {
        this.childOrders.a(string);
    }

    public void removeAllChildren() {
        this.childOrders.b();
    }

    public void removeChild(String string) {
        this.childOrders.a(string);
    }

    public List getChildren() {
        return this.childOrders.a();
    }

    public List getChildOrders() {
        if (this.childOrders.a()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (String string : this.childOrders.a()) {
            MWOrder mWOrder = OrderDirectory.findOrder(string);
            if (mWOrder == null) {
                mWOrder = OrderDirectory.findByOrigId(string);
            }
            if (mWOrder == null) continue;
            arrayList.add(mWOrder);
        }
        return arrayList;
    }

    public boolean hasChildren() {
        return !this.childOrders.a();
    }

    public boolean hasParent() {
        return !this.isParentEmpty();
    }

    public boolean isEntryOrder() {
        if (this.entryOrder != null) {
            return this.entryOrder;
        }
        Account account = this.getAccount();
        if (account != null && account.isHedging()) {
            return true;
        }
        float f2 = PositionDirectory.getPosition(this.getInstrument(), account);
        if (this.isBuy()) {
            return f2 >= 0.0f;
        }
        return f2 <= 0.0f;
    }

    public void setEntryOrder(boolean bl2) {
        this.entryOrder = bl2;
    }

    public boolean isNetClose() {
        return this.netClose;
    }

    public void setNetClose(boolean bl2) {
        this.netClose = bl2;
    }

    public String getRateId() {
        return this.rateId;
    }

    public void setRateId(String string) {
        this.rateId = string;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float f2) {
        this.rate = f2;
    }

    public float getMarketRange() {
        return this.marketRange;
    }

    public void setMarketRange(float f2) {
        this.marketRange = f2;
    }

    public boolean isUseMarketRange() {
        return this.useMarketRange;
    }

    public void setUseMarketRange(boolean bl2) {
        this.useMarketRange = bl2;
    }

    public boolean isTrailFixed() {
        return this.trailFixed;
    }

    public void setTrailFixed(boolean bl2) {
        this.trailFixed = bl2;
    }

    public boolean isAdjustedTrailFixed() {
        if (this.adjustedTrailFixed == null) {
            return this.trailFixed;
        }
        return this.adjustedTrailFixed;
    }

    public void setAdjustedTrailFixed(boolean bl2) {
        boolean bl3 = this.isAdjustedTrailFixed();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedTrailFixed = bl2;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedTrailFixed", bl3, bl2);
    }

    public boolean isAdjustedUsePips() {
        if (this.adjustedUsePips == null) {
            return this.usePips;
        }
        return this.adjustedUsePips;
    }

    public void setAdjustedUsePips(boolean bl2) {
        boolean bl3 = this.isAdjustedUsePips();
        if (bl2 == bl3) {
            return;
        }
        this.adjustedUsePips = bl2;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedUsePips", bl3, bl2);
    }

    public int getTrailPoints() {
        return this.trailPoints;
    }

    public void setTrailPoints(int n2) {
        this.trailPoints = n2;
    }

    public int getAdjustedTrailPoints() {
        if (this.adjustedTrailPoints == null || this.adjustedTrailPoints == 0) {
            return this.trailPoints;
        }
        return this.adjustedTrailPoints;
    }

    public void setAdjustedTrailPoints(int n2) {
        int n3 = this.getAdjustedTrailPoints();
        if (n3 == n2) {
            return;
        }
        this.adjustedTrailPoints = n2;
        this.updateAdjustedState();
        this.firePropertyChange("adjustedTrailPoints", n3, n2);
    }

    public boolean isForceClientAttached() {
        return this.forceClientAttached;
    }

    public void setForceClientAttached(boolean bl2) {
        this.forceClientAttached = bl2;
    }

    public void setChildOrder(MWOrder mWOrder) {
        if (mWOrder == null) {
            return;
        }
        mWOrder.setParentId(this.getOrderId());
        mWOrder.setTradeId(this.getOrderId());
        if (mWOrder.isLimit()) {
            this.setLimitOrder(mWOrder);
        }
        if (mWOrder.isStop() || mWOrder.isTrail()) {
            this.setStopTrailOrder(mWOrder);
        }
    }

    public MWOrder getStopTrailOrder() {
        return this.stopTrailOrder;
    }

    public MWOrder getStopOrder() {
        if (this.stopTrailOrder == null || this.stopTrailOrder.isTrail()) {
            return null;
        }
        return this.stopTrailOrder;
    }

    public MWOrder getTrailOrder() {
        if (this.stopTrailOrder == null || !this.stopTrailOrder.isTrail()) {
            return null;
        }
        return this.stopTrailOrder;
    }

    public void setStopTrailOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.stopTrailOrder;
        if (mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled())) {
            this.stopTrailOrder = null;
        } else {
            if (mWOrder == this.stopTrailOrder) {
                return;
            }
            this.stopTrailOrder = mWOrder;
        }
        this.firePropertyChange("stopTrailOrder", mWOrder2, this.stopTrailOrder);
        this.firePropertyChange("stopTrailOrderPrice", null, Float.valueOf(this.getStopTrailOrderPrice()));
        this.firePropertyChange("stopOrderPL", null, (Object)this.getStopOrderPL());
    }

    public float getStopTrailOrderPrice() {
        MWOrder mWOrder = this.getStopTrailOrder();
        if (mWOrder == null) {
            return 0.0f;
        }
        return mWOrder.getAdjustedAuxPrice();
    }

    public double getStopOrderPL() {
        if (this.isFilled()) {
            return 0.0;
        }
        MWOrder mWOrder = this.getStopTrailOrder();
        return mWOrder == null ? 0.0 : mWOrder.getOrderPL();
    }

    public void setStopTrailOrderPrice(float f2) {
        if (this.stopTrailOrder != null) {
            this.stopTrailOrder.setAdjustedAuxPrice(f2);
        }
        this.firePropertyChange("stopOrderPL", null, (Object)this.getStopOrderPL());
    }

    public MWOrder getLimitOrder() {
        return this.limitOrder;
    }

    public void setLimitOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.limitOrder;
        this.limitOrder = mWOrder != null && (mWOrder.isCancelled() || mWOrder.isFilled()) ? null : mWOrder;
        if (mWOrder2 == this.limitOrder) {
            return;
        }
        this.firePropertyChange("limitOrder", mWOrder2, this.limitOrder);
        this.firePropertyChange("limitOrderPrice", null, Float.valueOf(this.getLimitOrderPrice()));
        this.firePropertyChange("limitOrderPL", null, (Object)this.getLimitOrderPL());
    }

    public float getLimitOrderPrice() {
        if (this.limitOrder == null) {
            return 0.0f;
        }
        return this.limitOrder.getAdjustedLimitPrice();
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        double d3 = this.commission;
        this.commission = d2;
        this.firePropertyChange("commission", d3, this.commission);
    }

    public double getLimitOrderPL() {
        if (this.isFilled()) {
            return 0.0;
        }
        MWOrder mWOrder = this.getLimitOrder();
        return mWOrder == null ? 0.0 : mWOrder.getOrderPL();
    }

    public void setLimitOrderPrice(float f2) {
        if (this.limitOrder != null) {
            this.limitOrder.setAdjustedLimitPrice(f2);
        }
        this.firePropertyChange("limitOrderPL", null, (Object)this.getLimitOrderPL());
    }

    public float getOrderPrice() {
        if (this.isMarket()) {
            if (this.isSell()) {
                return this.ticker.getBidPrice();
            }
            return this.ticker.getAskPrice();
        }
        if (this.isLimit()) {
            return this.getAdjustedLimitPrice();
        }
        return this.getAdjustedAuxPrice();
    }

    public void setOrderPrice(float f2) {
        if (this.isLimit()) {
            this.setAdjustedLimitPrice(f2);
        }
        if (this.isStop()) {
            this.setAdjustedAuxPrice(f2);
        }
        this.firePropertyChange("orderPL", 0.0, this.getOrderPL());
        Position position = this.getPosition();
        if (position == null || position.isClosed()) {
            return;
        }
        if (this.isStop() || this.isTrail()) {
            position.firePropertyChange("stopOrderPL", 0.0, this.getOrderPL());
        } else if (this.isLimit()) {
            position.firePropertyChange("limitOrderPL", 0.0, this.getOrderPL());
        }
    }

    public double getOrderPL() {
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            return 0.0;
        }
        if (this.isCancelled()) {
            return 0.0;
        }
        float f2 = 0.0f;
        MWOrder mWOrder = this.getParentOrder();
        if (mWOrder != null && !mWOrder.isCancelled() && !mWOrder.isFilled()) {
            f2 = mWOrder.getTriggerPrice();
        }
        if (f2 == 0.0f) {
            PositionBase positionBase;
            if (this.isNetClose()) {
                positionBase = PositionDirectory.getSummary(mWInstrument, this.getAccountID());
                if (positionBase == null) {
                    return 0.0;
                }
                f2 = ((PositionSummary)positionBase).getAvgPrice();
            } else {
                positionBase = this.position;
                if (positionBase == null || ((Position)positionBase).isClosed() || ((Position)positionBase).getQuantity() == 0.0f) {
                    return 0.0;
                }
                f2 = ((Position)positionBase).getEntryPrice();
            }
        }
        if (f2 == 0.0f) {
            return 0.0;
        }
        float f3 = this.getTriggerPrice();
        float f4 = Math.abs(this.getAdjustedQuantity());
        if (this.isBuy()) {
            f4 *= -1.0f;
        }
        return mWInstrument.calcPnLAndConvert(f2, f3, f4, s.a(this.getAccount()));
    }

    public void resolveClosingOrders() {
        List list = OrderDirectory.findChildOrders(this.getOrderId());
        if (h.a((Collection)list) && !h.g(this.getOrigOrderId())) {
            list = OrderDirectory.findChildOrders(this.getOrigOrderId());
        }
        if (!ae.a(this.getAccount())) {
            this.setStopTrailOrder(null);
            this.setLimitOrder(null);
        }
        for (MWOrder mWOrder : list) {
            if (!mWOrder.getInstrument().equals(this.getInstrument())) continue;
            if (mWOrder.isStop() || mWOrder.isTrail()) {
                if (mWOrder.isCancelled() || mWOrder.isCancelInProgress()) {
                    this.setStopTrailOrder(null);
                    continue;
                }
                this.setStopTrailOrder(mWOrder);
                continue;
            }
            if (!mWOrder.isLimit()) continue;
            if (mWOrder.isCancelled() || mWOrder.isCancelInProgress()) {
                this.setLimitOrder(null);
                continue;
            }
            this.setLimitOrder(mWOrder);
        }
    }

    public void updateAdjustedState() {
        boolean bl2 = this.adjusted;
        boolean bl3 = this.adjusted = this.getLimitPrice() != this.getAdjustedLimitPrice() || this.getQuantity() != this.getAdjustedQuantity() || this.getAuxPrice() != this.getAdjustedAuxPrice() || this.isOutsideRTH() != this.isAdjustedOutsideRTH() || this.getTrailPoints() != this.getAdjustedTrailPoints() || this.isTrailFixed() != this.isAdjustedTrailFixed() || this.isUsePips() != this.isAdjustedUsePips();
        if (!this.adjusted) {
            if (ae.C(this.getAccount())) {
                this.adjusted |= !h.a((Object)this.getExpiryDate(), (Object)this.getAdjustedExpiryDate());
            } else {
                this.adjusted |= this.getTif() != this.getAdjustedTif();
                if (!this.adjusted && this.getTif() == Enums$TIF.GTD) {
                    this.adjusted |= !h.a((Object)this.getGTD(), (Object)this.getAdjustedGTD());
                }
            }
        }
        if (bl2 != this.adjusted) {
            this.firePropertyChange("adjusted", bl2, this.adjusted);
        }
    }

    public boolean isCancelInProgress() {
        return this.cancelInProgress;
    }

    public void setCancelInProgress(boolean bl2) {
        this.cancelInProgress = bl2;
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        return account == null ? false : account.isReplay();
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean bl2) {
        this.waiting = bl2;
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(String string) {
        this.failedMsg = string;
    }

    public boolean isSimulatedOrder() {
        return this.simulatedOrder;
    }

    public void setSimulatedOrder(boolean bl2) {
        this.simulatedOrder = bl2;
    }

    public boolean isClientMITOrder() {
        return this.getType() == Enums$OrderType.MIT && !this.supportsMITOrders();
    }

    public boolean isClientOrder() {
        MWOrder mWOrder;
        if (this.isSimulatedOrder() || this.isReplay() || this.isClientMITOrder()) {
            return true;
        }
        if (!this.isNew() && !this.isPreSubmitted()) {
            return false;
        }
        if (this.hasParent() && !ae.j(this.getAccount()) && (mWOrder = this.getParentOrder()) != null && mWOrder.isActive()) {
            return true;
        }
        return OrderDirectory.isClientAttachedOrder(this);
    }

    public cw getTradeRoute() {
        return this.tradeRoute;
    }

    public void setTradeRoute(cw cw2) {
        this.tradeRoute = cw2;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l2) {
        this.created = l2;
    }

    public boolean isCancelReplaceInProgress() {
        return this.cancelReplaceInProgress;
    }

    public void setCancelReplaceInProgress(boolean bl2) {
        this.cancelReplaceInProgress = bl2;
    }

    public x getPrimaryService() {
        as as2 = ae.a(this.getAccount());
        if (as2 == null) {
            return null;
        }
        return as2.a();
    }

    public Enums$ServiceType getServiceType() {
        as as2 = ae.a(this.getAccount());
        if (as2 == null) {
            return null;
        }
        return as2.a().a();
    }

    public List getTradeRoutes() {
        if (this.isSimulatedOrder() || this.isReplay()) {
            return new ArrayList();
        }
        x x2 = this.getPrimaryService();
        if (x2 == null) {
            return new ArrayList();
        }
        return x2.a(this.getInstrument().getExchange());
    }

    public x getRealTimeService() {
        as as2 = ae.a(this.getAccount());
        if (as2 == null) {
            return null;
        }
        return as2.c();
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    public void setUpdateInProgress(boolean bl2) {
        this.updateInProgress = bl2;
    }

    public void createHandler() {
        if (this.handler != null) {
            return;
        }
        if (!this.isReplay() && !this.isSimulatedOrder()) {
            return;
        }
        this.handler = new ai(this, null);
        this.ticker.addTickListener(this.handler);
    }

    public void createMITHandler() {
        if (this.mitHandler != null) {
            return;
        }
        if (this.isReplay() || this.isSimulatedOrder()) {
            return;
        }
        this.mitHandler = new ah(this, null);
        this.ticker.addTickListener(this.mitHandler);
    }

    public void fillReplay() {
        if (!this.isReplay() || !this.isMarket()) {
            return;
        }
        this.setFilled(Math.abs(this.getQuantity()));
        float f2 = this.isBuy() ? this.ticker.getBuyPrice() : this.ticker.getSellPrice();
        this.setLastFillPrice(f2);
        this.setAvgFillPrice(f2);
        this.setLastFillTime(this.ticker.getLastTimestamp());
        this.setCommission(this.ticker.getInstrument().calcCommission(this.getFilled()));
        this.setStatus(Enums$OrderStatus.FILLED);
        OrderDirectory.orderFilled(this.getOrderId());
    }

    @Override
    public void orderIdChanged(String string, String string2) {
        for (String string3 : this.childOrders.a()) {
            if (!h.a((Object)string3, (Object)string)) continue;
            this.childOrders.a(string3);
            this.childOrders.a(string2);
        }
    }

    private void handleMIT(p p2, float f2) {
        float f3 = this.getAuxPrice();
        float f4 = p2.getPrice();
        boolean bl2 = this.isBuy();
        if (f4 == 0.0f) {
            float f5 = f4 = bl2 ? p2.getAskPrice() : p2.getBidPrice();
        }
        if (f4 == 0.0f) {
            return;
        }
        boolean bl3 = false;
        if (f4 == f3) {
            bl3 = true;
        } else if (f2 != 0.0f) {
            if (f4 < f3 && f2 > f3) {
                bl3 = true;
            } else if (f4 > f3 && f2 < f3) {
                bl3 = true;
            }
        }
        if (!bl3) {
            return;
        }
        Ticker ticker = this.ticker;
        Account account = this.getAccount();
        float f6 = this.getQuantity();
        MWOrder mWOrder = this.getStopTrailOrder();
        MWOrder mWOrder2 = this.getLimitOrder();
        MWOrder mWOrder3 = OrderDirectory.createMarketOrder(account, this.ticker, bl2 ? Enums$OrderAction.BUY : Enums$OrderAction.SELL, ticker.getInstrument().getDefaultTIF(), f6);
        OrderDirectory.assignNewOrderId(this, mWOrder3.getOrderId());
        this.destroy();
        if (mWOrder != null) {
            al.a(mWOrder3, mWOrder);
        }
        if (mWOrder2 != null) {
            al.a(mWOrder3, mWOrder2);
        }
        al.a(mWOrder3);
    }

    static /* synthetic */ boolean access$200(MWOrder mWOrder) {
        return mWOrder.destroyed;
    }

    static /* synthetic */ Ticker access$300(MWOrder mWOrder) {
        return mWOrder.ticker;
    }

    static /* synthetic */ void access$400(MWOrder mWOrder, p p2, float f2) {
        mWOrder.handleMIT(p2, f2);
    }

    static /* synthetic */ ai access$500(MWOrder mWOrder) {
        return mWOrder.handler;
    }

    static /* synthetic */ ah access$600(MWOrder mWOrder) {
        return mWOrder.mitHandler;
    }

    static /* synthetic */ void access$700(MWOrder mWOrder, Ticker ticker) {
        mWOrder.removeListeners(ticker);
    }
}

