/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.c;
import ag.f;
import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$CustomInstrumentType;
import com.motivewave.platform.common.Enums$CustomOperation;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$OptionType;
import com.motivewave.platform.common.Enums$OrderExpiry;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.an;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.Commission;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.Currency;
import com.motivewave.platform.databean.DailyHours;
import com.motivewave.platform.databean.Exchange;
import com.motivewave.platform.databean.IndustryGroup;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument$Dependency;
import com.motivewave.platform.databean.MWInstrument$MinTickRule;
import com.motivewave.platform.databean.OrderPreset;
import com.motivewave.platform.databean.Sector;
import com.motivewave.platform.databean.SymbolInfo;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.ac;
import com.motivewave.platform.databean.ae;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.service.ad;
import com.motivewave.platform.service.as;
import com.motivewave.platform.service.aw;
import com.motivewave.platform.service.k;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javafx.beans.InvalidationListener;
import k.am;
import k.g;
import k.q;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import q.d;

public class MWInstrument
extends a.b
implements o,
Comparable {
    private long sod1;
    private long eod1;
    private long sod2;
    private long eod2;
    private boolean lastRth;
    private int places = -1000;
    private int pointPlaces = -1000;
    private int id = -1;
    private String key;
    private String symbol;
    private String underlying;
    private String productCode;
    private String baseSymbol;
    private String exchange;
    private String primaryExchange;
    private String symbolDisplay;
    private String symbolData;
    private String historicalSymbol;
    private String historicalExchange;
    private Enums$InstrumentType type;
    private String title;
    private String sourceDescription;
    private String description;
    private double minTick = 0.01;
    private float minTickFloat = 0.01f;
    private boolean tickOverride;
    private double pointSize = -1.0;
    private String sectorId;
    private String industryGroupId;
    private String serviceId;
    private String symbolDir;
    private Date expiryDate;
    private double priceMagnifier = 1.0;
    private double plDivisor = 1.0;
    private double displayMultiplier = 0.0;
    private String displayMask;
    private DecimalFormat displayFormat;
    private String currency;
    private Double strikePrice;
    private Enums$OptionType optionType;
    private String tradingHoursID;
    private TimeZone timeZone;
    private double contractValue;
    private int contractSize;
    private double pointValue;
    private boolean useDefaultCommission = true;
    private double baseCost = 0.0;
    private double unitCost = 0.0;
    private int unitSize = 1;
    private Boolean showExtendedData;
    private boolean localDataOnly = false;
    private boolean intradayData = true;
    private boolean useContinuousData = false;
    private String customDefinition;
    private List dependentInstruments = new ArrayList(1);
    private Enums$CustomInstrumentType customType = Enums$CustomInstrumentType.INDEX;
    private Enums$CustomOperation customOperation = Enums$CustomOperation.SUM;
    private boolean customInverted = false;
    private double customMultiplier = 1.0;
    private Map serviceMap = new LinkedHashMap(1);
    private ConnectionID source;
    private ConnectionID realTimeSource;
    private ConnectionID historicalSource;
    private ConnectionID newsSource;
    private List minTickRules = new ArrayList();
    private long lastTHResolve = 0L;
    private TradingHours lastTH;
    private TradingHours tradingHours;
    private Map sodMap = new HashMap(1);
    private Map sod2Map = new HashMap(1);
    private Map eodMap = new HashMap(1);
    private Map eod1Map = new HashMap(1);
    private Map eod2Map = new HashMap(1);
    private Map sodExt = new HashMap(1);
    private Map sod2Ext = new HashMap(1);
    private Map eodExt = new HashMap(1);
    private Map eod1Ext = new HashMap(1);
    private Map eod2Ext = new HashMap(1);
    private Boolean extendedData;
    private Boolean valid = null;
    private Boolean level1PriceSupported = null;
    private Boolean historicalBidAskSupported = null;
    private Boolean historicalPriceSupported = null;
    private am instrListeners = new am();
    private static Map idMap = new HashMap();
    private static Map keyMap = new HashMap();
    private static Map symbol2InstrumentMap = new HashMap();
    private static Map symbolDisplayMap = new HashMap();
    private static Map symbolExchangeMap = new HashMap();
    private static Map symbol2RelatedMap = new HashMap();
    private static k.f allInstruments = new k.f();
    private static Map serviceIdMap = new HashMap();
    private static boolean ignoreEvents = false;
    private static boolean unsavedChanges = false;
    private static int pendingUpdates = 0;
    private static k.f listeners = new k.f();

    public MWInstrument() {
    }

    public MWInstrument(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public MWInstrument(String string, Enums$InstrumentType enums$InstrumentType, String string2, String string3) {
        this.underlying = string;
        this.symbol = string;
        this.type = enums$InstrumentType;
        this.exchange = string2;
        this.currency = string3;
    }

    public MWInstrument(k k2) {
        this(k2.b(), k2.a(), k2.d(), k2.e());
        this.underlying = k2.a();
        this.title = k2.c();
        this.minTick = k2.a();
        this.pointSize = k2.c();
        this.expiryDate = k2.a();
        this.strikePrice = k2.b();
        this.optionType = k2.a();
        this.contractSize = k2.a();
        this.displayMultiplier = k2.f();
        this.plDivisor = k2.e();
        this.priceMagnifier = k2.d();
        if (!h.g(k2.f())) {
            this.primaryExchange = k2.f();
        }
        this.source = k2.a();
        this.serviceId = k2.i();
    }

    public double calcPnL(double d2, float f2) {
        if (f2 == 0.0f) {
            return 0.0;
        }
        d2 = this.round(d2);
        double d3 = d2 * (double)f2;
        if (this.isStock()) {
            return d3;
        }
        if (this.isOption()) {
            int n2 = 100;
            if (this.getContractSize() > 0) {
                n2 = this.getContractSize();
            }
            d3 *= (double)n2;
            if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 * this.getPointValue() / this.getPointSize() * (double)f2;
            }
        } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
            d3 = d2 * this.getPointValue() / this.getPointSize() * (double)f2;
        } else if (this.getPLDivisor() > 0.0) {
            d3 /= this.getPLDivisor();
        }
        return d3;
    }

    public double calcRawMove(double d2, float f2) {
        if (f2 == 0.0f) {
            return 0.0;
        }
        double d3 = d2 / (double)f2;
        if (this.isStock()) {
            return d3;
        }
        if (this.isOption()) {
            int n2 = 100;
            if (this.getContractSize() > 0) {
                n2 = this.getContractSize();
            }
            d3 /= (double)n2;
            if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 / (double)f2 * this.getPointSize() / this.getPointValue();
            }
        } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
            d3 = d2 / (double)f2 * this.getPointSize() / this.getPointValue();
        } else if (this.getPLDivisor() > 0.0) {
            d3 *= this.getPLDivisor();
        }
        return d3;
    }

    public double calcPnL(float f2, float f3, float f4) {
        if (f4 == 0.0f) {
            return 0.0;
        }
        return this.calcPnL(f3 - f2, f4);
    }

    public double calcPnLAndConvert(float f2, float f3, float f4, String string) {
        if (f4 == 0.0f) {
            return 0.0;
        }
        return this.convertTo(this.calcPnL(f3 - f2, f4), string);
    }

    public float calcAndConvertPrice(double d2, float f2, float f3) {
        if (f3 == 0.0f) {
            return 0.0f;
        }
        String string = this.getCurrency();
        if (!h.a((Object)string, (Object)com.motivewave.platform.service.ae.b())) {
            d2 = this.convertFrom(d2, com.motivewave.platform.service.ae.b());
        }
        double d3 = this.round(d2 / (double)f3);
        if (!this.isStock()) {
            if (this.isOption()) {
                int n2 = 100;
                if (this.getContractSize() > 0) {
                    n2 = this.getContractSize();
                }
                d3 /= (double)n2;
                if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                    d3 = d2 / (double)f3 * this.getPointSize() / this.getPointValue();
                }
            } else if (this.getPointValue() > 0.0 && this.getPointSize() > 0.0) {
                d3 = d2 / (double)f3 * this.getPointSize() / this.getPointValue();
            } else if (this.getPLDivisor() > 0.0) {
                d3 *= this.getPLDivisor();
            }
        }
        return this.round((float)((double)f2 + d3));
    }

    public double convertTo(double d2, Account account) {
        if (account == null || h.g(account.getBaseCurrency())) {
            return this.convertTo(d2, com.motivewave.platform.service.ae.b());
        }
        return this.convertTo(d2, account.getBaseCurrency());
    }

    public double convertTo(double d2, String string) {
        ac ac2 = LiveTicker.get(this).getConverter(string);
        return ac2.a(d2);
    }

    public double convertFrom(double d2, String string) {
        ac ac2 = LiveTicker.get(this).getConverter(string);
        return ac2.b(d2);
    }

    public Enums$OrderExpiry getDefaultExpiry() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null || orderPreset.getOrderExpiry() == null) {
            return Enums$OrderExpiry.ONE_DAY;
        }
        return orderPreset.getOrderExpiry();
    }

    public Enums$TIF getDefaultTIF() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null || orderPreset.getTif() == null) {
            return Enums$TIF.GTC;
        }
        return orderPreset.getTif();
    }

    public float getDefaultQuantity() {
        OrderPreset orderPreset = this.getOrderPreset();
        float f2 = this.getMinStep();
        if (orderPreset == null) {
            return f2;
        }
        float f3 = orderPreset.getQuantity();
        if (f3 < f2) {
            return f2;
        }
        return f3;
    }

    public float getQuantityInc() {
        OrderPreset orderPreset = this.getOrderPreset();
        if (orderPreset == null) {
            return this.getMinStep();
        }
        return orderPreset.getQuantityInc();
    }

    public boolean isValueValid(double d2) {
        if (d2 <= this.minTick && d2 >= -this.minTick) {
            return false;
        }
        if (this.isCash() && d2 < 0.0) {
            return false;
        }
        return !Double.isNaN(d2) && !Double.isInfinite(d2);
    }

    public boolean isValueValid(float f2) {
        if (f2 <= this.minTickFloat && f2 >= -this.minTickFloat) {
            return false;
        }
        if (this.isCash() && f2 < 0.0f) {
            return false;
        }
        return !Float.isNaN(f2) && !Float.isInfinite(f2);
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.b("underlying", this.getUnderlying()), this.b("symbol", this.getSymbol()), this.b("symbolDisplay", this.symbolDisplay), this.b("symbolData", this.symbolData), this.b("histSymbol", this.historicalSymbol), this.b("histExchange", this.historicalExchange), this.b("productCode", this.productCode), this.b("title", this.title), this.b("exchange", this.exchange), this.b("currency", this.currency), this.a("type", (Object)this.getType()), this.b("serviceId", this.serviceId), this.a("minTick", this.getMinTick()), this.a("pointSize", this.getPointSize()), this.a("optionType", (Object)this.getOptionType()), this.a("pointValue", this.getPointValue()), this.a("plDivisor", this.getPLDivisor()), this.a("strikePrice", (Object)this.getStrikePrice()), this.a("priceMagnifier", this.getPriceMagnifier()), this.b("displayMask", this.displayMask), this.a("displayMultiplier", this.displayMultiplier), this.b("desc", this.description), this.b("tradingHoursId", this.tradingHoursID), this.a("baseCost", this.baseCost), this.a("unitCost", this.unitCost), this.a("unitSize", this.unitSize), this.a("useDefaultCommission", this.useDefaultCommission), this.a_("customDefinition", this.customDefinition), this.a("localDataOnly", this.localDataOnly), this.b("sectorId", this.sectorId), this.b("industryGroupId", this.industryGroupId)});
        if (this.expiryDate != null) {
            list.add(this.a_("expiryDate", this.expiryDate.getTime()));
        }
        if (this.timeZone != null) {
            list.add(this.b("timeZone", this.timeZone.getID()));
        }
        if (this.showExtendedData != null) {
            list.add(this.a("showExtendedData", (Object)this.showExtendedData));
        }
        if (this.extendedData != null) {
            list.add(this.a("supportsExtendedData", (Object)this.extendedData));
        }
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.underlying = jSONObject.str("underlying");
        this.symbol = jSONObject.str("symbol");
        if (jSONObject.has("exchange")) {
            this.exchange = jSONObject.str("exchange");
        }
        if (jSONObject.has("currency")) {
            this.currency = jSONObject.str("currency");
        }
        this.setSymbolDisplay(jSONObject.str("symbolDisplay"));
        this.setSymbolData(jSONObject.str("symbolData"));
        this.setHistoricalSymbol(jSONObject.str("histSymbol"));
        this.setHistoricalExchange(jSONObject.str("histExchange"));
        this.setProductCode(jSONObject.str("productCode"));
        this.setTitle(jSONObject.str("title"));
        try {
            this.setType(Enums$InstrumentType.valueOf(jSONObject.str("type")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serviceId = jSONObject.str("serviceId");
        try {
            this.setOptionType(Enums$OptionType.valueOf(jSONObject.str("optionType")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMinTick(jSONObject.getDouble("minTick"));
        this.setPointSize(jSONObject.getDouble("pointSize"));
        this.setPointValue(jSONObject.getDouble("pointValue"));
        this.setPLDivisor(jSONObject.getDouble("plDivisor"));
        this.setStrikePrice(jSONObject.getDouble("strikePrice"));
        this.setPriceMagnifier(jSONObject.getDouble("priceMagnifier"));
        this.setDisplayMask(jSONObject.str("displayMask"));
        this.setDisplayMultiplier(jSONObject.getDouble("displayMultiplier"));
        this.setDescription(jSONObject.str("desc"));
        this.setTradingHoursID(jSONObject.str("tradingHoursID"));
        if (jSONObject.has("expiryDate")) {
            this.setExpiryDate(new Date(jSONObject.getLong("expiryDate")));
        }
        if (jSONObject.has("timeZone")) {
            this.setTimeZone(TimeZone.getTimeZone(jSONObject.str("timeZone")));
        }
        this.setBaseCost(jSONObject.getDouble("baseCost"));
        this.setUnitCost(jSONObject.getDouble("unitCost"));
        this.setUnitSize(jSONObject.getInt("unitSize"));
        this.setUseDefaultCommission(jSONObject.is("useDefaultCommission"));
        if (jSONObject.has("showExtendedData")) {
            this.showExtendedData = jSONObject.is("showExtendedData");
        }
        if (jSONObject.has("supportsExtendedData")) {
            this.extendedData = jSONObject.is("supportsExtendedData");
        }
        this.localDataOnly = jSONObject.is("localDataOnly");
        if (jSONObject.has("sectorId")) {
            this.sectorId = jSONObject.str("sectorId");
        }
        if (jSONObject.has("industryGroupId")) {
            this.industryGroupId = jSONObject.str("industryGroupId");
        }
        if (jSONObject.has("customDefinition")) {
            this.setCustomDefinition(jSONObject.str("customDefinition"));
            try {
                this.loadDefinition();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void read(String string) {
        if (h.g(string)) {
            return;
        }
        new ae().a(string, true);
    }

    public static MWInstrument read(Element element) {
        Object object;
        Object object22;
        String string;
        if (element == null) {
            return null;
        }
        if (!h.g(element.getAttribute("optionType"))) {
            return null;
        }
        String string2 = element.getAttribute("symbol");
        if (h.g(string2)) {
            string2 = element.getAttribute("sym");
        }
        if (h.g(string = element.getAttribute("exchange"))) {
            string = element.getAttribute("exch");
        }
        MWInstrument mWInstrument = null;
        Enums$ServiceType enums$ServiceType = null;
        String string3 = element.getAttribute("service");
        if (!h.g(string3)) {
            try {
                enums$ServiceType = Enums$ServiceType.read(string3);
            }
            catch (Exception exception) {
                h.a.warning("MWInstrument::read() undefined service: " + element.getAttribute("service"));
            }
        }
        boolean bl2 = enums$ServiceType == null || enums$ServiceType == com.motivewave.platform.service.ae.a();
        Date date = null;
        try {
            if (!h.g(element.getAttribute("expiryDate"))) {
                date = h.a(element.getAttribute("expiryDate"), "yyyy-MM-dd");
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (date != null && date.before(new Date(System.currentTimeMillis() - 2419200000L)) && !aw.a(string2, enums$ServiceType)) {
            return null;
        }
        if (!h.g(element.getAttribute("id"))) {
            mWInstrument = MWInstrument.get(h.b(element.getAttribute("id")));
            if (mWInstrument != null && h.b((Object)mWInstrument.getSymbol(), (Object)string2) && enums$ServiceType != null && enums$ServiceType == mWInstrument.getSourceType()) {
                return mWInstrument;
            }
            mWInstrument = null;
        }
        if (!h.g(element.getAttribute("instrument_id"))) {
            mWInstrument = MWInstrument.get(h.b(element.getAttribute("instrument_id")));
            if (mWInstrument != null && h.b((Object)mWInstrument.getSymbol(), (Object)string2) && enums$ServiceType != null && enums$ServiceType == mWInstrument.getSourceType()) {
                return mWInstrument;
            }
            mWInstrument = null;
        }
        Enums$OptionType enums$OptionType = null;
        String string4 = element.getAttribute("optionType");
        if (!h.g(string4)) {
            try {
                enums$OptionType = Enums$OptionType.valueOf(string4);
            }
            catch (Exception exception) {
                h.a.warning("MWInstrument::read() invalid option type: " + string4);
            }
        }
        if (!h.g(string) && (mWInstrument = MWInstrument.get(string2, string)) != null) {
            return mWInstrument;
        }
        if (!bl2) {
            mWInstrument = MWInstrument.getStrict(string2, enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
        } else if (enums$OptionType == null) {
            MWInstrument mWInstrument2 = mWInstrument = bl2 ? MWInstrument.get(string2) : MWInstrument.get(string2, enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument;
            }
        }
        Enums$InstrumentType enums$InstrumentType = Enums$InstrumentType.STOCK;
        String string5 = element.getAttribute("type");
        if (!h.g(string5)) {
            try {
                enums$InstrumentType = Enums$InstrumentType.valueOf(string5);
            }
            catch (Exception exception) {
                h.a.warning("MWInstrument::read() invalid instrument type: " + string5);
            }
        }
        if (enums$InstrumentType == Enums$InstrumentType.CUSTOM && !an.c()) {
            h.a.warning("MWInstrument::read() unsupported instrument type: " + enums$InstrumentType + " symbol: " + string2);
            return null;
        }
        if (enums$InstrumentType != Enums$InstrumentType.CUSTOM && !com.motivewave.platform.service.ae.a(enums$InstrumentType)) {
            h.a.warning("MWInstrument::read() unsupported instrument type: " + enums$InstrumentType + " symbol: " + string2);
            return null;
        }
        Currency currency = Currency.get(element.getAttribute("currency"));
        String string6 = element.getAttribute("exchange");
        if (h.g(string6)) {
            string6 = element.getAttribute("exch");
        }
        Exchange exchange = Exchange.get(string6);
        String string7 = element.getAttribute("minTick");
        ArrayList<Enums$ServiceType> arrayList = new ArrayList<Enums$ServiceType>();
        for (Object object22 : com.motivewave.platform.service.ae.v()) {
            object = ((as)object22).a().a();
            if (arrayList.contains(object)) continue;
            arrayList.add((Enums$ServiceType)((Object)object));
        }
        if (h.g(string7) && enums$InstrumentType != Enums$InstrumentType.STOCK) {
            h.a.warning("MWInstrument::read() not enough information to recreate instrument: " + string2);
            return null;
        }
        Object object3 = null;
        object22 = com.motivewave.platform.service.ae.v().iterator();
        while (object22.hasNext()) {
            object = (as)object22.next();
            if (((as)object).a().a() != enums$ServiceType) continue;
            object3 = object;
            break;
        }
        if (object3 == null) {
            object22 = com.motivewave.platform.service.ae.v().iterator();
            while (object22.hasNext()) {
                object = (as)object22.next();
                if (!((as)object).a().a(enums$InstrumentType)) continue;
                object3 = object;
                break;
            }
            if (object3 != null && ((as)object3).a() && enums$InstrumentType == Enums$InstrumentType.STOCK) {
                exchange = Exchange.get("SMART");
            }
        }
        mWInstrument = new MWInstrument(string2, enums$InstrumentType, exchange.getSymbol(), currency.getSymbol());
        if (object3 != null) {
            mWInstrument.setSource(((as)object3).a().getConnectionID());
        }
        if ((object22 = g.b("custom", element)) != null) {
            object = g.b("definition", (Node)object22);
            mWInstrument.setCustomDefinition(g.a((Node)object));
        }
        if (h.g(string7)) {
            return mWInstrument;
        }
        mWInstrument.setUnderlying(element.getAttribute("underlying"));
        mWInstrument.setExpiryDate(date);
        mWInstrument.setMinTick(h.a(element.getAttribute("minTick")));
        mWInstrument.setPLDivisor(h.a(element.getAttribute("multiplier")));
        mWInstrument.setStrikePrice(h.a(element.getAttribute("strikePrice")));
        mWInstrument.setPriceMagnifier(h.a(element.getAttribute("priceMagnifier")));
        mWInstrument.setOptionType(enums$OptionType);
        string7 = element.getAttribute("symbolDisplay");
        if (!h.g(string7)) {
            mWInstrument.setSymbolDisplay(string7);
        }
        if (!h.g(string7 = element.getAttribute("symbolData"))) {
            mWInstrument.setSymbolData(string7);
        }
        if (!h.g(string7 = element.getAttribute("histSymbol"))) {
            mWInstrument.setHistoricalSymbol(string7);
        }
        if (!h.g(string7 = element.getAttribute("histExchange"))) {
            mWInstrument.setHistoricalExchange(string7);
        }
        if (!h.g(string7 = element.getAttribute("pointSize"))) {
            mWInstrument.setPointSize(h.a(string7));
        }
        if (!h.g(string7 = element.getAttribute("displayMask"))) {
            mWInstrument.setDisplayMask(string7);
        }
        if (!h.g(string7 = element.getAttribute("displayMultiplier"))) {
            mWInstrument.setDisplayMultiplier(h.a(string7));
        }
        if (!h.g(string7 = element.getAttribute("desc"))) {
            mWInstrument.setDescription(string7);
        } else {
            mWInstrument.setDescription(string2);
        }
        string7 = element.getAttribute("trading_hours_id");
        if (!h.g(string7)) {
            mWInstrument.setTradingHoursID(string7);
        }
        mWInstrument = MWInstrument.createAndRegister(mWInstrument);
        return mWInstrument;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "symbolData": {
                return this.getSymbolData();
            }
            case "baseCost": {
                return s.a(this.getBaseCost());
            }
            case "contractValue": {
                return s.a(this.getContractValue());
            }
            case "currency": {
                return h.b((Object)this.getCurrency());
            }
            case "customDescription": {
                return this.getDescription();
            }
            case "customTitle": {
                return this.getTitle();
            }
            case "description": {
                return this.getDescription();
            }
            case "displayMask": {
                return this.getDisplayMask();
            }
            case "exchange": {
                return h.b((Object)this.getExchange());
            }
            case "primaryExchange": {
                return h.b((Object)this.getPrimaryExchange());
            }
            case "productCode": {
                return this.getProductCode();
            }
            case "sectorId": {
                return this.getSectorId();
            }
            case "sectorName": {
                return this.getSectorName();
            }
            case "industryGroupId": {
                return this.getIndustryGroupId();
            }
            case "industryGroupName": {
                return this.getIndustryGroupName();
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "historicalSymbol": {
                return this.getHistoricalSymbol();
            }
            case "historicalExchange": {
                return this.getHistoricalExchange();
            }
            case "symbolDisplay": {
                return this.getSymbolDisplay();
            }
            case "title": {
                return this.getTitle();
            }
            case "underlying": {
                return this.getUnderlying();
            }
            case "sourceType": {
                return this.getServiceName();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "strikePrice": {
                return this.isOption() && this.strikePrice != null ? this.formatValue(this.strikePrice) : "";
            }
            case "expiryDate": {
                return this.expiryDate == null ? "" : h.a(this.expiryDate, "yyyy-MM-dd");
            }
        }
        Object object = this.getProperty(string);
        return h.b(object);
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "symbolData": {
                return this.getSymbolData();
            }
            case "baseCost": {
                return this.getBaseCost();
            }
            case "contractValue": {
                return this.getContractValue();
            }
            case "currency": {
                return this.getCurrency();
            }
            case "customDescription": {
                return this.getDescription();
            }
            case "customTitle": {
                return this.getTitle();
            }
            case "decimalPlaces": {
                return this.getDecimalPlaces();
            }
            case "defaultQuantity": {
                return Float.valueOf(this.getDefaultQuantity());
            }
            case "description": {
                return this.getDescription();
            }
            case "displayMask": {
                return this.getDisplayMask();
            }
            case "displayMultiplier": {
                return this.getDisplayMultiplier();
            }
            case "exchange": {
                return this.getExchange();
            }
            case "exchangeSymbol": {
                return this.getExchange();
            }
            case "expiryDate": {
                return this.getExpiryDate();
            }
            case "expiryTime": {
                return this.getExpiryTime();
            }
            case "instrumentType": {
                return this.getType();
            }
            case "type": {
                return this.getType();
            }
            case "sectorId": {
                return this.getSectorId();
            }
            case "sectorName": {
                return this.getSectorName();
            }
            case "industryGroupId": {
                return this.getIndustryGroupId();
            }
            case "industryGroupName": {
                return this.getIndustryGroupName();
            }
            case "minStep": {
                return Float.valueOf(this.getMinStep());
            }
            case "minTick": {
                return this.getMinTick();
            }
            case "multiplier": {
                return this.getPLDivisor();
            }
            case "optionType": {
                return this.getOptionType();
            }
            case "pointSize": {
                return this.getPointSize();
            }
            case "pointValue": {
                return this.getPointValue();
            }
            case "priceMagnifier": {
                return this.getPriceMagnifier();
            }
            case "primaryExchange": {
                return this.getPrimaryExchange();
            }
            case "productCode": {
                return this.getProductCode();
            }
            case "strikePrice": {
                return this.getStrikePrice();
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "historicalSymbol": {
                return this.getHistoricalSymbol();
            }
            case "historicalExchange": {
                return this.getHistoricalExchange();
            }
            case "symbolDisplay": {
                return this.getSymbolDisplay();
            }
            case "title": {
                return this.getTitle();
            }
            case "underlying": {
                return this.getUnderlying();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
        }
        return super.getProperty(string);
    }

    public String getServiceName() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType == null ? "" : enums$ServiceType.toString();
    }

    public String getConnectionName() {
        ConnectionID connectionID = this.getSource();
        if (connectionID == null) {
            return "";
        }
        as as2 = connectionID.getConnection();
        if (as2 != null) {
            return as2.a().getName();
        }
        return "";
    }

    public OrderPreset getOrderPreset() {
        OrderPreset orderPreset = d.a(this, this.getType(), this.getSourceType());
        if (orderPreset != null) {
            return orderPreset;
        }
        orderPreset = d.a(null, this.getType(), this.getSourceType());
        if (orderPreset != null) {
            return orderPreset;
        }
        if (this.type == null) {
            h.a.severe("MWInstrument::getOrderPreset() type is null! " + this.toString());
        }
        orderPreset = new OrderPreset(null, this.type);
        orderPreset.setQuantity(this.supportsFractionalVolume() ? 1.0E-4f : 1.0f);
        orderPreset.setQuantityInc(this.supportsFractionalVolume() ? 1.0E-8f : 1.0f);
        orderPreset.setLimitOffset(50);
        orderPreset.setStopOffset(10);
        orderPreset.setTrailOffset(10);
        orderPreset.setTif(Enums$TIF.DAY);
        orderPreset.setOrderType(Enums$OrderType.LMT);
        d.a(orderPreset);
        d.b(orderPreset);
        return orderPreset;
    }

    public int getLimitOffset() {
        return this.getOrderPreset().getLimitOffset();
    }

    public float getLimitOffsetAmount() {
        return this.round((float)((double)this.getLimitOffset() * this.getMinTick()));
    }

    public int getLimitOffsetPips() {
        return (int)((double)this.getLimitOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public int getStopOffset() {
        return this.getOrderPreset().getStopOffset();
    }

    public float getStopOffsetAmount() {
        return this.round((float)((double)this.getStopOffset() * this.getMinTick()));
    }

    public int getStopOffsetPips() {
        return (int)((double)this.getStopOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public int getTrailOffset() {
        return this.getOrderPreset().getTrailOffset();
    }

    public float getTrailOffsetAmount() {
        return this.round((float)((double)this.getTrailOffset() * this.getMinTick()));
    }

    public int getTrailOffsetPips() {
        return (int)((double)this.getTrailOffset() / (this.getPointSize() / this.getMinTick()));
    }

    public boolean isIB() {
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        return enums$ServiceType != null && enums$ServiceType.isIB();
    }

    public boolean isExpired() {
        if (this.expiryDate == null) {
            return false;
        }
        if (!this.isFuture() && !this.isOption()) {
            return false;
        }
        if (aw.a(this)) {
            return false;
        }
        long l2 = com.motivewave.platform.service.ae.a();
        return l2 > this.expiryDate.getTime() + 86400000L;
    }

    public boolean isLevel1PriceSupported() {
        if (this.level1PriceSupported != null) {
            return this.level1PriceSupported;
        }
        if (com.motivewave.platform.service.ae.a(this) == null) {
            return true;
        }
        this.level1PriceSupported = com.motivewave.platform.service.ae.l(this);
        return this.level1PriceSupported;
    }

    public boolean isIndex() {
        return this.type == Enums$InstrumentType.INDEX;
    }

    public boolean isStock() {
        return this.type == Enums$InstrumentType.STOCK;
    }

    public boolean isCrypto() {
        return this.type == Enums$InstrumentType.CRYPTO_CURRENCY;
    }

    public boolean isCFD() {
        return this.type == Enums$InstrumentType.CFD;
    }

    public boolean isCash() {
        return this.type == Enums$InstrumentType.CASH;
    }

    public boolean isOption() {
        return this.type != null && this.type.isOption();
    }

    public boolean isFuture() {
        return this.type != null && this.type.isFuture();
    }

    public boolean hasHistoricalBidAskData() {
        if (this.historicalBidAskSupported != null) {
            return this.historicalBidAskSupported;
        }
        if (this.isLocalDataOnly() || this.isCustom()) {
            return false;
        }
        this.historicalBidAskSupported = com.motivewave.platform.service.ae.p(this);
        return this.historicalBidAskSupported;
    }

    public boolean hasHistoricalPriceData() {
        if (this.historicalPriceSupported != null) {
            return this.historicalPriceSupported;
        }
        if (this.isLocalDataOnly() || this.isCustom()) {
            return true;
        }
        this.historicalPriceSupported = com.motivewave.platform.service.ae.r(this);
        return this.historicalPriceSupported;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(String string) {
        this.underlying = h.p(string);
    }

    public String getUnderlying(Enums$ServiceType enums$ServiceType) {
        String string;
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getUnderlying();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null && !h.g(symbolInfo.getUnderlying())) {
            return symbolInfo.getUnderlying();
        }
        String string2 = string = symbolInfo == null ? this.getSymbol() : symbolInfo.getSymbol();
        if (this.isFuture()) {
            string2 = (string = h.c(string, "@#&!-_+=?><':;!~`%^&*()")).length() == 5 ? string.substring(0, 3) : (string.length() < 3 ? string : string.substring(0, 2));
        }
        return string2;
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String string) {
        this.baseSymbol = h.p(string);
    }

    public MWInstrument getUnderlyingInstrument() {
        if (!this.isOption()) {
            return MWInstrument.get(this.getUnderlying());
        }
        MWInstrument mWInstrument = null;
        if (!h.g(this.getBaseSymbol())) {
            mWInstrument = MWInstrument.get(this.getBaseSymbol());
        }
        if (mWInstrument != null) {
            return mWInstrument;
        }
        return MWInstrument.get(this.getUnderlying());
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String string) {
        this.productCode = h.p(string);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getSymbol(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getSymbol();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo.getSymbol();
        }
        return aw.a(this, enums$ServiceType2, enums$ServiceType);
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = this.getKey(this.getExchange());
        return this.key;
    }

    public String getKey(String string) {
        Object object;
        String string2 = MWInstrument.replaceBadCharacters(this.getSymbol());
        String string3 = string == null ? "" : MWInstrument.replaceBadCharacters(string);
        Object object2 = string2;
        if (!h.g(string3)) {
            object2 = (String)object2 + "." + string3;
        }
        if (this.isIB() && !h.g((String)(object = MWInstrument.replaceBadCharacters(this.getPrimaryExchange())))) {
            object2 = (String)object2 + "." + (String)object;
        }
        if ((object = this.getSourceType()) != null) {
            object2 = (String)object2 + "." + ((Enum)object).name();
        }
        return object2;
    }

    private static String replaceBadCharacters(String string) {
        if (h.g(string)) {
            return "";
        }
        string = h.a(string, "/", "");
        string = h.a(string, "\\", "");
        string = h.a(string, ":", "");
        string = h.a(string, ".", "");
        string = h.a(string, "*", "");
        string = h.a(string, "^", "");
        string = h.a(string, "%", "");
        string = h.a(string, "$", "");
        string = h.a(string, "!", "");
        string = h.a(string, "=", "");
        string = h.a(string, "~", "");
        string = h.a(string, "'", "");
        string = h.a(string, "`", "");
        string = h.a(string, "(", "");
        string = h.a(string, ")", "");
        return string;
    }

    public File getAnalysisFile(String string) {
        File file = this.getAnalysisDirectory();
        if (file == null) {
            return null;
        }
        return new File(file, string + ".mwml");
    }

    public File getAnalysisFile(File file, String string) {
        File file2 = this.getAnalysisDirectory(file);
        if (file2 == null) {
            return null;
        }
        return new File(file2, string + ".mwml");
    }

    public File getAnalysisDirectory() {
        return this.getAnalysisDirectory(com.motivewave.platform.service.ae.a().getAnalysisDir());
    }

    public File getAnalysisDirectory(File file) {
        File file2;
        Object object;
        File file3 = file;
        if (!h.b((Object)file.getName(), (Object)"analysis")) {
            file3 = new File(file, "analysis");
        }
        if (file3.mkdirs() && !file3.exists()) {
            return null;
        }
        Object object2 = new File(file3, this.getType().name());
        if (!((File)object2).exists() && this.getType() == Enums$InstrumentType.CRYPTO_CURRENCY && ((File)(object = new File(file3, "CRYTO_CURRENCY"))).exists()) {
            object2 = object;
        }
        ((File)object2).mkdirs();
        if (!((File)object2).exists()) {
            return null;
        }
        object = this.getSymbolDir();
        if (h.g((String)object)) {
            object = s.a(this);
        }
        if (!(file2 = new File((File)object2, (String)object)).exists()) {
            file2 = new File((File)object2, this.getKey());
        }
        file2.mkdirs();
        if (!file2.exists()) {
            return null;
        }
        return file2;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceId(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.serviceId;
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo == null) {
            MWInstrument mWInstrument = MWInstrument.get(this.getSymbol(enums$ServiceType), enums$ServiceType);
            if (mWInstrument != null) {
                return mWInstrument.getServiceId();
            }
            return this.serviceId;
        }
        MWInstrument mWInstrument = MWInstrument.get(symbolInfo.getSymbol(), symbolInfo.getExchange(), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument.getServiceId();
        }
        mWInstrument = MWInstrument.get(symbolInfo.getSymbol(), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument.getServiceId();
        }
        return this.serviceId;
    }

    public void setServiceId(String string) {
        this.serviceId = h.p(string);
    }

    public String getSymbolDir() {
        return this.symbolDir;
    }

    public void setSymbolDir(String string) {
        this.symbolDir = h.p(string);
    }

    public String getSymbolData() {
        return this.symbolData;
    }

    public void setSymbolData(String string) {
        this.symbolData = string;
    }

    public String getSymbolDisplay() {
        if (!h.g(this.symbolDisplay)) {
            return this.symbolDisplay;
        }
        if (this.isOption()) {
            return this.getTitle();
        }
        return this.symbol;
    }

    public void setSymbolDisplay(String string) {
        if (h.g(string) || h.a((Object)string, (Object)this.getSymbol())) {
            this.symbolDisplay = null;
            return;
        }
        this.symbolDisplay = string;
        this.firePropertyChange("symbolDisplay", null, this.symbolDisplay);
    }

    public boolean isSymbolDisplayEmpty() {
        return h.g(this.symbolDisplay);
    }

    public String getSectorId() {
        return this.sectorId;
    }

    public void setSectorId(String string) {
        if (h.a((Object)this.sectorId, (Object)string)) {
            return;
        }
        this.sectorId = string;
        this.firePropertyChange("sectorId", null, string);
        this.firePropertyChange("sectorName", null, this.getIndustryGroupName());
    }

    public void setSector(Sector sector) {
        String string = this.getSectorName();
        this.sectorId = sector == null ? null : sector.getId();
        this.firePropertyChange("sectorName", string, this.getSectorName());
    }

    public Sector getSector() {
        return h.g(this.sectorId) ? null : Sector.get(this.sectorId);
    }

    public String getSectorName() {
        Sector sector = this.getSector();
        return sector == null ? "" : sector.getName();
    }

    public String getIndustryGroupId() {
        return this.industryGroupId;
    }

    public void setIndustryGroupId(String string) {
        if (h.a((Object)this.industryGroupId, (Object)string)) {
            return;
        }
        this.industryGroupId = string;
        this.firePropertyChange("industryGroupId", null, string);
        this.firePropertyChange("industryGroupName", null, this.getIndustryGroupName());
    }

    public void setIndustryGroup(IndustryGroup industryGroup) {
        String string = this.getIndustryGroupName();
        if (industryGroup == null) {
            this.industryGroupId = null;
        } else {
            if (!h.g(industryGroup.getSectorId())) {
                this.setSector(industryGroup.getSector());
            }
            this.industryGroupId = industryGroup.getId();
        }
        this.firePropertyChange("industryGroupName", string, this.getIndustryGroupName());
    }

    public IndustryGroup getIndustryGroup() {
        return IndustryGroup.get(this.industryGroupId);
    }

    public String getIndustryGroupName() {
        IndustryGroup industryGroup = this.getIndustryGroup();
        return industryGroup == null ? "" : industryGroup.getName();
    }

    public Enums$InstrumentType getType() {
        return this.type == null ? Enums$InstrumentType.STOCK : this.type;
    }

    public void setType(Enums$InstrumentType enums$InstrumentType) {
        Enums$InstrumentType enums$InstrumentType2 = this.type;
        this.type = enums$InstrumentType;
        this.firePropertyChange("type", (Object)enums$InstrumentType2, (Object)this.type);
    }

    public boolean supportsFractionalVolume() {
        return this.getType() == Enums$InstrumentType.CRYPTO_CURRENCY;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public LocalDate getExpiryLocalDate() {
        return h.a(this.expiryDate);
    }

    public void setExpiryDate(Date date) {
        Date date2 = this.expiryDate;
        this.expiryDate = date;
        this.firePropertyChange("expiryDate", date2, this.expiryDate);
    }

    public long getExpiryTime() {
        return this.expiryDate == null ? 0L : this.expiryDate.getTime();
    }

    public String getExchange() {
        return this.exchange == null ? "" : this.exchange;
    }

    public String getExchange(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getExchange();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo.getExchange();
        }
        String string = this.getExchange();
        if (enums$ServiceType.isIB()) {
            if (this.isCash() && !h.a(string, new String[]{"IDEAL", "IDEALPRO"})) {
                string = "IDEALPRO";
            } else if (this.isStock()) {
                string = "SMART";
            }
        } else if (enums$ServiceType == Enums$ServiceType.GOOGLE) {
            return f.a(this);
        }
        return string;
    }

    public void setExchange(String string) {
        if (h.a((Object)string, (Object)this.exchange)) {
            return;
        }
        String string2 = this.exchange;
        this.updateKey(() -> {
            this.exchange = string;
        });
        this.firePropertyChange("exchange", string2, this.exchange);
    }

    public String getPrimaryExchange() {
        return h.g(this.primaryExchange) ? "" : this.primaryExchange;
    }

    public String getPrimaryExchange(Enums$ServiceType enums$ServiceType) {
        Enums$ServiceType enums$ServiceType2 = this.getSourceType();
        if (enums$ServiceType == null || enums$ServiceType == enums$ServiceType2) {
            return this.getPrimaryExchange();
        }
        SymbolInfo symbolInfo = this.findMapping(enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo.getPrimaryExchange();
        }
        return this.getPrimaryExchange();
    }

    public void setPrimaryExchange(String string) {
        if (h.a((Object)string, (Object)this.primaryExchange)) {
            return;
        }
        String string2 = this.primaryExchange;
        this.updateKey(() -> {
            this.primaryExchange = string;
        });
        this.firePropertyChange("primaryExchange", string2, this.primaryExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateKey(Runnable runnable) {
        Object object;
        Object object2;
        Object object3;
        MWInstrument.unregister(this);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Workspace workspace = com.motivewave.platform.service.ae.a();
        if (workspace != null) {
            object3 = workspace.getAnalysisSources().iterator();
            while (object3.hasNext()) {
                object2 = (AnalysisSource)object3.next();
                if (((AnalysisSource)object2).isReadOnly() || (object = this.getAnalysisDirectory(((AnalysisSource)object2).getDirectory())) == null || !((File)object).exists()) continue;
                hashMap.put(object2, object);
            }
        }
        object2 = object3 = this.getSymbolDir();
        if (h.g((String)object3)) {
            object3 = s.a(this);
            object2 = this.getKey();
        }
        object = this.getKey();
        runnable.run();
        this.key = null;
        MWInstrument.register(this);
        try {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object82;
            for (Object object82 : workspace.getAnalysisSources()) {
                if (((AnalysisSource)object82).isReadOnly() || (object7 = (File)hashMap.get(object82)) == null || h.a(object6 = this.getKey(), (Object)((File)object7).getName())) continue;
                object5 = new File(((File)object7).getParent(), (String)object6);
                ((File)object7).renameTo((File)object5);
                object4 = new File((File)object5, ".sync");
                if (!((File)object4).exists()) continue;
                ((File)object4).delete();
            }
            File file = workspace.isUseDatabase() ? Workspace.getWorkspaceDir() : workspace.getRepoDir();
            object82 = new File(file, "analysis");
            if (!((File)object82).exists()) {
                return;
            }
            object7 = new File((File)object82, this.getType().name());
            if (!((File)object7).exists()) {
                return;
            }
            object6 = new File((File)object7, (String)object3);
            if (!((File)object6).exists()) {
                object6 = new File((File)object7, (String)object2);
            }
            if (!((File)object6).exists()) {
                return;
            }
            object5 = this.getSymbolDir();
            if (h.g(object5)) {
                object5 = this.getKey();
            }
            if (h.a(object2, object5)) {
                return;
            }
            object4 = new File((File)object7, (String)object5);
            ((File)object6).renameTo((File)object4);
            File file2 = new File((File)object4, ".sync");
            if (file2.exists()) {
                file2.delete();
            }
        }
        finally {
            for (Object object6 : this.instrListeners.a()) {
                object6.keyUpdated(this, (String)object, this.getKey());
            }
        }
    }

    public double getPriceMagnifier() {
        return this.priceMagnifier;
    }

    public void setPriceMagnifier(double d2) {
        double d3 = this.priceMagnifier;
        this.priceMagnifier = d2;
        this.firePropertyChange("priceMagnifier", d3, this.priceMagnifier);
    }

    public double getPLDivisor() {
        return this.plDivisor;
    }

    public void setPLDivisor(double d2) {
        double d3 = this.plDivisor;
        this.plDivisor = d2;
        this.firePropertyChange("pLDivisor", d3, this.plDivisor);
    }

    public double getDisplayMultiplier() {
        return this.displayMultiplier;
    }

    public void setDisplayMultiplier(double d2) {
        double d3 = this.displayMultiplier;
        this.displayMultiplier = d2;
        this.firePropertyChange("displayMultiplier", d3, this.displayMultiplier);
    }

    public String getDisplayMask() {
        return this.displayMask;
    }

    public void setDisplayMask(String string) {
        String string2 = this.displayMask;
        if (h.g(string)) {
            this.displayFormat = null;
            this.displayMask = null;
        } else {
            this.displayMask = string;
            try {
                this.displayFormat = new DecimalFormat(string);
            }
            catch (Throwable throwable) {
                h.a.warning("MWInstrument::setDisplayMask() invalid format: " + string);
                this.displayFormat = null;
            }
        }
        this.firePropertyChange("displayMask", string2, this.displayMask);
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String string) {
        this.currency = string;
    }

    public boolean isCustom() {
        return this.getType() == Enums$InstrumentType.CUSTOM && !h.g(this.customDefinition);
    }

    public String getCustomDefinition() {
        this.updateDefinition();
        return this.customDefinition;
    }

    public void setCustomDefinition(String string) {
        this.customDefinition = string;
    }

    public boolean isCustomInverted() {
        return this.customInverted;
    }

    public void setCustomInverted(boolean bl2) {
        this.customInverted = bl2;
    }

    public double getCustomMultiplier() {
        return this.customMultiplier;
    }

    public void setCustomMultiplier(double d2) {
        this.customMultiplier = d2;
    }

    public List getDependencies() {
        return this.dependentInstruments;
    }

    public void updateDefinition() {
        if (this.getType() != Enums$InstrumentType.CUSTOM) {
            return;
        }
        List list = h.b(new String[]{this.a("type", (Object)this.customType), this.a("operation", (Object)this.customOperation), this.a("inverted", this.customInverted, false), this.a("multiplier", this.customMultiplier)});
        List list2 = h.b(new String[0]);
        for (MWInstrument$Dependency mWInstrument$Dependency : this.dependentInstruments) {
            list2.add(this.a(this.b("symbol", mWInstrument$Dependency.instr.getSymbol()), this.b("exchange", mWInstrument$Dependency.instr.getExchange()), this.a("multiplier", mWInstrument$Dependency.multiplier), this.a("exp", mWInstrument$Dependency.exponent), this.a("inverted", mWInstrument$Dependency.inverted, false)));
        }
        list.add(this.a("instruments", (Collection)list2));
        this.customDefinition = this.a((Collection)list);
    }

    public void loadDefinition() {
        if (h.g(this.customDefinition)) {
            return;
        }
        this.dependentInstruments = new ArrayList();
        if (q.a(this.customDefinition)) {
            try {
                JSONObject jSONObject = new JSONObject(this.customDefinition);
                try {
                    if (jSONObject.has("type")) {
                        this.customType = Enums$CustomInstrumentType.valueOf(jSONObject.str("type"));
                    }
                }
                catch (Exception exception) {
                    h.a.severe("MWInstrument::loadDefinition() invalid custom type: " + jSONObject.str("type"));
                    h.a.severe(this.customDefinition);
                    this.customType = Enums$CustomInstrumentType.INDEX;
                }
                String string = h.p(jSONObject.str("operation"));
                if (h.g(string)) {
                    string = "SUM";
                }
                try {
                    this.customOperation = Enums$CustomOperation.valueOf(string);
                }
                catch (Exception exception) {
                    h.a.severe("MWInstrument::loadDefinition() invalid custom operation: " + string);
                    h.a.severe(this.customDefinition);
                    this.customOperation = Enums$CustomOperation.SUM;
                }
                this.customInverted = jSONObject.is("inverted", false);
                this.customMultiplier = jSONObject.getDouble("multiplier");
                for (JSONObject jSONObject2 : jSONObject.getObjList("instruments")) {
                    MWInstrument mWInstrument = MWInstrument.get(jSONObject2.str("symbol"), jSONObject2.str("exchange"));
                    if (mWInstrument == null && (mWInstrument = MWInstrument.get(jSONObject2.str("symbol"))) == null) {
                        h.a.severe("MWInstrument:loadDefinition() " + this.getSymbol() + " Unable to resolve dependent instrument: " + jSONObject2.str("symbol") + " " + jSONObject2.str("exchange"));
                        return;
                    }
                    double d2 = jSONObject2.getDouble("multiplier", 1.0);
                    boolean bl2 = jSONObject2.is("inverted", false);
                    double d3 = jSONObject2.getDouble("exp", 1.0);
                    this.dependentInstruments.add(new MWInstrument$Dependency(mWInstrument, d2, d3, bl2));
                }
                this.setType(Enums$InstrumentType.CUSTOM);
            }
            catch (Exception exception) {
                h.a.warning("MWInstrument::loadCustomDefinition() error reading json: " + exception.getMessage());
                h.a.warning(this.customDefinition);
                h.c();
            }
            return;
        }
        Element element = g.a(this.customDefinition).getDocumentElement();
        String string = element.getAttribute("type");
        if (h.g(string)) {
            string = "SPREAD";
        }
        try {
            this.customType = Enums$CustomInstrumentType.valueOf(string);
        }
        catch (Exception exception) {
            h.a.severe("MWInstrument::loadDefinition() invalid custom type: " + string);
            h.a.severe(this.customDefinition);
            this.customType = Enums$CustomInstrumentType.SPREAD;
        }
        String string2 = h.p(element.getAttribute("operation"));
        if (h.g(string2)) {
            string2 = "SUM";
        }
        try {
            this.customOperation = Enums$CustomOperation.valueOf(string2);
        }
        catch (Exception exception) {
            h.a.severe("MWInstrument::loadDefinition() invalid custom operation: " + string2);
            h.a.severe(this.customDefinition);
            this.customOperation = Enums$CustomOperation.SUM;
        }
        this.customInverted = h.a((Object)element.getAttribute("inverted"));
        this.customMultiplier = h.a(element.getAttribute("multiplier"));
        Node node = g.b("instruments", element);
        for (Element element2 : g.c("instrument", node)) {
            int n2 = h.b(element2.getAttribute("id"));
            String string3 = element2.getAttribute("symbol");
            String string4 = element2.getAttribute("exchange");
            MWInstrument mWInstrument = MWInstrument.get(n2);
            if (mWInstrument == null || !h.a((Object)mWInstrument.getSymbol(), (Object)string3)) {
                mWInstrument = MWInstrument.get(string3, string4);
            }
            if (mWInstrument == null && (mWInstrument = MWInstrument.get(string3)) == null) {
                h.a.severe("MWInstrument:loadDefinitionXML() " + this.getSymbol() + " Unable to resolve dependent instrument: " + string3 + " " + string4);
                return;
            }
            String string5 = element2.getAttribute("multiplier");
            if (h.g(string5)) {
                string5 = element2.getAttribute("weight");
            }
            double d4 = 1.0;
            if (!h.g(string5)) {
                d4 = h.a(h.a(string5), 8);
            }
            boolean bl3 = false;
            if (!h.g(element2.getAttribute("inverted"))) {
                bl3 = h.a((Object)element2.getAttribute("inverted"));
            }
            double d5 = 1.0;
            if (!h.g(element2.getAttribute("exp"))) {
                d5 = h.a(h.a(element2.getAttribute("exp")), 8);
            }
            this.dependentInstruments.add(new MWInstrument$Dependency(mWInstrument, d4, d5, bl3));
        }
        this.setType(Enums$InstrumentType.CUSTOM);
    }

    public void setCustomType(Enums$CustomInstrumentType enums$CustomInstrumentType) {
        this.customType = enums$CustomInstrumentType;
    }

    public Enums$CustomInstrumentType getCustomType() {
        return this.customType;
    }

    public void setCustomOperation(Enums$CustomOperation enums$CustomOperation) {
        this.customOperation = enums$CustomOperation;
    }

    public Enums$CustomOperation getCustomOperation() {
        return this.customOperation;
    }

    public void addDependency(MWInstrument$Dependency mWInstrument$Dependency) {
        this.dependentInstruments.add(mWInstrument$Dependency);
    }

    public void clearDependentInstruments() {
        this.dependentInstruments.clear();
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String string) {
        this.sourceDescription = string;
    }

    public double getMinTick() {
        return this.minTick;
    }

    public float getMinTickFloat() {
        return this.minTickFloat;
    }

    public void setMinTick(double d2) {
        if (d2 <= 0.0) {
            return;
        }
        if (d2 > 1.0 && !h.a((Object)d2, new Object[]{2.0, 2.5, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0})) {
            h.a.warning("MWInstrument::setMinTick() bad min tick: " + d2);
            d2 = 0.01;
        }
        if (d2 == this.minTick) {
            return;
        }
        double d3 = this.minTick;
        this.minTick = d2;
        this.places = h.a(this.minTick);
        this.minTickFloat = this.round((float)d2);
        this.firePropertyChange("minTick", d3, this.minTick);
        if (d2 > this.pointSize) {
            this.setPointSize(d2);
        }
    }

    public void setMinTickRules(List list) {
        this.minTickRules = list;
    }

    public double getMinTick(float f2) {
        if (h.a((Collection)this.minTickRules)) {
            return this.minTick;
        }
        for (MWInstrument$MinTickRule mWInstrument$MinTickRule : this.minTickRules) {
            if (!mWInstrument$MinTickRule.applies(f2)) continue;
            double d2 = mWInstrument$MinTickRule.getMinTick();
            if (d2 != this.minTick) {
                this.setMinTick(d2);
                MWInstrument.update(this);
            }
            return d2;
        }
        return this.minTick;
    }

    public float getMinStep() {
        return this.getType() == Enums$InstrumentType.CRYPTO_CURRENCY ? 1.0E-8f : 1.0f;
    }

    public boolean isTickOverride() {
        return this.tickOverride;
    }

    public void setTickOverride(boolean bl2) {
        boolean bl3 = this.tickOverride;
        this.tickOverride = bl2;
        this.firePropertyChange("tickOverride", bl3, this.tickOverride);
    }

    public String getMinTickAsString() {
        return h.c(this.minTick, h.a(this.minTick));
    }

    public double getPointSize() {
        return this.pointSize <= 0.0 ? this.minTick : this.pointSize;
    }

    public void setPointSize(double d2) {
        if (d2 < this.minTick) {
            d2 = this.minTick;
        }
        if (d2 > 1.0 && !h.a((Object)d2, new Object[]{2.0, 2.5, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0})) {
            h.a.warning("MWInstrument::setPointSize() bad point size: " + d2 + " " + this.getKey());
            d2 = this.minTick;
        }
        double d3 = this.pointSize;
        this.pointSize = d2;
        if (this.pointPlaces == -1000) {
            this.pointPlaces = h.a(this.getPointSize());
        }
        this.firePropertyChange("pointSize", d3, this.pointSize);
    }

    public String getPointSizeAsString() {
        return h.c(this.getPointSize(), h.a(this.minTick));
    }

    public Double getStrikePrice() {
        return this.strikePrice;
    }

    public void setStrikePrice(Double d2) {
        this.strikePrice = d2;
    }

    public Enums$OptionType getOptionType() {
        return this.optionType;
    }

    public void setOptionType(Enums$OptionType enums$OptionType) {
        this.optionType = enums$OptionType;
    }

    public String getTitle() {
        return h.g(this.title) ? this.symbol : this.title;
    }

    public void setTitle(String string) {
        if (h.a((Object)string, (Object)this.getTitle())) {
            return;
        }
        String string2 = this.getTitle();
        this.title = h.p(string);
        this.firePropertyChange("title", string2, string);
    }

    @Override
    public String formatPrice(float f2) {
        return this.formatValue(f2);
    }

    public String formatValue(double d2) {
        return this.formatValue((float)d2, false);
    }

    public String formatValue(float f2) {
        return this.formatValue(f2, false);
    }

    public String formatValue(float f2, boolean bl2) {
        if (this.displayMultiplier > 1.0E-7) {
            f2 = (float)((double)f2 * this.displayMultiplier);
        }
        if (this.displayFormat != null) {
            return this.displayFormat.format(f2);
        }
        double d2 = 0.0;
        int n2 = 0;
        if (bl2) {
            d2 = this.getPointSize();
            if (this.pointPlaces == -1000) {
                this.pointPlaces = h.a(d2);
            }
            n2 = this.pointPlaces;
        } else {
            d2 = this.getMinTick();
            if (this.places == -1000) {
                this.places = h.a(d2);
            }
            n2 = this.places;
        }
        if (this.displayMultiplier > 1.0E-6) {
            if (this.displayMultiplier >= 10000.0) {
                n2 -= 4;
            } else if (this.displayMultiplier >= 1000.0) {
                n2 -= 3;
            } else if (this.displayMultiplier >= 100.0) {
                n2 -= 2;
            } else if (this.displayMultiplier >= 10.0) {
                --n2;
            }
        }
        if (d2 == 0.015625 || d2 == 0.03125 || d2 == 0.0078125) {
            double d3 = Math.floor(f2);
            int n3 = (int)(320.0 * ((double)f2 - d3));
            if (f2 < 0.0f) {
                d3 = Math.ceil(f2);
                n3 = (int)(320.0 * (d3 - (double)f2));
            }
            String string = "";
            if (n3 < 10) {
                string = "00";
            } else if (n3 < 100) {
                string = "0";
            }
            if (f2 < 0.0f && d3 == 0.0) {
                return "-0'" + string + n3;
            }
            return (int)d3 + "'" + string + n3;
        }
        if (d2 == 0.125) {
            double d4 = Math.floor(f2);
            double d5 = (double)f2 - d4;
            if (f2 < 0.0f) {
                d4 = Math.ceil(f2);
                d5 = d4 - (double)f2;
            }
            if (f2 < 0.0f && d4 == 0.0) {
                return "-0 " + (int)(d5 * 8.0) + "/8";
            }
            return (int)d4 + " " + (int)(d5 * 8.0) + "/8";
        }
        if (d2 == 0.0078125) {
            double d6 = Math.floor(f2);
            double d7 = (double)f2 - d6;
            if (f2 < 0.0f) {
                d6 = Math.ceil(f2);
                d7 = d6 - (double)f2;
            }
            if (f2 < 0.0f && d6 == 0.0) {
                return "-0 " + (int)(d7 * 128.0) + "/128";
            }
            return (int)d6 + " " + (int)(d7 * 128.0) + "/128";
        }
        if (d2 == 0.00390625) {
            double d8 = Math.floor(f2);
            double d9 = (double)f2 - d8;
            if (f2 < 0.0f) {
                d8 = Math.ceil(f2);
                d9 = d8 - (double)f2;
            }
            if (f2 < 0.0f && d8 == 0.0) {
                return "-0 " + (int)(d9 * 256.0) + "/256";
            }
            return (int)d8 + " " + (int)(d9 * 256.0) + "/256";
        }
        String string = h.b(f2, n2);
        return string;
    }

    public double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        if (h.g(string = string.trim())) {
            return 0.0;
        }
        if (this.displayFormat != null) {
            try {
                double d2 = h.a((Object)this.displayFormat.parse(string));
                if (this.displayMultiplier > 1.0E-7) {
                    d2 /= this.displayMultiplier;
                }
                return d2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n2 = 1;
        if (string.startsWith("-")) {
            n2 = -1;
            string = string.substring(1);
        }
        if (string.indexOf("'") >= 0) {
            Object object = string.substring(string.indexOf("'") + 1);
            if (h.g((String)object)) {
                object = "0";
            } else if (((String)object).length() == 1) {
                object = (String)object + "00";
            } else if (((String)object).length() == 2) {
                object = (String)object + "0";
            } else if (((String)object).length() > 3) {
                object = ((String)object).substring(0, 2);
            }
            int n3 = h.b((String)object);
            if (n3 > 320) {
                n3 = 320;
            }
            double d3 = (double)n3 / 320.0;
            return (d3 + (double)h.b(string.substring(0, string.indexOf("'")))) * (double)n2;
        }
        if (string.indexOf("/") > 0) {
            int n4 = h.b(string.substring(string.indexOf("/") + 1));
            int n5 = string.indexOf(" ");
            int n6 = h.b(string.substring(n5 < 0 ? 0 : n5, string.indexOf("/")));
            double d4 = (double)n6 / (double)n4;
            if (n5 > 0) {
                d4 += (double)h.b(string.substring(0, n5));
            }
            return d4 * (double)n2;
        }
        double d5 = h.a(string);
        if (this.displayMultiplier > 1.0E-7) {
            d5 /= this.displayMultiplier;
        }
        return d5 * (double)n2;
    }

    public float round(float f2, boolean bl2) {
        if (bl2) {
            return this.roundToPoint(f2);
        }
        return this.round(f2);
    }

    public float round(float f2) {
        if (this.minTick == 0.0) {
            return f2;
        }
        return (float)h.a(h.a((double)f2, this.minTick), 9);
    }

    public double round(double d2) {
        if (this.minTick == 0.0) {
            return d2;
        }
        return h.a(h.a(d2, this.minTick), 9);
    }

    public float roundToPoint(float f2) {
        if (!this.isCash()) {
            return this.round(f2);
        }
        if (this.minTick != 0.0 && (double)f2 < this.minTick && (double)f2 > -this.minTick) {
            return 0.0f;
        }
        return (float)h.a(h.a((double)f2, this.getPointSize()), 9);
    }

    public float floorToPoint(float f2) {
        if (!this.isCash()) {
            return this.round(f2);
        }
        if (this.minTick != 0.0 && (double)f2 < this.minTick && (double)f2 > -this.minTick) {
            return 0.0f;
        }
        return h.a(h.c(f2, (float)this.getPointSize()), 6);
    }

    public String getDescription() {
        if (!h.g(this.description)) {
            return this.description;
        }
        if (!h.g(this.sourceDescription)) {
            return this.sourceDescription;
        }
        if (!h.g(this.title)) {
            return this.title;
        }
        if (this.type == Enums$InstrumentType.STOCK) {
            if (h.g(this.exchange)) {
                return this.getTitle();
            }
            String string = this.getTitle() + " (" + this.exchange + ")";
            return string;
        }
        if (h.a((Object)this.type, new Object[]{Enums$InstrumentType.FUTURE, Enums$InstrumentType.CONT_FUTURE})) {
            String string = this.symbol;
            if (this.expiryDate == null) {
                return "Futures " + string;
            }
            return h.a(this.expiryDate, "MMMyy") + " Futures " + string;
        }
        return this.getSymbol();
    }

    public void setDescription(String string) {
        if (h.a((Object)string, (Object)this.getDescription())) {
            return;
        }
        String string2 = this.getDescription();
        this.description = string;
        this.firePropertyChange("description", string2, string);
    }

    public String getTradingHoursID() {
        return this.tradingHoursID;
    }

    public void setTradingHoursID(String string) {
        if (h.a((Object)string, (Object)this.tradingHoursID)) {
            return;
        }
        this.tradingHoursID = string;
        this.tradingHours = null;
        this.clearTHMaps();
        this.resolveTimeZone();
    }

    public TradingHours getTradingHours() {
        if (this.tradingHours != null) {
            return this.tradingHours;
        }
        this.tradingHours = this.resolveTradingHours();
        return this.tradingHours;
    }

    public void tradingHoursUpdated() {
        this.tradingHours = null;
        this.clearTHMaps();
        this.resolveTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTHMaps() {
        Map map = this.sodMap;
        synchronized (map) {
            this.sodMap.clear();
        }
        map = this.sod2Map;
        synchronized (map) {
            this.sod2Map.clear();
        }
        map = this.sodExt;
        synchronized (map) {
            this.sodExt.clear();
        }
        map = this.sod2Ext;
        synchronized (map) {
            this.sod2Ext.clear();
        }
        map = this.eodMap;
        synchronized (map) {
            this.eodMap.clear();
        }
        map = this.eod1Map;
        synchronized (map) {
            this.eod1Map.clear();
        }
        map = this.eod2Map;
        synchronized (map) {
            this.eod2Map.clear();
        }
        map = this.eodExt;
        synchronized (map) {
            this.eodExt.clear();
        }
        map = this.eod1Ext;
        synchronized (map) {
            this.eod1Ext.clear();
        }
        map = this.eod2Ext;
        synchronized (map) {
            this.eod2Ext.clear();
        }
    }

    private TradingHours _resolveTradingHours() {
        Object object;
        Object object2;
        if (this.isCrypto()) {
            return TradingHours.get(TradingHours.CRYPTO);
        }
        String string = this.getExchange();
        if (!h.g(string)) {
            object2 = TradingHours.getByExchange(string);
            if (object2 != null) {
                this.lastTH = object2;
                this.lastTHResolve = System.currentTimeMillis();
                return object2;
            }
            object = this.primaryExchange;
            if (!h.g((String)object) && (object2 = TradingHours.getByExchange((String)object)) != null) {
                this.lastTH = object2;
                this.lastTHResolve = System.currentTimeMillis();
                return object2;
            }
        }
        object2 = null;
        object = com.motivewave.platform.service.ae.a(this);
        if (object == null) {
            if (!h.a((Collection)com.motivewave.platform.service.ae.v())) {
                h.a.warning("MWInstrument::resolveTradingHours() instance not found for: " + this.toString());
            }
            this.lastTH = null;
            this.lastTHResolve = System.currentTimeMillis();
            return null;
        }
        object2 = ((as)object).a();
        if (((ad)object2).o()) {
            if (this.getSymbol().indexOf("@FXCM") >= 0) {
                return TradingHours.get(TradingHours.FXCM);
            }
            if (this.getSymbol().indexOf("@GAIN") >= 0) {
                return TradingHours.get(TradingHours.FOREX);
            }
        }
        if (h.a((Object)this.getType(), new Object[]{Enums$InstrumentType.FUTURE, Enums$InstrumentType.CONT_FUTURE})) {
            String string2;
            String string3 = this.getUnderlying();
            if (((ad)object2).t()) {
                string3 = aw.g(string3);
            }
            if (h.g(string2 = aw.f(string3))) {
                return null;
            }
            return TradingHours.get(string2);
        }
        if (((ad)object2).b()) {
            return TradingHours.get(TradingHours.FXCM);
        }
        if (((ad)object2).a() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.IB_FOREX);
        }
        if (((ad)object2).e() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.TS_FOREX);
        }
        if (((ad)object2).p() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.MB_FOREX);
        }
        if (((ad)object2).h()) {
            return TradingHours.get(TradingHours.OANDA);
        }
        if (((ad)object2).c()) {
            return TradingHours.get(TradingHours.FOREX);
        }
        if (((ad)object2).r() && this.getType() == Enums$InstrumentType.CASH) {
            return TradingHours.get(TradingHours.FOREX);
        }
        if ((h.g(string) || h.b((Object)string, (Object)"SMART")) && h.g(string = this.primaryExchange)) {
            return null;
        }
        switch (string) {
            case "NYSE": 
            case "AMEX": 
            case "NYSE_AMEX": {
                return TradingHours.get(TradingHours.NYSE);
            }
            case "NASDAQ": {
                return TradingHours.get(TradingHours.NASDAQ);
            }
            case "OTC": 
            case "OTCBB": {
                return TradingHours.get(TradingHours.NASDAQ);
            }
            case "TSE": 
            case "TSX": {
                return TradingHours.get(TradingHours.TSX);
            }
            case "ASX": {
                return TradingHours.get(TradingHours.ASX);
            }
            case "XETRA": {
                return TradingHours.get(TradingHours.XETRA);
            }
        }
        return null;
    }

    private TradingHours resolveTradingHours() {
        if (h.g(this.tradingHoursID)) {
            if (System.currentTimeMillis() - this.lastTHResolve < 1000L) {
                return this.lastTH;
            }
            this.lastTH = this._resolveTradingHours();
            this.lastTHResolve = System.currentTimeMillis();
            this.resolveTimeZone();
            return this.lastTH;
        }
        return TradingHours.get(this.tradingHoursID);
    }

    public Calendar getCalendar() {
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null) {
            return tradingHours.getCalendar();
        }
        return h.a(this.timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTradingDay(long l2) {
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours == null) {
            long l3 = this.timeZone == null ? h.j(l2) : h.a(l2, this.timeZone);
            Calendar calendar = h.a(this.timeZone);
            int n2 = 0;
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.setTimeInMillis(l3);
                n2 = calendar.get(7);
            }
            if (--n2 == 0) {
                n2 = 1;
            }
            if (n2 > 5) {
                n2 = 5;
            }
            return n2;
        }
        DailyHours dailyHours = tradingHours.getHours(l2, false);
        if (dailyHours == null) {
            return 1;
        }
        switch (dailyHours.getDayOfWeek()) {
            case SUN: {
                return 0;
            }
            case MON: {
                return 1;
            }
            case TUES: {
                return 2;
            }
            case WED: {
                return 3;
            }
            case THUR: {
                return 4;
            }
            case FRI: {
                return 5;
            }
            case SAT: {
                return 6;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartOfDay(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        l2 = h.e(l2);
        if (bl2) {
            Object object = this.sodMap;
            synchronized (object) {
                Long l3 = (Long)this.sodMap.get(l2);
                if (l3 != null) {
                    return l3;
                }
            }
            object = this.getTradingHours();
            long l4 = 0L;
            l4 = object != null ? ((TradingHours)object).getStartOfDay(l2, bl2) : h.a(l2, this.getTimeZone());
            Map map = this.sodMap;
            synchronized (map) {
                this.sodMap.put(l2, l4);
            }
            return l4;
        }
        Object object = this.sodExt;
        synchronized (object) {
            Long l5 = (Long)this.sodExt.get(l2);
            if (l5 != null) {
                return l5;
            }
        }
        object = this.getTradingHours();
        long l6 = 0L;
        l6 = object != null ? ((TradingHours)object).getStartOfDay(l2, bl2) : h.a(l2, this.timeZone);
        Map map = this.sodExt;
        synchronized (map) {
            this.sodExt.put(l2, l6);
        }
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStartOfDay2(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        l2 = h.e(l2);
        if (bl2) {
            Object object = this.sod2Map;
            synchronized (object) {
                Long l3 = (Long)this.sod2Map.get(l2);
                if (l3 != null) {
                    return l3;
                }
            }
            object = this.getTradingHours();
            long l4 = -1L;
            if (object != null) {
                l4 = ((TradingHours)object).getStartOfDay2(l2, bl2);
            }
            Map map = this.sod2Map;
            synchronized (map) {
                this.sod2Map.put(l2, l4);
            }
            return l4;
        }
        Object object = this.sod2Ext;
        synchronized (object) {
            Long l5 = (Long)this.sod2Ext.get(l2);
            if (l5 != null) {
                return l5;
            }
        }
        object = this.getTradingHours();
        long l6 = -1L;
        if (object != null) {
            l6 = ((TradingHours)object).getStartOfDay2(l2, bl2);
        }
        Map map = this.sod2Ext;
        synchronized (map) {
            this.sod2Ext.put(l2, l6);
        }
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndOfDay(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        l2 = h.e(l2);
        if (bl2) {
            Object object = this.eodMap;
            synchronized (object) {
                Long l3 = (Long)this.eodMap.get(l2);
                if (l3 != null) {
                    return l3;
                }
            }
            object = this.getTradingHours();
            long l4 = 0L;
            l4 = object != null ? ((TradingHours)object).getEndOfDay(l2, bl2) : h.o(l2, this.timeZone);
            Map map = this.eodMap;
            synchronized (map) {
                this.eodMap.put(l2, l4);
            }
            return l4;
        }
        Object object = this.eodExt;
        synchronized (object) {
            Long l5 = (Long)this.eodExt.get(l2);
            if (l5 != null) {
                return l5;
            }
        }
        object = this.getTradingHours();
        long l6 = 0L;
        l6 = object != null ? ((TradingHours)object).getEndOfDay(l2, bl2) : h.o(l2, this.timeZone);
        Map map = this.eodExt;
        synchronized (map) {
            this.eodExt.put(l2, l6);
        }
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEndOfDay1(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        l2 = h.e(l2);
        if (bl2) {
            Object object = this.eod1Map;
            synchronized (object) {
                Long l3 = (Long)this.eod1Map.get(l2);
                if (l3 != null) {
                    return l3;
                }
            }
            object = this.getTradingHours();
            long l4 = 0L;
            l4 = object != null ? ((TradingHours)object).getEndOfDay1(l2, bl2) : h.o(l2, this.timeZone);
            Map map = this.eod1Map;
            synchronized (map) {
                this.eod1Map.put(l2, l4);
            }
            return l4;
        }
        Object object = this.eod1Ext;
        synchronized (object) {
            Long l5 = (Long)this.eod1Ext.get(l2);
            if (l5 != null) {
                return l5;
            }
        }
        object = this.getTradingHours();
        long l6 = 0L;
        l6 = object != null ? ((TradingHours)object).getEndOfDay1(l2, bl2) : h.o(l2, this.timeZone);
        Map map = this.eod1Ext;
        synchronized (map) {
            this.eod1Ext.put(l2, l6);
        }
        return l6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEndOfDay2(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        l2 = h.e(l2);
        if (bl2) {
            Object object = this.eod2Map;
            synchronized (object) {
                Long l3 = (Long)this.eod2Map.get(l2);
                if (l3 != null) {
                    return l3;
                }
            }
            object = this.getTradingHours();
            long l4 = -1L;
            if (object != null) {
                l4 = ((TradingHours)object).getEndOfDay2(l2, bl2);
            }
            Map map = this.eod2Map;
            synchronized (map) {
                this.eod2Map.put(l2, l4);
            }
            return l4;
        }
        Object object = this.eod2Ext;
        synchronized (object) {
            Long l5 = (Long)this.eod2Ext.get(l2);
            if (l5 != null) {
                return l5;
            }
        }
        object = this.getTradingHours();
        long l6 = -1L;
        if (object != null) {
            l6 = ((TradingHours)object).getEndOfDay2(l2, bl2);
        }
        Map map = this.eod2Ext;
        synchronized (map) {
            this.eod2Ext.put(l2, l6);
        }
        return l6;
    }

    public long getStartOfWeek(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null) {
            return tradingHours.getStartOfWeek(l2, bl2);
        }
        TimeZone timeZone = this.timeZone;
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        return h.i(l2, timeZone);
    }

    public long getEndOfWeek(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null) {
            return tradingHours.getEndOfWeek(l2, bl2);
        }
        TimeZone timeZone = this.timeZone;
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        return h.g(l2, timeZone);
    }

    public long getStartOfMonth(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.timeZone;
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        l2 = h.k(l2, timeZone);
        return this.getStartOfDay(l2, bl2);
    }

    public long getEndOfMonth(long l2, boolean bl2) {
        if (l2 == Long.MIN_VALUE) {
            return l2;
        }
        TimeZone timeZone = this.timeZone;
        if (timeZone == null && this.isCrypto()) {
            timeZone = h.b;
        }
        l2 = h.c(l2, timeZone) - 43200000L;
        return this.getEndOfDay(l2, bl2);
    }

    public boolean isTradeableDay(long l2, boolean bl2) {
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours == null) {
            Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
            if (!this.isCrypto() && enums$DayOfWeek == Enums$DayOfWeek.SAT) {
                return false;
            }
            if ((this.isStock() || this.isFuture() && bl2) && enums$DayOfWeek == Enums$DayOfWeek.SUN) {
                return false;
            }
            return !s.b(l2, this.getTimeZone());
        }
        return tradingHours.isTradingDay(l2, bl2);
    }

    public boolean isInsideTradingHours(long l2, boolean bl2) {
        return this.isInsideTradingHours(l2, bl2, true);
    }

    public boolean isInsideTradingHours(long l2, boolean bl2, boolean bl3) {
        long l3;
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours == null) {
            if (!bl3) {
                return true;
            }
            TimeZone timeZone = this.getTimeZone();
            Enums$DayOfWeek enums$DayOfWeek = Enums$DayOfWeek.convertFromCalendar(h.a(l2, this.getTimeZone()));
            if (!this.isCrypto() && enums$DayOfWeek == Enums$DayOfWeek.SAT) {
                return false;
            }
            if ((this.isStock() || this.isFuture() && bl2) && enums$DayOfWeek == Enums$DayOfWeek.SUN) {
                return false;
            }
            return !s.b(l2, timeZone);
        }
        if (this.sod1 > 0L && bl2 == this.lastRth) {
            if (l2 >= this.sod1 && l2 < this.eod1) {
                return true;
            }
            if (l2 >= this.sod2 && l2 < this.eod2) {
                return true;
            }
        }
        if (l2 < (l3 = this.getStartOfDay(l2, bl2))) {
            return false;
        }
        long l4 = this.getEndOfDay1(l2, bl2);
        if (l2 <= l4) {
            this.sod1 = l3;
            this.eod1 = l4;
            this.lastRth = bl2;
            this.eod2 = 0L;
            this.sod2 = 0L;
            return true;
        }
        if (!tradingHours.hasSession2(bl2)) {
            return false;
        }
        long l5 = this.getStartOfDay2(l2, bl2);
        if (l2 < l5) {
            return false;
        }
        long l6 = this.getEndOfDay2(l2, bl2);
        if (l2 <= l6) {
            this.sod1 = l3;
            this.eod1 = l4;
            this.lastRth = bl2;
            this.sod2 = l5;
            this.eod2 = l6;
            return true;
        }
        return false;
    }

    public boolean isInsideTradingDay(long l2, boolean bl2, boolean bl3) {
        long l3;
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours == null) {
            if (!bl3) {
                return true;
            }
            TimeZone timeZone = this.getTimeZone();
            Enums$DayOfWeek enums$DayOfWeek = Enums$DayOfWeek.convertFromCalendar(h.a(l2, this.getTimeZone()));
            if (!this.isCrypto() && enums$DayOfWeek == Enums$DayOfWeek.SAT) {
                return false;
            }
            if ((this.isStock() || this.isFuture() && bl2) && enums$DayOfWeek == Enums$DayOfWeek.SUN) {
                return false;
            }
            return !s.b(l2, timeZone);
        }
        if (this.sod1 > 0L && bl2 == this.lastRth) {
            if (l2 >= this.sod1 && l2 < this.eod1) {
                return true;
            }
            if (l2 >= this.sod1 && l2 < this.eod2) {
                return true;
            }
        }
        if (l2 < (l3 = this.getStartOfDay(l2, bl2))) {
            return false;
        }
        long l4 = this.getEndOfDay1(l2, bl2);
        if (l2 <= l4) {
            this.sod1 = l3;
            this.eod1 = l4;
            this.lastRth = bl2;
            this.eod2 = 0L;
            this.sod2 = 0L;
            return true;
        }
        if (!tradingHours.hasSession2(bl2)) {
            return false;
        }
        long l5 = this.getStartOfDay2(l2, bl2);
        long l6 = this.getEndOfDay2(l2, bl2);
        if (l2 <= l6) {
            this.sod1 = l3;
            this.eod1 = l4;
            this.lastRth = bl2;
            this.sod2 = l5;
            this.eod2 = l6;
            return true;
        }
        return false;
    }

    public Boolean isValid() {
        return this.valid;
    }

    public void setValid(Boolean bl2) {
        this.valid = bl2;
    }

    public Boolean supportsExtendedData() {
        return this.extendedData;
    }

    public void setSupportsExtendedData(Boolean bl2) {
        this.extendedData = bl2;
    }

    public boolean isExtendedDataSupported() {
        if (!com.motivewave.platform.service.ae.o(this)) {
            return false;
        }
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null && !tradingHours.hasExtendedHours()) {
            return false;
        }
        if (this.extendedData != null) {
            return this.extendedData;
        }
        return tradingHours != null && tradingHours.hasExtendedHours();
    }

    public boolean isShowExtendedData() {
        return this.showExtendedData == null ? com.motivewave.platform.common.b.aM() : this.showExtendedData;
    }

    public void setShowExtendedData(boolean bl2) {
        this.showExtendedData = bl2;
    }

    public boolean isShowExtendedDataSet() {
        return this.showExtendedData != null;
    }

    public boolean isLocalDataOnly() {
        return this.localDataOnly;
    }

    public void setLocalDataOnly(boolean bl2) {
        this.localDataOnly = bl2;
    }

    public boolean hasIntradayData() {
        return this.intradayData;
    }

    public void setIntradayData(boolean bl2) {
        this.intradayData = bl2;
    }

    public boolean isUseContinuousData() {
        return this.useContinuousData;
    }

    public void setUseContinuousData(boolean bl2) {
        this.useContinuousData = bl2;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone resolveTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        TradingHours tradingHours = this.getTradingHours();
        if (tradingHours != null && tradingHours.getTimeZone() != null) {
            return tradingHours.getTimeZone();
        }
        return com.motivewave.platform.common.b.a();
    }

    public double getContractValue() {
        return this.contractValue;
    }

    public void setContractValue(double d2) {
        this.contractValue = d2;
    }

    public int getContractSize() {
        return this.contractSize;
    }

    public void setContractSize(int n2) {
        this.contractSize = n2;
    }

    public double getPointValue() {
        if (this.isFuture() && this.pointValue == 0.0 && !h.g(this.getUnderlying())) {
            return aw.f(this.getUnderlying());
        }
        return this.pointValue;
    }

    public double getRawPointValue() {
        return this.pointValue;
    }

    public void setPointValue(double d2) {
        this.pointValue = d2;
    }

    public boolean isUseDefaultCommission() {
        return this.useDefaultCommission;
    }

    public void setUseDefaultCommission(boolean bl2) {
        this.useDefaultCommission = bl2;
    }

    public double getBaseCost() {
        return this.baseCost;
    }

    public void setBaseCost(double d2) {
        this.baseCost = d2;
    }

    public double getUnitCost() {
        return this.unitCost;
    }

    public void setUnitCost(double d2) {
        this.unitCost = d2;
    }

    public int getUnitSize() {
        return this.unitSize;
    }

    public void setUnitSize(int n2) {
        this.unitSize = n2;
    }

    public double calcCommission(float f2) {
        if (f2 < 0.0f) {
            f2 *= -1.0f;
        }
        if (f2 == 0.0f || Float.isNaN(f2)) {
            return 0.0;
        }
        if (this.useDefaultCommission) {
            Commission commission = Commission.get(this.getType());
            if (commission == null) {
                return 0.0;
            }
            return commission.getBaseCost() + commission.getUnitCost() * (f2 / (float)commission.getUnitSize());
        }
        return this.baseCost + this.unitCost * (double)(f2 / (float)this.unitSize);
    }

    public void addListener(InstrumentListener instrumentListener) {
        this.instrListeners.a(instrumentListener);
    }

    public void removeListener(InstrumentListener instrumentListener) {
        this.instrListeners.b(instrumentListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            MWInstrument mWInstrument = (MWInstrument)object;
            return h.a((Object)mWInstrument.getKey(), (Object)this.getKey());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.getKey();
    }

    public int getDecimalPlaces() {
        return this.places;
    }

    public MWInstrument getHistoricalInstrument() {
        if (h.g(this.historicalSymbol)) {
            return null;
        }
        if (h.a((Object)this.historicalSymbol, (Object)this.getSymbol()) && h.a((Object)this.historicalExchange, (Object)this.getExchange())) {
            return null;
        }
        MWInstrument mWInstrument = MWInstrument.get(this.historicalSymbol, this.historicalExchange);
        if (mWInstrument == this) {
            return null;
        }
        return mWInstrument;
    }

    public void setHistoricalInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == null || mWInstrument == this) {
            this.historicalExchange = null;
            this.historicalSymbol = null;
            return;
        }
        this.historicalSymbol = mWInstrument.getSymbol();
        this.historicalExchange = mWInstrument.getExchange();
    }

    public int compareTo(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return 1;
        }
        if (mWInstrument == this) {
            return 0;
        }
        return this.getKey().compareTo(mWInstrument.getKey());
    }

    public void setHistoricalSymbol(String string) {
        this.historicalSymbol = string;
    }

    public String getHistoricalExchange() {
        return this.historicalExchange;
    }

    public void setHistoricalExchange(String string) {
        this.historicalExchange = string;
    }

    public MWInstrument getInstrument(Enums$ServiceType enums$ServiceType) {
        if (enums$ServiceType == this.getSourceType() || enums$ServiceType == null) {
            return this;
        }
        MWInstrument mWInstrument = MWInstrument.get(this.getSymbol(enums$ServiceType), enums$ServiceType);
        if (mWInstrument != null) {
            return mWInstrument;
        }
        return this;
    }

    public String getHistoricalSymbol() {
        if (!h.g(this.historicalSymbol)) {
            return this.historicalSymbol;
        }
        if (this.historicalSource == null || this.historicalSource.equals(this.source)) {
            return this.getSymbol();
        }
        String string = this.getSymbolData();
        if (!h.g(string)) {
            return string;
        }
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (this.historicalSource.getConnection() != null) {
            enums$ServiceType = this.historicalSource.getConnection().a().a();
        }
        return this.getSymbol(enums$ServiceType);
    }

    public String getHistoricalSymbol(Enums$ServiceType enums$ServiceType) {
        if (!h.g(this.historicalSymbol)) {
            return this.historicalSymbol;
        }
        if (this.historicalSource == null || this.historicalSource.equals(this.source)) {
            return this.getSymbol(enums$ServiceType);
        }
        String string = this.getSymbolData();
        if (!h.g(string) && this.getSourceType() == enums$ServiceType) {
            return string;
        }
        return this.getSymbol(enums$ServiceType);
    }

    public String getNewsSymbol() {
        if (this.newsSource == null || this.newsSource.equals(this.source)) {
            return this.getSymbol();
        }
        String string = this.getSymbolData();
        if (!h.g(string)) {
            return string;
        }
        Enums$ServiceType enums$ServiceType = this.getSourceType();
        if (this.newsSource.getConnection() != null) {
            enums$ServiceType = this.newsSource.getConnection().a().a();
        }
        return this.getSymbol(enums$ServiceType);
    }

    public Map getServiceMap() {
        return this.serviceMap;
    }

    public SymbolInfo findMapping(Enums$ServiceType enums$ServiceType) {
        SymbolInfo symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType);
        if (symbolInfo != null) {
            return symbolInfo;
        }
        if (enums$ServiceType.isIB()) {
            for (Enums$ServiceType enums$ServiceType2 : Enums$ServiceType.values()) {
                if (!enums$ServiceType2.isIB() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType2)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isFXCM()) {
            for (Enums$ServiceType enums$ServiceType3 : Enums$ServiceType.values()) {
                if (!enums$ServiceType3.isFXCM() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType3)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isOEC()) {
            for (Enums$ServiceType enums$ServiceType4 : Enums$ServiceType.values()) {
                if (!enums$ServiceType4.isOEC() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType4)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        if (enums$ServiceType.isRithmic()) {
            for (Enums$ServiceType enums$ServiceType5 : Enums$ServiceType.values()) {
                if (!enums$ServiceType5.isRithmic() || (symbolInfo = (SymbolInfo)this.serviceMap.get((Object)enums$ServiceType5)) == null) continue;
                return symbolInfo;
            }
            return null;
        }
        return null;
    }

    public ConnectionID getSource() {
        if (this.source == null) {
            as as2 = com.motivewave.platform.service.ae.a();
            if (as2 == null || as2.a() == null) {
                return null;
            }
            return as2.a().getConnectionID();
        }
        return this.source;
    }

    public void setSource(ConnectionID connectionID) {
        if (h.a((Object)connectionID, (Object)this.source)) {
            return;
        }
        if (connectionID != null && connectionID.getService() != this.getSourceType()) {
            this.updateKey(() -> {
                this.source = connectionID;
            });
        } else {
            this.source = connectionID;
        }
    }

    public Enums$ServiceType getSourceType() {
        ConnectionID connectionID = this.getSource();
        if (connectionID == null) {
            as as2 = com.motivewave.platform.service.ae.a(this);
            if (as2 == null) {
                return null;
            }
            return as2.a().a();
        }
        return connectionID.getService();
    }

    public ConnectionID getRealTimeSource() {
        return this.realTimeSource;
    }

    public void setRealTimeSource(ConnectionID connectionID) {
        if (h.a((Object)connectionID, (Object)this.getSource())) {
            connectionID = null;
        }
        this.realTimeSource = connectionID;
    }

    public ConnectionID getHistoricalSource() {
        return this.historicalSource;
    }

    public void setHistoricalSource(ConnectionID connectionID) {
        if (h.a((Object)connectionID, (Object)this.getSource())) {
            connectionID = null;
        }
        this.historicalSource = connectionID;
    }

    public ConnectionID getNewsSource() {
        return this.newsSource;
    }

    public void setNewsSource(ConnectionID connectionID) {
        if (h.a((Object)connectionID, (Object)this.getSource())) {
            connectionID = null;
        }
        this.newsSource = connectionID;
    }

    public String getServiceMapConfig() {
        return this.b(this.serviceMap.values());
    }

    public void setServiceMapConfig(String string) {
        if (h.g(string)) {
            return;
        }
        if (q.a(string)) {
            try {
                JSONArray jSONArray = new JSONArray(string);
                this.serviceMap.clear();
                for (JSONObject jSONObject : jSONArray.asObjList()) {
                    SymbolInfo symbolInfo = new SymbolInfo(jSONObject);
                    this.serviceMap.put(symbolInfo.getServiceType(), symbolInfo);
                }
            }
            catch (Exception exception) {
                h.a.warning("MWInstrument::setServiceMapConfig() " + string);
                exception.printStackTrace();
            }
            return;
        }
        try {
            Element element = g.a(string).getDocumentElement();
            if (element == null) {
                return;
            }
            for (Element element2 : g.c("map", element)) {
                try {
                    SymbolInfo symbolInfo = new SymbolInfo(Enums$ServiceType.read(element2.getAttribute("service")), element2.getAttribute("underlying"), element2.getAttribute("symbol"), element2.getAttribute("exchange"), element2.getAttribute("primaryExchange"), element2.getAttribute("currency"));
                    this.serviceMap.put(symbolInfo.getServiceType(), symbolInfo);
                }
                catch (Exception exception) {
                    h.a.warning("MWInstrument::setServiceMapConfig() " + string);
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            h.a.warning("MWInstrument::setServiceMapConfig() error reading xml: " + exception.getMessage() + " xml: " + string);
        }
    }

    public static void save() {
        Workspace workspace = com.motivewave.platform.service.ae.a();
        File file = new File(workspace.getConfigDir(), "instruments.csv");
        if (!unsavedChanges && file.exists()) {
            return;
        }
        unsavedChanges = false;
        MWInstrument.save(workspace, MWInstrument.getAll());
    }

    public static void save(Workspace workspace, List list) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(workspace.getConfigDir(), "instruments.csv"));
            Map map = MWInstrument.createMap(list);
            a.a(printWriter, map);
            for (MWInstrument mWInstrument : list) {
                MWInstrument.toCSV(mWInstrument, map, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Map map = idMap;
        synchronized (map) {
            idMap.clear();
            allInstruments.b();
            symbol2InstrumentMap.clear();
            symbolDisplayMap.clear();
            symbolExchangeMap.clear();
            symbol2RelatedMap.clear();
            keyMap.clear();
            List list = MWInstrument.load(com.motivewave.platform.service.ae.a());
            MWInstrument.register(list);
            for (MWInstrument mWInstrument : list) {
                try {
                    mWInstrument.loadDefinition();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            File file = new File(com.motivewave.platform.service.ae.a().getConfigDir(), "instruments.csv");
            if (!file.exists()) {
                MWInstrument.save();
            }
            unsavedChanges = false;
        }
    }

    public static List load(File file) {
        long l2 = System.currentTimeMillis();
        ArrayList<MWInstrument> arrayList = new ArrayList<MWInstrument>();
        if (!file.exists()) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string != null) {
                Map map = a.a(string);
                if (map != null) {
                    string = bufferedReader.readLine();
                }
                while (string != null) {
                    MWInstrument mWInstrument = MWInstrument.fromCSV(string, map);
                    if (mWInstrument != null) {
                        arrayList.add(mWInstrument);
                    }
                    string = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        h.a.info("MWInstrument::load() load instruments: " + arrayList.size() + " elapsed: " + (System.currentTimeMillis() - l2));
        return arrayList;
    }

    public static List load(Workspace workspace) {
        File file = new File(workspace.getConfigDir(), "instruments.csv");
        List list = new ArrayList();
        if (!file.exists() && workspace.isDBExists()) {
            list = MWInstrument.loadFromDB(workspace);
            h.a.warning("MWInstrument::load() migrating instruments from database(1): " + list.size());
            return list;
        }
        list = MWInstrument.load(file);
        if (!h.a(list)) {
            return list;
        }
        if (workspace.isDBExists()) {
            list = MWInstrument.loadFromDB(workspace);
            h.a.warning("MWInstrument::load() migrating instruments from database(2): " + list.size());
        }
        return list;
    }

    private static List loadFromDB(Workspace workspace) {
        List list = new ArrayList();
        try {
            b b2 = CommandFactory.createCmd("GET_ALL_INSTRUMENTS");
            b2.a(workspace.getDBName());
            list = (List)b2.a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    public static MWInstrument fromCSV(String string, Map map) {
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        MWInstrument mWInstrument = new MWInstrument();
        mWInstrument.id = a.a((String)list.get(0));
        mWInstrument.underlying = (String)list.get(1);
        mWInstrument.baseSymbol = (String)list.get(2);
        mWInstrument.productCode = (String)list.get(3);
        mWInstrument.type = Enums$InstrumentType.fromShortCode((String)list.get(4));
        mWInstrument.symbol = (String)list.get(5);
        mWInstrument.exchange = a.a((String)list.get(6), map);
        mWInstrument.primaryExchange = a.a((String)list.get(7), map);
        mWInstrument.currency = a.a((String)list.get(8), map);
        mWInstrument.symbolDisplay = (String)list.get(9);
        mWInstrument.symbolData = (String)list.get(10);
        mWInstrument.symbolDir = (String)list.get(11);
        mWInstrument.historicalSymbol = (String)list.get(12);
        mWInstrument.historicalExchange = (String)list.get(13);
        mWInstrument.serviceId = (String)list.get(14);
        mWInstrument.expiryDate = a.a((String)list.get(15));
        mWInstrument.title = (String)list.get(16);
        mWInstrument.description = (String)list.get(17);
        mWInstrument.sourceDescription = (String)list.get(18);
        mWInstrument.sectorId = (String)list.get(19);
        mWInstrument.industryGroupId = (String)list.get(20);
        mWInstrument.setTimeZone(a.a((String)list.get(22)));
        mWInstrument.setTradingHoursID((String)list.get(21));
        mWInstrument.setMinTick(a.a(a.a((String)list.get(23), map)));
        mWInstrument.tickOverride = a.a((String)list.get(24));
        mWInstrument.setPointSize(a.a(a.a((String)list.get(25), map)));
        mWInstrument.priceMagnifier = a.a((String)list.get(26));
        mWInstrument.plDivisor = a.a((String)list.get(27));
        mWInstrument.contractSize = a.a((String)list.get(28));
        mWInstrument.contractValue = a.a((String)list.get(29));
        mWInstrument.pointValue = a.a((String)list.get(30));
        mWInstrument.displayMultiplier = a.a((String)list.get(31));
        mWInstrument.setDisplayMask((String)list.get(32));
        mWInstrument.strikePrice = a.a((String)list.get(33));
        String string2 = (String)list.get(34);
        if (h.a((Object)string2, (Object)"C")) {
            mWInstrument.optionType = Enums$OptionType.CALL;
        } else if (h.a((Object)string2, (Object)"P")) {
            mWInstrument.optionType = Enums$OptionType.PUT;
        }
        mWInstrument.extendedData = a.a((String)list.get(35));
        mWInstrument.showExtendedData = a.a((String)list.get(36));
        mWInstrument.localDataOnly = a.a((String)list.get(37));
        mWInstrument.intradayData = a.a((String)list.get(38));
        mWInstrument.useDefaultCommission = a.a((String)list.get(39));
        mWInstrument.baseCost = a.a((String)list.get(40));
        mWInstrument.unitCost = a.a((String)list.get(41));
        mWInstrument.unitSize = a.a((String)list.get(42));
        mWInstrument.source = ConnectionID.get(a.a((String)list.get(43), map));
        mWInstrument.realTimeSource = ConnectionID.get(a.a((String)list.get(44), map));
        mWInstrument.historicalSource = ConnectionID.get(a.a((String)list.get(45), map));
        mWInstrument.newsSource = ConnectionID.get(a.a((String)list.get(46), map));
        if (!h.g((String)list.get(47))) {
            mWInstrument.setServiceMapConfig((String)list.get(47));
        }
        if (!h.g((String)list.get(48))) {
            mWInstrument.customDefinition = (String)list.get(48);
        }
        if (list.size() > 49) {
            mWInstrument.useContinuousData = a.a((String)list.get(49));
        }
        return mWInstrument;
    }

    public static void toCSV(MWInstrument mWInstrument, Map map, PrintWriter printWriter) {
        String string = null;
        if (mWInstrument.optionType == Enums$OptionType.CALL) {
            string = "C";
        } else if (mWInstrument.optionType == Enums$OptionType.PUT) {
            string = "P";
        }
        String string2 = mWInstrument.title;
        String string3 = mWInstrument.description;
        String string4 = mWInstrument.sourceDescription;
        if (h.a((Object)string4, (Object)string2) || !h.g(string3)) {
            string4 = null;
        }
        if (h.a((Object)string3, (Object)mWInstrument.title)) {
            string3 = null;
        } else if (h.a((Object)string3, (Object)string4)) {
            string3 = null;
        }
        String string5 = mWInstrument.underlying;
        if (mWInstrument.isStock() || mWInstrument.isCash()) {
            string5 = null;
        }
        a.a(printWriter, mWInstrument.id > 0 ? Integer.valueOf(mWInstrument.id) : null, string5, mWInstrument.baseSymbol, mWInstrument.productCode, mWInstrument.type == null ? "" : mWInstrument.type.getShortCode(), mWInstrument.symbol, a.a(mWInstrument.exchange, map), a.a(mWInstrument.primaryExchange, map), a.a(mWInstrument.currency, map), mWInstrument.symbolDisplay, mWInstrument.symbolData, mWInstrument.symbolDir, mWInstrument.historicalSymbol, mWInstrument.historicalExchange, mWInstrument.serviceId, mWInstrument.expiryDate, string2, string3, string4, mWInstrument.sectorId, mWInstrument.industryGroupId, mWInstrument.tradingHoursID, mWInstrument.timeZone, a.a(a.a(mWInstrument.minTick), map), mWInstrument.tickOverride, a.a(a.a(mWInstrument.pointSize), map), mWInstrument.priceMagnifier, mWInstrument.plDivisor, mWInstrument.contractSize, mWInstrument.contractValue, mWInstrument.pointValue, mWInstrument.displayMultiplier, mWInstrument.displayMask, mWInstrument.strikePrice, string, mWInstrument.extendedData, mWInstrument.showExtendedData, mWInstrument.localDataOnly, mWInstrument.intradayData, mWInstrument.useDefaultCommission, mWInstrument.baseCost, mWInstrument.unitCost, mWInstrument.unitSize, a.a(mWInstrument.source == null ? "" : mWInstrument.source.getPersistString(), map), a.a(mWInstrument.realTimeSource == null ? "" : mWInstrument.realTimeSource.getPersistString(), map), a.a(mWInstrument.historicalSource == null ? "" : mWInstrument.historicalSource.getPersistString(), map), a.a(mWInstrument.newsSource == null ? "" : mWInstrument.newsSource.getPersistString(), map), mWInstrument.getServiceMap() == null ? "" : mWInstrument.getServiceMapConfig(), mWInstrument.isCustom() ? mWInstrument.getCustomDefinition() : "", mWInstrument.useContinuousData);
    }

    private static Map createMap(List list) {
        HashMap hashMap = new HashMap();
        int n2 = 1;
        for (MWInstrument mWInstrument : list) {
            n2 = a.a(mWInstrument.exchange, hashMap, n2);
            n2 = a.a(mWInstrument.primaryExchange, hashMap, n2);
            n2 = a.a(mWInstrument.currency, hashMap, n2);
            n2 = a.a(mWInstrument.source == null ? "" : mWInstrument.source.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.realTimeSource == null ? "" : mWInstrument.realTimeSource.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.historicalSource == null ? "" : mWInstrument.historicalSource.getPersistString(), hashMap, n2);
            n2 = a.a(mWInstrument.newsSource == null ? "" : mWInstrument.newsSource.getPersistString(), hashMap, n2);
            n2 = a.a(a.a(mWInstrument.minTick), hashMap, n2);
            n2 = a.a(a.a(mWInstrument.pointSize), hashMap, n2);
        }
        return hashMap;
    }

    public static MWInstrument get(Instrument instrument) {
        if (instrument == null) {
            return null;
        }
        try {
            return ((LiveTicker)instrument).getInstrument();
        }
        catch (Exception exception) {
            return MWInstrument.get(instrument.getSymbol(), instrument.getExchangeSymbol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(int n2) {
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)idMap.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceMap() {
        Map map = idMap;
        synchronized (map) {
            symbol2RelatedMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, Enums$ServiceType enums$ServiceType) {
        Object object;
        if (enums$ServiceType == null) {
            return MWInstrument.get(string);
        }
        if (h.g(string)) {
            return null;
        }
        if (enums$ServiceType == com.motivewave.platform.service.ae.a()) {
            return MWInstrument.get(string);
        }
        string = string.trim().toUpperCase();
        List list = null;
        ArrayList arrayList = null;
        Object object2 = idMap;
        synchronized (object2) {
            list = (List)symbol2InstrumentMap.get(string);
            if (!h.a((Collection)list)) {
                for (MWInstrument mWInstrument : list) {
                    if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                    return mWInstrument;
                }
            }
            if ((arrayList = (ArrayList)symbolDisplayMap.get(string)) != null) {
                arrayList = new ArrayList(arrayList);
            }
        }
        if (!h.a(arrayList)) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (MWInstrument)object2.next();
                if (((MWInstrument)object).getSourceType() != enums$ServiceType) continue;
                return object;
            }
        }
        if (!h.a((Collection)(object2 = MWInstrument.getRelated(string)))) {
            object = object2.iterator();
            while (object.hasNext()) {
                MWInstrument mWInstrument;
                mWInstrument = (MWInstrument)object.next();
                if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                return mWInstrument;
            }
        }
        if (!h.a((Collection)list)) {
            return (MWInstrument)list.get(0);
        }
        if (!h.a(arrayList)) {
            return (MWInstrument)arrayList.get(0);
        }
        if (!h.a((Collection)object2)) {
            return (MWInstrument)object2.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument getStrict(String string, Enums$ServiceType enums$ServiceType) {
        Object object;
        if (enums$ServiceType == null) {
            return MWInstrument.get(string);
        }
        if (h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        List list = null;
        ArrayList arrayList = null;
        Object object2 = idMap;
        synchronized (object2) {
            list = (List)symbol2InstrumentMap.get(string);
            if (!h.a((Collection)list)) {
                for (MWInstrument mWInstrument : list) {
                    if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                    return mWInstrument;
                }
            }
            if ((arrayList = (ArrayList)symbolDisplayMap.get(string)) != null) {
                arrayList = new ArrayList(arrayList);
            }
        }
        if (!h.a(arrayList)) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (MWInstrument)object2.next();
                if (((MWInstrument)object).getSourceType() != enums$ServiceType) continue;
                return object;
            }
        }
        if (!h.a((Collection)(object2 = MWInstrument.getRelated(string)))) {
            object = object2.iterator();
            while (object.hasNext()) {
                MWInstrument mWInstrument;
                mWInstrument = (MWInstrument)object.next();
                if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                return mWInstrument;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument getExact(String string, Enums$ServiceType enums$ServiceType) {
        if (enums$ServiceType == null) {
            return MWInstrument.get(string);
        }
        if (h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbol2InstrumentMap.get(string);
            if (!h.a((Collection)list)) {
                for (MWInstrument mWInstrument : list) {
                    if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                    return mWInstrument;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRelated(String string) {
        if (h.g(string)) {
            return new ArrayList();
        }
        String string2 = string.trim().toUpperCase();
        ArrayList<Object> arrayList = null;
        Map map = idMap;
        synchronized (map) {
            arrayList = (ArrayList<Object>)symbol2RelatedMap.get(string2);
            if (arrayList != null) {
                return arrayList;
            }
            arrayList = new ArrayList<Object>();
            MWInstrument mWInstrument = MWInstrument.get(string);
            if (mWInstrument != null) {
                arrayList.add(mWInstrument);
                for (c c2 : mWInstrument.getServiceMap().values()) {
                    MWInstrument mWInstrument2 = MWInstrument.get(((SymbolInfo)c2).getSymbol());
                    if (mWInstrument2 == null || arrayList.contains(mWInstrument2)) continue;
                    arrayList.add(mWInstrument2);
                }
            }
            for (c c2 : MWInstrument.getAll()) {
                if (arrayList.contains(c2)) continue;
                for (SymbolInfo symbolInfo : ((MWInstrument)c2).getServiceMap().values()) {
                    if (!h.b((Object)symbolInfo.getSymbol(), (Object)string)) continue;
                    arrayList.add(c2);
                }
            }
            symbol2RelatedMap.put(string, arrayList);
        }
        return arrayList;
    }

    public static boolean isRelated(MWInstrument mWInstrument, MWInstrument mWInstrument2) {
        if (mWInstrument == mWInstrument2) {
            return true;
        }
        if (mWInstrument2 == null || mWInstrument == null) {
            return false;
        }
        String string = mWInstrument2.getKey();
        if (h.a((Object)string, (Object)mWInstrument.getKey())) {
            return true;
        }
        for (MWInstrument mWInstrument3 : MWInstrument.getRelated(mWInstrument.getSymbol())) {
            if (!h.a((Object)mWInstrument3.getKey(), (Object)string)) continue;
            return true;
        }
        if (mWInstrument2.getSourceType() != mWInstrument.getSourceType()) {
            Object object = aw.a(mWInstrument2, mWInstrument2.getSourceType(), mWInstrument.getSourceType());
            if (h.a(object, (Object)mWInstrument.getSymbol())) {
                return true;
            }
            object = aw.a(mWInstrument, mWInstrument.getSourceType(), mWInstrument2.getSourceType());
            if (h.a(object, (Object)mWInstrument2.getSymbol())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string) {
        if (h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (ArrayList)symbol2InstrumentMap.get(string);
            if (!h.a((Collection)list)) {
                return (MWInstrument)list.get(0);
            }
            list = (List)symbolDisplayMap.get(string);
            if (h.a((Collection)list)) {
                return null;
            }
            list = new ArrayList(list);
            return (MWInstrument)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument getByKey(String string) {
        if (h.g(string)) {
            return null;
        }
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)keyMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll(String string) {
        if (h.g(string)) {
            return Collections.EMPTY_LIST;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (ArrayList)symbol2InstrumentMap.get(string);
            if (!h.a((Collection)list)) {
                return list;
            }
            list = (List)symbolDisplayMap.get(string);
            if (h.a((Collection)list)) {
                return Collections.EMPTY_LIST;
            }
            list = new ArrayList(list);
            return list;
        }
    }

    public static MWInstrument get(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return MWInstrument.get(jSONObject.str("symbol"), jSONObject.str("exchange"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, String string2) {
        if (h.g(string)) {
            return null;
        }
        if (h.g(string2)) {
            return MWInstrument.get(string);
        }
        string = string.trim().toUpperCase();
        string2 = string2.trim().toUpperCase();
        String string3 = string + ":" + string2;
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbolExchangeMap.get(string3);
            if (h.a((Collection)list)) {
                return null;
            }
            return (MWInstrument)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(Enums$ServiceType enums$ServiceType, String string) {
        Map map = idMap;
        synchronized (map) {
            return (MWInstrument)serviceIdMap.get(enums$ServiceType + ":" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MWInstrument get(String string, String string2, Enums$ServiceType enums$ServiceType) {
        if (h.g(string)) {
            return null;
        }
        if (h.g(string2)) {
            return MWInstrument.get(string, enums$ServiceType);
        }
        string = string.trim().toUpperCase();
        string2 = string2.trim().toUpperCase();
        String string3 = string + ":" + string2;
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbolExchangeMap.get(string3);
            if (h.a((Collection)list)) {
                return null;
            }
            for (MWInstrument mWInstrument : list) {
                if (mWInstrument.getSourceType() != enums$ServiceType) continue;
                return mWInstrument;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMultiple(String string) {
        if (h.g(string)) {
            return false;
        }
        string = string.trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            List list = (List)symbol2InstrumentMap.get(string);
            if (h.a((Collection)list)) {
                list = (List)symbolDisplayMap.get(string);
            }
            if (list == null) {
                return false;
            }
            return list.size() != 1;
            {
            }
        }
    }

    public static MWInstrument resolveFromDirName(String string) {
        MWInstrument mWInstrument3;
        String string2;
        Object object;
        MWInstrument mWInstrument2 = MWInstrument.getByKey(string);
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        mWInstrument2 = MWInstrument.get(string);
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        if (string.indexOf(46) > 0) {
            object = string.substring(string.lastIndexOf(46) + 1);
            string2 = string.substring(0, string.lastIndexOf(46));
            mWInstrument2 = MWInstrument.get(string2, (String)object);
            if (mWInstrument2 != null) {
                return mWInstrument2;
            }
            object = string.substring(string.indexOf(46) + 1);
            string2 = string.substring(0, string.indexOf(46));
            mWInstrument2 = MWInstrument.get(string2, (String)object);
            if (mWInstrument2 != null) {
                return mWInstrument2;
            }
            string2 = h.o(string2);
            object = h.o((String)object);
            for (MWInstrument mWInstrument3 : MWInstrument.getAll()) {
                if (!h.b((Object)h.o(mWInstrument3.getSymbol()), (Object)string2) || !h.b((Object)h.o(mWInstrument3.getExchange()), object)) continue;
                return mWInstrument3;
            }
        }
        object = MWInstrument.getAll();
        string2 = h.o(string);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            mWInstrument3 = (MWInstrument)iterator.next();
            if (!h.b((Object)h.o(mWInstrument3.getSymbol()), (Object)string2)) continue;
            return mWInstrument3;
        }
        string2 = aw.a(string);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            mWInstrument3 = (MWInstrument)iterator.next();
            if (!h.b((Object)aw.a(mWInstrument3.getSymbol()), (Object)string2)) continue;
            return mWInstrument3;
        }
        return null;
    }

    public static MWInstrument resolveExpiredContract(MWInstrument mWInstrument) {
        if (mWInstrument == null || !mWInstrument.isFuture() || !mWInstrument.isExpired()) {
            return mWInstrument;
        }
        MWInstrument mWInstrument2 = MWInstrument.findNearestContract(mWInstrument.getUnderlying());
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        return mWInstrument;
    }

    public static MWInstrument findNearestContract(String string) {
        if (h.g(string)) {
            return null;
        }
        string = string.trim().toUpperCase();
        MWInstrument mWInstrument = null;
        for (MWInstrument mWInstrument2 : MWInstrument.getAll()) {
            if (!mWInstrument2.isFuture() || !h.b((Object)string, (Object)mWInstrument2.getUnderlying()) || mWInstrument2.getExpiryDate() == null || mWInstrument2.getExpiryDate().getTime() < System.currentTimeMillis()) continue;
            if (mWInstrument == null) {
                mWInstrument = mWInstrument2;
                continue;
            }
            if (mWInstrument2.getExpiryDate().getTime() >= mWInstrument.getExpiryDate().getTime()) continue;
            mWInstrument = mWInstrument2;
        }
        return mWInstrument;
    }

    public static MWInstrument create(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        MWInstrument mWInstrument2 = MWInstrument.getByKey(mWInstrument.getKey());
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        MWInstrument.register(mWInstrument);
        for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
            instrumentListener.created(mWInstrument);
        }
        unsavedChanges = true;
        return mWInstrument;
    }

    public static MWInstrument createOrReplace(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        MWInstrument mWInstrument2 = MWInstrument.getByKey(mWInstrument.getKey());
        if (mWInstrument2 != null) {
            mWInstrument2.setBaseSymbol(mWInstrument.getBaseSymbol());
            mWInstrument2.setProductCode(mWInstrument.getProductCode());
            mWInstrument2.setType(mWInstrument.getType());
            mWInstrument2.setCurrency(mWInstrument.getCurrency());
            mWInstrument2.setSymbolDisplay(mWInstrument.getSymbolDisplay());
            mWInstrument2.setSymbolData(mWInstrument.getSymbolData());
            mWInstrument2.setSymbolDir(mWInstrument.getSymbolDir());
            mWInstrument2.setHistoricalSymbol(mWInstrument.getHistoricalSymbol());
            mWInstrument2.setHistoricalExchange(mWInstrument.getHistoricalExchange());
            mWInstrument2.setServiceId(mWInstrument.getServiceId());
            mWInstrument2.setExpiryDate(mWInstrument.getExpiryDate());
            mWInstrument2.setTitle(mWInstrument.getTitle());
            mWInstrument2.setDescription(mWInstrument.getDescription());
            mWInstrument2.setSourceDescription(mWInstrument.getSourceDescription());
            mWInstrument2.setSectorId(mWInstrument.getSectorId());
            mWInstrument2.setIndustryGroupId(mWInstrument.getIndustryGroupId());
            mWInstrument2.setTradingHoursID(mWInstrument.getTradingHoursID());
            mWInstrument2.setTimeZone(mWInstrument.getTimeZone());
            mWInstrument2.setMinTick(mWInstrument.getMinTick());
            mWInstrument2.setTickOverride(mWInstrument.isTickOverride());
            mWInstrument2.setPointSize(mWInstrument.getPointSize());
            mWInstrument2.setPriceMagnifier(mWInstrument.getPriceMagnifier());
            mWInstrument2.setPLDivisor(mWInstrument.getPLDivisor());
            mWInstrument2.setContractSize(mWInstrument.getContractSize());
            mWInstrument2.setContractValue(mWInstrument.getContractValue());
            mWInstrument2.setPointValue(mWInstrument.getPointValue());
            mWInstrument2.setDisplayMultiplier(mWInstrument.getDisplayMultiplier());
            mWInstrument2.setDisplayMask(mWInstrument.getDisplayMask());
            mWInstrument2.setStrikePrice(mWInstrument.getStrikePrice());
            mWInstrument2.setOptionType(mWInstrument.getOptionType());
            mWInstrument2.showExtendedData = mWInstrument.showExtendedData;
            mWInstrument2.setSupportsExtendedData(mWInstrument.supportsExtendedData());
            mWInstrument2.setLocalDataOnly(mWInstrument.isLocalDataOnly());
            mWInstrument2.setIntradayData(mWInstrument.hasIntradayData());
            mWInstrument2.setUseDefaultCommission(mWInstrument.isUseDefaultCommission());
            mWInstrument2.setBaseCost(mWInstrument.getBaseCost());
            mWInstrument2.setUnitCost(mWInstrument.getUnitCost());
            mWInstrument2.setUnitSize(mWInstrument.getUnitSize());
            mWInstrument2.source = mWInstrument.source;
            mWInstrument2.realTimeSource = mWInstrument.realTimeSource;
            mWInstrument2.historicalSource = mWInstrument.historicalSource;
            mWInstrument2.newsSource = mWInstrument.newsSource;
            mWInstrument2.serviceMap = mWInstrument.serviceMap;
            mWInstrument2.setCustomDefinition(mWInstrument.getCustomDefinition());
            mWInstrument = mWInstrument2;
        } else {
            MWInstrument.register(mWInstrument);
            for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
                instrumentListener.created(mWInstrument);
            }
        }
        unsavedChanges = true;
        return mWInstrument;
    }

    public static MWInstrument createAndRegister(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return null;
        }
        MWInstrument mWInstrument2 = MWInstrument.getByKey(mWInstrument.getKey());
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        MWInstrument.register(mWInstrument);
        unsavedChanges = true;
        return mWInstrument;
    }

    public static void update(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        if (!MWInstrument.exists(mWInstrument)) {
            MWInstrument.register(mWInstrument);
        }
        for (InstrumentListener instrumentListener : mWInstrument.instrListeners.a()) {
            instrumentListener.updated(mWInstrument);
        }
        unsavedChanges = true;
    }

    public static List getAll() {
        return allInstruments.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return;
        }
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string3 = h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            Object object;
            if (mWInstrument.id >= 0) {
                idMap.remove(mWInstrument.id);
            }
            keyMap.remove(mWInstrument.getKey());
            allInstruments.a(mWInstrument);
            symbol2InstrumentMap.remove(string);
            symbolDisplayMap.remove(mWInstrument.getSymbolDisplay().trim().toUpperCase());
            symbolExchangeMap.remove(string + ":" + string3);
            symbolExchangeMap.remove(string2 + ":" + string3);
            if (!h.g(mWInstrument.getServiceId())) {
                serviceIdMap.remove(mWInstrument.getSourceType() + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
            if ((object = (List)symbol2RelatedMap.get(string)) != null) {
                object.remove(mWInstrument);
            }
        }
        for (Object object : mWInstrument.instrListeners.a()) {
            object.deleted(mWInstrument);
        }
        unsavedChanges = true;
    }

    public static void populate(List list) {
        for (k k2 : list) {
            MWInstrument mWInstrument = new MWInstrument(k2.b(), k2.a(), k2.d(), k2.e());
            mWInstrument.setUnderlying(k2.a());
            mWInstrument.setDescription(k2.c());
            mWInstrument.setMinTick(k2.a());
            mWInstrument.setPointSize(k2.c());
            mWInstrument.setPriceMagnifier(k2.d());
            mWInstrument.setPLDivisor(k2.e());
            mWInstrument.setDisplayMultiplier(k2.f());
            mWInstrument.setPointValue(k2.g());
            mWInstrument.setExpiryDate(k2.a());
            MWInstrument.register(mWInstrument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exists(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return false;
        }
        Map map = idMap;
        synchronized (map) {
            return keyMap.containsKey(mWInstrument.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean register(MWInstrument mWInstrument) {
        if (mWInstrument == null) {
            return false;
        }
        if (MWInstrument.exists(mWInstrument)) {
            MWInstrument mWInstrument2;
            h.a.warning("MWInstrument::register() instrument already exists! " + mWInstrument);
            if (mWInstrument.getId() > 0 && (mWInstrument2 = MWInstrument.getByKey(mWInstrument.getKey())) != null) {
                Map map = idMap;
                synchronized (map) {
                    idMap.put(mWInstrument.id, mWInstrument2);
                }
            }
            return false;
        }
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string3 = h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            idMap.put(mWInstrument.id, mWInstrument);
            keyMap.put(mWInstrument.getKey(), mWInstrument);
            allInstruments.a(mWInstrument);
            List<MWInstrument> list = (ArrayList<MWInstrument>)symbol2InstrumentMap.get(string);
            if (list == null) {
                list = new ArrayList<MWInstrument>();
            }
            if (!list.contains(mWInstrument)) {
                list.add(mWInstrument);
            }
            symbol2InstrumentMap.put(string, list);
            list = (List)symbolDisplayMap.get(string2);
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(mWInstrument)) {
                list.add(mWInstrument);
            }
            symbolDisplayMap.put(string2, list);
            MWInstrument.registerSymbol2Exchange(string + ":" + string3, mWInstrument);
            MWInstrument.registerSymbol2Exchange(string2 + ":" + string3, mWInstrument);
            if (!h.g(mWInstrument.primaryExchange)) {
                string3 = mWInstrument.primaryExchange.toUpperCase();
                MWInstrument.registerSymbol2Exchange(string + ":" + string3, mWInstrument);
                MWInstrument.registerSymbol2Exchange(string2 + ":" + string3, mWInstrument);
            }
            if (!h.g(mWInstrument.getServiceId())) {
                serviceIdMap.put(mWInstrument.getSourceType() + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregister(MWInstrument mWInstrument) {
        String string = mWInstrument.getSymbol().trim().toUpperCase();
        String string2 = mWInstrument.getSymbolDisplay().trim().toUpperCase();
        String string3 = h.b((Object)mWInstrument.getExchange()).trim().toUpperCase();
        Map map = idMap;
        synchronized (map) {
            idMap.remove(mWInstrument.id);
            keyMap.remove(mWInstrument.getKey());
            allInstruments.a(mWInstrument);
            List list = (List)symbol2InstrumentMap.get(string);
            if (list != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolDisplayMap.get(string2)) != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolExchangeMap.get(string + ":" + string3)) != null) {
                list.remove(mWInstrument);
            }
            if ((list = (List)symbolExchangeMap.get(string2 + ":" + string3)) != null) {
                list.remove(mWInstrument);
            }
            if (!h.g(mWInstrument.primaryExchange)) {
                string3 = mWInstrument.primaryExchange.toUpperCase();
                list = (List)symbolExchangeMap.get(string + ":" + string3);
                if (list != null) {
                    list.remove(mWInstrument);
                }
                if ((list = (List)symbolExchangeMap.get(string2 + ":" + string3)) != null) {
                    list.remove(mWInstrument);
                }
            }
            if (!h.g(mWInstrument.getServiceId())) {
                serviceIdMap.remove(mWInstrument.getSourceType() + ":" + mWInstrument.getServiceId(), mWInstrument);
            }
        }
    }

    public static void addListener(InvalidationListener invalidationListener) {
        listeners.a(invalidationListener);
    }

    public static void removeListener(InvalidationListener invalidationListener) {
        listeners.a(invalidationListener);
    }

    public static synchronized void beginUpdate() {
        if (pendingUpdates < 0) {
            pendingUpdates = 0;
        }
        ++pendingUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endUpdate() {
        Class<MWInstrument> clazz = MWInstrument.class;
        synchronized (MWInstrument.class) {
            if (--pendingUpdates > 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pendingUpdates = 0;
            if (ignoreEvents) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            for (InvalidationListener invalidationListener : listeners.a()) {
                invalidationListener.invalidated(null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerSymbol2Exchange(String string, MWInstrument mWInstrument) {
        Map map = idMap;
        synchronized (map) {
            ArrayList<MWInstrument> arrayList = (ArrayList<MWInstrument>)symbolExchangeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<MWInstrument>();
            }
            if (!arrayList.contains(mWInstrument)) {
                arrayList.add(mWInstrument);
            }
            symbolExchangeMap.put(string, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(List list) {
        Object object;
        Cloneable cloneable4;
        Object object2;
        if (h.a((Collection)list)) {
            return;
        }
        Map map = idMap;
        synchronized (map) {
            for (Cloneable cloneable2 : new ArrayList(list)) {
                if (keyMap.containsKey(((MWInstrument)cloneable2).getKey())) {
                    list.remove(cloneable2);
                    h.a.warning("MWInstrument::register() instrument already exists! " + (MWInstrument)cloneable2);
                    if (((MWInstrument)cloneable2).getId() <= 0 || (object2 = MWInstrument.getByKey(((MWInstrument)cloneable2).getKey())) == null) continue;
                    cloneable4 = idMap;
                    synchronized (cloneable4) {
                        idMap.put(((MWInstrument)cloneable2).id, object2);
                        continue;
                    }
                }
                object2 = ((MWInstrument)cloneable2).getSymbol().trim().toUpperCase();
                cloneable4 = ((MWInstrument)cloneable2).getSymbolDisplay().trim().toUpperCase();
                object = h.b((Object)((MWInstrument)cloneable2).getExchange()).trim().toUpperCase();
                if (((MWInstrument)cloneable2).id > 0) {
                    idMap.put(((MWInstrument)cloneable2).id, cloneable2);
                }
                keyMap.put(((MWInstrument)cloneable2).getKey(), cloneable2);
                Cloneable cloneable3 = (ArrayList<Cloneable>)symbol2InstrumentMap.get(object2);
                if (cloneable3 == null) {
                    cloneable3 = new ArrayList<Cloneable>();
                }
                if (!cloneable3.contains(cloneable2)) {
                    cloneable3.add(cloneable2);
                }
                symbol2InstrumentMap.put(object2, cloneable3);
                cloneable3 = (List)symbolDisplayMap.get(cloneable4);
                if (cloneable3 == null) {
                    cloneable3 = new ArrayList<Cloneable>();
                }
                if (!cloneable3.contains(cloneable2)) {
                    cloneable3.add(cloneable2);
                }
                symbolDisplayMap.put(cloneable4, cloneable3);
                MWInstrument.registerSymbol2Exchange((String)object2 + ":" + (String)object, (MWInstrument)cloneable2);
                MWInstrument.registerSymbol2Exchange(cloneable4 + ":" + (String)object, (MWInstrument)cloneable2);
                if (!h.g(((MWInstrument)cloneable2).primaryExchange)) {
                    object = ((MWInstrument)cloneable2).primaryExchange.toUpperCase();
                    MWInstrument.registerSymbol2Exchange((String)object2 + ":" + (String)object, (MWInstrument)cloneable2);
                    MWInstrument.registerSymbol2Exchange(cloneable4 + ":" + (String)object, (MWInstrument)cloneable2);
                }
                if (h.g(((MWInstrument)cloneable2).getServiceId())) continue;
                serviceIdMap.put(((MWInstrument)cloneable2).getSourceType() + ":" + ((MWInstrument)cloneable2).getServiceId(), cloneable2);
            }
            allInstruments.b(list);
        }
        Collections.sort(list, (mWInstrument, mWInstrument2) -> mWInstrument.getSymbol().compareToIgnoreCase(mWInstrument2.getSymbol()));
        map = idMap;
        synchronized (map) {
            Cloneable cloneable2;
            Object object3 = null;
            cloneable2 = new ArrayList();
            for (Cloneable cloneable4 : list) {
                if (h.g(((MWInstrument)cloneable4).getSymbol())) continue;
                object = ((MWInstrument)cloneable4).getSymbol().trim().toUpperCase();
                if (object3 == null) {
                    object3 = object;
                } else if (!h.a(object, object3)) {
                    if (!h.a((Collection)((Object)cloneable2))) {
                        symbol2InstrumentMap.put(object3, cloneable2);
                    }
                    cloneable2 = new ArrayList();
                    object3 = object;
                }
                cloneable2.add(cloneable4);
            }
            if (!h.a((Collection)((Object)cloneable2))) {
                symbol2InstrumentMap.put(object3, cloneable2);
            }
            Collections.sort(list, (mWInstrument, mWInstrument2) -> {
                if (h.g(mWInstrument.getSymbolDisplay())) {
                    return -1;
                }
                if (h.g(mWInstrument2.getSymbolDisplay())) {
                    return 1;
                }
                return mWInstrument.getSymbolDisplay().compareToIgnoreCase(mWInstrument2.getSymbolDisplay());
            });
            object2 = null;
            cloneable4 = new ArrayList();
            for (Cloneable cloneable3 : list) {
                if (h.g(((MWInstrument)cloneable3).getSymbolDisplay())) continue;
                String string = ((MWInstrument)cloneable3).getSymbolDisplay().trim().toUpperCase();
                if (object2 == null) {
                    object2 = string;
                } else if (!h.a((Object)string, object2)) {
                    if (!h.a(cloneable4)) {
                        symbolDisplayMap.put(object2, cloneable4);
                    }
                    cloneable4 = new ArrayList();
                    object2 = string;
                }
                cloneable4.add(cloneable3);
            }
            if (!h.a(cloneable4)) {
                symbolDisplayMap.put(object2, cloneable4);
            }
        }
    }
}

