/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$JournalAction;
import com.motivewave.platform.common.Enums$JournalType;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.JournalEntry;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import k.f;

public class JournalDirectory {
    private static f listeners = new f();
    private static List entries = new ArrayList();
    private static boolean unsavedChanges = false;

    public static void order(MWOrder mWOrder, Enums$JournalAction enums$JournalAction, String string) {
        JournalEntry journalEntry = new JournalEntry(ae.a(), Enums$JournalType.ORDER, enums$JournalAction, string);
        journalEntry.setOrderId(mWOrder.getOrderId());
        journalEntry.setOrderTime(mWOrder.getCreated());
        journalEntry.setOrderStatus(mWOrder.getStatus());
        as as2 = ae.a(mWOrder.getAccount());
        if (as2 != null) {
            journalEntry.setConnectionID(as2.a().a());
        }
        journalEntry.setSymbol(mWOrder.getSymbol());
        journalEntry.setExchange(mWOrder.getInstrument().getExchange());
        JournalDirectory.register(journalEntry);
    }

    public static void connection(Enums$JournalAction enums$JournalAction, ConnectionID connectionID, String string) {
        JournalEntry journalEntry = new JournalEntry(ae.a(), Enums$JournalType.CONNECTION, enums$JournalAction, string);
        journalEntry.setConnectionID(connectionID);
        JournalDirectory.register(journalEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(JournalEntry journalEntry) {
        List list = entries;
        synchronized (list) {
            entries.add(journalEntry);
            if (entries.size() > b.a() + 50) {
                entries = JournalDirectory.trimToSize(entries);
            }
            unsavedChanges = true;
        }
        for (q.b b2 : listeners.a()) {
            b2.a(journalEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List list = entries;
        synchronized (list) {
            entries.clear();
        }
        unsavedChanges = true;
        for (q.b b2 : listeners.a()) {
            b2.b();
        }
    }

    public static void addListener(q.b b2) {
        listeners.a(b2);
    }

    public static void removeListener(q.b b2) {
        listeners.a(b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        List list = entries;
        synchronized (list) {
            return new ArrayList(entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllTrimmed() {
        List list = entries;
        synchronized (list) {
            if (entries.size() >= b.a()) {
                return h.a(entries, entries.size() - b.a(), entries.size());
            }
            return new ArrayList(entries);
        }
    }

    public static void saveAll() {
        if (!unsavedChanges) {
            return;
        }
        JournalDirectory.saveAll(Workspace.findDir("journal"));
        unsavedChanges = false;
    }

    public static void saveAll(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(file, "journal.csv"));
            printWriter.println("Time, Type, Action, Connection, Symbol, Exchange, OrderId, Order Time, Order Status, Message");
            List list = JournalDirectory.getAll();
            Collections.sort(list);
            list = JournalDirectory.trimToSize(list);
            for (JournalEntry journalEntry : list) {
                printWriter.println(JournalEntry.toCSV(journalEntry));
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        unsavedChanges = true;
        Object object = entries;
        synchronized (object) {
            entries.clear();
        }
        object = Workspace.findFile("journal");
        if (object == null || !((File)object).exists()) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            Object object2;
            bufferedReader = new BufferedReader(new FileReader((File)object));
            String string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            List<JournalEntry> list = new ArrayList<JournalEntry>();
            while (string != null) {
                object2 = JournalEntry.fromCSV(string);
                if (object2 != null) {
                    list.add((JournalEntry)object2);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            Collections.sort(list);
            list = JournalDirectory.trimToSize(list);
            object2 = entries;
            synchronized (object2) {
                entries.addAll(list);
            }
            unsavedChanges = false;
            for (q.b b2 : listeners.a()) {
                b2.a();
            }
        }
        catch (Exception exception) {
            h.a.warning("JournalDirectory::read() error reading journal: " + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static List trimToSize(List list) {
        if (list.size() > b.a()) {
            list = h.a(list, list.size() - b.a() - 1, list.size());
        }
        return list;
    }
}

