/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.ai;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class InstrumentImportFormat {
    private File file;
    private int symbolIndex = -1;
    private int exchangeIndex = -1;
    private int titleIndex = -1;
    private int descriptionIndex = -1;
    private int currencyIndex = -1;
    private int typeIndex = -1;
    private int minTickIndex = -1;
    private char separator = (char)44;
    private boolean ignoreEmpty = false;
    private boolean symbolOnly = false;

    public void detectFormat(File file) {
        try {
            BufferedReader bufferedReader;
            String string;
            this.file = file;
            this.symbolIndex = 0;
            this.exchangeIndex = 1;
            this.typeIndex = 2;
            this.currencyIndex = 3;
            this.minTickIndex = 4;
            this.titleIndex = 5;
            this.descriptionIndex = 6;
            String string2 = this.file.getName().toUpperCase();
            this.separator = (char)44;
            this.ignoreEmpty = false;
            if (string2.endsWith(".PRN")) {
                this.separator = (char)32;
                this.ignoreEmpty = true;
            }
            if ((string = (bufferedReader = new BufferedReader(new FileReader(this.file))).readLine()) == null) {
                bufferedReader.close();
                throw new MWException(ai.a("E_CSV_NOT_CSV_FILE", new Object[0]));
            }
            if (string.indexOf(44) < 0) {
                this.symbolIndex = 0;
                this.symbolOnly = true;
                bufferedReader.close();
                return;
            }
            List list = this.tokenize(string);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string3 = (String)list.get(i2);
                if ((string3 = string3.toUpperCase()).indexOf("TICKER") >= 0) {
                    this.symbolIndex = i2;
                }
                if (string3.indexOf("SYMBOL") >= 0) {
                    this.symbolIndex = i2;
                }
                if (string3.indexOf("EXCHANGE") >= 0) {
                    this.exchangeIndex = i2;
                }
                if (string3.indexOf("TITLE") >= 0) {
                    this.titleIndex = i2;
                }
                if (string3.indexOf("DESCRIPTION") >= 0) {
                    this.descriptionIndex = i2;
                }
                if (string3.indexOf("MIN TICK") >= 0) {
                    this.minTickIndex = i2;
                }
                if (string3.indexOf("MINTICK") >= 0) {
                    this.minTickIndex = i2;
                }
                if (string3.indexOf("MIN_TICK") >= 0) {
                    this.minTickIndex = i2;
                }
                if (string3.indexOf("TYPE") >= 0) {
                    this.typeIndex = i2;
                }
                if (string3.indexOf("INSTRUMENT_TYPE") >= 0) {
                    this.typeIndex = i2;
                }
                if (string3.indexOf("INSTRUMENT TYPE") >= 0) {
                    this.typeIndex = i2;
                }
                if (string3.indexOf("CURRENCY") < 0) continue;
                this.currencyIndex = i2;
            }
            bufferedReader.close();
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MWException(com.motivewave.platform.common.h.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    public String getSymbol(List list) {
        if (this.symbolIndex < 0 || this.symbolIndex >= list.size()) {
            return null;
        }
        return InstrumentImportFormat.fixString((String)list.get(this.symbolIndex));
    }

    public String getExchange(List list) {
        if (this.exchangeIndex < 0 || this.exchangeIndex >= list.size()) {
            return null;
        }
        return InstrumentImportFormat.fixString((String)list.get(this.exchangeIndex));
    }

    public String getTitle(List list) {
        if (this.titleIndex < 0 || this.titleIndex >= list.size()) {
            return null;
        }
        return InstrumentImportFormat.fixString((String)list.get(this.titleIndex));
    }

    public String getDescription(List list) {
        if (this.descriptionIndex < 0 || this.descriptionIndex >= list.size()) {
            return null;
        }
        return InstrumentImportFormat.fixString((String)list.get(this.descriptionIndex));
    }

    public String getCurrency(List list) {
        if (this.currencyIndex < 0 || this.currencyIndex >= list.size()) {
            return "USD";
        }
        return InstrumentImportFormat.fixString((String)list.get(this.currencyIndex));
    }

    public double getMinTick(List list) {
        if (this.minTickIndex < 0 || this.minTickIndex >= list.size()) {
            return 0.01;
        }
        double d2 = h.a(InstrumentImportFormat.fixString((String)list.get(this.minTickIndex)));
        if (d2 <= 0.0) {
            return 0.01;
        }
        return d2;
    }

    public Enums$InstrumentType getType(List list, String string, String string2) {
        if (this.typeIndex < 0 || this.typeIndex >= list.size()) {
            if (string.startsWith(".") || string.startsWith("$")) {
                return Enums$InstrumentType.INDEX;
            }
            if (!h.g(string2) && h.a(string2 = string2.toUpperCase(), "CURRENCY", "FXCM", "FOREX")) {
                return Enums$InstrumentType.CASH;
            }
            return Enums$InstrumentType.STOCK;
        }
        try {
            return Enums$InstrumentType.valueOf(InstrumentImportFormat.fixString((String)list.get(this.typeIndex)).toUpperCase());
        }
        catch (Exception exception) {
            return Enums$InstrumentType.STOCK;
        }
    }

    public boolean hasType(List list) {
        return this.typeIndex >= 0 && this.typeIndex < list.size();
    }

    public boolean hasExchange(List list) {
        return this.exchangeIndex >= 0 && this.exchangeIndex < list.size();
    }

    public boolean hasCurrency(List list) {
        return this.currencyIndex >= 0 && this.currencyIndex < list.size();
    }

    public boolean hasMinTick(List list) {
        return this.minTickIndex >= 0 && this.minTickIndex < list.size();
    }

    public List tokenize(String string) {
        if (this.symbolOnly) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(h.p(string));
            return arrayList;
        }
        return h.a(string, this.separator, this.ignoreEmpty);
    }

    public File getFile() {
        return this.file;
    }

    public char getSeparator() {
        return this.separator;
    }

    private static String fixString(String string) {
        if (h.g(string)) {
            return "";
        }
        string = h.a(string, "\"", "");
        string = h.a(string, "'", "");
        return h.p(string);
    }
}

