/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.DOM;
import com.motivewave.platform.sdk.common.DOMListener;
import com.motivewave.platform.sdk.common.DOMSnapshot;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import com.motivewave.platform.ui.draw.am;
import com.motivewave.platform.ui.draw.n;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import k.f;
import o.p;
import q.i;

public class InstrumentImpl
extends a.b
implements Ticker,
am,
PropertyChangeListener,
i {
    private float pHigh;
    private float pLow;
    private float pOpen;
    private float pPrevClose;
    private float pChange;
    private float pChangePer;
    private float pInvChange;
    private float pInvChangePer;
    private float pPercentOffHigh;
    private float pPercentOffLow;
    private float pPercentOffOpen;
    private float pDayRange;
    private float pDayRangePer;
    private p lastTick;
    private LiveTicker ticker;
    private com.motivewave.platform.ui.draw.p dm;
    private float rpLastPrice;
    private float rpBidPrice;
    private float rpAskPrice;
    private float minTick = 0.01f;
    private long rpLastTime = 0L;
    private f tickListeners = new f();
    private static DecimalFormat sizeFormat = new DecimalFormat("###,###,###,###");
    private static DecimalFormat sizeFormat2 = new DecimalFormat("###,###,###,###.########");
    private BooleanProperty replayProperty = new SimpleBooleanProperty(false);
    private Map propertyTime = Collections.synchronizedMap(new HashMap());
    private f domListeners = new f();
    private com.motivewave.platform.service.h domDispatcher = g2 -> {
        if (this.isReplay()) {
            return;
        }
        for (DOMListener dOMListener : this.domListeners.a()) {
            dOMListener.update((DOM)g2);
        }
    };
    private f sdkTickListeners = new f();
    private i tickDispatcher = p2 -> {
        for (TickOperation tickOperation : this.sdkTickListeners.a()) {
            tickOperation.onTick((Tick)p2);
        }
    };

    public InstrumentImpl(com.motivewave.platform.ui.draw.p p3, LiveTicker liveTicker) {
        this.ticker = liveTicker;
        this.dm = p3;
        p3.a(this);
        this.replayProperty.bind((ObservableValue)p3.a());
        this.minTick = liveTicker.getMinTickFloat();
    }

    @Override
    public String getKey() {
        return this.getInstrument().getKey();
    }

    @Override
    public void destroy() {
        if (this.ticker != null) {
            this.ticker.removeTickListener(this);
            this.ticker.removePropertyChangeListener(this);
            this.ticker.removeDepthListener(this.domDispatcher);
        }
        if (this.dm != null) {
            this.dm.b(this);
        }
        this.tickListeners.b();
        this.domListeners.b();
        this.replayProperty.unbind();
    }

    @Override
    public float getCurrentPrice(float f2) {
        float f3;
        float f4 = f3 = b.cz() ? this.getLastPrice() : 0.0f;
        if (f3 != 0.0f) {
            return f3;
        }
        if (f2 < 0.0f) {
            return this.getAskPrice();
        }
        if (f2 > 0.0f) {
            f3 = this.getBidPrice();
        }
        if (f3 == 0.0f) {
            f3 = this.getLastPrice();
        }
        return f3;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.hasListeners() && this.ticker != null) {
            this.ticker.addPropertyChangeListener(this);
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (!this.hasListeners() && this.ticker != null) {
            this.ticker.addPropertyChangeListener(this);
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (!this.hasListeners() && this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (!this.hasListeners() && this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
    }

    @Override
    public void addTickListener(i i2) {
        if (this.tickListeners.a() && this.ticker != null) {
            this.ticker.addTickListener(this);
        }
        this.tickListeners.a(i2);
    }

    @Override
    public void removeTickListener(i i2) {
        this.tickListeners.a(i2);
        if (this.tickListeners.a() && this.ticker != null) {
            this.ticker.removeTickListener(this);
        }
    }

    public void addListener(DOMListener dOMListener) {
        if (this.domListeners.b(dOMListener)) {
            return;
        }
        boolean bl2 = this.domListeners.a();
        this.domListeners.a(dOMListener);
        if (bl2) {
            this.ticker.addDepthListener(this.domDispatcher);
        }
    }

    public void removeListener(DOMListener dOMListener) {
        if (!this.domListeners.b(dOMListener)) {
            return;
        }
        this.domListeners.a(dOMListener);
        if (this.domListeners.a()) {
            this.ticker.removeDepthListener(this.domDispatcher);
        }
    }

    public void addListener(TickOperation tickOperation) {
        if (this.sdkTickListeners.b(tickOperation)) {
            return;
        }
        boolean bl2 = this.sdkTickListeners.a();
        this.sdkTickListeners.a(tickOperation);
        if (bl2) {
            this.addTickListener(this.tickDispatcher);
        }
    }

    public void removeListener(TickOperation tickOperation) {
        if (!this.sdkTickListeners.b(tickOperation)) {
            return;
        }
        this.sdkTickListeners.a(tickOperation);
        if (this.sdkTickListeners.a()) {
            this.removeTickListener(this.tickDispatcher);
        }
    }

    @Override
    public boolean isReplay() {
        return this.replayProperty.get();
    }

    @Override
    public long getCurrentTime() {
        return this.dm == null ? ae.a() : this.dm.d();
    }

    public ReadOnlyBooleanProperty replayProperty() {
        return this.replayProperty;
    }

    public boolean isInsideTradingHours(long l2, boolean bl2) {
        return this.ticker.isInsideTradingHours(l2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTicks(long l2, long l3) {
        if (this.isReplay() && l3 > this.dm.d()) {
            l3 = this.dm.d();
        }
        try {
            List list = this.ticker.getTicksByPeriod(l2, l3, this.dm);
            ArrayList<Tick> arrayList = new ArrayList<Tick>(list.size());
            for (Tick tick : list) {
                if (tick.getTime() < l2 || tick.getTime() > l3) continue;
                arrayList.add(tick);
            }
            ArrayList<Tick> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.dm.a((n)null);
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTicks(long l2, long l3, boolean bl2) {
        if (this.isReplay() && l3 > this.dm.d()) {
            l3 = this.dm.d();
        }
        try {
            List list = this.ticker.getTicksByPeriod(l2, l3, this.dm);
            ArrayList<Tick> arrayList = new ArrayList<Tick>(list.size());
            MWInstrument mWInstrument = this.ticker.getInstrument();
            for (Tick tick : list) {
                if (tick.getTime() < l2 || tick.getTime() > l3 || bl2 && !mWInstrument.isInsideTradingHours(tick.getTime(), bl2)) continue;
                arrayList.add(tick);
            }
            ArrayList<Tick> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.dm.f();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTick(long l2, long l3, boolean bl2, TickOperation tickOperation) {
        if (this.isReplay()) {
            long l4 = this.dm.d();
            if (l2 > l4) {
                return;
            }
            if (l3 > this.dm.d()) {
                l3 = this.dm.d();
            }
        }
        try {
            this.ticker.forEachTick(l2, l3, bl2, this.dm, tickOperation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.dm.f();
        }
    }

    public void forEachTick(long l2, long l3, TickOperation tickOperation) {
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "change": {
                return Float.valueOf(this.getChange());
            }
            case "changePer": {
                return Float.valueOf(this.getChangePer());
            }
            case "invChange": {
                return Float.valueOf(this.getInvChange());
            }
            case "invChangePer": {
                return Float.valueOf(this.getInvChangePer());
            }
            case "bidSize": {
                return this.getBidSize();
            }
            case "askSize": {
                return this.getAskSize();
            }
            case "bidPrice": {
                return Float.valueOf(this.getBidPrice());
            }
            case "askPrice": {
                return Float.valueOf(this.getAskPrice());
            }
            case "lastPrice": {
                return Float.valueOf(this.getLastPrice());
            }
            case "lastSize": {
                return this.getLastSize();
            }
            case "midpoint": {
                return Float.valueOf(this.getMidpoint());
            }
            case "lastTimestamp": {
                return this.getLastTimestamp();
            }
            case "spread": {
                return Float.valueOf(this.getSpread());
            }
            case "high": {
                return Float.valueOf(this.getHigh());
            }
            case "low": {
                return Float.valueOf(this.getLow());
            }
            case "symbolDisplay": {
                return this.getSymbolDisplay();
            }
            case "open": {
                return Float.valueOf(this.getOpen());
            }
            case "close": 
            case "previousClose": {
                return Float.valueOf(this.getPreviousClose());
            }
            case "dayVolume": {
                return Float.valueOf(this.getDayVolume());
            }
            case "percentOffHigh": {
                return Float.valueOf(this.getPercentOffHigh());
            }
            case "percentOffLow": {
                return Float.valueOf(this.getPercentOffLow());
            }
            case "percentOffOpen": {
                return Float.valueOf(this.getPercentOffOpen());
            }
            case "dayRange": {
                return Float.valueOf(this.getDayRange());
            }
            case "dayRangePercent": {
                return Float.valueOf(this.getDayRangePercent());
            }
        }
        return this.ticker.getProperty(string);
    }

    @Override
    public String format(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return "";
        }
        switch (string) {
            case "bidSize": 
            case "askSize": 
            case "lastSize": {
                int n2 = (Integer)object;
                if (n2 < 10000) {
                    return sizeFormat.format(n2);
                }
                return s.c(n2);
            }
            case "bidPrice": 
            case "askPrice": 
            case "lastPrice": 
            case "midpoint": 
            case "change": 
            case "invChange": 
            case "high": 
            case "low": 
            case "open": 
            case "dayRange": 
            case "close": 
            case "previousClose": {
                return this.getInstrument().formatValue(((Float)object).floatValue());
            }
            case "spread": {
                float f2 = ((Float)object).floatValue();
                if (f2 == 0.0f) {
                    return "";
                }
                return h.c((double)f2, 1);
            }
            case "lastTimestamp": {
                if (this.getLastTimestamp() == 0L) {
                    return "";
                }
                return s.a(this.getLastTimestamp(), b.a());
            }
            case "changePer": {
                return h.a(this.getChangePer(), 2);
            }
            case "invChangePer": {
                return h.a(this.getInvChangePer(), 2);
            }
            case "percentOffHigh": {
                return h.a(this.getPercentOffHigh(), 2);
            }
            case "percentOffLow": {
                return h.a(this.getPercentOffLow(), 2);
            }
            case "percentOffOpen": {
                return h.a(this.getPercentOffOpen(), 2);
            }
            case "dayRangePercent": {
                return h.a(this.getDayRangePercent(), 2);
            }
            case "dayVolume": {
                float f3 = this.getDayVolume();
                if (this.ticker.getInstrument().supportsFractionalVolume()) {
                    if (f3 < 1000.0f) {
                        return sizeFormat2.format(f3);
                    }
                    return s.b(f3, this.ticker.getInstrument());
                }
                if (f3 < 10000.0f) {
                    return sizeFormat.format(f3);
                }
                return s.c((long)f3);
            }
        }
        if (object instanceof Number) {
            float f4 = ((Number)object).floatValue();
            if (!this.getInstrument().isValueValid(f4)) {
                return "";
            }
            return this.getInstrument().formatValue(f4);
        }
        return h.b(object);
    }

    public Enums.Service getBroker() {
        as as2 = ae.a(this.getInstrument());
        if (as2 == null) {
            return null;
        }
        return as2.a().a().getService();
    }

    public Enums.Service getDataSource() {
        as as2 = ae.a(this.getInstrument());
        return as2.a().a().getService();
    }

    public String getUnderlying() {
        return this.ticker == null ? "" : this.ticker.getUnderlying();
    }

    public String getSymbol() {
        return this.ticker == null ? "" : this.ticker.getSymbol();
    }

    @Override
    public String getSymbolDisplay() {
        return this.ticker == null ? "" : this.ticker.getSymbolDisplay();
    }

    public String getExchangeSymbol() {
        return this.ticker == null ? "" : this.ticker.getExchangeSymbol();
    }

    public Enums.InstrumentType getType() {
        return this.ticker == null ? null : this.ticker.getType();
    }

    public float round(float f2) {
        return this.ticker == null ? f2 : this.ticker.round(f2);
    }

    public double round(double d2) {
        return this.ticker == null ? d2 : this.ticker.round(d2);
    }

    @Override
    public String format(float f2) {
        return this.ticker == null ? "" + f2 : this.ticker.format(f2);
    }

    @Override
    public String format(double d2) {
        return this.ticker == null ? "" + d2 : this.ticker.format(d2);
    }

    public int getDefaultQuantity() {
        return this.ticker == null ? 1 : this.ticker.getDefaultQuantity();
    }

    public float getDefaultQuantityAsFloat() {
        return this.ticker == null ? 1.0f : this.ticker.getDefaultQuantityAsFloat();
    }

    public double getPointSize() {
        return this.ticker == null ? 1.0 : this.ticker.getPointSize();
    }

    public double getTickSize() {
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            return 0.01;
        }
        float f2 = this.getLastPrice();
        if (f2 == 0.0f) {
            f2 = this.getMidpoint();
        }
        return mWInstrument.getMinTick(f2);
    }

    public double calcPnL(double d2, int n2) {
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            h.a.severe("InstrumentImpl::calcPnL() instr is null!");
            return 0.0;
        }
        return mWInstrument.calcPnL(d2, n2);
    }

    public double calcPnL(double d2, float f2) {
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            h.a.severe("InstrumentImpl::calcPnL() instr is null!");
            return 0.0;
        }
        return mWInstrument.calcPnL(d2, f2);
    }

    public float getLastPrice() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return this.rpLastPrice;
        }
        float f2 = this.ticker.getLastPrice();
        if (f2 != 0.0f) {
            return f2;
        }
        switch (this.dm.a()) {
            case MIDPOINT: {
                return this.ticker.round(this.ticker.getBidPrice() + this.ticker.getAskPrice()) / 2.0f;
            }
            case ASK: {
                return this.ticker.getAskPrice();
            }
            case BID: {
                return this.ticker.getBidPrice();
            }
            case PRICE: {
                break;
            }
        }
        return f2;
    }

    public float getBidPrice() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return this.rpBidPrice;
        }
        return this.ticker.getBidPrice();
    }

    public float getAskPrice() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return this.rpAskPrice;
        }
        return this.ticker.getAskPrice();
    }

    public float getChange() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return this.rpLastPrice - this.dm.d();
        }
        return this.ticker.getChange();
    }

    @Override
    public float getChangePer() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a(this.getChange() / this.dm.d(), 4);
        }
        return this.ticker.getChangePer();
    }

    @Override
    public float getInvChange() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return 1.0f / this.rpLastPrice - 1.0f / this.dm.d();
        }
        return this.ticker.getInvChange();
    }

    @Override
    public float getInvChangePer() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a(this.getInvChange() / (1.0f / this.dm.d()), 4);
        }
        return this.ticker.getInvChangePer();
    }

    public int getLastSize() {
        if (this.dm == null) {
            return 0;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                return this.lastTick.getVolume();
            }
            return (int)this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getLastSize();
    }

    public float getLastSizeAsFloat() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                return this.lastTick.getVolumeAsFloat();
            }
            return this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getLastSizeAsFloat();
    }

    public int getAskSize() {
        if (this.dm == null) {
            return 0;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                if (this.lastTick.c()) {
                    return this.lastTick.getAskSize();
                }
                return this.lastTick.getVolume();
            }
            return (int)this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getAskSize();
    }

    public float getAskSizeAsFloat() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                if (this.lastTick.c()) {
                    return this.lastTick.getAskSizeAsFloat();
                }
                return this.lastTick.getVolumeAsFloat();
            }
            return this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getAskSizeAsFloat();
    }

    public int getBidSize() {
        if (this.dm == null) {
            return 0;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                if (this.lastTick.c()) {
                    return this.lastTick.getBidSize();
                }
                return this.lastTick.getVolume();
            }
            return (int)this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getBidSize();
    }

    public float getBidSizeAsFloat() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h() && this.lastTick != null) {
            if (this.ticker == this.dm.a()) {
                if (this.lastTick.c()) {
                    return this.lastTick.getBidSizeAsFloat();
                }
                return this.lastTick.getVolumeAsFloat();
            }
            return this.dm.g(this.ticker.getInstrument());
        }
        return this.ticker.getBidSizeAsFloat();
    }

    public float getSpread() {
        return (this.getAskPrice() - this.getBidPrice()) / (float)this.getPointSize();
    }

    public float getHigh() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            if (this.ticker == this.dm.a()) {
                return this.dm.a();
            }
            return this.dm.a(this.ticker.getInstrument());
        }
        return this.ticker.getHigh();
    }

    public float getLow() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            if (this.ticker == this.dm.a()) {
                return this.dm.b();
            }
            return this.dm.b(this.ticker.getInstrument());
        }
        return this.ticker.getLow();
    }

    public float getOpen() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            if (this.ticker == this.dm.a()) {
                return this.dm.c();
            }
            return this.dm.c(this.ticker.getInstrument());
        }
        return this.ticker.getOpen();
    }

    public float getPreviousClose() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            if (this.ticker == this.dm.a()) {
                return this.dm.d();
            }
            return this.dm.d(this.ticker.getInstrument());
        }
        return this.ticker.getClose();
    }

    @Override
    public float getPercentOffOpen() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a((this.rpLastPrice - this.dm.c()) / this.dm.c(), 4);
        }
        return this.ticker.getPercentOffOpen();
    }

    @Override
    public float getPercentOffHigh() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a((this.dm.a() - this.rpLastPrice) / this.dm.a(), 4);
        }
        return this.ticker.getPercentOffHigh();
    }

    @Override
    public float getPercentOffLow() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a((this.rpLastPrice - this.dm.b()) / this.dm.b(), 4);
        }
        return this.ticker.getPercentOffLow();
    }

    @Override
    public float getDayVolume() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            if (this.ticker == this.dm.a()) {
                return this.dm.e();
            }
            return this.dm.e(this.ticker.getInstrument());
        }
        return this.ticker.getDayVolume();
    }

    @Override
    public float getDayRange() {
        return this.getHigh() - this.getLow();
    }

    @Override
    public float getDayRangePercent() {
        if (this.dm == null) {
            return 0.0f;
        }
        if (this.dm.h()) {
            return h.a((this.dm.a() - this.dm.b()) / this.rpLastPrice, 4);
        }
        return this.ticker.getDayRangePercent();
    }

    public long getLastTimestamp() {
        if (this.dm == null) {
            return ae.a();
        }
        if (this.dm.h()) {
            return this.rpLastTime;
        }
        return this.ticker.getLastTimestamp();
    }

    public float getMidpoint() {
        return this.round((this.getBidPrice() + this.getAskPrice()) / 2.0f);
    }

    public float getBuyPrice() {
        float f2 = this.round(this.getAskPrice());
        if (!this.ticker.getInstrument().isValueValid(f2)) {
            return this.getLastPrice();
        }
        return f2;
    }

    public float getSellPrice() {
        float f2 = this.round(this.getBidPrice());
        if (!this.ticker.getInstrument().isValueValid(f2)) {
            return this.getLastPrice();
        }
        return f2;
    }

    @Override
    public float getHighCalendarYear() {
        return this.ticker.getHighCalendarYear();
    }

    @Override
    public float getLowCalendarYear() {
        return this.ticker.getLowCalendarYear();
    }

    @Override
    public float getHigh52Week() {
        return this.ticker.getHigh52Week();
    }

    @Override
    public float getLow52Week() {
        return this.ticker.getLow52Week();
    }

    @Override
    public float getHigh26Week() {
        return this.ticker.getHigh26Week();
    }

    @Override
    public float getLow26Week() {
        return this.ticker.getLow26Week();
    }

    @Override
    public float getHigh13Week() {
        return this.ticker.getHigh13Week();
    }

    @Override
    public float getLow13Week() {
        return this.ticker.getLow13Week();
    }

    @Override
    public void tick(p p2) {
        if (p2.a() != this.ticker) {
            return;
        }
        if (this.dm != null && this.dm.h()) {
            return;
        }
        for (i i2 : this.tickListeners.a()) {
            i2.tick(p2);
        }
    }

    @Override
    public void replayTick(p p2) {
        if (p2.a() != this.ticker) {
            return;
        }
        p p3 = this.lastTick;
        this.lastTick = p2;
        this.replayTickUpdated(p3, p2);
        for (i i2 : this.tickListeners.a()) {
            i2.tick(p2);
        }
    }

    public void initReplayValues(p p2) {
        if (p2 != null && p2.a() != this.ticker) {
            return;
        }
        this.pPrevClose = 0.0f;
        this.pOpen = 0.0f;
        this.pLow = 0.0f;
        this.pHigh = 0.0f;
        if (p2 != null) {
            this.replayTickUpdated(null, p2);
        }
    }

    @Override
    public void initReplay(p p2) {
        if (p2 != null && p2.a() != this.ticker) {
            return;
        }
        this.lastTick = p2;
        this.pPrevClose = 0.0f;
        this.pOpen = 0.0f;
        this.pLow = 0.0f;
        this.pHigh = 0.0f;
        if (p2 == null) {
            return;
        }
        this.replayTickUpdated(null, p2);
        for (i i2 : this.tickListeners.a()) {
            i2.tick(p2);
        }
    }

    private void replayTickUpdated(p p2, p p3) {
        float f2 = p3.getAskPrice();
        float f3 = p3.getBidPrice();
        float f4 = p3.getPrice();
        if (!p3.c() && f4 != 0.0f) {
            f2 = f4 + this.minTick;
            f3 = f4 - this.minTick;
        }
        this.rpLastTime = p3.getTime();
        if (this.dm.g()) {
            this.rpLastPrice = f4;
            this.rpAskPrice = f2;
            this.rpBidPrice = f3;
            return;
        }
        if (f4 == this.rpLastPrice && f2 == this.rpAskPrice && f3 == this.rpBidPrice && p2 != null) {
            this.firePropertyChange("lastSize", p2.getVolumeAsFloat(), p3.getVolumeAsFloat());
            this.firePropertyChange("bidSize", p2.getBidSizeAsFloat(), p3.getBidSizeAsFloat());
            this.firePropertyChange("askSize", p2.getAskSizeAsFloat(), p3.getAskSizeAsFloat());
            return;
        }
        this.rpLastPrice = f4;
        this.rpAskPrice = f2;
        this.rpBidPrice = f3;
        long l2 = System.currentTimeMillis();
        this.propertyTime.put("lastPrice", l2);
        this.propertyTime.put("lastSize", l2);
        this.propertyTime.put("askPrice", l2);
        this.propertyTime.put("askSize", l2);
        this.propertyTime.put("bidPrice", l2);
        this.propertyTime.put("bidSize", l2);
        this.propertyTime.put("midpoint", l2);
        this.propertyTime.put("spread", l2);
        this.propertyTime.put("high", l2);
        this.propertyTime.put("low", l2);
        this.propertyTime.put("open", l2);
        this.propertyTime.put("lastTimestamp", l2);
        this.propertyTime.put("change", l2);
        this.propertyTime.put("changePer", l2);
        this.propertyTime.put("invChange", l2);
        this.propertyTime.put("invChangePer", l2);
        float f5 = this.dm.a();
        float f6 = this.dm.b();
        float f7 = this.dm.c();
        float f8 = this.dm.d();
        float f9 = this.getChange();
        float f10 = this.getChangePer();
        float f11 = this.getInvChange();
        float f12 = this.getInvChangePer();
        float f13 = this.getPercentOffHigh();
        float f14 = this.getPercentOffLow();
        float f15 = this.getPercentOffOpen();
        float f16 = this.getDayRangePercent();
        float f17 = this.getDayRange();
        long l3 = 0L;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (p2 != null) {
            f18 = p2.getAskPrice();
            f19 = p2.getBidPrice();
            f20 = p2.getPrice();
            l3 = p2.getTime();
            n2 = p2.getAskSize();
            n3 = p2.getBidSize();
            if (!p2.c() && f20 != 0.0f) {
                f18 = f4 + this.minTick;
                f19 = f4 - this.minTick;
            }
        } else {
            this.pPrevClose = 0.0f;
            this.pOpen = 0.0f;
            this.pLow = 0.0f;
            this.pHigh = 0.0f;
            this.pInvChangePer = 0.0f;
            this.pInvChange = 0.0f;
            this.pChangePer = 0.0f;
            this.pChange = 0.0f;
            this.pDayRange = 0.0f;
            this.pDayRangePer = 0.0f;
            this.pPercentOffOpen = 0.0f;
            this.pPercentOffLow = 0.0f;
            this.pPercentOffHigh = 0.0f;
        }
        this.firePropertyChange("lastPrice", f20, this.rpLastPrice);
        this.firePropertyChange("lastSize", n4, p3.getVolume());
        this.firePropertyChange("askPrice", f18, this.rpAskPrice);
        this.firePropertyChange("askSize", n2, p3.getAskSize());
        this.firePropertyChange("bidPrice", f19, this.rpBidPrice);
        this.firePropertyChange("bidSize", n3, p3.getBidSize());
        this.firePropertyChange("midpoint", this.round((f18 + f19) / 2.0f), this.round((f2 + f3) / 2.0f));
        this.firePropertyChange("spread", f18 - f19, f2 - f3);
        this.firePropertyChange("lastTimestamp", l3, p3.getTime());
        if (p3.getVolume() != 0) {
            this.notifyProperty(this, "dayVolume");
        }
        this.firePropertyChange("high", this.pHigh, f5);
        this.firePropertyChange("low", this.pLow, f6);
        this.firePropertyChange("open", this.pOpen, f7);
        this.firePropertyChange("previousClose", this.pPrevClose, f8);
        this.firePropertyChange("change", this.pChange, f9);
        this.firePropertyChange("changePer", this.pChangePer, f10);
        this.firePropertyChange("invChange", this.pInvChange, f11);
        this.firePropertyChange("invChangePer", this.pInvChangePer, f12);
        this.firePropertyChange("percentOffHigh", this.pPercentOffHigh, f13);
        this.firePropertyChange("percentOffLow", this.pPercentOffLow, f14);
        this.firePropertyChange("percentOffOpen", this.pPercentOffOpen, f15);
        this.firePropertyChange("dayRange", this.pDayRange, f17);
        this.firePropertyChange("dayRangePercent", this.pDayRangePer, f16);
        this.pLow = f6;
        this.pHigh = f5;
        this.pOpen = f7;
        this.pPrevClose = f8;
        this.pChange = f9;
        this.pChangePer = f10;
        this.pInvChange = f11;
        this.pInvChangePer = f12;
        this.pPercentOffHigh = f13;
        this.pPercentOffLow = f14;
        this.pPercentOffOpen = f15;
        this.pDayRange = f17;
        this.pDayRangePer = f16;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.dm == null || this.dm.h() || !this.hasListeners()) {
            return;
        }
        if (!h.a(propertyChangeEvent.getPropertyName(), "lastPrice", "lastSize", "askPrice", "askSize", "bidPrice", "bidSize", "midpoint", "buyPrice", "sellPrice", "change", "spread", "high", "low", "open", "close", "previousClose", "lastTimestamp", "changePer", "invChange", "invChangePer", "dayRange", "dayVolume", "percentOffHigh", "percentOffLow", "percentOffOpen", "histogram")) {
            return;
        }
        this.propertyTime.put(propertyChangeEvent.getPropertyName(), System.currentTimeMillis());
        this.firePropertyChange(new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
    }

    public LiveTicker getTicker() {
        return this.ticker;
    }

    public long getStartOfDay(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getStartOfDay(l2, bl2);
    }

    public long getEndOfDay(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getEndOfDay(l2, bl2);
    }

    public long getStartOfWeek(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getStartOfWeek(l2, bl2);
    }

    public long getEndOfWeek(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getEndOfWeek(l2, bl2);
    }

    public long getStartOfMonth(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getStartOfMonth(l2, bl2);
    }

    public long getEndOfMonth(long l2, boolean bl2) {
        return this.ticker == null ? 0L : this.ticker.getEndOfMonth(l2, bl2);
    }

    public TimeZone getTimeZone() {
        return this.ticker == null ? b.a() : this.ticker.getTimeZone();
    }

    public double calcCommission(int n2) {
        return this.ticker == null ? 0.0 : this.ticker.calcCommission(n2);
    }

    public double calcCommission(float f2) {
        return this.ticker == null ? 0.0 : this.ticker.calcCommission(f2);
    }

    public List getDOMHistory() {
        if (this.ticker == null) {
            return Collections.EMPTY_LIST;
        }
        List list = this.ticker.getDOMHistory();
        if (!this.isReplay()) {
            return list;
        }
        long l2 = this.getCurrentTime();
        int n2 = -1;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            if (((DOMSnapshot)list.get(i2)).getTime() > l2) continue;
            n2 = i2;
            break;
        }
        if (n2 < 0) {
            return Collections.EMPTY_LIST;
        }
        return list.subList(0, n2 + 1);
    }

    public DOMSnapshot getLatestDOMHistory() {
        if (!this.isReplay()) {
            return this.ticker.getLatestDOMHistory();
        }
        List list = this.ticker.getDOMHistory();
        long l2 = this.getCurrentTime();
        if (h.a((Collection)list) || ((DOMSnapshot)list.get(0)).getTime() > l2) {
            return null;
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            if (((DOMSnapshot)list.get(i2)).getTime() > l2) continue;
            return (DOMSnapshot)list.get(i2);
        }
        return null;
    }

    @Override
    public MWInstrument getInstrument() {
        if (this.ticker == null) {
            return null;
        }
        return this.ticker.getInstrument();
    }

    @Override
    public long getLastUpdate(String string) {
        return h.a((Long)this.propertyTime.get(string));
    }
}

