/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.databean.MWInstrument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;

public class ImportFormat {
    private boolean multiSymbol = false;
    private String symbol;
    private String name;
    private String exchange;
    private MWInstrument instrument;
    private File file;
    private int symbolIndex = -1;
    private int openIndex = -1;
    private int closeIndex = -1;
    private int highIndex = -1;
    private int lowIndex = -1;
    private int openBidIndex = -1;
    private int openAskIndex = -1;
    private int closeBidIndex = -1;
    private int closeAskIndex = -1;
    private int highBidIndex = -1;
    private int highAskIndex = -1;
    private int lowBidIndex = -1;
    private int lowAskIndex = -1;
    private int volumeIndex = -1;
    private int openInterestIndex = -1;
    private int dateIndex = -1;
    private int timeIndex = -1;
    private int nameIndex = -1;
    private int upVolIndex = -1;
    private int downVolIndex = -1;
    private double minTick = 0.01;
    private SimpleDateFormat dateTimeFormat;
    private boolean dateLetters = false;
    private TimeZone timeZone;
    private int barSize = 0;
    private Boolean rth = null;
    private boolean validNameFormat = false;
    private char separator = (char)44;
    private boolean ignoreEmpty = false;

    public ImportFormat(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void detectFormat(File file) {
        this.file = file;
        try {
            this.detectFormat(new BufferedReader(new FileReader(file)), file.getName());
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            throw new MWException(com.motivewave.platform.common.h.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    public void detectFormat(BufferedReader bufferedReader, String string) {
        try {
            int n2;
            int n3;
            String string2;
            Object object;
            String string3;
            this.dateTimeFormat = null;
            this.symbol = null;
            this.instrument = null;
            this.barSize = 0;
            this.validNameFormat = false;
            this.downVolIndex = -1;
            this.upVolIndex = -1;
            this.openInterestIndex = -1;
            this.timeIndex = -1;
            this.dateIndex = -1;
            this.volumeIndex = -1;
            this.closeIndex = -1;
            this.lowIndex = -1;
            this.highIndex = -1;
            this.openIndex = -1;
            this.nameIndex = -1;
            this.symbolIndex = -1;
            this.closeBidIndex = -1;
            this.lowBidIndex = -1;
            this.highBidIndex = -1;
            this.openBidIndex = -1;
            this.closeAskIndex = -1;
            this.lowAskIndex = -1;
            this.highAskIndex = -1;
            this.openAskIndex = -1;
            this.minTick = 0.01;
            String string4 = string.toUpperCase();
            this.separator = (char)44;
            this.ignoreEmpty = false;
            String string5 = this.nextLine(bufferedReader);
            if (string5 != null && string5.indexOf(44) < 0) {
                string5 = this.nextLine(bufferedReader);
            }
            if (string5 == null || (string4.endsWith(".CSV") || string4.endsWith(".TXT")) && string5.indexOf(44) < 0) {
                bufferedReader.close();
                throw new MWException(ai.a("E_CSV_NOT_CSV_FILE", new Object[0]));
            }
            if (string4.endsWith(".PRN") && string5.indexOf(44) < 0) {
                this.separator = (char)32;
                this.ignoreEmpty = true;
            }
            if ((string3 = string4).indexOf(46) > 0) {
                string3 = string3.substring(0, string3.lastIndexOf(46));
            }
            this.validNameFormat = true;
            String string6 = "";
            if (string3.length() >= 11) {
                string6 = string4.substring(0, 11);
            }
            if (string6.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d-") && string4.length() > 11) {
                object = string3.substring(11);
                List list = h.a((String)object, '-');
                this.exchange = (String)list.get(0);
                this.multiSymbol = true;
                this.barSize = 1440;
            } else if (!h.g(string3)) {
                object = h.a(string3, ' ');
                this.symbol = (String)object.get(0);
                if (object.size() > 2) {
                    int n4 = 1;
                    string2 = (String)object.get(n4);
                    if (h.a((Object)string2, (Object)"-") || h.a((Object)string2, (Object)"")) {
                        string2 = (String)object.get(++n4);
                    }
                    if (h.b(string2) && object.size() > ++n4) {
                        n3 = h.b(string2);
                        if (h.a(object.get(n4), (Object)"MIN")) {
                            this.barSize = n3;
                        } else if (h.a(object.get(n4), (Object)"HOUR")) {
                            this.barSize = n3 * 60;
                        } else if (h.a(object.get(n4), (Object)"DAY")) {
                            this.barSize = n3 * 1440;
                        } else if (h.a(object.get(n4), (Object)"DAYS")) {
                            this.barSize = n3 * 1440;
                        } else if (h.a(object.get(n4), (Object)"WEEK")) {
                            this.barSize = n3 * 7 * 1440;
                        } else if (h.a(object.get(n4), (Object)"MONTH")) {
                            this.barSize = n3 * 30 * 1440;
                        }
                    }
                    if (object.size() > n4 + 1) {
                        if ((h.a((Object)(string2 = (String)object.get(++n4)), (Object)"-") || h.a((Object)string2, (Object)"")) && object.size() > n4) {
                            string2 = (String)object.get(++n4);
                        }
                        if (h.b((Object)string2, (Object)"RTH")) {
                            this.rth = true;
                        } else if (h.b((Object)string2, (Object)"ETH")) {
                            this.rth = false;
                        }
                    }
                }
            }
            object = this.tokenize(string5);
            if (object.size() <= 3 && (string5.toUpperCase().indexOf("DTYYYYMMDD") >= 0 || string5.toUpperCase().indexOf("DATE") >= 0)) {
                for (n2 = 0; n2 < object.size(); ++n2) {
                    string2 = (String)object.get(n2);
                    string2 = string2.toUpperCase();
                    if ((string2 = string2.trim()).indexOf("DTYYYYMMDD") >= 0) {
                        this.dateTimeFormat = new SimpleDateFormat("yyyyMMdd");
                        this.dateIndex = n2;
                        continue;
                    }
                    if (string2.indexOf("DATE") >= 0) {
                        this.dateIndex = n2;
                        continue;
                    }
                    if (string2.indexOf("<TIME>") >= 0 || string2.indexOf("\"TIME\"") >= 0) {
                        this.timeIndex = n2;
                        continue;
                    }
                    if (this.closeIndex < 0 && (string2.indexOf("CLOSE") >= 0 || string2.indexOf("VALUE") >= 0 || string2.indexOf("SETTLE") >= 0 || string2.indexOf("RATE") >= 0)) {
                        this.closeIndex = n2;
                        continue;
                    }
                    if (this.volumeIndex < 0 && string2.indexOf("VOLUME") >= 0) {
                        this.volumeIndex = n2;
                        continue;
                    }
                    if (this.volumeIndex >= 0 || string2.indexOf("VOL") < 0) continue;
                    this.volumeIndex = n2;
                }
                if (this.closeIndex < 0 || this.dateIndex < 0) {
                    h.a.warning("ImportFormat::detectFormat() unrecognized header: " + string5);
                    bufferedReader.close();
                    throw new MWException(com.motivewave.platform.common.h.E_IMPORT_UNRECOGNIZED_FORMAT);
                }
                this.lowIndex = this.highIndex = this.closeIndex;
                this.openIndex = this.highIndex;
            } else if (string5.toUpperCase().indexOf("DTYYYYMMDD") < 0 && string5.toUpperCase().indexOf("DATE") < 0) {
                int n5;
                int n6;
                string5 = this.nextLine(bufferedReader);
                object = this.tokenize(string5);
                this.dateIndex = -1;
                for (n2 = 0; n2 < object.size(); ++n2) {
                    if (h.a((String)object.get(n2)) == null) continue;
                    this.dateIndex = n2;
                    break;
                }
                this.timeIndex = -1;
                for (n2 = 0; n2 < object.size(); ++n2) {
                    if (n2 == this.dateIndex || (string2 = (String)object.get(n2)).length() < 4 || string2.length() > 8 || string2.indexOf(58) <= 0) continue;
                    this.timeIndex = n2;
                    break;
                }
                this.symbolIndex = -1;
                for (n2 = 0; n2 < object.size(); ++n2) {
                    if (n2 == this.dateIndex || n2 == this.timeIndex || (string2 = (String)object.get(n2)).length() <= 2 || !h.d(string2)) continue;
                    this.symbolIndex = n2;
                    break;
                }
                this.volumeIndex = -1;
                n2 = 0;
                for (n6 = 0; n6 < object.size(); ++n6) {
                    if (n6 == this.dateIndex || n6 == this.symbolIndex || n6 == this.timeIndex || !h.b((String)object.get(n6)) || (n3 = h.b((String)object.get(n6))) < n2) continue;
                    n2 = n3;
                    this.volumeIndex = n6;
                }
                this.openInterestIndex = -1;
                if (object.size() > 6) {
                    n6 = Integer.MAX_VALUE;
                    for (n3 = 0; n3 < object.size(); ++n3) {
                        int n7;
                        if (n3 == this.dateIndex || n3 == this.symbolIndex || n3 == this.volumeIndex || n3 == this.timeIndex || !h.b((String)object.get(n3)) || (n7 = h.b((String)object.get(n3))) >= n6) continue;
                        n6 = n7;
                        this.openInterestIndex = n3;
                    }
                }
                this.closeIndex = -1;
                this.lowIndex = -1;
                this.highIndex = -1;
                this.openIndex = -1;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                for (n5 = 0; n5 < object.size(); ++n5) {
                    if (n5 == this.dateIndex || n5 == this.symbolIndex || n5 == this.volumeIndex || n5 == this.openInterestIndex || n5 == this.timeIndex) continue;
                    String string7 = (String)object.get(n5);
                    if (object.size() > 7 && string7.indexOf(46) < 0 || !h.e(string7)) continue;
                    double d6 = h.a(string7);
                    if (d2 == 0.0 && object.size() > 4) {
                        d2 = d6;
                        this.openIndex = n5;
                        continue;
                    }
                    if (d4 == 0.0) {
                        d4 = d6;
                        this.highIndex = n5;
                        continue;
                    }
                    if (d5 == 0.0) {
                        d5 = d6;
                        this.lowIndex = n5;
                        continue;
                    }
                    if (d3 != 0.0) continue;
                    d3 = d6;
                    this.closeIndex = n5;
                }
                if (d5 > d2 && this.openIndex >= 0) {
                    n5 = this.lowIndex;
                    double d7 = d5;
                    this.lowIndex = this.openIndex;
                    d5 = d2;
                    this.openIndex = n5;
                    d2 = d7;
                }
                if (d5 > d3) {
                    n5 = this.lowIndex;
                    double d8 = d5;
                    this.lowIndex = this.closeIndex;
                    d5 = d3;
                    this.closeIndex = n5;
                    d3 = d8;
                }
                if (d5 > d4) {
                    n5 = this.lowIndex;
                    double d9 = d5;
                    this.lowIndex = this.highIndex;
                    d5 = d4;
                    this.highIndex = n5;
                    d4 = d9;
                }
                if (d4 < d2 && this.openIndex >= 0) {
                    n5 = this.highIndex;
                    double d10 = d4;
                    this.highIndex = this.openIndex;
                    d4 = d2;
                    this.openIndex = n5;
                    d2 = d10;
                }
                if (d4 < d3) {
                    n5 = this.highIndex;
                    double d11 = d4;
                    this.highIndex = this.closeIndex;
                    d4 = d3;
                    this.closeIndex = n5;
                    d3 = d11;
                }
                if (this.dateIndex < 0 || this.highIndex < 0 || this.lowIndex < 0 && this.closeIndex < 0) {
                    bufferedReader.close();
                    throw new MWException(com.motivewave.platform.common.h.E_IMPORT_UNRECOGNIZED_FORMAT);
                }
            } else {
                n2 = 0;
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    String string8 = (String)object.get(i2);
                    string8 = string8.toUpperCase();
                    if ((string8 = string8.trim()).indexOf("TICKER") >= 0 || string8.indexOf("SYMBOL") >= 0) {
                        this.symbolIndex = i2;
                        this.multiSymbol = true;
                        continue;
                    }
                    if (string8.indexOf("NAME") >= 0) {
                        this.nameIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("OPENINT") >= 0 || string8.indexOf("OPEN INT") >= 0 || string8.indexOf("INTEREST") >= 0) {
                        this.openInterestIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("O/I") >= 0 || h.a((Object)string8, (Object)"OI")) {
                        this.openInterestIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("DTYYYYMMDD") >= 0) {
                        this.dateTimeFormat = new SimpleDateFormat("yyyyMMdd");
                        this.dateIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("DATE") >= 0) {
                        this.dateIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("<TIME>") >= 0 || string8.indexOf("\"TIME\"") >= 0 || h.a((Object)string8, (Object)"TIME")) {
                        this.timeIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("OPENBID") >= 0 || string8.indexOf("OPEN BID") >= 0) {
                        this.openBidIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("OPENASK") >= 0 || string8.indexOf("OPEN ASK") >= 0) {
                        this.openAskIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("HIGHBID") >= 0 || string8.indexOf("HIGH BID") >= 0) {
                        this.highBidIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("HIGHASK") >= 0 || string8.indexOf("HIGH ASK") >= 0) {
                        this.highAskIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("LOWBID") >= 0 || string8.indexOf("LOW BID") >= 0) {
                        this.lowBidIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("LOWASK") >= 0 || string8.indexOf("LOW ASK") >= 0) {
                        this.lowAskIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("CLOSEBID") >= 0 || string8.indexOf("CLOSE BID") >= 0) {
                        this.closeBidIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("CLOSEASK") >= 0 || string8.indexOf("CLOSE ASK") >= 0) {
                        this.closeAskIndex = i2;
                        continue;
                    }
                    if (n2 == 0 && string8.indexOf("CLOSE") >= 0) {
                        this.closeIndex = i2;
                        n2 = 1;
                        continue;
                    }
                    if (string8.indexOf("OPEN") >= 0) {
                        this.openIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("SETTLE") >= 0 && n2 == 0) {
                        this.closeIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("RATE") >= 0 && n2 == 0) {
                        this.closeIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("HIGH") >= 0) {
                        this.highIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("LOW") >= 0) {
                        this.lowIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("TOTAL TICKS") >= 0 && this.volumeIndex < 0) {
                        this.volumeIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("VOLUME") >= 0) {
                        this.volumeIndex = i2;
                        continue;
                    }
                    if (string8.indexOf("VOL") >= 0) {
                        this.volumeIndex = i2;
                        continue;
                    }
                    if (h.a((Object)string8, (Object)"UP")) {
                        this.upVolIndex = i2;
                        continue;
                    }
                    if (!h.a((Object)string8, (Object)"DOWN")) continue;
                    this.downVolIndex = i2;
                }
                if (this.closeIndex < 0 && this.closeBidIndex < 0) {
                    h.a.warning("ImportFormat::detectFormat() unrecognized header: " + string5);
                    bufferedReader.close();
                    throw new MWException(com.motivewave.platform.common.h.E_IMPORT_UNRECOGNIZED_FORMAT);
                }
            }
            string5 = this.nextLine(bufferedReader);
            if (string5 == null) {
                h.a.warning("ImportFormat::detectFormat() no data");
                bufferedReader.close();
                throw new MWException(com.motivewave.platform.common.h.E_IMPORT_UNRECOGNIZED_FORMAT);
            }
            object = this.tokenize(string5);
            if (this.symbolIndex >= 0) {
                this.symbol = this.getSymbol((List)object);
            }
            if (this.nameIndex >= 0) {
                this.name = this.getSymbol((List)object);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add((String)object.get(this.dateIndex));
            if (this.timeIndex >= 0) {
                arrayList2.add((String)object.get(this.timeIndex));
            }
            int n8 = (n3 = (int)(this.isPriceData() ? 1 : 0)) != 0 ? (this.openIndex >= 0 ? h.a(this.getOpen((List)object)) : h.a(this.getClose((List)object))) : (this.openBidIndex >= 0 ? h.a(this.getOpenBid((List)object)) : h.a(this.getCloseBid((List)object)));
            int n9 = h.a(n3 != 0 ? this.getClose((List)object) : this.getCloseBid((List)object));
            if (n9 > n8) {
                n8 = n9;
            }
            if ((n9 = h.a(n3 != 0 ? this.getHigh((List)object) : this.getHighBid((List)object))) > n8) {
                n8 = n9;
            }
            if ((n9 = h.a(n3 != 0 ? this.getLow((List)object) : this.getLowBid((List)object))) > n8) {
                n8 = n9;
            }
            String string9 = "";
            boolean bl2 = false;
            int n10 = 0;
            this.dateLetters = true;
            while (n10 < 30 && (string5 = this.nextLine(bufferedReader)) != null) {
                float f2;
                object = this.tokenize(string5);
                arrayList.add(this.getTimeStr((List)object));
                if (this.timeIndex >= 0) {
                    arrayList2.add((String)object.get(this.timeIndex));
                }
                float f3 = n3 != 0 ? this.getClose((List)object) : this.getCloseBid((List)object);
                float f4 = n3 != 0 ? this.getHigh((List)object) : this.getHighBid((List)object);
                float f5 = f2 = n3 != 0 ? this.getLow((List)object) : this.getLowBid((List)object);
                if (f3 == 0.0f && f4 == 0.0f && f2 == 0.0f) continue;
                ++n10;
                n9 = h.a(f3);
                if (n9 > n8) {
                    n8 = n9;
                }
                if ((n9 = h.a(f4)) > n8) {
                    n8 = n9;
                }
                if ((n9 = h.a(f2)) > n8) {
                    n8 = n9;
                }
                if (this.symbolIndex < 0) continue;
                String string10 = this.getSymbol((List)object);
                if (!(h.g(string10) || h.g(string9) || h.b((Object)string9, (Object)string10))) {
                    bl2 = true;
                }
                string9 = string10;
            }
            bufferedReader.close();
            if (!this.multiSymbol) {
                this.multiSymbol = bl2;
            }
            this.minTick = n8 <= 0 ? 1.0 : Math.pow(10.0, -n8);
            this.dateTimeFormat = h.a(arrayList);
            if (this.dateTimeFormat == null) {
                h.a.warning("ImportFormat::detectFormat() Invalid date format: " + (String)object.get(this.dateIndex));
                throw new MWException(com.motivewave.platform.common.h.E_IMPORT_UNRECOGNIZED_DATE_FORMAT, object.get(this.dateIndex));
            }
            this.dateLetters = this.dateTimeFormat.toPattern().indexOf("MMM") >= 0;
            if (this.timeZone != null) {
                this.dateTimeFormat.setTimeZone(this.timeZone);
            }
            if (this.barSize <= 0) {
                long l2 = 31557600000L;
                if (!h.a(arrayList2)) {
                    long l3 = 0L;
                    for (String string11 : arrayList2) {
                        long l4 = this.readTime(string11);
                        if (l3 == 0L) {
                            l3 = l4;
                            continue;
                        }
                        long l5 = l4 - l3;
                        if (l5 < l2 && l5 > 0L) {
                            l2 = l5;
                        }
                        l3 = l4;
                    }
                } else {
                    long l6 = 0L;
                    for (String string12 : arrayList) {
                        long l7 = 0L;
                        try {
                            l7 = this.dateTimeFormat.parse(h.n(string12)).getTime();
                        }
                        catch (Exception exception) {
                            h.a.warning("ImportFormat::detectFormat() invalid date: " + string12);
                            continue;
                        }
                        if (l6 == 0L) {
                            l6 = l7;
                            continue;
                        }
                        long l8 = l7 - l6;
                        if (l8 < 0L) {
                            l8 = -l8;
                        }
                        if (l8 < l2 && l8 > 0L) {
                            l2 = l8;
                        }
                        l6 = l7;
                    }
                }
                if (l2 <= 0L) {
                    l2 = -l2;
                }
                this.barSize = (int)(l2 / 60000L);
                if (this.barSize >= 1000) {
                    this.barSize = 1440;
                } else if (this.barSize >= 30) {
                    this.barSize = 30;
                } else if (this.barSize >= 5) {
                    this.barSize = 5;
                } else if (this.barSize >= 1) {
                    this.barSize = 1;
                }
                if (this.barSize == 0) {
                    h.a.warning("ImportFormat::detectFormat() unable to detect bar size, assuming daily bars: " + string);
                    this.barSize = 1440;
                }
            }
            if (this.barSize > 0 && !h.a((Object)this.barSize, new Object[]{1, 5, 30, 1440})) {
                throw new MWException(com.motivewave.platform.common.h.E_IMPORT_INVALID_BAR_SIZE);
            }
            if (!h.g(this.symbol)) {
                this.instrument = MWInstrument.get(this.symbol);
            }
        }
        catch (MWException mWException) {
            throw mWException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MWException(com.motivewave.platform.common.h.E_IMPORT_DETECT_FORMAT, exception.getMessage());
        }
    }

    public boolean isPriceData() {
        return this.closeIndex >= 0;
    }

    public boolean isBidAskData() {
        return this.closeBidIndex >= 0 && this.closeAskIndex >= 0;
    }

    public float getOpen(List list) {
        return this.getFloat(list, this.openIndex);
    }

    public void setOpenIndex(int n2) {
        this.openIndex = n2;
    }

    public float getOpenBid(List list) {
        return this.getFloat(list, this.openBidIndex);
    }

    public void setOpenBidIndex(int n2) {
        this.openBidIndex = n2;
    }

    public float getOpenAsk(List list) {
        return this.getFloat(list, this.openAskIndex);
    }

    public void setOpenAskIndex(int n2) {
        this.openAskIndex = n2;
    }

    public float getHigh(List list) {
        return this.getFloat(list, this.highIndex);
    }

    public void setHighIndex(int n2) {
        this.highIndex = n2;
    }

    public float getHighBid(List list) {
        return this.getFloat(list, this.highBidIndex);
    }

    public void setHighBidIndex(int n2) {
        this.highBidIndex = n2;
    }

    public float getHighAsk(List list) {
        return this.getFloat(list, this.highAskIndex);
    }

    public void setHighAskIndex(int n2) {
        this.highAskIndex = n2;
    }

    public float getLow(List list) {
        return this.getFloat(list, this.lowIndex);
    }

    public void setLowIndex(int n2) {
        this.lowIndex = n2;
    }

    public float getLowBid(List list) {
        return this.getFloat(list, this.lowBidIndex);
    }

    public void setLowBidIndex(int n2) {
        this.lowBidIndex = n2;
    }

    public float getLowAsk(List list) {
        return this.getFloat(list, this.lowAskIndex);
    }

    public void setLowAskIndex(int n2) {
        this.lowAskIndex = n2;
    }

    public float getClose(List list) {
        return this.getFloat(list, this.closeIndex);
    }

    public void setCloseIndex(int n2) {
        this.closeIndex = n2;
    }

    public float getCloseBid(List list) {
        return this.getFloat(list, this.closeBidIndex);
    }

    public void setCloseBidIndex(int n2) {
        this.closeBidIndex = n2;
    }

    public float getCloseAsk(List list) {
        return this.getFloat(list, this.closeAskIndex);
    }

    public void setCloseAskIndex(int n2) {
        this.closeAskIndex = n2;
    }

    private float getFloat(List list, int n2) {
        if (n2 < 0 || n2 >= list.size()) {
            return 0.0f;
        }
        return h.b(ImportFormat.fixString((String)list.get(n2)));
    }

    public float getVolume(List list) {
        if (this.volumeIndex < 0 || this.volumeIndex >= list.size()) {
            if (this.upVolIndex >= 0 && this.downVolIndex >= 0) {
                float f2 = this.upVolIndex < list.size() ? h.b(ImportFormat.fixString((String)list.get(this.upVolIndex))) : 0.0f;
                float f3 = this.downVolIndex < list.size() ? h.b(ImportFormat.fixString((String)list.get(this.downVolIndex))) : 0.0f;
                return f2 + f3;
            }
            return 0.0f;
        }
        return h.b(ImportFormat.fixString((String)list.get(this.volumeIndex)));
    }

    public void setVolumeIndex(int n2) {
        this.volumeIndex = n2;
    }

    public long getOpenInterest(List list) {
        if (this.openInterestIndex < 0 || this.openInterestIndex >= list.size()) {
            return 0L;
        }
        return h.b(ImportFormat.fixString((String)list.get(this.openInterestIndex)));
    }

    public void setOpenInterestIndex(int n2) {
        this.openInterestIndex = n2;
    }

    public String getSymbol(List list) {
        if (this.symbolIndex < 0 || this.symbolIndex >= list.size()) {
            return null;
        }
        return (String)list.get(this.symbolIndex);
    }

    public String getName(List list) {
        if (this.nameIndex < 0 || this.nameIndex >= list.size()) {
            return null;
        }
        return (String)list.get(this.nameIndex);
    }

    public double getMinTick() {
        return this.minTick;
    }

    public List tokenize(String string) {
        if (this.separator == ',') {
            return h.a(string, false);
        }
        return h.a(string, this.separator, this.ignoreEmpty);
    }

    public long getTime(List list) {
        if (h.a((Collection)list)) {
            return -1L;
        }
        long l2 = -1L;
        String string = h.n(this.getTimeStr(list));
        try {
            l2 = this.dateTimeFormat.parse(string).getTime();
            if (this.timeIndex >= 0) {
                l2 += this.readTime((String)list.get(this.timeIndex));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            h.a.warning("ImportFormat:getTime() invalid time: " + string);
            return -1L;
        }
        return l2;
    }

    private long readTime(String string) {
        if (h.g(string)) {
            return 0L;
        }
        if (string.indexOf(58) >= 0) {
            string = h.a(string, ":", "");
        }
        if (string.indexOf(46) >= 0) {
            string = h.a(string, ".", "");
        }
        int n2 = 0;
        int n3 = 0;
        if (string.length() == 6) {
            n2 = h.b(string.substring(0, 2));
            n3 = h.b(string.substring(2, 4));
        } else if (string.length() == 5) {
            n2 = h.b(string.substring(0, 1));
            n3 = h.b(string.substring(1, 3));
        } else if (string.length() == 4) {
            n2 = h.b(string.substring(0, 2));
            n3 = h.b(string.substring(2, 4));
        }
        return (long)n2 * 3600000L + (long)n3 * 60000L;
    }

    public String getTimeStr(List list) {
        if (h.a((Collection)list)) {
            return "";
        }
        String string = (String)list.get(this.dateIndex);
        if (!this.dateLetters) {
            string = h.a(string, "l", "1");
            string = h.a(string, "O", "0");
        }
        return string;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String string) {
        this.exchange = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        this.instrument = mWInstrument;
    }

    public int getBarSize() {
        return this.barSize;
    }

    public void setBarSize(int n2) {
        this.barSize = n2;
    }

    public Boolean isRTH() {
        return this.rth;
    }

    public void setRTH(boolean bl2) {
        this.rth = bl2;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isValidNameFormat() {
        return this.validNameFormat;
    }

    public boolean isMultiSymbol() {
        return this.multiSymbol;
    }

    public char getSeparator() {
        return this.separator;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private static String fixString(String string) {
        string = h.a(string, "\"", "");
        string = h.a(string, "'", "");
        return string;
    }

    private String nextLine(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        while (h.g(string)) {
            string = bufferedReader.readLine();
            if (string != null) continue;
            return null;
        }
        return string;
    }
}

