/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.e;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$BackTestType;
import com.motivewave.platform.common.Enums$OptimizeMetric;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.PeriodData;
import com.motivewave.platform.databean.StrategyAnalysis;
import com.motivewave.platform.databean.StrategyMetric;
import com.motivewave.platform.databean.Trade;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.databean.p;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.order_mgmt.Execution;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.service.ae;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import k.g;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExecutionReport
extends b
implements o,
InstrumentListener {
    private StrategyAnalysis analysis;
    private Map parameterMap = new LinkedHashMap();
    private boolean calculated = false;
    private MWInstrument instrument;
    private String parameters;
    private double profit;
    private double profitLong;
    private double profitShort;
    private double grossProfit;
    private double grossProfitLong;
    private double grossProfitShort;
    private double grossLoss;
    private double grossLossLong;
    private double grossLossShort;
    private double commissions;
    private double commissionsLong;
    private double commissionsShort;
    private double maxDrawdown;
    private double maxDrawdownLong;
    private double maxDrawdownShort;
    private double maxDrawdownPercent;
    private double maxDrawdownPercentLong;
    private double maxDrawdownPercentShort;
    private int totalTrades;
    private int totalTradesLong;
    private int totalTradesShort;
    private int totalQuantity;
    private int totalQuantityLong;
    private int totalQuantityShort;
    private int winningTrades;
    private int winningTradesLong;
    private int winningTradesShort;
    private int losingTrades;
    private int losingTradesLong;
    private int losingTradesShort;
    private int maxConsecutiveWins;
    private int maxConsecutiveWinsLong;
    private int maxConsecutiveWinsShort;
    private int maxConsecutiveLosses;
    private int maxConsecutiveLossesLong;
    private int maxConsecutiveLossesShort;
    private double largestWinningTrade;
    private double largestWinningTradeLong;
    private double largestWinningTradeShort;
    private double largestLosingTrade;
    private double largestLosingTradeLong;
    private double largestLosingTradeShort;
    private double avgBarsInTrade;
    private double avgBarsInTradeLong;
    private double avgBarsInTradeShort;
    private double avgTrade;
    private double avgTradeLong;
    private double avgTradeShort;
    private double avgWinningTrade;
    private double avgWinningTradeLong;
    private double avgWinningTradeShort;
    private double avgLosingTrade;
    private double avgLosingTradeLong;
    private double avgLosingTradeShort;
    private double winningVsLosingTrade;
    private double winningVsLosingTradeLong;
    private double winningVsLosingTradeShort;
    private double avgMAE;
    private double avgMAELong;
    private double avgMAEShort;
    private double avgMAEPercent;
    private double avgMAEPercentLong;
    private double avgMAEPercentShort;
    private double avgMAEPoints;
    private double avgMAEPointsLong;
    private double avgMAEPointsShort;
    private double avgMFE;
    private double avgMFELong;
    private double avgMFEShort;
    private double avgMFEPercent;
    private double avgMFEPercentLong;
    private double avgMFEPercentShort;
    private double avgMFEPoints;
    private double avgMFEPointsLong;
    private double avgMFEPointsShort;
    private double profitPerDay;
    private double profitPerDayLong;
    private double profitPerDayShort;
    private long avgTimeInTrade;
    private long avgTimeInTradeLong;
    private long avgTimeInTradeShort;
    private int tradingDays;
    private long startTime;
    private long endTime;
    private long optimizeStartTime;
    private long optimizeEndTime;
    private double initialAccountValue;
    private List executions;
    private List trades;
    private List metrics;
    private Map dailyData = new LinkedHashMap();
    private Map weeklyData = new LinkedHashMap();
    private Map monthlyData = new LinkedHashMap();
    private Map dayOfWeekData = new LinkedHashMap();
    private Map hourOfDayData = new LinkedHashMap();
    private Map halfHourOfDayData = new LinkedHashMap();
    private Enums$BackTestType type = Enums$BackTestType.BACKTEST;

    public ExecutionReport(StrategyAnalysis strategyAnalysis) {
        this.analysis = strategyAnalysis;
    }

    ExecutionReport(StrategyAnalysis strategyAnalysis, JSONObject jSONObject) {
        this(strategyAnalysis);
        this.fromJSON(jSONObject);
    }

    public ExecutionReport(StrategyAnalysis strategyAnalysis, Enums$BackTestType enums$BackTestType, MWInstrument mWInstrument, double d2, long l2, long l3, Study study, List list) {
        this(strategyAnalysis);
        this.type = enums$BackTestType;
        this.setInstrument(mWInstrument);
        this.executions = list;
        this.startTime = l2;
        this.endTime = l3;
        this.initialAccountValue = d2;
        Object object = "";
        Object object2 = "";
        boolean bl2 = true;
        this.parameterMap.clear();
        for (SettingDescriptor settingDescriptor : study.getSettingsDescriptor().getStrategySettings()) {
            if (bl2) {
                bl2 = false;
            } else {
                object = (String)object + ",";
                object2 = (String)object2 + ",";
            }
            Object object3 = study.getSettings().getSetting(settingDescriptor.getName());
            object = object3 instanceof Double ? (String)object + h.c((Double)object3, 9) : (object3 instanceof Enums.BarInput ? (String)object + ((Enums.BarInput)object3).getShortLabel() : (String)object + object3);
            object2 = (String)object2 + settingDescriptor.getLabel();
            this.parameterMap.put(settingDescriptor.getName(), object3);
        }
        this.parameters = (String)object + " (" + (String)object2 + ")";
        this.load();
    }

    private void setInstrument(MWInstrument mWInstrument) {
        this.instrument = mWInstrument;
    }

    @Override
    public ExecutionReport clone() {
        try {
            ExecutionReport executionReport = (ExecutionReport)super.clone();
            executionReport.trades = new ArrayList(this.trades);
            executionReport.metrics = new ArrayList(this.metrics);
            executionReport.executions = new ArrayList(this.executions);
            executionReport.parameterMap = new LinkedHashMap(this.parameterMap);
            executionReport.dailyData = new LinkedHashMap(this.dailyData);
            executionReport.weeklyData = new LinkedHashMap(this.weeklyData);
            executionReport.monthlyData = new LinkedHashMap(this.monthlyData);
            executionReport.dayOfWeekData = new LinkedHashMap(this.dayOfWeekData);
            executionReport.hourOfDayData = new LinkedHashMap(this.hourOfDayData);
            executionReport.halfHourOfDayData = new LinkedHashMap(this.halfHourOfDayData);
            return executionReport;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StrategyAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(StrategyAnalysis strategyAnalysis) {
        this.analysis = strategyAnalysis;
    }

    public void setType(Enums$BackTestType enums$BackTestType) {
        this.type = enums$BackTestType;
    }

    public Enums$BackTestType getType() {
        return this.type;
    }

    public long getOptimizeStartTime() {
        return this.optimizeStartTime;
    }

    public void setOptimizeStartTime(long l2) {
        this.optimizeStartTime = l2;
    }

    public long getOptimizeEndTime() {
        return this.optimizeEndTime;
    }

    public void setOptimizeEndTime(long l2) {
        this.optimizeEndTime = l2;
    }

    public double getMetric(Enums$OptimizeMetric enums$OptimizeMetric) {
        if (enums$OptimizeMetric == null) {
            return this.getNetProfit();
        }
        switch (enums$OptimizeMetric) {
            case NET_PROFIT: {
                return this.getNetProfit();
            }
            case NET_PROFIT_LONG: {
                return this.profitLong;
            }
            case NET_PROFIT_SHORT: {
                return this.profitShort;
            }
            case DRAWDOWN: {
                return this.maxDrawdown;
            }
            case DRAWDOWN_LONG: {
                return this.maxDrawdownLong;
            }
            case DRAWDOWN_SHORT: {
                return this.maxDrawdownShort;
            }
            case PERCENT_PROFITABLE: {
                return this.winningTrades / this.totalTrades;
            }
            case PERCENT_PROFITABLE_LONG: {
                return this.winningTradesLong / this.totalTradesLong;
            }
            case PERCENT_PROFITABLE_SHORT: {
                return this.winningTradesShort / this.totalTradesShort;
            }
            case PROFIT_FACTOR: {
                return Math.abs(this.grossProfit / this.grossLoss);
            }
            case PROFIT_FACTOR_LONG: {
                return Math.abs(this.grossProfitLong / this.grossLossLong);
            }
            case PROFIT_FACTOR_SHORT: {
                return Math.abs(this.grossProfitShort / this.grossLossShort);
            }
            case WIN_LOSS_RATIO: {
                return this.winningVsLosingTrade;
            }
            case WIN_LOSS_RATIO_LONG: {
                return this.winningVsLosingTradeLong;
            }
            case WIN_LOSS_RATIO_SHORT: {
                return this.winningVsLosingTradeShort;
            }
        }
        return this.getNetProfit();
    }

    public void calculate() {
        PeriodData periodData;
        PeriodData periodData2;
        Object object;
        Object object22;
        int n2;
        if (this.calculated) {
            return;
        }
        long l2 = this.endTime;
        for (Execution execution : this.executions) {
            if (execution.getTime() <= l2) continue;
            l2 = execution.getTime();
        }
        long l3 = h.j(this.startTime);
        while (l3 <= l2) {
            this.dailyData.put(l3, new PeriodData(l3));
            l3 = h.K(l3);
        }
        long l4 = h.A(this.startTime);
        while (l4 <= l2) {
            this.weeklyData.put(l4, new PeriodData(l4));
            l4 = h.B(l4);
        }
        long l5 = h.C(this.startTime);
        while (l5 <= l2) {
            this.monthlyData.put(l5, new PeriodData(l5));
            l5 = h.E(l5);
        }
        this.dayOfWeekData.put(Enums$DayOfWeek.SUN, new PeriodData(Enums$DayOfWeek.SUN));
        this.dayOfWeekData.put(Enums$DayOfWeek.MON, new PeriodData(Enums$DayOfWeek.MON));
        this.dayOfWeekData.put(Enums$DayOfWeek.TUES, new PeriodData(Enums$DayOfWeek.TUES));
        this.dayOfWeekData.put(Enums$DayOfWeek.WED, new PeriodData(Enums$DayOfWeek.WED));
        this.dayOfWeekData.put(Enums$DayOfWeek.THUR, new PeriodData(Enums$DayOfWeek.THUR));
        this.dayOfWeekData.put(Enums$DayOfWeek.FRI, new PeriodData(Enums$DayOfWeek.FRI));
        this.dayOfWeekData.put(Enums$DayOfWeek.SAT, new PeriodData(Enums$DayOfWeek.SAT));
        for (n2 = 0; n2 < 24; ++n2) {
            this.hourOfDayData.put(n2 * 60 * 60 * 1000, new PeriodData(n2 * 60 * 60 * 1000));
        }
        for (n2 = 0; n2 < 48; ++n2) {
            this.halfHourOfDayData.put(n2 * 30 * 60 * 1000, new PeriodData(n2 * 30 * 60 * 1000));
        }
        for (Object object22 : this.trades) {
            l3 = h.j(((Trade)object22).getExitTime());
            object = (PeriodData)this.dailyData.get(l3);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() strategy data not found: " + h.n(l3));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            l4 = h.A(((Trade)object22).getExitTime());
            object = (PeriodData)this.weeklyData.get(l4);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() weekly strategy data not found: " + h.g(l4));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            l5 = h.C(((Trade)object22).getExitTime());
            object = (PeriodData)this.monthlyData.get(l5);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() monthly strategy data not found: " + h.g(l5));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            object = h.a(((Trade)object22).getExitTime());
            periodData2 = (PeriodData)this.dayOfWeekData.get(object);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() day of week strategy data not found: " + (Enums$DayOfWeek)((Object)object));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            int n3 = h.d(((Trade)object22).getExitTime()) * 60 * 60 * 1000;
            periodData2 = (PeriodData)this.hourOfDayData.get(n3);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() hour strategy data not found: " + h.l(n3));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            int n4 = h.e(((Trade)object22).getExitTime()) * 30 * 60 * 1000;
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n4);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() half hour strategy data not found: " + h.l(n4));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        Object object3 = null;
        object22 = this.dailyData.keySet().iterator();
        while (object22.hasNext()) {
            long l6 = (Long)object22.next();
            periodData = (PeriodData)this.dailyData.get(l6);
            this.updateCumulativeData((PeriodData)object3, periodData);
            object3 = periodData;
        }
        object3 = null;
        object22 = this.weeklyData.keySet().iterator();
        while (object22.hasNext()) {
            long l7 = (Long)object22.next();
            periodData = (PeriodData)this.weeklyData.get(l7);
            this.updateCumulativeData((PeriodData)object3, periodData);
            object3 = periodData;
        }
        object3 = null;
        object22 = this.monthlyData.keySet().iterator();
        while (object22.hasNext()) {
            long l8 = (Long)object22.next();
            periodData = (PeriodData)this.monthlyData.get(l8);
            this.updateCumulativeData((PeriodData)object3, periodData);
            object3 = periodData;
        }
        object3 = null;
        for (Enums$DayOfWeek enums$DayOfWeek : this.dayOfWeekData.keySet()) {
            periodData2 = (PeriodData)this.dayOfWeekData.get((Object)enums$DayOfWeek);
            this.updateCumulativeData((PeriodData)object3, periodData2);
            object3 = periodData2;
        }
        object3 = null;
        object22 = this.hourOfDayData.keySet().iterator();
        while (object22.hasNext()) {
            int n5 = (Integer)object22.next();
            periodData2 = (PeriodData)this.hourOfDayData.get(n5);
            this.updateCumulativeData((PeriodData)object3, periodData2);
            object3 = periodData2;
        }
        object3 = null;
        object22 = this.halfHourOfDayData.keySet().iterator();
        while (object22.hasNext()) {
            int n6 = (Integer)object22.next();
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n6);
            this.updateCumulativeData((PeriodData)object3, periodData2);
            object3 = periodData2;
        }
        object22 = new ArrayList(this.dailyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l9 = (Long)object22.next();
            periodData = (PeriodData)this.dailyData.get(l9);
            if (periodData.getTotalTrades() != 0) continue;
            this.dailyData.remove(l9);
        }
        object22 = new ArrayList(this.weeklyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l10 = (Long)object22.next();
            periodData = (PeriodData)this.weeklyData.get(l10);
            if (periodData.getTotalTrades() != 0) continue;
            this.weeklyData.remove(l10);
        }
        object22 = new ArrayList(this.monthlyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l11 = (Long)object22.next();
            periodData = (PeriodData)this.monthlyData.get(l11);
            if (periodData.getTotalTrades() != 0) continue;
            this.monthlyData.remove(l11);
        }
        for (Enums$DayOfWeek enums$DayOfWeek : new ArrayList(this.dayOfWeekData.keySet())) {
            periodData2 = (PeriodData)this.dayOfWeekData.get((Object)enums$DayOfWeek);
            if (periodData2.getTotalTrades() != 0) continue;
            this.dayOfWeekData.remove((Object)enums$DayOfWeek);
        }
        object22 = new ArrayList(this.hourOfDayData.keySet()).iterator();
        while (object22.hasNext()) {
            int n7 = (Integer)object22.next();
            periodData2 = (PeriodData)this.hourOfDayData.get(n7);
            if (periodData2.getTotalTrades() != 0) continue;
            this.hourOfDayData.remove(n7);
        }
        object22 = new ArrayList(this.halfHourOfDayData.keySet()).iterator();
        while (object22.hasNext()) {
            int n8 = (Integer)object22.next();
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n8);
            if (periodData2.getTotalTrades() != 0) continue;
            this.halfHourOfDayData.remove(n8);
        }
        this.calculated = true;
    }

    private void updateCumulativeData(PeriodData periodData, PeriodData periodData2) {
        if (periodData != null) {
            periodData2.setCumulativeCommissions(periodData.getCumulativeCommissions() + periodData2.getCommissions());
            periodData2.setCumulativeCommissionsLong(periodData.getCumulativeCommissionsLong() + periodData2.getCommissionsLong());
            periodData2.setCumulativeCommissionsShort(periodData.getCumulativeCommissionsShort() + periodData2.getCommissionsShort());
            periodData2.setCumulativeNetProfit(periodData.getCumulativeNetProfit() + periodData2.getNetProfit());
            periodData2.setCumulativeNetProfitLong(periodData.getCumulativeNetProfitLong() + periodData2.getNetProfitLong());
            periodData2.setCumulativeNetProfitShort(periodData.getCumulativeNetProfitShort() + periodData2.getNetProfitShort());
            periodData2.setCumulativeGrossProfit(periodData.getCumulativeGrossProfit() + periodData2.getGrossProfit());
            periodData2.setCumulativeGrossProfitLong(periodData.getCumulativeGrossProfitLong() + periodData2.getGrossProfitLong());
            periodData2.setCumulativeGrossProfitShort(periodData.getCumulativeGrossProfitShort() + periodData2.getGrossProfitShort());
            periodData2.setCumulativeGrossLoss(periodData.getCumulativeGrossLoss() + periodData2.getGrossLoss());
            periodData2.setCumulativeGrossLossLong(periodData.getCumulativeGrossLossLong() + periodData2.getGrossLossLong());
            periodData2.setCumulativeGrossLossShort(periodData.getCumulativeGrossLossShort() + periodData2.getGrossLossShort());
        } else {
            periodData2.setCumulativeCommissions(periodData2.getCommissions());
            periodData2.setCumulativeCommissionsLong(periodData2.getCommissionsLong());
            periodData2.setCumulativeCommissionsShort(periodData2.getCommissionsShort());
            periodData2.setCumulativeNetProfit(periodData2.getNetProfit());
            periodData2.setCumulativeNetProfitLong(periodData2.getNetProfitLong());
            periodData2.setCumulativeNetProfitShort(periodData2.getNetProfitShort());
            periodData2.setCumulativeGrossProfit(periodData2.getGrossProfit());
            periodData2.setCumulativeGrossProfitLong(periodData2.getGrossProfitLong());
            periodData2.setCumulativeGrossProfitShort(periodData2.getGrossProfitShort());
            periodData2.setCumulativeGrossLoss(periodData2.getGrossLoss());
            periodData2.setCumulativeGrossLossLong(periodData2.getGrossLossLong());
            periodData2.setCumulativeGrossLossShort(periodData2.getGrossLossShort());
        }
    }

    private void updateData(PeriodData periodData, Trade trade) {
        periodData.setCommissions(periodData.getCommissions() + trade.getCommission());
        periodData.setNetProfit(periodData.getNetProfit() + trade.getPnl());
        periodData.setTotalTrades(periodData.getTotalTrades() + 1);
        if (trade.getPnl() > 0.0) {
            periodData.setGrossProfit(periodData.getGrossProfit() + trade.getPnl());
            periodData.setTotalWinningTrades(periodData.getTotalWinningTrades() + 1);
            if (trade.getPnl() > periodData.getLargestWinningTrade()) {
                periodData.setLargestWinningTrade(trade.getPnl());
            }
        } else {
            periodData.setGrossLoss(periodData.getGrossLoss() + trade.getPnl());
            periodData.setTotalLosingTrades(periodData.getTotalLosingTrades() + 1);
            if (trade.getPnl() < periodData.getLargestLosingTrade()) {
                periodData.setLargestLosingTrade(trade.getPnl());
            }
        }
        periodData.setMAE(periodData.getMAE() + trade.getMAEPnl());
        periodData.setMFE(periodData.getMFE() + trade.getMFEPnl());
        if (trade.isLong()) {
            periodData.setTotalTradesLong(periodData.getTotalTradesLong() + 1);
            periodData.setCommissionsLong(periodData.getCommissionsLong() + trade.getCommission());
            periodData.setNetProfitLong(periodData.getNetProfitLong() + trade.getPnl());
            periodData.setMAELong(periodData.getMAELong() + trade.getMAEPnl());
            periodData.setMFELong(periodData.getMFELong() + trade.getMFEPnl());
            if (trade.getPnl() > 0.0) {
                periodData.setGrossProfitLong(periodData.getGrossProfitLong() + trade.getPnl());
                periodData.setTotalWinningTradesLong(periodData.getTotalWinningTradesLong() + 1);
                if (trade.getPnl() > periodData.getLargestWinningTradeLong()) {
                    periodData.setLargestWinningTradeLong(trade.getPnl());
                }
            } else if (trade.getPnl() < 0.0) {
                periodData.setGrossLossLong(periodData.getGrossLossLong() + trade.getPnl());
                if (trade.getPnl() < periodData.getLargestLosingTradeLong()) {
                    periodData.setLargestLosingTradeLong(trade.getPnl());
                }
                periodData.setTotalLosingTradesLong(periodData.getTotalLosingTradesLong() + 1);
            }
        } else {
            periodData.setTotalTradesShort(periodData.getTotalTradesShort() + 1);
            periodData.setCommissionsShort(periodData.getCommissionsShort() + trade.getCommission());
            periodData.setNetProfitShort(periodData.getNetProfitShort() + trade.getPnl());
            periodData.setMAEShort(periodData.getMAEShort() + trade.getMAEPnl());
            periodData.setMFEShort(periodData.getMFEShort() + trade.getMFEPnl());
            if (trade.getPnl() > 0.0) {
                periodData.setGrossProfitShort(periodData.getGrossProfitShort() + trade.getPnl());
                periodData.setTotalWinningTradesShort(periodData.getTotalWinningTradesShort() + 1);
                if (trade.getPnl() > periodData.getLargestWinningTradeShort()) {
                    periodData.setLargestWinningTradeShort(trade.getPnl());
                }
            } else if (trade.getPnl() < 0.0) {
                periodData.setGrossLossShort(periodData.getGrossLossShort() + trade.getPnl());
                if (trade.getPnl() < periodData.getLargestLosingTradeShort()) {
                    periodData.setLargestLosingTradeShort(trade.getPnl());
                }
                periodData.setTotalLosingTradesShort(periodData.getTotalLosingTradesShort() + 1);
            }
        }
    }

    @Override
    public String format(String string) {
        if ((string = string.intern()) == "netProfit" || string == "grossProfit" || string == "grossLoss" || string == "commissions" || string == "maxDrawdown") {
            double d2 = (Double)this.getProperty(string);
            return h.a(d2, ae.b());
        }
        if (string == "startTime") {
            return h.d(this.startTime);
        }
        if (string == "endTime") {
            return h.d(this.endTime);
        }
        return super.format(string);
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getSymbol() {
        return this.instrument.getSymbol();
    }

    public String getExchange() {
        return this.instrument.getExchange();
    }

    public String getParameters() {
        return this.parameters;
    }

    public double getNetProfit() {
        return this.profit;
    }

    public double getGrossProfit() {
        return this.grossProfit;
    }

    public double getGrossLoss() {
        return this.grossLoss;
    }

    public double getCommissions() {
        return this.commissions;
    }

    public double getMaxDrawdown() {
        return this.maxDrawdown;
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    public List getExecutions() {
        return this.executions;
    }

    public List getTrades() {
        return this.trades;
    }

    public int getTotalTrades() {
        return this.totalTrades;
    }

    public int getTotalTradesLong() {
        return this.totalTradesLong;
    }

    public int getTotalTradesShort() {
        return this.totalTradesShort;
    }

    public List getMetrics() {
        return this.metrics;
    }

    public Map getDailyData() {
        return this.dailyData;
    }

    public Map getWeeklyData() {
        return this.weeklyData;
    }

    public Map getMonthlyData() {
        return this.monthlyData;
    }

    public Map getDayOfWeekData() {
        return this.dayOfWeekData;
    }

    public Map getHourOfDayData() {
        return this.hourOfDayData;
    }

    public Map getHalfHourOfDayData() {
        return this.halfHourOfDayData;
    }

    public void readXML(Element element) {
        Object object;
        Object object2;
        String string;
        String string2 = element.getAttribute("type");
        if (!h.g(string2)) {
            this.type = Enums$BackTestType.valueOf(string2);
        }
        String string3 = element.getAttribute("symbol");
        String string4 = element.getAttribute("exchange");
        this.setInstrument(MWInstrument.get(string3, string4));
        this.parameters = element.getAttribute("params");
        this.startTime = h.b(element.getAttribute("start"));
        this.endTime = h.b(element.getAttribute("end"));
        this.initialAccountValue = h.a(element.getAttribute("acctValue"));
        Node node = g.b("parameters", element);
        this.parameterMap.clear();
        if (node != null) {
            for (Object object3 : g.a(node)) {
                string = object3.getTagName();
                if (h.a((Object)string, (Object)"double")) {
                    this.parameterMap.put(object3.getAttribute("name"), h.a(object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"float")) {
                    this.parameterMap.put(object3.getAttribute("name"), Float.valueOf(h.b(object3.getAttribute("value"))));
                    continue;
                }
                if (h.a((Object)string, (Object)"integer")) {
                    this.parameterMap.put(object3.getAttribute("name"), h.b(object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"long")) {
                    this.parameterMap.put(object3.getAttribute("name"), h.b(object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"boolean")) {
                    this.parameterMap.put(object3.getAttribute("name"), h.a((Object)object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"input")) {
                    this.parameterMap.put(object3.getAttribute("name"), Enums.BarInput.valueOf((String)object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"method")) {
                    this.parameterMap.put(object3.getAttribute("name"), Enums.MAMethod.valueOf((String)object3.getAttribute("value")));
                    continue;
                }
                if (h.a((Object)string, (Object)"string")) {
                    this.parameterMap.put(object3.getAttribute("name"), object3.getAttribute("value"));
                    continue;
                }
                if (h.a((Object)string, (Object)"barSize")) {
                    this.parameterMap.put(object3.getAttribute("name"), s.a((Element)object3));
                    continue;
                }
                if (h.a((Object)string, (Object)"guide")) {
                    object2 = s.a((Element)object3);
                    this.parameterMap.put(((e)object2).a(), ((e)object2).a());
                    continue;
                }
                if (!h.a((Object)string, (Object)"instrument")) continue;
                object2 = MWInstrument.get(object3.getAttribute("symbol"), object3.getAttribute("exchange"));
                object = object2 == null ? null : LiveTicker.get((MWInstrument)object2);
                this.parameterMap.put(object3.getAttribute("name"), object);
            }
        }
        this.executions = new ArrayList();
        this.executions.clear();
        Node node2 = g.b("executions", element);
        if (node2 != null) {
            try {
                Object object3;
                object3 = new BufferedReader(new StringReader(g.b(node2)));
                string = ((BufferedReader)object3).readLine();
                if (h.g(string)) {
                    string = ((BufferedReader)object3).readLine();
                }
                while (!h.g(string)) {
                    object2 = h.a(string, ',');
                    object = (String)object2.get(0);
                    String string5 = (String)object2.get(1);
                    MWInstrument mWInstrument = MWInstrument.get((String)object2.get(2), (String)object2.get(3));
                    String string6 = (String)object2.get(4);
                    if (h.g(string6)) {
                        string6 = null;
                    }
                    long l2 = h.b((String)object2.get(5));
                    Enums.OrderAction orderAction = Enums.OrderAction.valueOf((String)((String)object2.get(6)));
                    int n2 = h.b((String)object2.get(7));
                    float f2 = h.b((String)object2.get(8));
                    float f3 = h.b((String)object2.get(9));
                    Enums.ExecutionType executionType = Enums.ExecutionType.valueOf((String)((String)object2.get(10)));
                    float f4 = h.b((String)object2.get(11));
                    float f5 = h.b((String)object2.get(12));
                    float f6 = h.b((String)object2.get(13));
                    int n3 = h.b((String)object2.get(14));
                    int n4 = h.b((String)object2.get(15));
                    float f7 = h.b((String)object2.get(16));
                    float f8 = h.b((String)object2.get(17));
                    this.executions.add(new Execution((String)object, string5, (Instrument)LiveTicker.get(mWInstrument), (Object)string6, l2, orderAction, (float)n2, f2, f3, executionType, f4, f5, f6, (float)n3, n4, f7, f8));
                    string = ((BufferedReader)object3).readLine();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.load();
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.a("type", (Object)this.type), this.b("symbol", this.getSymbol()), this.b("exchange", this.getExchange()), this.a_("start", this.startTime), this.a_("end", this.endTime), this.a_("optStart", this.optimizeStartTime), this.a_("optEnd", this.optimizeEndTime), this.a("acctValue", this.initialAccountValue), this.a_("params", this.parameters)});
        List list2 = h.b(new String[0]);
        for (Object object : this.parameterMap.keySet()) {
            Object object2 = this.parameterMap.get(object);
            List list3 = h.b(new String[]{this.b("name", (String)object)});
            String string = "";
            if (object2 == null) {
                h.a.warning("ExecutionReport::getNVPs() value is null: " + (String)object);
            } else if (object2 instanceof Double) {
                string = "double";
            } else if (object2 instanceof Float) {
                string = "float";
            } else if (object2 instanceof Integer) {
                string = "int";
            } else if (object2 instanceof Long) {
                string = "long";
            } else if (object2 instanceof Boolean) {
                string = "bool";
            } else if (object2 instanceof Enums.BarInput) {
                string = "barInput";
            } else if (object2 instanceof Enums.MAMethod) {
                string = "ma";
            } else if (object2 instanceof String) {
                string = "str";
            } else if (object2 instanceof BarSize) {
                string = "bs";
            } else if (object2 instanceof Instrument) {
                string = "instr";
            } else if (object2 instanceof GuideInfo) {
                string = "guide";
            } else {
                h.a.warning("ExecutionReport::getNVPs() unknown parameter type: " + (String)object + " val: " + object2 + " class: " + object2.getClass().getName());
            }
            list3.add(this.b("type", string));
            if (string.equals("bs")) {
                list3.add(this.a("value", (BarSize)object2));
            } else if (string.equals("instr")) {
                list3.add(this.a("value", (Instrument)object2));
            } else if (string.equals("guide")) {
                list3.add(this.a("value", (GuideInfo)object2));
            } else {
                list3.add(this.a("value", object2));
            }
            list2.add(this.a((Collection)list3));
        }
        list.add(this.a("parameters", (Collection)list2));
        List list4 = h.b(new String[0]);
        for (Object object2 : this.getExecutions()) {
            list4.add(object2.getAccountId() + "," + object2.getId() + "," + object2.getInstrument().getSymbol() + "," + h.b((Object)object2.getInstrument().getExchangeSymbol()) + "," + h.b(object2.getReferenceId()) + "," + object2.getTime() + "," + object2.getAction().name() + "," + object2.getQuantityAsFloat() + "," + object2.getAvgPrice() + "," + object2.getEntryPrice() + "," + object2.getType().name() + "," + h.c(object2.getPnl(), 3) + "," + h.c((double)object2.getPips(), 2) + "," + h.c(object2.getCommission(), 2) + "," + object2.getPositionAsFloat() + "," + object2.getBar() + "," + object2.getMaxPriceReached() + "," + object2.getMinPriceReached());
        }
        list.add(this.a("executions", (Collection)list4));
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        Object object;
        this.type = Enums$BackTestType.valueOf(jSONObject.str("type"));
        this.setInstrument(MWInstrument.get(jSONObject.str("symbol"), jSONObject.str("exchange")));
        this.parameters = jSONObject.str("params");
        this.startTime = jSONObject.getLong("start");
        this.endTime = jSONObject.getLong("end");
        this.initialAccountValue = jSONObject.getDouble("acctValue");
        this.parameterMap.clear();
        for (Object object2 : jSONObject.getObjList("parameters")) {
            object = null;
            switch (((JSONObject)object2).str("type")) {
                case "double": {
                    object = ((JSONObject)object2).getDouble("value");
                    break;
                }
                case "float": {
                    object = Float.valueOf(((JSONObject)object2).getFloat("value"));
                    break;
                }
                case "int": {
                    object = ((JSONObject)object2).getInt("value");
                    break;
                }
                case "long": {
                    object = ((JSONObject)object2).getLong("value");
                    break;
                }
                case "bool": {
                    object = ((JSONObject)object2).is("value");
                    break;
                }
                case "barInput": {
                    object = Enums.BarInput.valueOf((String)((JSONObject)object2).str("value"));
                    break;
                }
                case "ma": {
                    object = Enums.MAMethod.valueOf((String)((JSONObject)object2).str("value"));
                    break;
                }
                case "str": {
                    object = ((JSONObject)object2).str("value");
                    break;
                }
                case "bs": {
                    object = this.a((JSONObject)object2, "value");
                    break;
                }
                case "instr": {
                    object = this.a((JSONObject)object2, "value");
                }
                case "guide": {
                    object = this.a((JSONObject)object2, "value");
                }
            }
            this.parameterMap.put(((JSONObject)object2).str("name"), object);
        }
        this.executions = new ArrayList();
        for (Object object2 : jSONObject.getStringList("executions")) {
            object = h.a((String)object2, ',');
            String string = (String)object.get(0);
            String string2 = (String)object.get(1);
            MWInstrument mWInstrument = MWInstrument.get((String)object.get(2), (String)object.get(3));
            String string3 = (String)object.get(4);
            if (h.g(string3)) {
                string3 = null;
            }
            long l2 = h.b((String)object.get(5));
            Enums.OrderAction orderAction = Enums.OrderAction.valueOf((String)((String)object.get(6)));
            float f2 = h.b((String)object.get(7));
            float f3 = h.b((String)object.get(8));
            float f4 = h.b((String)object.get(9));
            Enums.ExecutionType executionType = Enums.ExecutionType.valueOf((String)((String)object.get(10)));
            float f5 = h.b((String)object.get(11));
            float f6 = h.b((String)object.get(12));
            float f7 = h.b((String)object.get(13));
            float f8 = h.b((String)object.get(14));
            int n2 = h.b((String)object.get(15));
            float f9 = h.b((String)object.get(16));
            float f10 = h.b((String)object.get(17));
            this.executions.add(new Execution(string, string2, (Instrument)LiveTicker.get(mWInstrument), (Object)string3, l2, orderAction, f2, f3, f4, executionType, f5, f6, f7, f8, n2, f9, f10));
        }
        this.load();
    }

    private void load() {
        int n2;
        long l2;
        this.trades = new ArrayList();
        int n22 = 1;
        ArrayList<p> arrayList = new ArrayList<p>();
        double d2 = 0.0;
        double d3 = 0.0;
        float f2 = 0.0f;
        if (this.executions == null) {
            this.executions = new ArrayList();
        }
        for (Execution execution : this.executions) {
            if (execution.getType() == Enums.ExecutionType.ENTRY) {
                arrayList.add(0, new p(execution.getTime(), execution.getBar(), execution.getInstrument(), execution.getAccountId(), execution.getQuantityAsFloat(), execution.getAvgPrice(), execution.getCommission()));
                f2 += execution.getAction() == Enums.OrderAction.SELL ? execution.getQuantityAsFloat() * -1.0f : execution.getQuantityAsFloat();
                continue;
            }
            float f3 = execution.getQuantityAsFloat();
            if (execution.getType() == Enums.ExecutionType.SAR) {
                f3 = Math.abs(f2);
            }
            for (p object2 : arrayList) {
                if (object2.c < execution.getMaxPriceReached()) {
                    object2.c = execution.getMaxPriceReached();
                }
                if (!(object2.d > execution.getMinPriceReached())) continue;
                object2.d = execution.getMinPriceReached();
            }
            p p2 = (p)arrayList.get(0);
            if (f3 == p2.a) {
                Trade f4 = new Trade(n22++, p2.a, p2.a);
                f4.setCommission(p2.a + (double)f3 / (double)execution.getQuantityAsFloat() * execution.getCommission());
                f4.setEntryPrice(p2.b);
                f4.setEntryTime(p2.a);
                f4.setExitPrice(execution.getAvgPrice());
                f4.setExitTime(execution.getTime());
                f4.setQuantity(f3);
                f4.setPnl(execution.getPnl());
                f4.setPips(execution.getPips());
                f4.setLong(execution.getAction() == Enums.OrderAction.SELL);
                f4.setBars(execution.getBar() - p2.a);
                f4.setMaxPrice(p2.c);
                f4.setMinPrice(p2.d);
                this.trades.add(f4);
                f4.setPosition(f2 += execution.getAction() == Enums.OrderAction.SELL ? f4.getQuantity() * -1.0f : f4.getQuantity());
                f4.setCumulativePnl(d2 += f4.getPnl());
                f4.setCumulativeCommisssion(d3 += f4.getCommission());
                arrayList.remove(p2);
            } else if (f3 < p2.a) {
                Trade f5 = new Trade(n22++, p2.a, p2.a);
                double d4 = p2.a * ((double)f3 / (double)p2.a);
                f5.setCommission(d4 + (double)f3 / (double)execution.getQuantityAsFloat() * execution.getCommission());
                f5.setEntryPrice(p2.b);
                f5.setEntryTime(p2.a);
                f5.setExitPrice(execution.getAvgPrice());
                f5.setExitTime(execution.getTime());
                f5.setPnl(execution.getPnl());
                f5.setPips(execution.getPips());
                f5.setQuantity(f3);
                f5.setLong(execution.getAction() == Enums.OrderAction.SELL);
                f5.setBars(execution.getBar() - p2.a);
                f5.setMaxPrice(p2.c);
                f5.setMinPrice(p2.d);
                this.trades.add(f5);
                f5.setPosition(f2 += execution.getAction() == Enums.OrderAction.SELL ? f5.getQuantity() * -1.0f : f5.getQuantity());
                f5.setCumulativePnl(d2 += f5.getPnl());
                f5.setCumulativeCommisssion(d3 += f5.getCommission());
                p2.a -= d4;
                p2.a -= f5.getQuantity();
            } else if (f3 > p2.a) {
                float n7 = f3;
                for (p p3 : new ArrayList(arrayList)) {
                    Trade trade;
                    if (n7 >= p3.a) {
                        trade = new Trade(n22++, p3.a, p3.a);
                        trade.setCommission(p3.a + (double)p3.a / (double)execution.getQuantityAsFloat() * execution.getCommission());
                        trade.setEntryPrice(p3.b);
                        trade.setEntryTime(p3.a);
                        trade.setExitPrice(execution.getAvgPrice());
                        trade.setExitTime(execution.getTime());
                        trade.setPnl((double)p3.a / (double)f3 * execution.getPnl());
                        trade.setPips((float)((double)p3.a / (double)f3 * (double)execution.getPips()));
                        trade.setQuantity(p3.a);
                        trade.setLong(execution.getAction() == Enums.OrderAction.SELL);
                        trade.setBars(execution.getBar() - p2.a);
                        trade.setMaxPrice(p2.c);
                        trade.setMinPrice(p2.d);
                        this.trades.add(trade);
                        arrayList.remove(p3);
                        trade.setPosition(f2 += execution.getAction() == Enums.OrderAction.SELL ? trade.getQuantity() * -1.0f : trade.getQuantity());
                        trade.setCumulativePnl(d2 += trade.getPnl());
                        trade.setCumulativeCommisssion(d3 += trade.getCommission());
                        n7 -= trade.getQuantity();
                    } else if (n7 < p3.a) {
                        trade = new Trade(n22++, p3.a, p3.a);
                        double d5 = p3.a * ((double)n7 / (double)p3.a);
                        trade.setCommission(d5 + (double)n7 / (double)execution.getQuantityAsFloat() * execution.getCommission());
                        trade.setEntryPrice(p3.b);
                        trade.setEntryTime(p3.a);
                        trade.setExitPrice(execution.getAvgPrice());
                        trade.setExitTime(execution.getTime());
                        trade.setPnl((double)n7 / (double)f3 * execution.getPnl());
                        trade.setPips((float)((double)n7 / (double)f3 * execution.getPnl()));
                        trade.setQuantity(n7);
                        trade.setLong(execution.getAction() == Enums.OrderAction.SELL);
                        trade.setBars(execution.getBar() - p2.a);
                        trade.setMaxPrice(p2.c);
                        trade.setMinPrice(p2.d);
                        this.trades.add(trade);
                        trade.setPosition(f2 += execution.getAction() == Enums.OrderAction.SELL ? trade.getQuantity() * -1.0f : trade.getQuantity());
                        trade.setCumulativePnl(d2 += trade.getPnl());
                        trade.setCumulativeCommisssion(d3 += trade.getCommission());
                        p3.a -= d5;
                        p3.a -= trade.getQuantity();
                        n7 = 0.0f;
                    }
                    if (n7 != 0.0f) continue;
                    break;
                }
            }
            if (execution.getType() != Enums.ExecutionType.SAR) continue;
            float f4 = execution.getQuantityAsFloat() - f3;
            arrayList.add(0, new p(execution.getTime(), execution.getBar(), execution.getInstrument(), execution.getAccountId(), f4, execution.getAvgPrice(), (double)f4 / (double)execution.getQuantityAsFloat() * execution.getCommission()));
            if (execution.getAction() == Enums.OrderAction.SELL) {
                f4 *= -1.0f;
            }
            f2 += f4;
        }
        TradingHours tradingHours = this.instrument.getTradingHours();
        if (tradingHours != null) {
            for (l2 = this.startTime; l2 < this.endTime; l2 += 86400000L) {
                if (!tradingHours.isTradingDay(l2)) continue;
                ++this.tradingDays;
            }
        } else {
            for (l2 = this.startTime; l2 < this.endTime; l2 += 86400000L) {
                int n3 = h.a(l2);
                if (n3 == 1 || n3 == 7) continue;
                ++this.tradingDays;
            }
        }
        this.totalTrades = this.trades.size();
        this.totalTradesShort = 0;
        this.totalTradesLong = 0;
        this.winningTradesShort = 0;
        this.winningTradesLong = 0;
        this.winningTrades = 0;
        this.losingTradesShort = 0;
        this.losingTradesLong = 0;
        this.losingTrades = 0;
        this.maxConsecutiveLossesShort = 0;
        this.maxConsecutiveLossesLong = 0;
        this.maxConsecutiveLosses = 0;
        this.maxConsecutiveWinsShort = 0;
        this.maxConsecutiveWinsLong = 0;
        this.maxConsecutiveWins = 0;
        this.largestWinningTradeShort = 0.0;
        this.largestWinningTradeLong = 0.0;
        this.largestWinningTrade = 0.0;
        this.largestLosingTradeShort = 0.0;
        this.largestLosingTradeLong = 0.0;
        this.largestLosingTrade = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        int n3 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        this.totalQuantityShort = 0;
        this.totalQuantityLong = 0;
        this.totalQuantity = 0;
        double d24 = this.initialAccountValue;
        double d25 = this.initialAccountValue;
        double d26 = this.initialAccountValue;
        for (Trade trade : this.trades) {
            n8 += trade.getBars();
            long l6 = trade.getExitTime() - trade.getEntryTime();
            d6 += trade.getMAEPnl();
            d9 += trade.getMAEPercent();
            d12 += trade.getMAEPoints();
            d15 += trade.getMFEPnl();
            d18 += trade.getMFEPercent();
            d21 += trade.getMFEPoints();
            l3 += l6;
            this.commissions += trade.getCommission();
            this.profit += trade.getPnl();
            this.totalQuantity = (int)((float)this.totalQuantity + trade.getQuantity());
            trade.setAccountValue(d24 += trade.getNetPnl());
            if (trade.isLong()) {
                ++this.totalTradesLong;
                n9 += trade.getBars();
                l4 += l6;
                d7 += trade.getMAEPnl();
                d10 += trade.getMAEPercent();
                d13 += trade.getMAEPoints();
                d16 += trade.getMFEPnl();
                d19 += trade.getMFEPercent();
                d22 += trade.getMFEPoints();
                this.commissionsLong += trade.getCommission();
                this.profitLong += trade.getPnl();
                this.totalQuantityLong = (int)((float)this.totalQuantityLong + trade.getQuantity());
                d25 += trade.getNetPnl();
                trade.setAccountValueLong(d24);
            } else {
                ++this.totalTradesShort;
                n10 += trade.getBars();
                l5 += l6;
                d8 += trade.getMAEPnl();
                d11 += trade.getMAEPercent();
                d14 += trade.getMAEPoints();
                d17 += trade.getMFEPnl();
                d20 += trade.getMFEPercent();
                d23 += trade.getMFEPoints();
                this.commissionsShort += trade.getCommission();
                this.profitShort += trade.getPnl();
                this.totalQuantityShort = (int)((float)this.totalQuantityShort + trade.getQuantity());
                d26 += trade.getNetPnl();
                trade.setAccountValueShort(d24);
            }
            if (trade.getPnl() > 0.0) {
                this.grossProfit += trade.getPnl();
                if (n2 > this.maxConsecutiveLosses) {
                    this.maxConsecutiveLosses = n2;
                }
                if (n3 > this.maxConsecutiveLossesLong) {
                    this.maxConsecutiveLossesLong = n3;
                }
                if (n7 > this.maxConsecutiveLossesShort) {
                    this.maxConsecutiveLossesShort = n7;
                }
                n7 = 0;
                n3 = 0;
                n2 = 0;
                if (trade.getPnl() > this.largestWinningTrade) {
                    this.largestWinningTrade = trade.getPnl();
                }
                ++this.winningTrades;
                ++n4;
                if (trade.isLong()) {
                    this.grossProfitLong += trade.getPnl();
                    ++this.winningTradesLong;
                    ++n5;
                    if (!(trade.getPnl() > this.largestWinningTradeLong)) continue;
                    this.largestWinningTradeLong = trade.getPnl();
                    continue;
                }
                this.grossProfitShort += trade.getPnl();
                ++this.winningTradesShort;
                ++n6;
                if (!(trade.getPnl() > this.largestWinningTradeShort)) continue;
                this.largestWinningTradeShort = trade.getPnl();
                continue;
            }
            if (!(trade.getPnl() < 0.0)) continue;
            this.grossLoss += trade.getPnl();
            if (n4 > this.maxConsecutiveWins) {
                this.maxConsecutiveWins = n4;
            }
            if (n5 > this.maxConsecutiveWinsLong) {
                this.maxConsecutiveWinsLong = n5;
            }
            if (n6 > this.maxConsecutiveWinsShort) {
                this.maxConsecutiveWinsShort = n6;
            }
            if (trade.getPnl() < this.largestLosingTrade) {
                this.largestLosingTrade = trade.getPnl();
            }
            n6 = 0;
            n5 = 0;
            n4 = 0;
            ++this.losingTrades;
            ++n2;
            if (trade.isLong()) {
                this.grossLossLong += trade.getPnl();
                ++this.losingTradesLong;
                ++n3;
                if (!(trade.getPnl() < this.largestLosingTradeLong)) continue;
                this.largestLosingTradeLong = trade.getPnl();
                continue;
            }
            this.grossLossShort += trade.getPnl();
            ++this.losingTradesShort;
            ++n7;
            if (!(trade.getPnl() < this.largestLosingTradeShort)) continue;
            this.largestLosingTradeShort = trade.getPnl();
        }
        if (n4 > this.maxConsecutiveWins) {
            this.maxConsecutiveWins = n4;
        }
        if (n5 > this.maxConsecutiveWinsLong) {
            this.maxConsecutiveWinsLong = n5;
        }
        if (n6 > this.maxConsecutiveWinsShort) {
            this.maxConsecutiveWinsShort = n6;
        }
        if (n2 > this.maxConsecutiveLosses) {
            this.maxConsecutiveLosses = n2;
        }
        if (n3 > this.maxConsecutiveLossesLong) {
            this.maxConsecutiveLossesLong = n3;
        }
        if (n7 > this.maxConsecutiveLossesShort) {
            this.maxConsecutiveLossesShort = n7;
        }
        d24 = this.initialAccountValue;
        double d27 = 0.0;
        d25 = this.initialAccountValue;
        double d28 = 0.0;
        d26 = this.initialAccountValue;
        double d29 = 0.0;
        this.maxDrawdown = 0.0;
        for (Execution execution : this.executions) {
            double d30 = execution.getNetPnl();
            if (d30 == 0.0) continue;
            if (d27 < (d24 += d30)) {
                d27 = d24;
            }
            if (execution.getAction() == Enums.OrderAction.BUY) {
                if (d29 < (d26 += d30)) {
                    d29 = d26;
                }
            } else if (d28 < (d25 += d30)) {
                d28 = d25;
            }
            if (!(d30 < 0.0)) continue;
            double d31 = Math.abs(d27 - d24);
            if (d31 > this.maxDrawdown) {
                this.maxDrawdown = d31;
                this.maxDrawdownPercent = 1.0 - d24 / d27;
            }
            if (execution.getAction() == Enums.OrderAction.BUY) {
                d31 = d29 - d26;
                if (!(d31 > this.maxDrawdownShort)) continue;
                this.maxDrawdownShort = d31;
                this.maxDrawdownPercentShort = 1.0 - d26 / d29;
                continue;
            }
            d31 = d28 - d25;
            if (!(d31 > this.maxDrawdownLong)) continue;
            this.maxDrawdownLong = d31;
            this.maxDrawdownPercentLong = 1.0 - d25 / d28;
        }
        if (this.totalTrades > 0) {
            this.avgBarsInTrade = (double)n8 / (double)this.totalTrades;
            this.avgTimeInTrade = l3 / (long)this.totalTrades;
            this.avgMAE = d6 / (double)this.totalTrades;
            this.avgMAEPercent = d9 / (double)this.totalQuantity;
            this.avgMAEPoints = d12 / (double)this.totalTrades;
            this.avgMFE = d15 / (double)this.totalTrades;
            this.avgMFEPercent = d18 / (double)this.totalQuantity;
            this.avgMFEPoints = d21 / (double)this.totalTrades;
            this.avgTrade = this.profit / (double)this.totalTrades;
        }
        if (this.totalTradesLong > 0) {
            this.avgBarsInTradeLong = (double)n9 / (double)this.totalTradesLong;
            this.avgTimeInTradeLong = l4 / (long)this.totalTradesLong;
            this.avgMAELong = d7 / (double)this.totalTradesLong;
            this.avgMAEPercentLong = d10 / (double)this.totalQuantityLong;
            this.avgMAEPointsLong = d13 / (double)this.totalTradesLong;
            this.avgMFELong = d16 / (double)this.totalTradesLong;
            this.avgMFEPercentLong = d19 / (double)this.totalQuantityLong;
            this.avgMFEPointsLong = d22 / (double)this.totalTradesLong;
            this.avgTradeLong = this.profitLong / (double)this.totalTradesLong;
        }
        if (this.totalTradesShort > 0) {
            this.avgBarsInTradeShort = (double)n10 / (double)this.totalTradesShort;
            this.avgTimeInTradeShort = l5 / (long)this.totalTradesShort;
            this.avgMAEShort = d8 / (double)this.totalTradesShort;
            this.avgMAEPercentShort = d11 / (double)this.totalQuantityShort;
            this.avgMAEPointsShort = d14 / (double)this.totalTradesShort;
            this.avgMFEShort = d17 / (double)this.totalTradesShort;
            this.avgMFEPercentShort = d20 / (double)this.totalQuantityShort;
            this.avgMFEPointsShort = d23 / (double)this.totalTradesShort;
            this.avgTradeShort = this.profitShort / (double)this.totalTradesShort;
        }
        if (this.winningTrades > 0) {
            this.avgWinningTrade = this.grossProfit / (double)this.winningTrades;
        }
        if (this.winningTradesLong > 0) {
            this.avgWinningTradeLong = this.grossProfitLong / (double)this.winningTradesLong;
        }
        if (this.winningTradesShort > 0) {
            this.avgWinningTradeShort = this.grossProfitShort / (double)this.winningTradesShort;
        }
        if (this.losingTrades > 0) {
            this.avgLosingTrade = this.grossLoss / (double)this.losingTrades;
        }
        if (this.losingTradesLong > 0) {
            this.avgLosingTradeLong = this.grossLossLong / (double)this.losingTradesLong;
        }
        if (this.losingTradesShort > 0) {
            this.avgLosingTradeShort = this.grossLossShort / (double)this.losingTradesShort;
        }
        if (this.avgLosingTrade != 0.0) {
            this.winningVsLosingTrade = Math.abs(this.avgWinningTrade / this.avgLosingTrade);
        }
        if (this.avgLosingTradeLong != 0.0) {
            this.winningVsLosingTradeLong = Math.abs(this.avgWinningTradeLong / this.avgLosingTradeLong);
        }
        if (this.avgLosingTradeShort != 0.0) {
            this.winningVsLosingTradeShort = Math.abs(this.avgWinningTradeShort / this.avgLosingTradeShort);
        }
        if (this.tradingDays > 0) {
            this.profitPerDay = this.profit / (double)this.tradingDays;
            this.profitPerDayLong = this.profitLong / (double)this.tradingDays;
            this.profitPerDayShort = this.profitShort / (double)this.tradingDays;
        }
        this.metrics = new ArrayList();
        this.metrics.add(new StrategyMetric(ai.a("METRIC_TOTAL_NET_PROFIT", new Object[0]), this.profit - this.commissions, this.profitLong - this.commissionsLong, this.profitShort - this.commissionsShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_TOTAL_PROFIT", new Object[0]), this.profit, this.profitLong, this.profitShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_GROSS_PROFIT", new Object[0]), this.grossProfit, this.grossProfitLong, this.grossProfitShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_GROSS_LOSS", new Object[0]), this.grossLoss, this.grossLossLong, this.grossLossShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_COMMISSION", new Object[0]), this.commissions, this.commissionsLong, this.commissionsShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_PROFIT_FACTOR", new Object[0]), Math.abs(this.grossProfit / this.grossLoss), Math.abs(this.grossProfitLong / this.grossLossLong), Math.abs(this.grossProfitShort / this.grossLossShort)));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_MAX_DRAWDOWN", new Object[0]), this.maxDrawdown, this.maxDrawdownLong, this.maxDrawdownShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_MAX_DRAWDOWN_PERCENT", new Object[0]), this.maxDrawdownPercent, this.maxDrawdownPercentLong, this.maxDrawdownPercentShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_NUM_TRADES", new Object[0]), this.totalTrades, this.totalTradesLong, this.totalTradesShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_PER_PROFITABLE", new Object[0]), (double)this.winningTrades / (double)this.totalTrades, (double)this.winningTradesLong / (double)this.totalTradesLong, (double)this.winningTradesShort / (double)this.totalTradesShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_WINNING_TRADES", new Object[0]), this.winningTrades, this.winningTradesLong, this.winningTradesShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_LOSING_TRADES", new Object[0]), this.losingTrades, this.losingTradesLong, this.losingTradesShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_TRADE", new Object[0]), this.avgTrade, this.avgTradeLong, this.avgTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_WINNING_TRADE", new Object[0]), this.avgWinningTrade, this.avgWinningTradeLong, this.avgWinningTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_LOSING_TRADE", new Object[0]), this.avgLosingTrade, this.avgLosingTradeLong, this.avgLosingTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_WINNING_LOSING_TRADE", new Object[0]), this.winningVsLosingTrade, this.winningVsLosingTradeLong, this.winningVsLosingTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_MAX_CON_WINNERS", new Object[0]), this.maxConsecutiveWins, this.maxConsecutiveWinsLong, this.maxConsecutiveWinsShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_MAX_CON_LOSERS", new Object[0]), this.maxConsecutiveLosses, this.maxConsecutiveLossesLong, this.maxConsecutiveLossesShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_LARGEST_WINNING_TRADE", new Object[0]), this.largestWinningTrade, this.largestWinningTradeLong, this.largestWinningTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_LARGEST_LOSING_TRADE", new Object[0]), this.largestLosingTrade, this.largestLosingTradeLong, this.largestLosingTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_NUM_TRADES_PER_DAY", new Object[0]), (double)this.totalTrades / (double)this.tradingDays, (double)this.totalTradesLong / (double)this.tradingDays, (double)this.totalTradesShort / (double)this.tradingDays));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_TIME_IN_MARKET", new Object[0]), this.avgTimeInTrade, this.avgTimeInTradeLong, this.avgTimeInTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_BARS_IN_TRADE", new Object[0]), this.avgBarsInTrade, this.avgBarsInTradeLong, this.avgBarsInTradeShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_PROFIT_PER_DAY", new Object[0]), this.profitPerDay, this.profitPerDayLong, this.profitPerDayShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_PROFIT_PER_WEEK", new Object[0]), this.profitPerDay * 5.0, this.profitPerDayLong * 5.0, this.profitPerDayShort * 5.0));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_PROFIT_PER_MONTH", new Object[0]), this.profitPerDay * 30.0, this.profitPerDayLong * 30.0, this.profitPerDayShort * 30.0));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MAE", new Object[0]), this.avgMAE, this.avgMAELong, this.avgMAEShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MAE_PERCENT", new Object[0]), this.avgMAEPercent, this.avgMAEPercentLong, this.avgMAEPercentShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MAE_POINTS", new Object[0]), this.avgMAEPoints, this.avgMAEPointsLong, this.avgMAEPointsShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MFE", new Object[0]), this.avgMFE, this.avgMFELong, this.avgMFEShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MFE_PERCENT", new Object[0]), this.avgMFEPercent, this.avgMFEPercentLong, this.avgMFEPercentShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_MFE_POINTS", new Object[0]), this.avgMFEPoints, this.avgMFEPointsLong, this.avgMFEPointsShort));
        this.metrics.add(new StrategyMetric(ai.a("METRIC_AVG_ETD", new Object[0]), this.avgMFE - this.avgTrade, this.avgMFELong - this.avgTradeLong, this.avgMFEShort - this.avgTradeShort));
    }
}

