/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import cn.dr;
import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.EEOrder;
import com.motivewave.platform.databean.EntryOrder;
import com.motivewave.platform.databean.ExitOrder;
import com.motivewave.platform.databean.ExitTrigger;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.service.ae;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import k.g;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntryExitStrategy
extends b
implements o {
    private String name;
    private boolean absoluteOffset = false;
    private boolean adjustExitSize = true;
    private List entryOrders = new ArrayList();
    private List exitOrders = new ArrayList();

    public EntryExitStrategy() {
    }

    public EntryExitStrategy(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public EntryExitStrategy(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange("name", string2, this.name);
    }

    public boolean isAbsoluteOffset() {
        return this.absoluteOffset;
    }

    public void setAbsoluteOffset(boolean bl2) {
        boolean bl3 = this.absoluteOffset;
        this.absoluteOffset = bl2;
        this.firePropertyChange("absoluteOffset", bl3, bl2);
    }

    public boolean isAdjustExitSize() {
        return this.adjustExitSize;
    }

    public void setAdjustExitSize(boolean bl2) {
        boolean bl3 = this.adjustExitSize;
        this.adjustExitSize = bl2;
        this.firePropertyChange("adjustExitSize", bl3, bl2);
    }

    public void execute(dr dr2, Ticker ticker, String string, float f2, Enums$TIF enums$TIF, int n2) {
        Cloneable cloneable;
        MWInstrument mWInstrument = ticker.getInstrument();
        ArrayList<List> arrayList = new ArrayList<List>();
        Account account = ae.a(string);
        float f3 = (float)ticker.getTickSize();
        float f4 = ticker.getMidOrLast();
        for (Object object : this.getEntries()) {
            int n3;
            EntryOrder object2 = (EntryOrder)object.get(0);
            if (object2.getType() == Enums$OrderType.MKT) {
                cloneable = OrderDirectory.createMarketOrder(account, ticker, object2.getAction(), enums$TIF, Math.abs(f2 * (float)object2.getLots()));
                ae.a((MWOrder)cloneable, dr2);
                arrayList.add(h.b(new MWOrder[]{cloneable}));
                continue;
            }
            cloneable = object.size() > 1 ? (EntryOrder)object.get(1) : null;
            int n4 = n3 = this.isAbsoluteOffset() ? object2.getOffset() : n2 * object2.getOffset();
            int n5 = cloneable == null ? 0 : (this.isAbsoluteOffset() ? ((EEOrder)cloneable).getOffset() : n2 * ((EEOrder)cloneable).getOffset());
            float f5 = mWInstrument.round(f4 + (float)n3 * f3);
            float f6 = mWInstrument.round(f4 + (float)n5 * f3);
            ArrayList<MWOrder> arrayList2 = new ArrayList<MWOrder>();
            if (object2.getType().isLimit()) {
                if (object2.getAction().isBuy() && f5 > f4) {
                    f5 = mWInstrument.round(f4 - (float)n3 * f3);
                } else if (object2.getAction().isSell() && f5 < f4) {
                    f5 = mWInstrument.round(f4 - (float)n3 * f3);
                }
            } else if (object2.getType().isStop()) {
                if (object2.getAction().isBuy() && f5 < f4) {
                    f5 = mWInstrument.round(f4 - (float)n3 * f3);
                } else if (object2.getAction().isSell() && f5 > f4) {
                    f5 = mWInstrument.round(f4 - (float)n3 * f3);
                }
            }
            if (cloneable != null) {
                if (((EEOrder)cloneable).getType().isLimit()) {
                    if (((EntryOrder)cloneable).getAction().isBuy() && f6 > f4) {
                        f6 = mWInstrument.round(f4 - (float)n5 * f3);
                    } else if (((EntryOrder)cloneable).getAction().isSell() && f6 < f4) {
                        f6 = mWInstrument.round(f4 - (float)n5 * f3);
                    }
                } else if (((EEOrder)cloneable).getType().isStop()) {
                    if (((EntryOrder)cloneable).getAction().isBuy() && f6 < f4) {
                        f6 = mWInstrument.round(f4 - (float)n5 * f3);
                    } else if (((EntryOrder)cloneable).getAction().isSell() && f6 > f4) {
                        f6 = mWInstrument.round(f4 - (float)n5 * f3);
                    }
                }
            }
            arrayList2.add(new MWOrder(string, ticker, object2.getAction(), object2.getType(), Math.abs(f2 * (float)object2.getLots()), enums$TIF, f5));
            if (cloneable != null) {
                arrayList2.add(new MWOrder(string, ticker, ((EntryOrder)cloneable).getAction(), ((EEOrder)cloneable).getType(), Math.abs(f2 * (float)((EEOrder)cloneable).getLots()), enums$TIF, f6));
            }
            for (MWOrder mWOrder : arrayList2) {
                OrderDirectory.createOrder(mWOrder);
            }
            if (arrayList2.size() == 1) {
                ae.a((MWOrder)arrayList2.get(0), dr2);
            } else {
                ae.c(arrayList2, dr2);
            }
            arrayList.add(arrayList2);
        }
        if (h.a((Collection)this.getExits())) {
            return;
        }
        if (!h.a((Collection)this.getEntries())) {
            Object object;
            ArrayList arrayList3 = new ArrayList();
            for (List list : arrayList) {
                cloneable = new ArrayList();
                for (MWOrder mWOrder : list) {
                    cloneable.add(mWOrder.getOrderId());
                }
                arrayList3.add(cloneable);
            }
            object = new ExitTrigger(this, arrayList3);
            ((ExitTrigger)object).setAccountID(string);
            ((ExitTrigger)object).setTicker(ticker);
            ((ExitTrigger)object).setContainer(dr2);
            ((ExitTrigger)object).setOffset(n2);
            ((ExitTrigger)object).setQuantity(f2);
            ((ExitTrigger)object).setTif(enums$TIF);
            OrderDirectory.createExitTrigger((ExitTrigger)object);
            return;
        }
        float f7 = PositionDirectory.getPosition(ticker.getInstrument(), account);
        if (f7 == 0.0f) {
            s.a(dr2, "TITLE_EXIT_NO_POSITION", ai.a("MSG_EXIT_NO_POSITION", ticker.getSymbolDisplay()));
            return;
        }
        float f8 = mWInstrument.round(PositionDirectory.getAvgPrice(ticker.getInstrument(), account));
        this.doExit(dr2, ticker, string, f7, f8, f2, enums$TIF, n2);
    }

    public void doExit(dr dr2, Ticker ticker, String string, float f2, float f3, float f4, Enums$TIF enums$TIF, int n2) {
        Account account = ae.a(string);
        boolean bl2 = ae.a(account);
        MWInstrument mWInstrument = ticker.getInstrument();
        List list3 = PositionDirectory.getOpen(mWInstrument, string);
        for (Object object : new ArrayList(list3)) {
            if (((Position)object).getQuantity() < 0.0f && f2 > 0.0f) {
                list3.remove(object);
                continue;
            }
            if (!(((Position)object).getQuantity() > 0.0f) || !(f2 < 0.0f)) continue;
            list3.remove(object);
        }
        int n3 = 0;
        for (List list4 : this.getExits()) {
            n3 += ((ExitOrder)list4.get(0)).getLots();
        }
        if (this.adjustExitSize) {
            f4 = Math.abs(f2 / (float)n3);
            float f5 = mWInstrument.getQuantityInc();
            if (f5 > 0.0f) {
                if (f4 < f5) {
                    s.a(dr2, "TITLE_EXIT_POSITION_TOO_SMALL", ai.a("MSG_EXIT_POSITION_TOO_SMALL", ticker.getSymbolDisplay()));
                    return;
                }
                if (!h.a(f4, f5)) {
                    int n4 = (int)Math.floor((double)f4 / (double)f5);
                    f4 = (float)n4 * f5;
                    h.a.info("EntryExitStrategy::execute() quantity: " + f4 + " adjusted to min step: " + f5);
                }
            }
        } else if (f4 * (float)n3 > Math.abs(f2)) {
            s.a(dr2, "TITLE_EXIT_POSITION_TOO_SMALL", ai.a("MSG_EXIT_POSITION_TOO_SMALL", ticker.getSymbolDisplay()));
            return;
        }
        Enums$OrderAction enums$OrderAction = f2 < 0.0f ? Enums$OrderAction.BUY : Enums$OrderAction.SELL;
        Collections.sort(list3, (position, position2) -> {
            if (position == position2) {
                return 0;
            }
            if (Math.abs(position.getQuantity()) > Math.abs(position2.getQuantity())) {
                return -1;
            }
            if (Math.abs(position.getQuantity()) == Math.abs(position2.getQuantity()) && position.getOpenTime() > position2.getOpenTime()) {
                return -1;
            }
            return 1;
        });
        ArrayList arrayList = new ArrayList(this.getExits());
        Collections.sort(arrayList, (list, list2) -> {
            if (Math.abs(((ExitOrder)list.get(0)).getLots()) > Math.abs(((ExitOrder)list2.get(0)).getLots())) {
                return -1;
            }
            return 1;
        });
        float f6 = 0.0f;
        int n5 = 0;
        float f7 = ticker.getMidOrLast();
        if (f3 > 0.0f && !h.a((Collection)this.getEntries())) {
            f7 = f3;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object;
            float f8;
            int n6;
            int n7;
            ExitOrder exitOrder;
            List list5 = (List)arrayList.get(i2);
            ArrayList<MWOrder> arrayList2 = new ArrayList<MWOrder>();
            ExitOrder exitOrder2 = (ExitOrder)list5.get(0);
            ExitOrder exitOrder3 = exitOrder = list5.size() > 1 ? (ExitOrder)list5.get(1) : null;
            if (!exitOrder2.isEnabled() && (exitOrder == null || !exitOrder.isEnabled())) continue;
            int n8 = n7 = this.isAbsoluteOffset() ? exitOrder2.getOffset() : n2 * exitOrder2.getOffset();
            int n9 = exitOrder == null ? 0 : (n6 = this.isAbsoluteOffset() ? exitOrder.getOffset() : n2 * exitOrder.getOffset());
            if (enums$OrderAction == Enums$OrderAction.BUY) {
                n7 *= -1;
            } else {
                n6 *= -1;
            }
            float f9 = mWInstrument.round(f7 + (float)n7 * (float)ticker.getTickSize());
            float f10 = mWInstrument.round(f7 + (float)n6 * (float)ticker.getTickSize());
            float f11 = (float)exitOrder2.getLots() * f4;
            if (i2 == arrayList.size() - 1 && f11 != (f8 = Math.abs(f2) - (float)Math.abs(n5))) {
                h.a.warning("EntryExitStrategy::doExit() remaining quantity: " + f8 + " not equal to the exit qty: " + f11 + " orig position: " + f2);
                f11 = f8;
            }
            Object object2 = null;
            if (!h.a((Collection)list3)) {
                if (account.isHedging()) {
                    object = list3.iterator();
                    while (object.hasNext()) {
                        Position position3 = (Position)object.next();
                        if (position3.getQuantity() != f11) continue;
                        object2 = position3;
                        if (f6 != 0.0f) continue;
                        f6 = Math.abs(((Position)object2).getQuantity());
                    }
                } else {
                    object2 = (Position)list3.get(0);
                    if (f6 == 0.0f) {
                        f6 = Math.abs(((Position)object2).getQuantity());
                    }
                }
            }
            Object object3 = object = object2 == null ? null : ((Position)object2).getTicket();
            if (exitOrder2.isEnabled()) {
                arrayList2.add(new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.LMT, Math.abs(f11), enums$TIF, f9));
            }
            if (exitOrder != null && exitOrder.isEnabled()) {
                arrayList2.add(new MWOrder(string, ticker, enums$OrderAction, exitOrder.getType(), Math.abs(f11), enums$TIF, f10));
            }
            for (MWOrder mWOrder : arrayList2) {
                if (bl2) {
                    mWOrder.setParentId((String)object);
                    mWOrder.setTradeId((String)object);
                    mWOrder.setUsePips(false);
                    mWOrder.setEntryOrder(false);
                    mWOrder.setNetClose(false);
                }
                OrderDirectory.createOrder(mWOrder);
            }
            if (account.isHedging() && object2 != null && f6 >= f11) {
                for (MWOrder mWOrder : arrayList2) {
                    mWOrder.setTradeId(((Position)object2).getTicket());
                    mWOrder.setParentId(((Position)object2).getTicket());
                }
            }
            f6 -= f11;
            n5 = (int)((float)n5 + f11);
            if (f6 <= 0.0f) {
                f6 = 0.0f;
                list3.remove(object2);
            }
            if (h.a(arrayList2)) {
                h.a.warning("EntryExitStrategy::doExit() no orders!");
                continue;
            }
            try {
                if (arrayList2.size() == 1) {
                    ae.a((MWOrder)arrayList2.get(0), dr2);
                    continue;
                }
                ae.c(arrayList2, dr2);
                continue;
            }
            catch (MWException mWException) {
                s.a(dr2, "TITLE_E_SUBMIT_ORDER", mWException.getMessage());
            }
        }
    }

    public void clear() {
        this.entryOrders.clear();
        this.exitOrders.clear();
    }

    public void addEntry(EntryOrder entryOrder) {
        this.addEntry(entryOrder, null);
    }

    public void addEntry(EntryOrder entryOrder, EntryOrder entryOrder2) {
        ArrayList<EntryOrder> arrayList = new ArrayList<EntryOrder>();
        arrayList.add(entryOrder);
        if (entryOrder2 != null) {
            arrayList.add(entryOrder2);
        }
        this.addEntry(arrayList);
    }

    public void addExit(ExitOrder exitOrder) {
        this.addExit(exitOrder, null);
    }

    public void addExit(ExitOrder exitOrder, ExitOrder exitOrder2) {
        ArrayList<ExitOrder> arrayList = new ArrayList<ExitOrder>();
        arrayList.add(exitOrder);
        if (exitOrder2 != null) {
            arrayList.add(exitOrder2);
        }
        this.addExit(arrayList);
    }

    public List getEntries() {
        return this.entryOrders;
    }

    public void addEntry(List list) {
        this.entryOrders.add(list);
    }

    public List getExits() {
        return this.exitOrders;
    }

    public void addExit(List list) {
        this.exitOrders.add(list);
    }

    @Override
    public List getNVPs() {
        List list;
        List list2 = h.b(new String[]{this.b("name", this.name), this.a("absoluteOffset", this.absoluteOffset, false), this.a("adjustExitSize", this.adjustExitSize)});
        if (!h.a((Collection)this.entryOrders)) {
            list = h.b(new String[0]);
            for (List list3 : this.entryOrders) {
                list.add(this.b(list3));
            }
            list2.add(this.a("entryOrders", (Collection)list));
        }
        if (!h.a((Collection)this.exitOrders)) {
            list = h.b(new String[0]);
            for (List list3 : this.exitOrders) {
                list.add(this.b(list3));
            }
            list2.add(this.a("exitOrders", (Collection)list));
        }
        return list2;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        List list;
        this.name = jSONObject.str("name");
        this.absoluteOffset = jSONObject.is("absoluteOffset", false);
        this.adjustExitSize = jSONObject.is("adjustExitSize");
        this.entryOrders.clear();
        for (Object e2 : jSONObject.getList("entryOrders")) {
            if (!(e2 instanceof JSONArray)) continue;
            list = h.b(new EntryOrder[0]);
            for (JSONObject jSONObject2 : ((JSONArray)e2).asObjList()) {
                list.add(new EntryOrder(jSONObject2));
            }
            this.entryOrders.add(list);
        }
        this.exitOrders.clear();
        for (Object e2 : jSONObject.getList("exitOrders")) {
            if (!(e2 instanceof JSONArray)) continue;
            list = h.b(new ExitOrder[0]);
            for (JSONObject jSONObject2 : ((JSONArray)e2).asObjList()) {
                list.add(new ExitOrder(jSONObject2));
            }
            this.exitOrders.add(list);
        }
    }

    public void readXML(Element element) {
        Object object;
        this.entryOrders.clear();
        this.exitOrders.clear();
        this.name = element.getAttribute("name");
        this.absoluteOffset = h.a((Object)element.getAttribute("absoluteOffset"));
        this.adjustExitSize = h.a((Object)element.getAttribute("adjustExitSize"));
        Node node = g.b("entry_orders", element);
        if (node != null) {
            object = g.c("group", node).iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                Object object2 = new ArrayList();
                for (Object object3 : g.c("entry", element2)) {
                    Object object4 = new EntryOrder();
                    ((EntryOrder)object4).read((Element)object3);
                    object2.add(object4);
                }
                this.entryOrders.add(object2);
            }
        }
        if ((object = g.b("exit_orders", element)) != null) {
            for (Object object2 : g.c("group", (Node)object)) {
                ArrayList arrayList = new ArrayList();
                for (Object object4 : g.c("exit", (Node)object2)) {
                    ExitOrder exitOrder = new ExitOrder();
                    exitOrder.read((Element)object4);
                    arrayList.add(exitOrder);
                }
                this.exitOrders.add(arrayList);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            int n2;
            List list;
            List list2;
            int n3;
            EntryExitStrategy entryExitStrategy = (EntryExitStrategy)object;
            if (!h.a((Object)this.name, (Object)entryExitStrategy.name)) {
                return false;
            }
            if (this.absoluteOffset != entryExitStrategy.absoluteOffset) {
                return false;
            }
            if (this.adjustExitSize != entryExitStrategy.adjustExitSize) {
                return false;
            }
            if (entryExitStrategy.entryOrders.size() != this.entryOrders.size()) {
                return false;
            }
            if (entryExitStrategy.exitOrders.size() != this.exitOrders.size()) {
                return false;
            }
            for (n3 = 0; n3 < this.entryOrders.size(); ++n3) {
                list2 = (List)this.entryOrders.get(n3);
                list = (List)entryExitStrategy.entryOrders.get(n3);
                if (list2.size() != list.size()) {
                    return false;
                }
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (((EntryOrder)list2.get(n2)).equals(list.get(n2))) continue;
                    return false;
                }
            }
            for (n3 = 0; n3 < this.exitOrders.size(); ++n3) {
                list2 = (List)this.exitOrders.get(n3);
                list = (List)entryExitStrategy.exitOrders.get(n3);
                if (list2.size() != list.size()) {
                    return false;
                }
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (((ExitOrder)list2.get(n2)).equals(list.get(n2))) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public EntryExitStrategy clone() {
        ArrayList<EEOrder> arrayList;
        EntryExitStrategy entryExitStrategy = (EntryExitStrategy)super.clone();
        entryExitStrategy.entryOrders = new ArrayList();
        for (List list : this.entryOrders) {
            arrayList = new ArrayList<EEOrder>();
            for (EEOrder eEOrder : list) {
                arrayList.add((EntryOrder)eEOrder.clone());
            }
            entryExitStrategy.entryOrders.add(arrayList);
        }
        entryExitStrategy.exitOrders = new ArrayList();
        for (List list : this.exitOrders) {
            arrayList = new ArrayList();
            for (EEOrder eEOrder : list) {
                arrayList.add((ExitOrder)eEOrder.clone());
            }
            entryExitStrategy.exitOrders.add(arrayList);
        }
        return entryExitStrategy;
    }
}

