/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$WaveDegree;
import com.motivewave.platform.common.i;
import i.c;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.List;
import k.q;
import k.z;
import org.json.JSONObject;

public class DegreeDescriptor
implements q,
z {
    private Enums$WaveDegree degree;
    private Font font;
    private Color fontColor;
    private float lineWidth = 1.0f;
    private float[] lineDash = null;
    private Color lineColor;
    private boolean lineUseFontColor = false;
    private Stroke stroke = null;

    public DegreeDescriptor(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public DegreeDescriptor(Enums$WaveDegree enums$WaveDegree, Font font, Color color) {
        this(enums$WaveDegree);
        this.fontColor = color;
        this.font = font;
        this.lineUseFontColor = true;
    }

    public DegreeDescriptor(Enums$WaveDegree enums$WaveDegree) {
        this.degree = enums$WaveDegree;
        this.reset();
    }

    public void reset() {
        this.fontColor = null;
        this.lineColor = null;
        this.lineUseFontColor = false;
        this.lineWidth = 1.0f;
        this.lineDash = null;
        this.stroke = null;
        this.font = DegreeDescriptor.getDefaultFont(this.degree);
    }

    private static Font getDefaultFont(Enums$WaveDegree enums$WaveDegree) {
        switch (enums$WaveDegree) {
            case SUPER_MILLENNIUM: {
                return i.a;
            }
            case MILLENNIUM: {
                return i.b;
            }
            case SUB_MILLENNIUM: {
                return i.c;
            }
            case GRAND_SUPERCYCLE: {
                return i.d;
            }
            case SUPERCYCLE: {
                return i.e;
            }
            case CYCLE: {
                return i.f;
            }
            case PRIMARY: {
                return i.g;
            }
            case INTERMEDIATE: {
                return i.h;
            }
            case MINOR: {
                return i.i;
            }
            case MINUTE: {
                return i.j;
            }
            case MINUETTE: {
                return i.k;
            }
            case SUBMINUETTE: {
                return i.l;
            }
            case MICRO: {
                return i.m;
            }
            case SUBMICRO: {
                return i.n;
            }
            case MINISCULE: {
                return i.o;
            }
            case NANO: {
                return i.p;
            }
            case SUBNANO: {
                return i.q;
            }
            case PICO: {
                return i.r;
            }
        }
        return null;
    }

    public Enums$WaveDegree getDegree() {
        return this.degree;
    }

    public void setDegree(Enums$WaveDegree enums$WaveDegree) {
        this.degree = enums$WaveDegree;
    }

    public Font getFont() {
        return this.font == null ? DegreeDescriptor.getDefaultFont(this.degree) : this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f2) {
        this.lineWidth = f2;
        this.stroke = null;
    }

    public float[] getLineDash() {
        return this.lineDash;
    }

    public void setLineDash(float[] fArray) {
        this.lineDash = fArray;
        this.stroke = null;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public boolean isLineUseFontColor() {
        return this.lineUseFontColor;
    }

    public void setLineUseFontColor(boolean bl2) {
        this.lineUseFontColor = bl2;
    }

    public Stroke getLineStroke() {
        if (this.stroke == null) {
            this.stroke = c.a(this.lineWidth, this.lineDash);
        }
        return this.stroke;
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.a("degree", (Object)this.degree), this.a("width", this.lineWidth, 1.0f), this.a("dash", this.lineDash), this.a("useFontColor", this.lineUseFontColor, false), this.a("fontColor", this.fontColor), this.a("lineColor", this.lineColor), this.a("font", (Object)this.font, (Object)DegreeDescriptor.getDefaultFont(this.degree))});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        try {
            this.degree = Enums$WaveDegree.valueOf(jSONObject.str("degree"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lineWidth = jSONObject.getFloat("width", 1.0f);
        this.lineDash = jSONObject.getDash("dash");
        this.lineUseFontColor = jSONObject.is("useFontColor", false);
        this.fontColor = jSONObject.getColor("fontColor");
        this.lineColor = jSONObject.getColor("lineColor");
        this.font = jSONObject.getFont("font");
        if (this.font == null) {
            this.font = DegreeDescriptor.getDefaultFont(this.degree);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof DegreeDescriptor)) {
            return false;
        }
        DegreeDescriptor degreeDescriptor = (DegreeDescriptor)object;
        if (this.degree != degreeDescriptor.degree) {
            return false;
        }
        if (!h.a((Object)this.font, (Object)degreeDescriptor.font)) {
            return false;
        }
        if (!h.a((Object)this.fontColor, (Object)degreeDescriptor.fontColor)) {
            return false;
        }
        if (!h.a((Object)this.lineColor, (Object)degreeDescriptor.lineColor)) {
            return false;
        }
        if (this.lineWidth != degreeDescriptor.lineWidth) {
            return false;
        }
        if (!h.a(this.lineDash, degreeDescriptor.lineDash)) {
            return false;
        }
        return this.lineUseFontColor == degreeDescriptor.lineUseFontColor;
    }

    @Override
    public DegreeDescriptor clone() {
        try {
            return (DegreeDescriptor)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

