/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import cm.f;
import com.motivewave.common.h;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.MWInstrument;

public class DOMTotals
extends b {
    private float bidTotal;
    private float askTotal;
    private f panel;

    public DOMTotals(f f2) {
        this.panel = f2;
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "bidTotal": {
                return Float.valueOf(this.bidTotal);
            }
            case "askTotal": {
                return Float.valueOf(this.askTotal);
            }
            case "net": {
                return Float.valueOf(this.getNet());
            }
            case "ratio": {
                return this.getRatio();
            }
            case "netRatio": {
                return this.getNetRatio();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "bidTotal": {
                return this.formatVol(this.bidTotal);
            }
            case "askTotal": {
                return this.formatVol(this.askTotal);
            }
            case "net": {
                return this.formatVol(this.getNet());
            }
            case "ratio": {
                return h.a(this.getRatio(), 1);
            }
            case "netRatio": {
                return this.getNetRatio();
            }
        }
        return super.format(string);
    }

    private String formatVol(float f2) {
        if (f2 == 0.0f) {
            return "0";
        }
        MWInstrument mWInstrument = this.panel.a();
        if (mWInstrument != null && mWInstrument.supportsFractionalVolume()) {
            return s.b(f2, this.panel.a());
        }
        long l2 = (long)f2;
        if (l2 >= 10000L || l2 <= -10000L) {
            return s.c(l2);
        }
        return h.b((Object)l2);
    }

    public float getBidTotal() {
        return this.bidTotal;
    }

    public void setBidTotal(float f2) {
        float f3 = this.bidTotal;
        this.bidTotal = f2;
        this.firePropertyChange("bidTotal", f3, this.bidTotal);
    }

    public float getAskTotal() {
        return this.askTotal;
    }

    public void setAskTotal(float f2) {
        float f3 = this.askTotal;
        this.askTotal = f2;
        this.firePropertyChange("askTotal", f3, this.askTotal);
    }

    public void clear() {
        this.setAskTotal(0.0f);
        this.setBidTotal(0.0f);
        this.fireUpdate();
    }

    public double getRatio() {
        return (double)this.bidTotal / (double)this.askTotal;
    }

    public float getNet() {
        return this.bidTotal - this.askTotal;
    }

    public String getNetRatio() {
        if (this.askTotal == 0.0f) {
            return this.format("net");
        }
        return this.format("net") + " (" + this.format("ratio") + ")";
    }

    public void fireUpdate() {
        this.firePropertyChange("update", 0, 1);
    }
}

