/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.ae;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class Currency
implements Comparable {
    private String symbol;
    private String description;
    private static Map symbolMap = new HashMap();
    private static SortedSet allCurrencies = new TreeSet();
    private static SortedSet allSymbols = new TreeSet();
    private static boolean unsavedChanges = false;

    public Currency(String string, String string2) {
        this.symbol = string;
        this.description = string2;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Currency currency) {
        if (currency == null) {
            return -1;
        }
        return this.symbol.compareTo(currency.symbol);
    }

    public String toString() {
        return this.symbol;
    }

    public static void save() {
        Workspace workspace = ae.a();
        File file = new File(workspace.getConfigDir(), "currencies.csv");
        if (!unsavedChanges && file.exists()) {
            return;
        }
        unsavedChanges = false;
        Currency.save(workspace, Currency.getAll());
    }

    public static void save(Workspace workspace, List list) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(workspace.getConfigDir(), "currencies.csv"));
            for (Currency currency : list) {
                Currency.toCSV(currency, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            symbolMap.clear();
            allCurrencies.clear();
            allSymbols.clear();
        }
        for (Currency currency : Currency.load(ae.a())) {
            Currency.register(currency);
        }
        unsavedChanges = false;
    }

    public static List load(File file) {
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        if (!file.exists()) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                Currency currency = Currency.fromCSV(string);
                if (currency != null) {
                    arrayList.add(currency);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List load(Workspace workspace) {
        File file = new File(workspace.getConfigDir(), "currencies.csv");
        if (!file.exists() && workspace.isDBExists()) {
            try {
                b b2 = CommandFactory.createCmd("LOAD_CURRENCIES");
                b2.a(workspace.getDBName());
                return (List)b2.a();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new ArrayList();
            }
        }
        return Currency.load(file);
    }

    private static Currency fromCSV(String string) {
        if (h.g(string) || string.indexOf(44) < 0) {
            return null;
        }
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        if (list.size() == 2) {
            return new Currency((String)list.get(0), (String)list.get(1));
        }
        if (list.size() == 3) {
            return new Currency((String)list.get(1), (String)list.get(2));
        }
        return null;
    }

    private static void toCSV(Currency currency, PrintWriter printWriter) {
        a.a(printWriter, currency.symbol, currency.description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Currency currency) {
        if (currency == null || currency.getSymbol() == null) {
            return;
        }
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            if (symbolMap.get(currency.getSymbol()) == currency) {
                return;
            }
            symbolMap.put(currency.getSymbol(), currency);
            allCurrencies.add(currency);
            allSymbols.add(currency.getSymbol());
            unsavedChanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency get(String string) {
        if (h.g(string)) {
            return null;
        }
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return (Currency)symbolMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return new ArrayList(allCurrencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllSymbols() {
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return new ArrayList(allSymbols);
        }
    }
}

