/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.service.ae;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class Balance
extends b
implements PropertyChangeListener {
    private String exchange;
    private String accountId;
    private String currency;
    private String name;
    private double held;
    private double available;
    private double totalBTC;
    private Map tickerMap = new HashMap();
    private Map ticker2CurrencyMap = new HashMap();

    public Balance(String string, String string2) {
        this.accountId = string;
        this.currency = string2;
    }

    @Override
    public void destroy() {
        if (this.tickerMap == null) {
            return;
        }
        for (LiveTicker liveTicker : this.tickerMap.values()) {
            liveTicker.removePropertyChangeListener(this);
        }
        this.tickerMap.clear();
        this.ticker2CurrencyMap.clear();
    }

    public String getCurrency() {
        return this.currency;
    }

    public Account getAccount() {
        return ae.a(this.accountId);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        Account account = this.getAccount();
        if (account == null) {
            return "";
        }
        return account.getAccountName();
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "currency": {
                return this.getCurrency();
            }
            case "account": {
                return this.getAccount();
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "name": {
                return this.getName();
            }
            case "held": {
                return this.getHeld();
            }
            case "available": {
                return this.getHeld();
            }
            case "total": {
                return this.getTotal();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "totalUSD": {
                return this.getTotal("USD");
            }
            case "totalBTC": {
                return this.getTotalBTC();
            }
            case "totalEUR": {
                return this.getTotal("EUR");
            }
            case "totalGBP": {
                return this.getTotal("GBP");
            }
            case "totalCAD": {
                return this.getTotal("CAD");
            }
            case "totalAUD": {
                return this.getTotal("AUD");
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "currency": {
                return this.getCurrency();
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "name": {
                return this.getName();
            }
            case "held": {
                return s.a(this.getHeld(), this.getCurrency());
            }
            case "available": {
                return s.a(this.getAvailable(), this.getCurrency());
            }
            case "total": {
                return s.a(this.getTotal(), this.getCurrency());
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "serviceType": {
                return this.getServiceType() == null ? "" : this.getServiceType().toString();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "totalUSD": {
                return s.a(this.getTotal("USD"), "USD");
            }
            case "totalBTC": {
                return s.a(this.getTotal("BTC"), "BTC");
            }
            case "totalEUR": {
                return s.a(this.getTotal("EUR"), "EUR");
            }
            case "totalGBP": {
                return s.a(this.getTotal("GBP"), "GBP");
            }
            case "totalCAD": {
                return s.a(this.getTotal("CAD"), "CAD");
            }
            case "totalAUD": {
                return s.a(this.getTotal("AUD"), "AUD");
            }
        }
        return super.format(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String string) {
        this.exchange = string;
    }

    public double getHeld() {
        return this.held;
    }

    public void setHeld(double d2) {
        double d3 = this.held;
        this.held = d2;
        this.firePropertyChange("held", d3, d2);
        this.firePropertyChange("total", 0.0, this.getTotal());
    }

    public double getAvailable() {
        return this.available;
    }

    public void setAvailable(double d2) {
        double d3 = this.available;
        this.available = d2;
        this.firePropertyChange("available", d3, d2);
        this.firePropertyChange("total", 0.0, this.getTotal());
    }

    public double getTotal() {
        return this.getAvailable() + this.getHeld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal(String string) {
        if (h.b((Object)string, (Object)this.currency)) {
            return this.getTotal();
        }
        if (h.b((Object)string, (Object)"BTC") && this.totalBTC != 0.0) {
            return this.totalBTC;
        }
        if (this.totalBTC == 0.0) {
            return this.getTotal();
        }
        Map map = this.tickerMap;
        synchronized (map) {
            LiveTicker liveTicker = (LiveTicker)this.tickerMap.get(string);
            if (liveTicker == null) {
                MWInstrument mWInstrument = MWInstrument.get("BTC/" + string, this.exchange, this.getServiceType());
                if (mWInstrument == null) {
                    mWInstrument = MWInstrument.get("BTC/" + string, this.getServiceType());
                }
                if (mWInstrument == null) {
                    return 0.0;
                }
                liveTicker = LiveTicker.get(mWInstrument);
                liveTicker.addPropertyChangeListener("bidPrice", this);
                liveTicker.addPropertyChangeListener("askPrice", this);
                liveTicker.addPropertyChangeListener("lastPrice", this);
                this.tickerMap.put(string, liveTicker);
                this.ticker2CurrencyMap.put(liveTicker, string);
            }
            return this.totalBTC * (double)liveTicker.getSellPrice();
        }
    }

    public void setTotalBTC(double d2) {
        double d3 = this.totalBTC;
        this.totalBTC = d2;
        this.firePropertyChange("totalBTC", d3, d2);
    }

    public double getTotalBTC() {
        return this.totalBTC == 0.0 ? this.getTotal("BTC") : this.totalBTC;
    }

    public String getServiceName() {
        Account account = this.getAccount();
        return account == null ? "" : account.getServiceName();
    }

    public Enums$ServiceType getServiceType() {
        Account account = this.getAccount();
        return account == null ? null : account.getServiceType();
    }

    public String getConnectionName() {
        Account account = this.getAccount();
        return account == null ? "" : account.getConnectionName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)this.ticker2CurrencyMap.get(propertyChangeEvent.getSource());
        if (string == null) {
            return;
        }
        this.firePropertyChange("total" + string, 0.0, this.getTotal(string));
    }
}

