/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Analysis;
import com.motivewave.platform.databean.AnalysisInfo;
import com.motivewave.platform.databean.AnalysisListener;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.f;
import com.motivewave.platform.service.ae;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalysisDirectory {
    private static k.f listeners = new k.f();

    public static void migrateFromDatabase() {
        if (!Workspace.hasDB()) {
            return;
        }
        try {
            b b2 = CommandFactory.createCmd("MIGRATE_ANALYSES");
            b2.a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addListener(AnalysisListener analysisListener) {
        listeners.a(analysisListener);
    }

    public static void removeListener(AnalysisListener analysisListener) {
        listeners.a(analysisListener);
    }

    public static Analysis load(MWInstrument mWInstrument, String string) {
        Analysis analysis;
        Object object;
        Object object2;
        if (mWInstrument == null) {
            return null;
        }
        Workspace workspace = ae.a();
        if (workspace.isOverrideRepository()) {
            object2 = workspace.getAnalysisSources().iterator();
            while (object2.hasNext()) {
                object = (AnalysisSource)object2.next();
                Object object3 = mWInstrument.getAnalysisFile(((AnalysisSource)object).getDirectory(), string);
                if (object3 == null || !((File)object3).exists() || (analysis = AnalysisDirectory.readAnalysis((File)object3)) == null) continue;
                if (((AnalysisSource)object).isReadOnly()) {
                    analysis.setReadOnly(true);
                }
                return analysis;
            }
        }
        if ((object2 = mWInstrument.getAnalysisFile(string)) != null && ((File)object2).exists()) {
            object = AnalysisDirectory.readAnalysis((File)object2);
            if (object == null) {
                object = new Analysis(string, mWInstrument);
                ((Analysis)object).setLastUpdated(((File)object2).lastModified());
                ((Analysis)object).setSrcFile((File)object2);
            }
            return object;
        }
        for (Object object3 : workspace.getAnalysisSources()) {
            object2 = mWInstrument.getAnalysisFile(((AnalysisSource)object3).getDirectory(), string);
            if (object2 == null || !((File)object2).exists() || (analysis = AnalysisDirectory.readAnalysis((File)object2)) == null) continue;
            if (((AnalysisSource)object3).isReadOnly()) {
                analysis.setReadOnly(true);
            }
            return analysis;
        }
        try {
            object = mWInstrument.getAnalysisFile(string);
            if (object == null) {
                return null;
            }
            long l2 = System.currentTimeMillis();
            Analysis analysis2 = new Analysis(string, mWInstrument);
            analysis2.setLastUpdated(l2);
            analysis2.setSrcFile((File)object);
            return analysis2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void rename(Analysis analysis, String string) {
        if (analysis == null || h.a((Object)analysis.getName(), (Object)string)) {
            return;
        }
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::rename() cannot rename read only: " + analysis.getInstrument().getSymbol() + " - " + analysis.getName());
            throw new MWException(com.motivewave.platform.common.h.E_ANALYSIS_RENAME_READONLY, analysis.getInstrument().getSymbol() + " - " + analysis.getName());
        }
        String string2 = analysis.getName();
        analysis.setName(string);
        if (analysis.getSrcFile() != null) {
            if (analysis.getSrcFile().exists() && !analysis.getSrcFile().delete()) {
                h.a.warning("AnalysisDirectory::rename() unable to delete src file: " + analysis.getSrcFile().getAbsolutePath());
            }
            analysis.setSrcFile(null);
        }
        AnalysisDirectory.write(analysis, false);
        for (AnalysisListener analysisListener : listeners.a()) {
            try {
                analysisListener.renamed(analysis, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void writeTo(Analysis analysis, AnalysisSource analysisSource) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (analysis.isReadOnly() || analysisSource.isReadOnly()) {
            h.a.warning("AnalysisDirectory::writeTo() cannot write read only: " + mWInstrument.getSymbol() + " - " + analysis.getName() + " " + analysisSource.getName());
            return;
        }
        File file = mWInstrument.getAnalysisFile(analysisSource.getDirectory(), analysis.getName());
        if (file == null) {
            h.a.warning("AnalysisDirectory::writeTo() cannot write file: " + mWInstrument.getSymbol() + " - " + analysis.getName() + " " + analysisSource.getName());
            return;
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            h.a(file, analysis.getData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Analysis analysis, boolean bl2) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (mWInstrument == null) {
            h.a.warning("AnalysisDirectory::write() instrument is missing for analysis: " + analysis.getName());
            h.c();
            return;
        }
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::write() cannot write read only: " + mWInstrument.getSymbol() + " - " + analysis.getName());
            throw new MWException(com.motivewave.platform.common.h.E_ANALYSIS_SAVE_READONLY, mWInstrument.getSymbol() + " - " + analysis.getName());
        }
        try {
            block16: {
                analysis.setWriteInProgress(true);
                analysis.setLastUpdated(System.currentTimeMillis());
                if (analysis.getSrcFile() == null) {
                    try {
                        File file = mWInstrument.getAnalysisFile(analysis.getName());
                        if (file == null) {
                            h.a.warning("AnalysisDirectory::write() unable to get source file: " + mWInstrument.getSymbol() + " - " + analysis.getName());
                            break block16;
                        }
                        h.a(file, analysis.getData());
                        analysis.setSrcFile(file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (analysis.getSrcFile() != null) {
                    try {
                        h.a(analysis.getSrcFile(), analysis.getData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            analysis.updateTimestamp();
        }
        finally {
            analysis.setWriteInProgress(false);
        }
        if (bl2) {
            for (AnalysisListener analysisListener : listeners.a()) {
                analysisListener.added(analysis);
            }
        }
    }

    public static void delete(Analysis analysis) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::delete() cannot delete read only: " + mWInstrument.getSymbol() + " - " + analysis.getName());
            return;
        }
        File file = analysis.getSrcFile();
        if (file != null && file.exists() && !file.delete()) {
            h.a.warning("AnalysisDirectory::delete() unable to delete src file: " + file.getAbsolutePath());
        }
        for (AnalysisListener analysisListener : listeners.a()) {
            analysisListener.removed(analysis);
        }
    }

    public static List getNames(MWInstrument mWInstrument) {
        List list = AnalysisDirectory.getInfos(mWInstrument);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AnalysisInfo analysisInfo : list) {
            arrayList.add(analysisInfo.getName());
        }
        if (h.a(arrayList)) {
            arrayList.add("Primary Analysis");
        } else if (!arrayList.contains("Primary Analysis")) {
            arrayList.add(0, "Primary Analysis");
        }
        return arrayList;
    }

    private static File getRootDir() {
        Workspace workspace = ae.a();
        return workspace.isUseDatabase() ? Workspace.getWorkspaceDir() : workspace.getRepoDir();
    }

    public static List getAll(MWInstrument mWInstrument) {
        File file;
        ArrayList arrayList = new ArrayList();
        File file2 = new File(AnalysisDirectory.getRootDir(), "analysis");
        if (!file2.exists()) {
            return arrayList;
        }
        File file3 = new File(file2, mWInstrument.getType().name());
        if (!file3.exists()) {
            return arrayList;
        }
        String string = mWInstrument.getSymbolDir();
        if (h.g(string)) {
            string = s.a(mWInstrument);
        }
        if (!(file = new File(file3, string)).exists()) {
            file = new File(file3, mWInstrument.getKey());
        }
        if (!file.exists()) {
            return arrayList;
        }
        AnalysisDirectory.readAnalysisFiles(file, arrayList);
        return arrayList;
    }

    public static List getAllInfos() {
        ArrayList arrayList = new ArrayList();
        for (MWInstrument mWInstrument : MWInstrument.getAll()) {
            AnalysisDirectory.addFromDir(AnalysisDirectory.getRootDir(), mWInstrument, arrayList);
        }
        return arrayList;
    }

    public static List getInfos(MWInstrument mWInstrument) {
        return AnalysisDirectory.getInfos(mWInstrument, true);
    }

    public static List getInfos(MWInstrument mWInstrument, boolean bl2) {
        ArrayList<AnalysisInfo> arrayList = new ArrayList<AnalysisInfo>();
        AnalysisDirectory.addFromDir(AnalysisDirectory.getRootDir(), mWInstrument, arrayList);
        for (Object object : ae.a().getAnalysisSources()) {
            AnalysisDirectory.addFromDir(((AnalysisSource)object).getDirectory(), mWInstrument, arrayList);
        }
        if (bl2) {
            boolean bl3 = false;
            for (AnalysisInfo analysisInfo : arrayList) {
                if (!analysisInfo.isPrimary()) continue;
                bl3 = true;
            }
            if (!bl3) {
                arrayList.add(0, new AnalysisInfo(mWInstrument, "Primary Analysis", System.currentTimeMillis()));
            }
        }
        return arrayList;
    }

    private static void addFromDir(File file, MWInstrument mWInstrument, List list) {
        File file2 = mWInstrument.getAnalysisDirectory(file);
        if (file2 == null || !file2.exists() || !file2.isDirectory()) {
            return;
        }
        for (File file3 : file2.listFiles()) {
            AnalysisInfo analysisInfo;
            String string;
            if (file3.isDirectory() || !(string = file3.getName()).toUpperCase().endsWith(".MWML") || list.contains(analysisInfo = new AnalysisInfo(mWInstrument, string = string.substring(0, string.lastIndexOf(46)), file3.lastModified()))) continue;
            list.add(analysisInfo);
        }
    }

    private static void readAnalysisFiles(File file, List list) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                AnalysisDirectory.readAnalysisFiles(file2, list);
                continue;
            }
            if (!file2.getName().toUpperCase().endsWith(".MWML")) continue;
            try {
                Analysis analysis = AnalysisDirectory.readAnalysis(file2);
                if (analysis == null) continue;
                list.add(analysis);
            }
            catch (Exception exception) {
                h.a.warning("AnalysisDirectory::readAnalysisFile() error reading analysis file: " + file2.getAbsolutePath() + " error: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static Analysis readAnalysis(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            Object object;
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            long l2 = file.lastModified();
            String string2 = h.a(file);
            if (h.g(string2)) {
                return null;
            }
            MWInstrument mWInstrument = MWInstrument.getByKey(file.getParentFile().getName());
            if (mWInstrument == null) {
                if (q.a(string2)) {
                    object = new JSONObject(string2);
                    if (!((JSONObject)object).has("instr")) {
                        h.a.warning("AnalsisDirectory::readAnalysis() instrument not defined: " + file.getAbsolutePath() + " contents: " + string2);
                        return null;
                    }
                    mWInstrument = new f().a(((JSONObject)object).str("instr"));
                } else {
                    object = g.a(string2);
                    if (object == null) {
                        h.a.warning("AnalsisDirectoryt::readAnalysis() unable to read xml file: " + file.getAbsolutePath() + " contents: " + string2);
                        return null;
                    }
                    Node node = object.getDocumentElement();
                    if (!h.b((Object)node.getTagName(), (Object)"analysis")) {
                        node = g.b("analysis", node);
                    }
                    if (node == null) {
                        return null;
                    }
                    mWInstrument = MWInstrument.read((Element)g.b("instrument", node));
                }
            }
            if (mWInstrument == null) {
                return null;
            }
            object = new Analysis(string, mWInstrument);
            ((Analysis)object).setLastUpdated(l2);
            ((Analysis)object).setData(string2);
            ((Analysis)object).setSrcFile(file);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

