/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import com.motivewave.common.h;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.ae;
import java.io.File;
import k.z;

public class Analysis
extends b
implements InstrumentListener,
z {
    public static final String PRIMARY_NAME = "Primary Analysis";
    private MWInstrument instrument;
    private String name = "";
    private String data;
    private long lastUpdated;
    private File srcFile;
    private long srcLastUpdated = 0L;
    private boolean readOnly = false;
    private boolean writeInProgress = false;

    public Analysis(MWInstrument mWInstrument) {
        this.setInstrument(mWInstrument);
    }

    public Analysis(String string, MWInstrument mWInstrument) {
        this(mWInstrument);
        this.name = string;
    }

    @Override
    public void destroy() {
        if (this.instrument == null) {
            return;
        }
        this.instrument.removeListener(this);
        this.instrument = null;
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "lastUpdated": {
                return h.f(this.lastUpdated);
            }
            case "name": {
                return h.b((Object)this.name);
            }
            case "primary": {
                return h.b((Object)this.isPrimary());
            }
            case "untitled": {
                return h.b((Object)this.isUntitled());
            }
            case "readOnly": {
                return h.b((Object)this.isReadOnly());
            }
            case "instrument": {
                return this.instrument == null ? "" : this.instrument.getKey();
            }
        }
        return h.b(this.getProperty(string));
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "lastUpdated": {
                return this.lastUpdated;
            }
            case "name": {
                return this.name;
            }
            case "data": {
                return this.data;
            }
            case "srcFile": {
                return this.srcFile;
            }
            case "srcLastUpdated": {
                return this.srcLastUpdated;
            }
            case "primary": {
                return this.isPrimary();
            }
            case "untitled": {
                return this.isUntitled();
            }
            case "readOnly": {
                return this.isReadOnly();
            }
            case "instrument": {
                return this.instrument;
            }
            case "writeInProgress": {
                return this.isWriteInProgress();
            }
        }
        return super.getProperty(string);
    }

    public boolean isUntitled() {
        return h.g(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String string) {
        this.data = string;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long l2) {
        this.lastUpdated = l2;
    }

    public boolean isPrimary() {
        return h.a((Object)this.name, (Object)PRIMARY_NAME);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == this.instrument) {
            return;
        }
        if (this.instrument != null) {
            this.instrument.removeListener(this);
        }
        this.instrument = mWInstrument;
        if (this.instrument != null) {
            this.instrument.addListener(this);
        }
    }

    public File checkNewSrcFile() {
        Workspace workspace = ae.a();
        if (!workspace.isOverrideRepository()) {
            return null;
        }
        for (AnalysisSource analysisSource : workspace.getAnalysisSources()) {
            File file = this.getInstrument().getAnalysisFile(analysisSource.getDirectory(), this.getName());
            if (file == null || !file.exists() || this.srcFile != null && this.srcFile.equals(file)) continue;
            return file;
        }
        return null;
    }

    @Override
    public void keyUpdated(MWInstrument mWInstrument, String string, String string2) {
        this.srcFile = this.getInstrument().getAnalysisFile(this.getName());
        this.updateTimestamp();
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File file) {
        this.srcFile = file;
        this.updateTimestamp();
        if (this.srcFile != null && this.srcFile.exists() && !this.srcFile.canWrite()) {
            this.readOnly = true;
        }
    }

    public void clearSrcFile() {
        this.srcFile = null;
        this.readOnly = false;
        this.srcLastUpdated = 0L;
    }

    public long getSrcLastUpdated() {
        return this.srcLastUpdated;
    }

    public void setSrcLastUpdated(long l2) {
        this.srcLastUpdated = l2;
    }

    public void updateTimestamp() {
        if (this.srcFile == null || !this.srcFile.exists()) {
            return;
        }
        this.srcLastUpdated = this.srcFile.lastModified();
    }

    @Override
    public Analysis clone() {
        return (Analysis)super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Analysis)) {
            return false;
        }
        Analysis analysis = (Analysis)object;
        return this.name.equals(analysis.name) && this.instrument == analysis.instrument;
    }

    public boolean isWriteInProgress() {
        return this.writeInProgress;
    }

    void setWriteInProgress(boolean bl2) {
        this.writeInProgress = bl2;
    }

    public String toString() {
        return "Analysis name: " + this.name + " instrument: " + this.getInstrument();
    }
}

