/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.c;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.h;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Alert;
import com.motivewave.platform.databean.AlertHistory;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.d;
import com.motivewave.platform.databean.e;
import com.motivewave.platform.ui.draw.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import k.f;
import k.g;
import k.q;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import q.a;

public class AlertDirectory {
    private static f history = new f();
    private static f allAlerts = new f();
    private static f listeners = new f();
    private static boolean unsavedAlerts = false;
    private static boolean unsavedHistory = false;

    public static void register(Alert alert) {
        if (alert == null || allAlerts.b(alert)) {
            return;
        }
        allAlerts.a(alert);
        if (alert.isGlobal() && !alert.isReplay()) {
            unsavedAlerts = true;
        }
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.a(alert);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }

    public static void update(Alert alert) {
        if (alert == null || !allAlerts.b(alert)) {
            return;
        }
        if (alert.isGlobal() && !alert.isReplay()) {
            unsavedAlerts = true;
        }
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.c(alert);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }

    public static void remove(Alert alert) {
        if (alert == null || !allAlerts.b(alert)) {
            return;
        }
        allAlerts.a(alert);
        if (alert.isGlobal() && !alert.isReplay()) {
            unsavedAlerts = true;
        }
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.b(alert);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                alert.destroy();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activated(Alert alert, String string) {
        AlertHistory alertHistory = new AlertHistory(alert.getInstrument(), alert.isGlobal(), alert.isReplay(), alert.getInput(), alert.getName(), alert.getBarSize(), alert.isSignal(), alert.getSignalName(), alert.getFormattedLastTriggeredValue(), alert.getLastTriggeredValue(), alert.getLastActivated(), alert.getLastLocation(), string, alert.getGraph());
        f f2 = history;
        synchronized (f2) {
            history.a(b.c(), b.c() + 50);
            history.a(0, alertHistory);
            unsavedHistory = true;
        }
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.a(alert, alertHistory);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        });
    }

    public static List getByInstrument(MWInstrument mWInstrument) {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        for (Alert alert : allAlerts.a()) {
            if (alert.getInstrument() != mWInstrument) continue;
            arrayList.add(alert);
        }
        return arrayList;
    }

    public static List getHistory() {
        return history.a();
    }

    public static List getHistory(MWInstrument mWInstrument) {
        ArrayList<AlertHistory> arrayList = new ArrayList<AlertHistory>();
        for (AlertHistory alertHistory : history.a()) {
            if (alertHistory.getInstrument() != mWInstrument) continue;
            arrayList.add(alertHistory);
        }
        return arrayList;
    }

    public static void clearReplayHistory(Graph graph) {
        for (AlertHistory alertHistory : history.a()) {
            if (!alertHistory.isReplay() || alertHistory.getGraph() != graph) continue;
            history.a(alertHistory);
        }
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.a();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        });
    }

    public static void addListener(a a2) {
        listeners.a(a2);
    }

    public static void removeListener(a a2) {
        listeners.a(a2);
    }

    public static List getAll() {
        return allAlerts.a();
    }

    public static void clearHistory() {
        File file = Workspace.findDir("alert_history");
        h.a(new File(file, "alert_history.json"), "");
        if (Workspace.hasDB()) {
            try {
                CommandFactory.createCmd("DELETE_ALL_ALERT_HISTORY").a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        history.b();
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.a();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        });
    }

    public static void removeHistory(AlertHistory alertHistory) {
        if (!history.b(alertHistory)) {
            return;
        }
        history.a(alertHistory);
        unsavedHistory = true;
        c.a(() -> {
            Class<AlertDirectory> clazz = AlertDirectory.class;
            synchronized (AlertDirectory.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.a(alertHistory);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }

    public static void saveAll() {
        File file = Workspace.findDir("alert_history");
        if (unsavedAlerts) {
            AlertDirectory.saveAlerts(file);
        }
        if (unsavedHistory) {
            AlertDirectory.saveHistory(file);
        }
        unsavedHistory = false;
        unsavedAlerts = false;
    }

    private static void saveAlerts(File file) {
        List list = h.b(new Alert[0]);
        for (Alert alert : allAlerts.a()) {
            if (!alert.isGlobal() || alert.isReplay()) continue;
            list.add(alert);
        }
        h.a(new File(file, "alerts.json"), new d().b(list));
    }

    private static void saveHistory(File file) {
        List list = history.a();
        if (list.size() > b.c()) {
            Collections.sort(list, (alertHistory, alertHistory2) -> {
                if (alertHistory == null) {
                    return -1;
                }
                if (alertHistory2 == null) {
                    return 1;
                }
                return Long.compare(alertHistory2.getActivated(), alertHistory.getActivated());
            });
            list = h.a(list, 0, b.c());
        }
        h.a(new File(file, "alert_history.json"), new e().b(list));
    }

    public static void saveAll(File file) {
        AlertDirectory.saveAlerts(file);
        AlertDirectory.saveHistory(file);
    }

    private static void readAlerts(File file) {
        String string = h.a(file);
        allAlerts.b();
        if (h.g(string)) {
            unsavedAlerts = false;
            return;
        }
        try {
            if (q.a(string)) {
                for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                    Alert alert = new Alert(true);
                    alert.fromJSON(jSONObject);
                    if (alert.isExpired() || alert.getInstrument() == null) continue;
                    for (Alert alert2 : allAlerts.a()) {
                        if (!alert.is(alert2)) continue;
                        h.a.warning("AlertDirectory::read() removing duplicate alert:\n" + alert2 + "\n" + alert);
                        allAlerts.a(alert2);
                    }
                    allAlerts.a(alert);
                }
                unsavedAlerts = false;
            } else {
                for (Element element : g.c("alert", g.a(string))) {
                    Alert alert = new Alert(true, element);
                    if (alert.isExpired() || alert.getInstrument() == null) continue;
                    for (Alert alert3 : allAlerts.a()) {
                        if (!alert.is(alert3)) continue;
                        h.a.warning("AlertDirectory::read() removing duplicate alert:\n" + alert3 + "\n" + alert);
                        allAlerts.a(alert3);
                    }
                    allAlerts.a(alert);
                }
                unsavedAlerts = true;
            }
        }
        catch (Exception exception) {
            h.a.warning("AlertDirectory::loadAlerts() error reading alerts: " + exception.getMessage() + " " + string);
            exception.printStackTrace();
        }
    }

    public static void read() {
        Object object;
        File file = Workspace.findFile("alerts");
        if (file != null) {
            AlertDirectory.readAlerts(file);
        } else if (Workspace.hasDB()) {
            try {
                object = CommandFactory.createCmd("LOAD_ALERTS");
                allAlerts.d((List)object.a());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            unsavedAlerts = true;
        }
        file = Workspace.findFile("alert_history");
        if (file != null) {
            try {
                history.b();
                object = h.a(file);
                if (!h.g((String)object)) {
                    long l2 = 86400000L * (long)b.N();
                    for (JSONObject jSONObject : new JSONArray((String)object).asObjList()) {
                        AlertHistory alertHistory = new AlertHistory(jSONObject);
                        if (alertHistory.getActivated() <= l2) continue;
                        history.a(alertHistory);
                    }
                }
                unsavedHistory = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        unsavedHistory = true;
        if (!Workspace.hasDB()) {
            return;
        }
        try {
            CommandFactory.createCmd("CLEANUP_ALERT_HISTORY").a();
            object = CommandFactory.createCmd("LOAD_ALERT_HISTORY");
            history.d((List)object.a());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

