/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import ba.c;
import by.b;
import cn.cl;
import cn.dr;
import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$AlertInput;
import com.motivewave.platform.common.Enums$AlertOperator;
import com.motivewave.platform.common.Enums$Align;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.an;
import com.motivewave.platform.common.ao;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.AlertCondition;
import com.motivewave.platform.databean.AlertDirectory;
import com.motivewave.platform.databean.AlertHistory;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.ui.console.Console;
import com.motivewave.platform.ui.draw.Graph;
import com.motivewave.platform.ui.draw.component.graph.ap;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import k.f;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Alert
extends a.b
implements o,
PropertyChangeListener {
    public static String F_BARSIZE = "barSize";
    public static String F_LAST_ACTIVATED = "lastActivated";
    public static String F_LAST_LOCATION = "lastLocation";
    public static String F_LAST_VALUE = "lastValue";
    public static String F_NAME = "name";
    public static String F_SHOW_LABEL = "showLabel";
    public static String F_ORDER = "order";
    public static String F_ORDER_NAME = "orderName";
    public static String F_SYMBOL = "symbol";
    public static String F_CHART = "chart";
    public static String F_CANCEL = "cancel";
    public static String F_SIGNAL_NAME = "signalName";
    public static String F_INPUT = "input";
    public static String F_TARGET_VALUE = "targetValue";
    public static String F_TARGET_INPUT = "targetInput";
    public static String F_EXPIRES = "expires";
    public static String F_TIME_ZONE = "timeZone";
    public static String F_USE_DEFAULT_TIME_ZONE = "useDefaultTimeZone";
    public static String F_CONDITION = "condition";
    public static String F_SESSION1_START = "session1Start";
    public static String F_SESSION1_END = "session1End";
    public static String F_SESSION1_ENABLED = "session1Enabled";
    public static String F_SESSION2_START = "session2Start";
    public static String F_SESSION2_END = "session2End";
    public static String F_SESSION2_ENABLED = "session2Enabled";
    private int id = -1;
    private f prevValues = new f();
    private List conditions;
    private long expires = -1L;
    private int session1Start = 32400000;
    private int session1End = 57600000;
    private boolean session1Enabled = false;
    private int session2Start = 32400000;
    private int session2End = 57600000;
    private boolean session2Enabled = false;
    private TimeZone timeZone;
    private boolean useDefaultTimeZone = true;
    private boolean showAlert = com.motivewave.platform.common.b.u();
    private boolean playSound = com.motivewave.platform.common.b.w();
    private boolean usePresetSound = com.motivewave.platform.common.b.x();
    private boolean sendEmail = com.motivewave.platform.common.b.y();
    private boolean attachImage = com.motivewave.platform.common.b.z();
    private String emailAddress = com.motivewave.platform.common.b.i();
    private File soundFile = com.motivewave.platform.common.b.a();
    private String name;
    private String signalName;
    private String comments;
    private String label;
    private boolean signal = false;
    private String message;
    private BarSize barSize;
    private long lastActivated;
    private long lastLocation;
    private Ticker ticker;
    private boolean replay = false;
    private boolean global = false;
    private MWOrder order;
    private boolean orderSubmitted = false;
    private boolean triggerMultiple = false;
    private boolean enabled = true;
    private double lastValue;
    private String formattedLastValue;
    private String formattedLastTriggeredValue = "";
    private double lastTriggeredValue;
    private boolean destroyed = false;
    private Boolean showBtn;
    private Boolean showLine;
    private Boolean showLabel;
    private Enums$Align align;
    private WeakReference graph;
    private com.motivewave.platform.ui.draw.component.f component;
    private Object componentId;

    public Alert() {
        this.conditions = new ArrayList();
        this.conditions.add(new AlertCondition());
    }

    public Alert(boolean bl2) {
        this();
        this.setGlobal(bl2);
    }

    public Alert(int n2, boolean bl2, String string) {
        this();
        this.id = n2;
        this.global = bl2;
        if (q.a(string)) {
            this.b(string);
        } else {
            this.read(g.a(string));
        }
    }

    Alert(boolean bl2, Element element) {
        this.conditions = new ArrayList();
        this.conditions.add(new AlertCondition());
        this.global = bl2;
        this.read(element);
    }

    public Alert(Graph graph, Ticker ticker) {
        this();
        this.graph = new WeakReference<Graph>(graph);
        this.ticker = ticker;
        ticker.addPropertyChangeListener(this);
        this.replay = ticker.isReplay();
    }

    public int getId() {
        return this.id;
    }

    public boolean is(Alert alert) {
        if (alert == null) {
            return false;
        }
        if (alert == this) {
            return true;
        }
        if (this.expires != alert.expires) {
            return false;
        }
        if (this.replay != alert.replay) {
            return false;
        }
        if (this.global != alert.global) {
            return false;
        }
        if (this.ticker != alert.ticker) {
            return false;
        }
        if (this.signal != alert.signal) {
            return false;
        }
        if (!h.a(this.componentId, alert.componentId)) {
            return false;
        }
        if (!h.a((Object)this.barSize, (Object)alert.barSize)) {
            return false;
        }
        if (!h.c(this.conditions, alert.conditions)) {
            return false;
        }
        return h.a((Object)this.signalName, (Object)alert.signalName);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void reset() {
        this.prevValues.b();
        this.lastValue = 0.0;
        this.formattedLastValue = null;
        this.formattedLastTriggeredValue = null;
        this.lastTriggeredValue = 0.0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isGlobal() || this.isReplay() || !this.enabled) {
            return;
        }
        if (this.isExpired()) {
            AlertDirectory.remove(this);
            return;
        }
        if (!this.isValidTime()) {
            return;
        }
        Enums$AlertOperator enums$AlertOperator = this.getOperator();
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null || enums$AlertOperator == null) {
            return;
        }
        if (!(h.a((Object)this.getInput(), (Object)Enums$AlertInput.ASK_PRICE.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"askPrice") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.LAST_PRICE.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"lastPrice") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.BID_PRICE.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"bidPrice") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.DAY_CLOSE.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"close") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.DAY_OPEN.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"open") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.DAY_HIGH.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"high") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.DAY_LOW.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"low") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.HIGH_YEAR.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"highCalendarYear") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.LOW_YEAR.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"lowCalendarYear") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.HIGH_52_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"high52Week") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.LOW_52_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"low52Week") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.HIGH_26_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"high26Week") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.LOW_26_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"low26Week") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.HIGH_13_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"high13Week") || h.a((Object)this.getInput(), (Object)Enums$AlertInput.LOW_13_WEEK.name()) && h.a((Object)propertyChangeEvent.getPropertyName(), (Object)"low13Week"))) {
            return;
        }
        double d2 = mWInstrument.round(h.a(propertyChangeEvent.getNewValue()));
        if (!mWInstrument.isValueValid(d2)) {
            return;
        }
        this.setFormattedLastValue(mWInstrument.formatValue(d2));
        this.setLastValue(d2);
        if (this.prevValues == null) {
            this.setPrevValue(d2);
            return;
        }
        boolean bl2 = this.isTriggered(d2);
        this.setPrevValue(d2);
        if (bl2) {
            if (!this.triggerMultiple) {
                this.enabled = false;
            }
            this.lastTriggeredValue = d2;
            this.formattedLastTriggeredValue = mWInstrument.formatValue(d2);
            long l2 = this.getCurrentTime();
            com.motivewave.common.c.a(() -> {
                this.doNotification(l2);
                if (!this.isTriggerMultiple()) {
                    AlertDirectory.remove(this);
                }
            });
        }
    }

    private boolean isTriggered(double d2) {
        Double d3 = this.computeTargetValue();
        if (d3 == null) {
            return false;
        }
        if (this.prevValues == null) {
            return false;
        }
        return this.isTriggered(d2, this.prevValues.a(), d3, d3);
    }

    public boolean isTriggered(double d2, List list, double d3, double d4) {
        return ((AlertCondition)this.conditions.get(0)).eval(d2, list, d3, d4);
    }

    public void updateLastValue() {
        String string = this.getInput();
        if (h.g(string)) {
            return;
        }
        Graph graph = this.getGraph();
        if (graph != null) {
            b b2 = graph.a(string);
            if (b2 == null) {
                return;
            }
            Object object = b2.a(graph);
            if (object != null && object instanceof Number) {
                ap ap2 = graph.a(string);
                double d2 = ap2.a(h.a(object));
                this.setFormattedLastValue(ap2.a(d2));
                this.setLastValue(d2);
            }
            return;
        }
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument == null) {
            return;
        }
        Ticker ticker = this.getTicker();
        double d3 = 0.0;
        if (h.a((Object)string, (Object)"LAST_PRICE")) {
            d3 = ticker.getLastPrice();
        } else if (h.a((Object)string, (Object)"BID_PRICE")) {
            d3 = ticker.getBidPrice();
        } else if (h.a((Object)string, (Object)"ASK_PRICE")) {
            d3 = ticker.getAskPrice();
        }
        if (d3 == 0.0) {
            return;
        }
        d3 = mWInstrument.round(d3);
        this.setFormattedLastValue(mWInstrument.formatValue(d3));
        this.setLastValue(d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotification(long l2) {
        String string = this.formattedLastTriggeredValue;
        Graph graph = this.getGraph();
        Object object = Alert.class;
        synchronized (Alert.class) {
            Object object2;
            a.b b2;
            long l3;
            Object object3 = AlertDirectory.getHistory().iterator();
            while (object3.hasNext() && (l3 = l2 - ((AlertHistory)(b2 = (AlertHistory)object3.next())).getActivated()) <= 5000L) {
                if (!this.isEquivalent((AlertHistory)b2) || this.isReplay()) continue;
                h.a.warning("Alert::doNotification() ignoring duplicate alert: " + this.toString());
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            this.setLastActivated(l2);
            object3 = this.getOrderName();
            if (this.orderSubmitted) {
                object3 = "";
            }
            AlertDirectory.activated(this, (String)object3);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            object = graph == null ? Console.a() : graph.a();
            object3 = null;
            b2 = this.order;
            if (b2 != null && an.k() && !this.orderSubmitted && ((MWOrder)b2).isNew()) {
                this.orderSubmitted = true;
                try {
                    MWOrder mWOrder = ((MWOrder)b2).getLimitOrder();
                    object2 = ((MWOrder)b2).getStopTrailOrder();
                    OrderDirectory.createOrder((MWOrder)b2);
                    if (mWOrder != null || object2 != null) {
                        ae.a((MWOrder)b2, null, null, (MWOrder)object2, mWOrder, false, (dr)object);
                    } else {
                        ae.a((MWOrder)b2, (dr)object);
                    }
                }
                catch (MWException mWException) {
                    object3 = mWException.getMessage();
                }
            }
            if (this.isShowAlert() && !com.motivewave.platform.common.b.v()) {
                c.b();
            }
            if (!h.g((String)object3)) {
                cl cl2 = this.isShowAlert() ? c.a() : object.b();
                cl2.d("TITLE_ERROR_PLACE_ALERT_ORDER", (String)object3);
            }
            if (this.isPlaySound()) {
                if (this.isUsePresetSound()) {
                    ao.a().a();
                } else {
                    ao.a().j(this.getSoundFile());
                }
            }
            if (this.isSendEmail()) {
                String string2;
                Object object4 = ai.a("EMAIL_ALERT_SUBJECT", new Object[0]);
                if (!h.g(this.getLabel())) {
                    object4 = (String)object4 + " " + this.getLabel();
                }
                object4 = (String)object4 + " " + this.getSymbolDisplay() + " " + h.b((Object)this.getName()) + " " + h.b((Object)this.getSignalName());
                if (!h.g(string)) {
                    object4 = (String)object4 + " (" + ai.a("LBL_VALUE", new Object[0]) + ": " + string + ")";
                }
                object2 = ai.a("LBL_ALL", new Object[0]);
                if (this.barSize != null) {
                    object2 = this.barSize.toString();
                }
                String string3 = h.g(l2);
                Object object5 = "";
                if (!h.g(this.getSignalName())) {
                    object5 = ai.a("EMAIL_SIGNAL_BODY", new Object[0]) + "\r\n";
                    if (!h.g(this.getLabel())) {
                        object5 = (String)object5 + ai.a("LBL_LABEL", this.getLabel()) + "\r\n";
                    }
                    object5 = (String)object5 + ai.a("LBL_TIME", new Object[0]) + ": " + string3 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_SYMBOL", new Object[0]) + ": " + this.getSymbolDisplay();
                    string2 = "";
                    if (this.getInstrument() != null) {
                        string2 = this.getInstrument().getDescription();
                        if (h.g(string2)) {
                            string2 = this.getInstrument().getTitle();
                        }
                        if (h.a((Object)string2, (Object)this.getSymbolDisplay())) {
                            string2 = "";
                        }
                    }
                    if (!h.g(string2)) {
                        object5 = (String)object5 + " - " + string2;
                    }
                    object5 = (String)object5 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_BAR_SIZE", new Object[0]) + ": " + (String)object2 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_NAME", new Object[0]) + ": " + this.getName() + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_SIGNAL", new Object[0]) + ": " + this.getSignalName() + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_MESSAGE", new Object[0]) + ": " + this.getMessage() + "\r\n";
                    if (!h.g(string)) {
                        object5 = (String)object5 + ai.a("LBL_VALUE", new Object[0]) + ": " + string + "\r\n";
                    }
                } else {
                    object5 = ai.a("EMAIL_ALERT_BODY", new Object[0]) + "\r\n";
                    if (!h.g(this.getLabel())) {
                        object5 = (String)object5 + ai.a("LBL_LABEL", new Object[0]) + ": " + this.getLabel() + "\r\n";
                    }
                    object5 = (String)object5 + ai.a("LBL_TIME", new Object[0]) + ": " + string3 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_SYMBOL", new Object[0]) + ": " + this.getSymbolDisplay();
                    string2 = "";
                    if (this.getInstrument() != null) {
                        string2 = this.getInstrument().getDescription();
                        if (h.g(string2)) {
                            string2 = this.getInstrument().getTitle();
                        }
                        if (h.a((Object)string2, (Object)this.getSymbolDisplay())) {
                            string2 = "";
                        }
                    }
                    if (!h.g(string2)) {
                        object5 = (String)object5 + " - " + string2;
                    }
                    object5 = (String)object5 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_BAR_SIZE", new Object[0]) + ": " + (String)object2 + "\r\n";
                    object5 = (String)object5 + ai.a("LBL_CONDITION", new Object[0]) + ": " + this.getName() + "\r\n";
                    if (!h.g(string)) {
                        object5 = (String)object5 + ai.a("LBL_VALUE", new Object[0]) + ": " + string + "\r\n";
                    }
                }
                if (!h.g(this.getComments())) {
                    object5 = (String)object5 + "\r\n" + ai.a("EMAIL_ALERT_COMMENTS", this.getComments());
                }
                if (h.g(string2 = this.getEmailAddress())) {
                    string2 = com.motivewave.platform.common.b.i();
                }
                if (h.g(string2)) {
                    h.a.warning("Alert::doNotification() toEmail is empty");
                } else {
                    try {
                        if (graph != null && graph.a() != null && this.isAttachImage()) {
                            BufferedImage bufferedImage = graph.a().a();
                            s.a(string2, (String)object4, (String)object5, bufferedImage);
                        } else {
                            s.a(string2, (String)object4, (String)object5);
                        }
                    }
                    catch (Exception exception) {
                        cl cl3 = object.b();
                        if (cl3 != null) {
                            cl3.d("TITLE_ERROR_SEND_EMAIL", exception.getMessage());
                        }
                        exception.printStackTrace();
                    }
                }
            }
            return;
        }
    }

    public boolean isExpired() {
        if (this.expires <= 0L) {
            return false;
        }
        return this.expires < this.getCurrentTime();
    }

    public boolean isValidTime() {
        long l2;
        if (!this.session1Enabled) {
            return true;
        }
        long l3 = this.getCurrentTime();
        if (l3 >= (l2 = h.a(l3, this.getTimeZone())) + (long)this.session1Start && l3 <= l2 + (long)this.session1End) {
            return true;
        }
        if (!this.session2Enabled) {
            return false;
        }
        return l3 >= l2 + (long)this.session2Start && l3 <= l2 + (long)this.session2End;
    }

    public long getCurrentTime() {
        if (this.isReplay() && this.graph != null && this.graph.get() != null && !((Graph)this.graph.get()).e()) {
            return ((Graph)this.graph.get()).a().d();
        }
        return ae.a();
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long l2) {
        long l3 = l2;
        this.expires = l2;
        this.firePropertyChange(F_EXPIRES, l3, l2);
    }

    public int getSession1Start() {
        return this.session1Start;
    }

    public void setSession1Start(int n2) {
        int n3 = this.session1Start;
        this.session1Start = n2;
        this.firePropertyChange(F_SESSION1_START, n3, this.session1Start);
    }

    public int getSession1End() {
        return this.session1End;
    }

    public void setSession1End(int n2) {
        int n3 = this.session1End;
        this.session1End = n2;
        this.firePropertyChange(F_SESSION1_END, n3, this.session1End);
    }

    public boolean isSession1Enabled() {
        return this.session1Enabled;
    }

    public void setSession1Enabled(boolean bl2) {
        boolean bl3 = this.session1Enabled;
        this.session1Enabled = bl2;
        this.firePropertyChange(F_SESSION1_ENABLED, bl3, this.session1Enabled);
    }

    public int getSession2Start() {
        return this.session2Start;
    }

    public void setSession2Start(int n2) {
        int n3 = this.session2Start;
        this.session2Start = n2;
        this.firePropertyChange(F_SESSION2_START, n3, this.session2Start);
    }

    public int getSession2End() {
        return this.session2End;
    }

    public void setSession2End(int n2) {
        int n3 = this.session2End;
        this.session2End = n2;
        this.firePropertyChange(F_SESSION2_END, n3, this.session2End);
    }

    public boolean isSession2Enabled() {
        return this.session2Enabled;
    }

    public void setSession2Enabled(boolean bl2) {
        boolean bl3 = this.session2Enabled;
        this.session2Enabled = bl2;
        this.firePropertyChange(F_SESSION2_ENABLED, bl3, this.session2Enabled);
    }

    public TimeZone getTimeZone() {
        if (this.useDefaultTimeZone || this.timeZone == null) {
            Graph graph = this.getGraph();
            if (graph != null && !graph.e()) {
                return graph.a().a();
            }
            return com.motivewave.platform.common.b.a();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = this.timeZone;
        this.timeZone = timeZone;
        this.firePropertyChange(F_TIME_ZONE, timeZone2, this.timeZone);
    }

    public boolean isUseDefaultTimeZone() {
        return this.useDefaultTimeZone;
    }

    public void setUseDefaultTimeZone(boolean bl2) {
        boolean bl3 = this.useDefaultTimeZone;
        this.useDefaultTimeZone = bl2;
        this.firePropertyChange(F_USE_DEFAULT_TIME_ZONE, bl3, this.useDefaultTimeZone);
    }

    public boolean isOrderSubmitted() {
        return this.orderSubmitted;
    }

    public boolean isTriggerMultiple() {
        return this.triggerMultiple;
    }

    public void setTriggerMultiple(boolean bl2) {
        this.triggerMultiple = bl2;
    }

    public boolean isShowAlert() {
        return this.showAlert;
    }

    public void setShowAlert(boolean bl2) {
        this.showAlert = bl2;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean bl2) {
        this.playSound = bl2;
    }

    public boolean isUsePresetSound() {
        return this.usePresetSound;
    }

    public void setUsePresetSound(boolean bl2) {
        this.usePresetSound = bl2;
    }

    public File getSoundFile() {
        return this.soundFile;
    }

    public void setSoundFile(File file) {
        this.soundFile = file;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean bl2) {
        this.sendEmail = bl2;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    public boolean isAttachImage() {
        return this.attachImage;
    }

    public void setAttachImage(boolean bl2) {
        this.attachImage = bl2;
    }

    public long getLastActivated() {
        return this.lastActivated;
    }

    public void setLastActivated(long l2) {
        this.lastActivated = l2;
        this.firePropertyChange(F_LAST_ACTIVATED, 0L, l2);
    }

    public long getLastLocation() {
        return this.lastLocation == 0L ? this.lastActivated : this.lastLocation;
    }

    public void setLastLocation(long l2) {
        this.lastLocation = l2;
        this.firePropertyChange(F_LAST_LOCATION, 0L, l2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(F_NAME, string2, this.name);
    }

    public void updateName() {
        String string = this.name;
        Object object = "";
        Graph graph = this.getGraph();
        MWInstrument mWInstrument = this.getInstrument();
        Object object2 = "";
        switch (this.getOperator()) {
            case CROSSES_ABOVE: {
                object2 = ">";
                break;
            }
            case CROSSES_BELOW: {
                object2 = "<";
                break;
            }
            default: {
                object2 = "" + this.getOperator();
            }
        }
        if (graph != null) {
            object = graph.a(this.getInput()) + " " + (String)object2 + " ";
            if (this.isUseTargetInput()) {
                object = (String)object + graph.a(this.getTargetInput());
            } else {
                Double d2 = this.computeTargetValue();
                if (d2 != null) {
                    ap ap2 = graph.a(this.getInput());
                    object = ap2 != null ? (String)object + ap2.a((double)d2) : (String)object + d2;
                }
            }
        } else if (this.isGlobal()) {
            object = this.getAlertInput() + " " + (String)object2 + " ";
            object = mWInstrument != null ? (String)object + mWInstrument.formatValue(this.getTargetValue()) : (String)object + this.getTargetValue();
        }
        if (!h.a((Object)string, object)) {
            this.setName((String)object);
        }
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String string) {
        this.signalName = string;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isSignal() {
        return this.signal;
    }

    public void setSignal(boolean bl2) {
        this.signal = bl2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setBarSize(BarSize barSize) {
        this.barSize = barSize;
    }

    public BarSize getBarSize() {
        return this.barSize;
    }

    public String getSymbol() {
        return this.getInstrument() == null ? "" : this.getInstrument().getSymbol();
    }

    public String getSymbolDisplay() {
        return this.getInstrument() == null ? "" : this.getInstrument().getSymbolDisplay();
    }

    public String getInput() {
        return ((AlertCondition)this.conditions.get(0)).getInput();
    }

    public void setInput(String string) {
        ((AlertCondition)this.conditions.get(0)).setInput(string);
        this.firePropertyChange(F_INPUT, null, string);
    }

    public Enums$AlertOperator getOperator() {
        return ((AlertCondition)this.conditions.get(0)).getOperator();
    }

    public void setCondition(Enums$AlertOperator enums$AlertOperator) {
        ((AlertCondition)this.conditions.get(0)).setOperator(enums$AlertOperator);
    }

    public double getTargetValue() {
        return ((AlertCondition)this.conditions.get(0)).getTargetValue();
    }

    public void setTargetValue(double d2) {
        ((AlertCondition)this.conditions.get(0)).setTargetValue(d2);
    }

    public boolean isUseTargetInput() {
        return ((AlertCondition)this.conditions.get(0)).isUseTargetInput();
    }

    public void setUseTargetInput(boolean bl2) {
        ((AlertCondition)this.conditions.get(0)).setUseTargetInput(bl2);
    }

    public String getTargetInput() {
        return ((AlertCondition)this.conditions.get(0)).getTargetInput();
    }

    public void setTargetInput(String string) {
        ((AlertCondition)this.conditions.get(0)).setTargetInput(string);
        this.firePropertyChange(F_TARGET_INPUT, null, string);
    }

    public String getTargetOption() {
        return ((AlertCondition)this.conditions.get(0)).getTargetOption();
    }

    public void setTargetOption(String string) {
        ((AlertCondition)this.conditions.get(0)).setTargetOption(string);
    }

    public int getAlertIndex() {
        int n2;
        Graph graph = this.getGraph();
        if (graph == null || h.a((Collection)graph.m())) {
            return -1;
        }
        int n3 = graph.m().size() - 1;
        if (graph.a(this.getInput())) {
            n3 = graph.a(this.getInput());
        }
        if (graph.a(this.getTargetInput()) && (n2 = graph.a(this.getTargetInput())) < n3) {
            n3 = n2;
        }
        return n3;
    }

    public Double computeTargetValue() {
        try {
            com.motivewave.platform.ui.draw.component.f f2 = this.getComponent();
            if (f2 == null && this.getComponentId() == null) {
                Graph graph;
                if (this.isUseTargetInput() && (graph = this.getGraph()) != null) {
                    int n2 = this.getAlertIndex();
                    b b2 = graph.a(this.getTargetInput());
                    if (b2 == null) {
                        return null;
                    }
                    Object object = b2.a(graph, n2);
                    if (object == null) {
                        object = b2.a(graph, n2 - 1);
                    }
                    if (object == null) {
                        return null;
                    }
                    if (object instanceof Number) {
                        return h.a(object);
                    }
                }
                return this.getTargetValue();
            }
            if (f2 == null) {
                return null;
            }
            return f2.a(this.getTargetOption());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public com.motivewave.platform.ui.draw.component.f getComponent() {
        if (this.component != null) {
            return this.component;
        }
        if (this.componentId == null) {
            return null;
        }
        Graph graph = this.getGraph();
        if (graph == null) {
            return null;
        }
        this.component = (com.motivewave.platform.ui.draw.component.f)graph.a(this.componentId);
        return this.component;
    }

    public void setComponent(com.motivewave.platform.ui.draw.component.f f2) {
        this.component = f2;
        this.componentId = f2 == null ? null : f2.getID();
    }

    public void setComponentId(Object object) {
        this.componentId = object;
    }

    public Object getComponentId() {
        return this.componentId;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public String getChart() {
        return "";
    }

    public void setChart(String string) {
    }

    public String getCancel() {
        return "";
    }

    public void setCancel(String string) {
    }

    public Enums$AlertInput getAlertInput() {
        for (Enums$AlertInput enums$AlertInput : Enums$AlertInput.values()) {
            if (!h.a((Object)enums$AlertInput.name(), (Object)this.getInput())) continue;
            return enums$AlertInput;
        }
        return null;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(double d2) {
        double d3 = this.lastValue;
        this.lastValue = d2;
        this.firePropertyChange(F_LAST_VALUE, d3, d2);
    }

    public void setFormattedLastValue(String string) {
        this.formattedLastValue = string;
    }

    public String getFormattedLastValue() {
        return this.formattedLastValue;
    }

    public void setFormattedLastTriggeredValue(String string) {
        this.formattedLastTriggeredValue = string;
    }

    public String getFormattedLastTriggeredValue() {
        return this.formattedLastTriggeredValue;
    }

    public void setLastTriggeredValue(double d2) {
        this.lastTriggeredValue = d2;
    }

    public double getLastTriggeredValue() {
        return this.lastTriggeredValue;
    }

    boolean isEquivalent(AlertHistory alertHistory) {
        long l2 = Math.abs(this.lastActivated - alertHistory.getActivated());
        if (l2 > 5000L) {
            return false;
        }
        if (this.barSize != null && this.barSize.isLinear() ? l2 > 2000L : l2 > 1000L) {
            return false;
        }
        if (this.isSignal()) {
            return h.a((Object)this.getInstrument(), (Object)alertHistory.getInstrument()) && h.a((Object)this.signalName, (Object)alertHistory.getSignalName()) && h.a((Object)this.barSize, (Object)alertHistory.getBarSize()) && h.a((Object)this.name, (Object)alertHistory.getName());
        }
        return h.a((Object)this.getInstrument(), (Object)alertHistory.getInstrument()) && h.a((Object)this.name, (Object)alertHistory.getName()) && h.a((Object)this.barSize, (Object)alertHistory.getBarSize());
    }

    public String toString() {
        if (this.isSignal()) {
            return "Signal: " + this.getSymbolDisplay() + " " + this.format("barSize") + " " + this.getSignalName() + " " + this.getMessage() + " Value: " + this.formattedLastTriggeredValue;
        }
        return "Alert: " + this.getSymbolDisplay() + " " + this.format("barSize") + " " + this.getName() + " Value: " + this.formattedLastTriggeredValue;
    }

    @Override
    public String formatPrice(float f2) {
        return this.ticker == null ? super.formatPrice(f2) : this.getInstrument().formatValue(f2);
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals(F_NAME)) {
            return this.getName();
        }
        if (string.equals(F_CHART)) {
            return "";
        }
        if (string.equals(F_CANCEL)) {
            return "";
        }
        if (string.equals("replay")) {
            return this.isReplay() ? "Y" : "N";
        }
        if (string.equals(F_ORDER_NAME)) {
            return this.getOrderName();
        }
        if (string.equals(F_SIGNAL_NAME)) {
            if (h.g(this.getSignalName())) {
                return h.b((Object)this.getLabel());
            }
            return this.getSignalName();
        }
        if (string.equals(F_LAST_VALUE)) {
            return h.b((Object)this.formattedLastValue);
        }
        if (string.equals(F_LAST_ACTIVATED)) {
            long l2 = this.getLastActivated();
            if (l2 <= 0L) {
                return "";
            }
            return s.a(this.getLastActivated(), com.motivewave.platform.common.b.a());
        }
        if (string.equals(F_EXPIRES)) {
            long l3 = this.getExpires();
            if (l3 <= 0L) {
                return "";
            }
            return s.a(l3, com.motivewave.platform.common.b.a());
        }
        if (string.equals(F_BARSIZE)) {
            if (this.barSize == null) {
                return "N/A";
            }
            return this.barSize.toString();
        }
        if (string.equals(F_SYMBOL)) {
            if (this.getInstrument() == null) {
                return "";
            }
            return this.getInstrument().getSymbolDisplay();
        }
        return super.format(string);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean bl2) {
        if (bl2 == this.global) {
            return;
        }
        this.global = bl2;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public void setGraph(Graph graph) {
        Graph graph2 = this.graph == null ? null : (Graph)this.graph.get();
        this.graph = graph == null || graph.e() ? null : new WeakReference<Graph>(graph);
        this.firePropertyChange(F_CHART, graph2, graph);
    }

    public Graph getGraph() {
        if (this.graph == null) {
            return null;
        }
        Graph graph = (Graph)this.graph.get();
        if (graph == null || graph.e()) {
            return null;
        }
        return graph;
    }

    public MWOrder getOrder() {
        return this.orderSubmitted ? null : this.order;
    }

    public void setOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.order;
        if (mWOrder != null && mWOrder.isNew()) {
            this.orderSubmitted = false;
        }
        this.order = mWOrder;
        this.firePropertyChange(F_ORDER, mWOrder2, mWOrder);
        this.firePropertyChange(F_ORDER_NAME, null, this.getOrderName());
    }

    public String getOrderName() {
        if (this.order == null) {
            return "";
        }
        String string = this.order.getAction() + " " + this.order.getInstrument().getSymbol();
        if (this.order.isMarket()) {
            string = string + "@MKT";
        }
        if (this.order.isLimit()) {
            string = string + " " + this.order.getType() + "@" + this.order.getInstrument().formatValue(this.order.getLimitPrice());
        } else if (this.order.isStop()) {
            string = string + " " + this.order.getType() + "@" + this.order.getInstrument().formatValue(this.order.getStopPrice());
        }
        return string;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        this.ticker = LiveTicker.get(mWInstrument);
        this.ticker.addPropertyChangeListener(this);
    }

    public MWInstrument getInstrument() {
        return this.ticker == null ? null : this.ticker.getInstrument();
    }

    public boolean isShowBtn() {
        return this.showBtn == null ? com.motivewave.platform.common.b.s() : this.showBtn;
    }

    public void setShowBtn(boolean bl2) {
        this.showBtn = bl2 == com.motivewave.platform.common.b.s() ? null : Boolean.valueOf(bl2);
    }

    public boolean isShowLine() {
        return this.showLine == null ? com.motivewave.platform.common.b.r() : this.showLine;
    }

    public void setShowLine(boolean bl2) {
        this.showLine = bl2 == com.motivewave.platform.common.b.r() ? null : Boolean.valueOf(bl2);
    }

    public boolean isShowLabel() {
        return this.showLabel == null ? com.motivewave.platform.common.b.t() : this.showLabel;
    }

    public void setShowLabel(boolean bl2) {
        boolean bl3 = this.isShowLabel();
        this.showLabel = bl2 == com.motivewave.platform.common.b.t() ? null : Boolean.valueOf(bl2);
        this.firePropertyChange(F_SHOW_LABEL, bl3, this.isShowLabel());
    }

    public Enums$Align getAlign() {
        return this.align == null ? com.motivewave.platform.common.b.c() : this.align;
    }

    public void setAlign(Enums$Align enums$Align) {
        enums$Align = enums$Align == com.motivewave.platform.common.b.c() ? null : enums$Align;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public List getPrevValues() {
        return this.prevValues.a();
    }

    public void setPrevValue(double d2) {
        this.prevValues.a(0, d2);
        this.prevValues.a(20, 30);
    }

    public void read(Element element) {
        try {
            a.b b2;
            Object object;
            Object object2;
            Node node;
            if (this.id < 0 && !h.g(element.getAttribute("id"))) {
                this.id = h.b(element.getAttribute("id"));
            }
            this.setInput(element.getAttribute("input"));
            boolean bl2 = this.setCondition(element.getAttribute("condition"));
            String string = element.getAttribute("targetOption");
            if (h.g(string)) {
                string = element.getAttribute("triggerOption");
            }
            this.setTargetOption(string);
            string = element.getAttribute("targetValue");
            if (h.g(string)) {
                string = element.getAttribute("triggerValue");
            }
            if (!h.g(string)) {
                this.setTargetValue(h.a(string));
            }
            if (!h.g(string = element.getAttribute("targetInput"))) {
                this.setTargetInput(string);
            }
            if (!h.g(string = element.getAttribute("useTargetInput"))) {
                this.setUseTargetInput(h.a((Object)string));
            }
            if (!h.g(string = element.getAttribute("expires"))) {
                this.expires = h.b(string);
            }
            if (!h.g(string = element.getAttribute("timeZone"))) {
                this.timeZone = TimeZone.getTimeZone(string);
            }
            if (!h.g(string = element.getAttribute("useDefaultTimeZone"))) {
                this.useDefaultTimeZone = h.a((Object)string);
            }
            if (!h.g(string = element.getAttribute("session1Start"))) {
                this.session1Start = h.b(string);
            }
            if (!h.g(string = element.getAttribute("session1End"))) {
                this.session1End = h.b(string);
            }
            if (!h.g(string = element.getAttribute("session1Enabled"))) {
                this.session1Enabled = h.a((Object)string);
            }
            if (!h.g(string = element.getAttribute("session2Start"))) {
                this.session2Start = h.b(string);
            }
            if (!h.g(string = element.getAttribute("session2End"))) {
                this.session2End = h.b(string);
            }
            if (!h.g(string = element.getAttribute("session2Enabled"))) {
                this.session2Enabled = h.a((Object)string);
            }
            this.setTriggerMultiple(h.a((Object)element.getAttribute("triggerMultiple")));
            this.setShowAlert(h.a((Object)element.getAttribute("showAlert")));
            string = element.getAttribute("componentId");
            if (!h.g(string)) {
                this.componentId = h.b(string) ? Integer.valueOf(string) : string;
            }
            if (!h.g(string = element.getAttribute("showBtn"))) {
                this.showBtn = h.a((Object)string);
            }
            if (!h.g(string = element.getAttribute("showLine"))) {
                this.showLine = h.a((Object)string);
            }
            if (!h.g(string = element.getAttribute("showLabel"))) {
                this.showLabel = h.a((Object)string);
            }
            if (!h.g(string = element.getAttribute("align"))) {
                try {
                    this.align = Enums$Align.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.showLabel = h.a((Object)string);
            }
            Node node2 = g.b("name", element);
            this.setName(g.b(node2));
            node2 = g.b("label", element);
            if (this.label != null) {
                this.setLabel(g.b(node2));
            }
            node2 = g.b("comments", element);
            if (this.comments != null) {
                this.setComments(g.b(node2));
            }
            node2 = g.b("signalName", element);
            if (this.signalName != null) {
                this.setSignalName(g.b(node2));
            }
            Node node3 = g.b("sound", element);
            this.setPlaySound(h.a((Object)node3.getAttribute("enabled")));
            this.setUsePresetSound(h.a((Object)node3.getAttribute("presetSound")));
            if (!h.g(node3.getAttribute("soundFile"))) {
                this.setSoundFile(new File(node3.getAttribute("soundFile")));
            }
            Node node4 = g.b("email", element);
            this.setSendEmail(h.a((Object)node4.getAttribute("enabled")));
            this.setEmailAddress(node4.getAttribute("emailAddress"));
            string = node4.getAttribute("attachImage");
            if (!h.g(string)) {
                this.setAttachImage(h.a((Object)string));
            }
            if ((node = g.b("instrument", element)) != null) {
                object2 = node.getAttribute("symbol");
                b2 = MWInstrument.get((String)object2, (String)(object = node.getAttribute("exchange")));
                if (b2 != null) {
                    this.ticker = LiveTicker.get((MWInstrument)b2);
                    this.ticker.addPropertyChangeListener(this);
                } else {
                    h.a.warning("Alert::readXML() instrument not found: " + (String)object2 + ":" + (String)object);
                }
            }
            if ((object2 = g.b("order", element)) != null && an.k()) {
                try {
                    this.setOrder(MWOrder.read((Element)object2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((object = g.b("trade", element)) != null && an.k() && (object2 = g.b("order", (Node)object)) != null) {
                try {
                    b2 = MWOrder.read((Element)object2);
                    object2 = g.b("limit", (Node)object);
                    if (object2 != null) {
                        ((MWOrder)b2).setLimitOrder(MWOrder.read((Element)g.b("order", (Node)object2)));
                    }
                    if ((object2 = g.b("stopTrail", (Node)object)) != null) {
                        ((MWOrder)b2).setStopTrailOrder(MWOrder.read((Element)g.b("order", (Node)object2)));
                    }
                    this.setOrder((MWOrder)b2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (bl2) {
                this.updateName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean setCondition(String string) {
        if (h.g(string)) {
            return false;
        }
        if (h.a(string, new String[]{"GT", "GTE"})) {
            this.setCondition(Enums$AlertOperator.CROSSES_ABOVE);
            return true;
        }
        if (h.a(string, new String[]{"LT", "LTE"})) {
            this.setCondition(Enums$AlertOperator.CROSSES_BELOW);
            return true;
        }
        try {
            this.setCondition(Enums$AlertOperator.valueOf(string));
        }
        catch (Exception exception) {
            h.a.warning("Alert::read() invalid condition: " + string);
            this.setCondition(Enums$AlertOperator.CROSSES);
            return true;
        }
        return false;
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[0]);
        if (this.id > 0) {
            list.add(this.a("id", this.id));
        }
        h.a((Collection)list, (Object[])new String[]{this.b("name", this.getName()), this.b("signalName", this.getSignalName()), this.b("label", this.getLabel()), this.b("comments", this.getComments()), this.b("input", this.getInput()), this.a("condition", (Object)this.getOperator()), this.b("targetInput", this.getTargetInput()), this.a("targetValue", this.getTargetValue()), this.a("useTargetInput", this.isUseTargetInput(), false), this.b("targetOption", this.getTargetOption()), this.a("triggerMultiple", this.triggerMultiple, false), this.a("useDefaultTimeZone", this.useDefaultTimeZone, true)});
        if (!this.isUseDefaultTimeZone()) {
            list.add(this.b("timeZone", this.getTimeZone().getID()));
        }
        h.a((Collection)list, (Object[])new String[]{this.a("expires", this.expires, -1L), this.a("start1", this.session1Start, 0), this.a("end1", this.session1End, 0), this.a("session1Enabled", this.session1Enabled, false), this.a("start2", this.session2Start, 0), this.a("end2", this.session2End, 0), this.a("session2Enabled", this.session2Enabled, false), this.a("showAlert", this.isShowAlert(), true), this.a("showBtn", (Object)this.showBtn), this.a("showLine", (Object)this.showLine), this.a("showLabel", (Object)this.showLabel), this.a("align", (Object)this.align)});
        if (this.component != null) {
            list.add(this.a("componentId", this.component.getID()));
        } else if (this.componentId != null) {
            list.add(this.a("componentId", this.componentId));
        }
        list.add(this.a_("sound", this.a(this.a("enabled", this.playSound), this.a("usePreset", this.usePresetSound), this.b("file", this.getSoundFile() == null ? null : this.getSoundFile().getAbsolutePath()))));
        list.add(this.a_("email", this.a(this.a("enabled", this.sendEmail, false), this.b("emailAddress", this.emailAddress), this.a("attachImage", this.attachImage))));
        list.add(this.a("instr", this.getInstrument()));
        MWOrder mWOrder = this.getOrder();
        if (mWOrder != null && !this.isOrderSubmitted() && mWOrder.isNew()) {
            List list2 = mWOrder.getNVPs();
            list2.add(this.a("limit", mWOrder.getLimitOrder()));
            list2.add(this.a("stopTrail", mWOrder.getStopTrailOrder()));
            list.add(this.a_("order", this.a((Collection)list2)));
        }
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        a.b b2;
        Object object;
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        if (jSONObject.has("id")) {
            this.id = jSONObject.getInt("id");
        }
        this.setName(jSONObject.str("name"));
        this.setSignalName(jSONObject.str("signalName"));
        this.setLabel(jSONObject.str("label"));
        this.setComments(jSONObject.str("comments"));
        this.setInput(jSONObject.str("input"));
        boolean bl2 = this.setCondition(jSONObject.str("condition"));
        if (jSONObject.has("targetOption")) {
            this.setTargetOption(jSONObject.str("targetOption"));
        }
        if (jSONObject.has("targetValue")) {
            this.setTargetValue(jSONObject.getDouble("targetValue"));
        }
        if (jSONObject.has("targetInput")) {
            this.setTargetInput(jSONObject.str("targetInput"));
        }
        this.setUseTargetInput(jSONObject.is("useTargetInput", false));
        this.triggerMultiple = jSONObject.is("triggerMultiple", false);
        this.expires = jSONObject.getLong("expires", -1L);
        if (jSONObject.has("timeZone")) {
            this.timeZone = TimeZone.getTimeZone(jSONObject.str("timeZone"));
        }
        this.useDefaultTimeZone = jSONObject.is("useDefaultTimeZone", true);
        this.session1Start = jSONObject.getInt("start1", 0);
        this.session1End = jSONObject.getInt("end1", 0);
        this.session1Enabled = jSONObject.is("session1Enabled", false);
        this.session2Start = jSONObject.getInt("start2", 0);
        this.session2End = jSONObject.getInt("end2", 0);
        this.session2Enabled = jSONObject.is("session2Enabled", false);
        this.showAlert = jSONObject.is("showAlert");
        if (jSONObject.has("showBtn")) {
            this.showBtn = jSONObject.is("showBtn");
        }
        if (jSONObject.has("showLine")) {
            this.showLine = jSONObject.is("showLine");
        }
        if (jSONObject.has("showLabel")) {
            this.showLabel = jSONObject.is("showLabel");
        }
        try {
            this.align = Enums$Align.valueOf(jSONObject.str("align"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = jSONObject.str("componentId");
        if (!h.g(string)) {
            this.componentId = h.b(string) ? Integer.valueOf(string) : string;
        }
        if ((jSONObject3 = jSONObject.obj("sound")) != null) {
            this.setPlaySound(jSONObject3.is("enabled"));
            this.setUsePresetSound(jSONObject3.is("usePreset"));
            if (jSONObject3.has("file")) {
                this.setSoundFile(new File(jSONObject3.str("file")));
            }
        }
        if ((jSONObject2 = jSONObject.obj("email")) != null) {
            this.setSendEmail(jSONObject2.is("enabled", false));
            this.setEmailAddress(jSONObject2.str("emailAddress"));
            this.setAttachImage(jSONObject2.is("attachImage"));
        }
        if (jSONObject.has("instr") && this.getInstrument() == null) {
            object = this.a(jSONObject, "instr");
            if (object != null) {
                b2 = LiveTicker.get((MWInstrument)object);
                if (this.ticker != b2) {
                    if (this.ticker != null) {
                        this.ticker.removePropertyChangeListener(this);
                    }
                    this.ticker = b2;
                    this.ticker.addPropertyChangeListener(this);
                }
            } else {
                h.a.warning("Alert::fromJSON() instrument not found: " + jSONObject.obj("instr"));
            }
        }
        if (jSONObject.has("order") && an.k()) {
            object = jSONObject.obj("order");
            b2 = new MWOrder((JSONObject)object);
            if (((JSONObject)object).has("limit")) {
                ((MWOrder)b2).setLimitOrder(new MWOrder(((JSONObject)object).obj("limit")));
            }
            if (((JSONObject)object).has("stopTrail")) {
                ((MWOrder)b2).setStopTrailOrder(new MWOrder(((JSONObject)object).obj("stopTrail")));
            }
            this.setOrder((MWOrder)b2);
        }
        if (bl2) {
            this.updateName();
        }
    }
}

