/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.TradeHistoryDirectory;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.a;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Account
extends b {
    protected String id;
    protected double balance;
    protected double statementBalance;
    protected double minimumBalance;
    protected String baseCurrency = "USD";
    protected double unrealizedPL;
    protected boolean readOnly = false;
    protected String accountName;
    protected boolean useAccountName = false;
    protected boolean simulatedAccount = false;
    protected boolean replay = false;
    protected boolean billing = false;
    protected boolean primary = false;
    protected String type;
    protected String typeDesc;
    protected String status;
    protected String statusDesc;
    private double accountValue;
    private double accountCredit;
    private double longValue;
    private double shortValue;
    private double equity;
    private double overnightBuyingPower;
    private double buyingPower;
    private double reservedBuyingPower;
    private double usedBuyingPower;
    private double optionBuyingPower;
    private double optionRequirement;
    private double stockBuyingPower;
    private double cashBalance;
    private double availableFunds;
    private double initialCashBalance;
    private double initialAccountValue;
    private double initialMarginBalance;
    private double maintenanceMargin;
    private double maintenanceExcess;
    private double netLiquidationValue;
    private double netEquity;
    private double openTradeEquity;
    private double marginBalance;
    private double minimumMarginBalance;
    private double initialMarginEquity;
    private double marginEquity;
    private double sessionPL;
    private double totalPL;
    private double unclearedDeposit;
    private double excessEquity;
    private double morningExcessEquity;
    private double overnightExcessEquity;
    private double marginDebit;
    private double percentEquity;
    private double marginAvailable;
    private double marginRate;
    private double marginUsed;
    private double positionValue;
    private double currentRequirement;
    private double marketValue;
    private double totalEquity;
    private double pendingCash;
    private double tradableFunds;
    private double totalMarginRequirement;
    private int pendingOrders;
    private boolean hedging = false;
    private boolean netOrders = false;
    private List supportedTypes = new ArrayList();
    private String fcmId;
    private double lossLimit;
    private double open;
    private double closed;
    private int buyLimit;
    private int sellLimit;
    private boolean dayTrading;
    protected boolean includeCommission = false;
    private double usdBalance = 0.0;
    private double cadBalance = 0.0;
    private int freeTradeBalance = 0;
    private boolean interestFree = false;
    private boolean longOnly = false;
    private String serviceName = null;
    private Enums$ServiceType serviceType = null;
    private static Account simAccount;
    private static String defaultAccountId;
    private static boolean simulatedEnabled;
    private static boolean fillMarketImmediate;
    private static boolean includeCommissions;
    private static long uniqueCounter;
    private static long uniqueReplayCounter;

    public Account(String string) {
        this.id = string;
    }

    public boolean isAccount(String string) {
        if (h.a((Object)string, (Object)this.id)) {
            return true;
        }
        return h.a((Object)string, (Object)this.accountName);
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "accountID": {
                return this.getAccountID();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "accountValue": {
                return this.getAccountValue();
            }
            case "accountCredit": {
                return this.getAccountCredit();
            }
            case "sessionPL": {
                return this.getSessionPL();
            }
            case "unrealizedPL": {
                return this.getUnrealizedPL();
            }
            case "totalPL": {
                return this.getTotalPL();
            }
            case "type": {
                return this.getType();
            }
            case "typeDesc": {
                return this.getTypeDesc();
            }
            case "status": {
                return this.getStatus();
            }
            case "statusDesc": {
                return this.getStatusDesc();
            }
            case "baseCurrency": {
                return this.getBaseCurrency();
            }
            case "primary": {
                return this.isPrimary();
            }
            case "default": {
                return this.isDefault();
            }
            case "billing": {
                return this.isBilling();
            }
            case "groupAccount": {
                return this.isGroupAccount();
            }
            case "simulatedAccount": {
                return this.isSimulatedAccount();
            }
            case "initialMarginBalance": {
                return this.getInitialMarginBalance();
            }
            case "marginBalance": {
                return this.getMarginBalance();
            }
            case "minimumMarginBalance": {
                return this.getMinimumMarginBalance();
            }
            case "initialMarginEquity": {
                return this.getInitialMarginEquity();
            }
            case "marginEquity": {
                return this.getMarginEquity();
            }
            case "initialCashBalance": {
                return this.getInitialCashBalance();
            }
            case "cashBalance": {
                return this.getCashBalance();
            }
            case "usdBalance": {
                return this.getUsdBalance();
            }
            case "cadBalance": {
                return this.getCadBalance();
            }
            case "initialAccountValue": {
                return this.getInitialAccountValue();
            }
            case "equity": {
                return this.getEquity();
            }
            case "totalEquity": {
                return this.getTotalEquity();
            }
            case "netEquity": {
                return this.getNetEquity();
            }
            case "openTradeEquity": {
                return this.getOpenTradeEquity();
            }
            case "tradableFunds": {
                return this.getTradableFunds();
            }
            case "totalMarginRequirement": {
                return this.getTotalMarginRequirement();
            }
            case "overnightBuyingPower": {
                return this.getOvernightBuyingPower();
            }
            case "buyingPower": {
                return this.getBuyingPower();
            }
            case "reservedBuyingPower": {
                return this.getReservedBuyingPower();
            }
            case "usedBuyingPower": {
                return this.getUsedBuyingPower();
            }
            case "optionBuyingPower": {
                return this.getOptionBuyingPower();
            }
            case "stockBuyingPower": {
                return this.getStockBuyingPower();
            }
            case "optionRequirement": {
                return this.getOptionRequirement();
            }
            case "balance": {
                return this.getBalance();
            }
            case "statementBalance": {
                return this.getStatementBalance();
            }
            case "minimumBalance": {
                return this.getMinimumBalance();
            }
            case "availableFunds": {
                return this.getAvailableFunds();
            }
            case "unclearedDeposit": {
                return this.getUnclearedDeposit();
            }
            case "marginDebit": {
                return this.getMarginDebit();
            }
            case "excessEquity": {
                return this.getExcessEquity();
            }
            case "morningExcessEquity": {
                return this.getMorningExcessEquity();
            }
            case "overnightExcessEquity": {
                return this.getOvernightExcessEquity();
            }
            case "marginAvailable": {
                return this.getMarginAvailable();
            }
            case "marginUsed": {
                return this.getMarginUsed();
            }
            case "netAssetValue": {
                return this.getNetAssetValue();
            }
            case "positionValue": {
                return this.getPositionValue();
            }
            case "longValue": {
                return this.getLongValue();
            }
            case "shortValue": {
                return this.getShortValue();
            }
            case "percentEquity": {
                return this.getPercentEquity();
            }
            case "marginRate": {
                return this.getMarginRate();
            }
            case "readOnly": {
                return this.isReadOnly();
            }
            case "maintenanceMargin": {
                return this.getMaintenanceMargin();
            }
            case "maintenanceExcess": {
                return this.getMaintenanceExcess();
            }
            case "netLiquidationValue": {
                return this.getNetLiquidationValue();
            }
            case "currentRequirement": {
                return this.getCurrentRequirement();
            }
            case "marketValue": {
                return this.getMarketValue();
            }
            case "pendingCash": {
                return this.getPendingCash();
            }
            case "pendingOrders": {
                return this.getPendingOrders();
            }
            case "replayAccount": {
                return this.isReplay();
            }
            case "hedging": {
                return this.isHedging();
            }
            case "netOrders": {
                return this.isNetOrders();
            }
            case "open": {
                return this.getOpen();
            }
            case "closed": {
                return this.getClosed();
            }
            case "buyLimit": {
                return this.getBuyLimit();
            }
            case "sellLimit": {
                return this.getSellLimit();
            }
            case "lossLimit": {
                return this.getLossLimit();
            }
            case "dayTrading": {
                return this.isDayTrading();
            }
            case "longOnly": {
                return this.isLongOnly();
            }
            case "interestFree": {
                return this.isInterestFree();
            }
            case "freeTradeBalance": {
                return this.getFreeTradeBalance();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
        }
        return null;
    }

    @Override
    public String format(String string) {
        Object object = this.getProperty(string);
        if (h.a(string, "initialMarginBalance", "minimumMarginBalance", "marginBalance", "initialMarginEquity", "marginEquity", "initialCashBalance", "cashBalance", "initialAccountValue", "accountValue", "accountCredit", "equity", "overnightBuyingPower", "buyingPower", "usedBuyingPower", "reservedBuyingPower", "unrealizedPL", "balance", "statementBalance", "minimumBalance", "availableFunds", "sessionPL", "totalPL", "unclearedDeposit", "marginDebit", "morningExcessEquity", "overnightExessEquity", "excessEquity", "marginAvailable", "marginUsed", "netAssetValue", "positionValue", "maintenanceMargin", "maintenanceExcess", "netLiquidationValue", "pendingCash", "totalEquity", "marketValue", "optionBuyingPower", "stockBuyingPower", "optionRequirement", "longValue", "shortValue", "open", "closed", "buyLimit", "sellLimit", "lossLimit", "cadBalance", "usdBalance", "netEquity", "openTradeEquity", "tradableFunds", "totalMarginRequirement")) {
            double d2 = h.a(object);
            if (d2 == 0.0 || d2 > -0.01 && d2 < 0.01) {
                return "";
            }
            return s.a(d2);
        }
        if (h.a(string, new String[]{"percentEquity", "marginRate"})) {
            double d3 = h.a(object);
            if (d3 == 0.0) {
                return "";
            }
            return h.a(d3, 2);
        }
        if (h.a(string, "dayTrading", "billing", "primary", "default", "interestFree", "longOnly", "hedging")) {
            return this.getBoolean(string) ? "Y" : "N";
        }
        if (string == "serviceName") {
            return this.getServiceName();
        }
        if (string == "serviceType") {
            return this.getServiceType() == null ? "" : this.getServiceType().toString();
        }
        if (string == "connectionName") {
            return this.getConnectionName();
        }
        return h.b(object);
    }

    public String getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        as as2 = ae.a(this);
        if (as2 != null) {
            this.serviceName = as2.a().getType().toString();
        }
        return this.serviceName;
    }

    public Enums$ServiceType getServiceType() {
        if (this.serviceType != null) {
            return this.serviceType;
        }
        as as2 = ae.a(this);
        if (as2 != null) {
            this.serviceType = as2.a().getType();
        }
        return this.serviceType;
    }

    public String getConnectionName() {
        as as2 = ae.a(this);
        if (as2 != null) {
            return as2.a().getName();
        }
        return "";
    }

    public boolean isSimulatedAccount() {
        return this.simulatedAccount;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public void setReplay(boolean bl2) {
        this.replay = bl2;
    }

    public String getAccountID() {
        return this.id;
    }

    public String getAccountName() {
        return h.g(this.accountName) ? this.getAccountID() : this.accountName;
    }

    public void setAccountName(String string) {
        String string2 = this.accountName;
        this.accountName = string;
        this.firePropertyChange("accountName", string2, this.accountName);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        String string2 = this.type;
        this.type = string;
        this.firePropertyChange("type", string2, this.type);
    }

    public boolean isBilling() {
        return this.billing;
    }

    public void setBilling(boolean bl2) {
        boolean bl3 = this.billing;
        this.billing = bl2;
        this.firePropertyChange("billing", bl3, this.billing);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean bl2) {
        boolean bl3 = this.primary;
        this.primary = bl2;
        this.firePropertyChange("primary", bl3, this.primary);
    }

    public boolean isHedging() {
        return this.hedging;
    }

    public void setHedging(boolean bl2) {
        boolean bl3 = this.hedging;
        this.hedging = bl2;
        this.firePropertyChange("hedging", bl3, this.hedging);
    }

    public boolean isNetOrders() {
        return this.netOrders;
    }

    public void setNetOrders(boolean bl2) {
        boolean bl3 = this.netOrders;
        this.netOrders = bl2;
        this.firePropertyChange("netOrders", bl3, this.netOrders);
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public void setTypeDesc(String string) {
        String string2 = this.typeDesc;
        this.typeDesc = string;
        this.firePropertyChange("typeDesc", string2, this.typeDesc);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.firePropertyChange("status", string2, this.status);
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public void setStatusDesc(String string) {
        String string2 = this.statusDesc;
        this.statusDesc = string;
        this.firePropertyChange("statusDesc", string2, this.statusDesc);
    }

    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    public void setBaseCurrency(String string) {
        String string2 = this.baseCurrency;
        this.baseCurrency = string;
        this.firePropertyChange("baseCurrency", string2, this.baseCurrency);
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double d2) {
        double d3 = this.balance;
        double d4 = this.getNetAssetValue();
        this.balance = d2;
        this.firePropertyChange("balance", d3, this.balance);
        this.firePropertyChange("netAssetValue", d4, this.getNetAssetValue());
    }

    public double getStatementBalance() {
        return this.statementBalance;
    }

    public void setStatementBalance(double d2) {
        double d3 = this.statementBalance;
        this.statementBalance = d2;
        this.firePropertyChange("statementBalance", d3, this.statementBalance);
    }

    public double getRiskBalance() {
        return this.cashBalance > 0.0 ? this.cashBalance : this.getBalance();
    }

    public double getMinimumBalance() {
        return this.minimumBalance;
    }

    public void setMinimumBalance(double d2) {
        double d3 = this.minimumBalance;
        this.minimumBalance = d2;
        this.firePropertyChange("minimumBalance", d3, this.minimumBalance);
    }

    public double getNetAssetValue() {
        return this.getBalance() + this.getUnrealizedPL();
    }

    public double getUnrealizedPL() {
        return this.unrealizedPL;
    }

    public void setUnrealizedPL(double d2) {
        double d3 = this.unrealizedPL;
        double d4 = this.getNetAssetValue();
        this.unrealizedPL = d2;
        this.firePropertyChange("unrealizedPL", d3, this.unrealizedPL);
        this.firePropertyChange("netAssetValue", d4, this.getNetAssetValue());
    }

    public double getSessionPL() {
        return this.sessionPL;
    }

    public void setSessionPL(double d2) {
        double d3 = this.sessionPL;
        this.sessionPL = d2;
        this.firePropertyChange("sessionPL", d3, this.sessionPL);
    }

    public double getTotalPL() {
        return this.totalPL;
    }

    public void setTotalPL(double d2) {
        double d3 = this.totalPL;
        this.totalPL = d2;
        this.firePropertyChange("totalPL", d3, this.totalPL);
    }

    public boolean isDefault() {
        return h.a((Object)this.getAccountID(), (Object)defaultAccountId);
    }

    public void setDefault(boolean bl2) {
        boolean bl3 = h.a((Object)defaultAccountId, (Object)this.getAccountID());
        if (bl2) {
            defaultAccountId = this.getAccountID();
        } else if (bl3) {
            defaultAccountId = null;
        }
        this.firePropertyChange("default", !bl2, bl2);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        boolean bl3 = this.readOnly;
        this.readOnly = bl2;
        this.firePropertyChange("readOnly", bl3, this.readOnly);
    }

    public void calcPnl() {
        double d2 = 0.0;
        List list = PositionDirectory.getAll();
        if (h.a((Collection)list)) {
            this.setUnrealizedPL(d2);
            return;
        }
        for (Position position : list) {
            if (!position.isOpen() || !h.g(position.getAccountId()) && !h.a((Object)position.getAccountId(), (Object)this.id)) continue;
            d2 += position.getUnrealizedPnL();
        }
        d2 = h.a(d2, 2);
        this.setUnrealizedPL(d2);
    }

    public boolean isGroupAccount() {
        return false;
    }

    public boolean isUseAccountName() {
        return this.useAccountName;
    }

    public void setUseAccountName(boolean bl2) {
        this.useAccountName = bl2;
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double d2) {
        double d3 = d2;
        this.cashBalance = d2;
        this.firePropertyChange("cashBalance", d3, d2);
    }

    public double getUsdBalance() {
        return this.usdBalance;
    }

    public void setUsdBalance(double d2) {
        double d3 = this.usdBalance;
        this.usdBalance = d2;
        this.firePropertyChange("usdBalance", d3, this.usdBalance);
    }

    public double getCadBalance() {
        return this.cadBalance;
    }

    public void setCadBalance(double d2) {
        double d3 = this.cadBalance;
        this.cadBalance = d2;
        this.firePropertyChange("cadBalance", d3, this.cadBalance);
    }

    public void adjustAccount(double d2) {
        this.setBalance(this.balance + d2);
        this.setCashBalance(this.cashBalance + d2);
        this.setSessionPL(this.sessionPL + d2);
        this.setTotalPL(this.totalPL + d2);
    }

    public double getAvailableFunds() {
        return this.availableFunds;
    }

    public void setAvailableFunds(double d2) {
        double d3 = this.availableFunds;
        this.availableFunds = d2;
        this.firePropertyChange("availableFunds", d3, this.availableFunds);
    }

    public double getInitialCashBalance() {
        return this.initialCashBalance;
    }

    public void setInitialCashBalance(double d2) {
        double d3 = this.initialCashBalance;
        this.initialCashBalance = d2;
        this.firePropertyChange("initialCashBalance", d3, this.initialCashBalance);
    }

    public double getInitialAccountValue() {
        return this.initialAccountValue;
    }

    public void setInitialAccountValue(double d2) {
        double d3 = this.initialAccountValue;
        this.initialAccountValue = d2;
        this.firePropertyChange("initialAccountValue", d3, this.initialAccountValue);
    }

    public double getAccountValue() {
        return this.accountValue;
    }

    public void setAccountValue(double d2) {
        double d3 = this.accountValue;
        this.accountValue = d2;
        this.firePropertyChange("accountValue", d3, this.accountValue);
    }

    public double getAccountCredit() {
        return this.accountCredit;
    }

    public void setAccountCredit(double d2) {
        double d3 = this.accountCredit;
        this.accountCredit = d2;
        this.firePropertyChange("accountCredit", d3, this.accountCredit);
    }

    public double getLongValue() {
        return this.longValue;
    }

    public void setLongValue(double d2) {
        double d3 = this.longValue;
        this.longValue = d2;
        this.firePropertyChange("longValue", d3, this.longValue);
    }

    public double getShortValue() {
        return this.shortValue;
    }

    public void setShortValue(double d2) {
        double d3 = this.shortValue;
        this.shortValue = d2;
        this.firePropertyChange("shortValue", d3, this.shortValue);
    }

    public double getEquity() {
        return this.equity;
    }

    public void setEquity(double d2) {
        double d3 = this.equity;
        this.equity = d2;
        this.firePropertyChange("equity", d3, this.equity);
    }

    public double getBuyingPower() {
        return this.buyingPower;
    }

    public void setBuyingPower(double d2) {
        double d3 = this.buyingPower;
        this.buyingPower = d2;
        this.firePropertyChange("buyingPower", d3, this.buyingPower);
    }

    public double getUsedBuyingPower() {
        return this.usedBuyingPower;
    }

    public void setUsedBuyingPower(double d2) {
        double d3 = this.usedBuyingPower;
        this.usedBuyingPower = d2;
        this.firePropertyChange("usedBuyingPower", d3, this.usedBuyingPower);
    }

    public double getReservedBuyingPower() {
        return this.reservedBuyingPower;
    }

    public void setReservedBuyingPower(double d2) {
        double d3 = this.reservedBuyingPower;
        this.reservedBuyingPower = d2;
        this.firePropertyChange("reservedBuyingPower", d3, this.reservedBuyingPower);
    }

    public double getOvernightBuyingPower() {
        return this.overnightBuyingPower;
    }

    public void setOvernightBuyingPower(double d2) {
        double d3 = this.overnightBuyingPower;
        this.overnightBuyingPower = d2;
        this.firePropertyChange("overnightBuyingPower", d3, this.overnightBuyingPower);
    }

    public double getOptionBuyingPower() {
        return this.optionBuyingPower;
    }

    public void setOptionBuyingPower(double d2) {
        double d3 = this.optionBuyingPower;
        this.optionBuyingPower = d2;
        this.firePropertyChange("optionBuyingPower", d3, this.optionBuyingPower);
    }

    public double getStockBuyingPower() {
        return this.stockBuyingPower;
    }

    public void setStockBuyingPower(double d2) {
        double d3 = this.stockBuyingPower;
        this.stockBuyingPower = d2;
        this.firePropertyChange("stockBuyingPower", d3, this.stockBuyingPower);
    }

    public double getOptionRequirement() {
        return this.optionRequirement;
    }

    public void setOptionRequirement(double d2) {
        double d3 = this.optionRequirement;
        this.optionRequirement = d2;
        this.firePropertyChange("optionRequirement", d3, this.optionRequirement);
    }

    public double getInitialMarginBalance() {
        return this.initialMarginBalance;
    }

    public void setInitialMarginBalance(double d2) {
        double d3 = this.initialMarginBalance;
        this.initialMarginBalance = d2;
        this.firePropertyChange("initialMarginBalance", d3, this.initialMarginBalance);
    }

    public double getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(double d2) {
        double d3 = this.maintenanceMargin;
        this.maintenanceMargin = d2;
        this.firePropertyChange("maintenanceMargin", d3, this.maintenanceMargin);
    }

    public double getMaintenanceExcess() {
        return this.maintenanceExcess;
    }

    public void setMaintenanceExcess(double d2) {
        double d3 = this.maintenanceExcess;
        this.maintenanceExcess = d2;
        this.firePropertyChange("maintenanceExcess", d3, this.maintenanceExcess);
    }

    public double getNetLiquidationValue() {
        return this.netLiquidationValue;
    }

    public void setNetLiquidationValue(double d2) {
        double d3 = this.netLiquidationValue;
        this.netLiquidationValue = d2;
        this.firePropertyChange("netLiquidationValue", d3, this.netLiquidationValue);
    }

    public double getMarginBalance() {
        return this.marginBalance;
    }

    public void setMarginBalance(double d2) {
        double d3 = this.marginBalance;
        this.marginBalance = d2;
        this.firePropertyChange("marginBalance", d3, this.marginBalance);
    }

    public double getMinimumMarginBalance() {
        return this.minimumMarginBalance;
    }

    public void setMinimumMarginBalance(double d2) {
        double d3 = this.minimumMarginBalance;
        this.minimumMarginBalance = d2;
        this.firePropertyChange("minimumMarginBalance", d3, this.minimumMarginBalance);
    }

    public double getInitialMarginEquity() {
        return this.initialMarginEquity;
    }

    public void setInitialMarginEquity(double d2) {
        double d3 = this.initialMarginEquity;
        this.initialMarginEquity = d2;
        this.firePropertyChange("initialMarginEquity", d3, this.initialMarginEquity);
    }

    public double getMarginEquity() {
        return this.marginEquity;
    }

    public void setMarginEquity(double d2) {
        double d3 = this.marginEquity;
        this.marginEquity = d2;
        this.firePropertyChange("marginEquity", d3, this.marginEquity);
    }

    public double getUnclearedDeposit() {
        return this.unclearedDeposit;
    }

    public void setUnclearedDeposit(double d2) {
        double d3 = this.unclearedDeposit;
        this.unclearedDeposit = d2;
        this.firePropertyChange("unclearedDeposit", d3, this.unclearedDeposit);
    }

    public double getExcessEquity() {
        return this.excessEquity;
    }

    public void setExcessEquity(double d2) {
        double d3 = this.excessEquity;
        this.excessEquity = d2;
        this.firePropertyChange("excessEquity", d3, this.excessEquity);
    }

    public double getMorningExcessEquity() {
        return this.morningExcessEquity;
    }

    public void setMorningExcessEquity(double d2) {
        double d3 = this.morningExcessEquity;
        this.morningExcessEquity = d2;
        this.firePropertyChange("morningExcessEquity", d3, this.morningExcessEquity);
    }

    public double getOvernightExcessEquity() {
        return this.overnightExcessEquity;
    }

    public void setOvernightExcessEquity(double d2) {
        double d3 = this.overnightExcessEquity;
        this.overnightExcessEquity = d2;
        this.firePropertyChange("overnightExcessEquity", d3, this.overnightExcessEquity);
    }

    public double getMarginDebit() {
        return this.marginDebit;
    }

    public void setMarginDebit(double d2) {
        double d3 = this.marginDebit;
        this.marginDebit = d2;
        this.firePropertyChange("marginDebit", d3, this.marginDebit);
    }

    public double getPercentEquity() {
        return this.percentEquity;
    }

    public void setPercentEquity(double d2) {
        double d3 = this.percentEquity;
        this.percentEquity = d2;
        this.firePropertyChange("percentEquity", d3, this.percentEquity);
    }

    public double getMarginAvailable() {
        return this.marginAvailable;
    }

    public void setMarginAvailable(double d2) {
        double d3 = this.marginAvailable;
        this.marginAvailable = d2;
        this.firePropertyChange("marginAvailable", d3, this.marginAvailable);
    }

    public double getMarginRate() {
        return this.marginRate;
    }

    public void setMarginRate(double d2) {
        double d3 = this.marginRate;
        this.marginRate = d2;
        this.firePropertyChange("marginRate", d3, this.marginRate);
    }

    public double getMarginUsed() {
        return this.marginUsed;
    }

    public void setMarginUsed(double d2) {
        double d3 = this.marginUsed;
        this.marginUsed = d2;
        this.firePropertyChange("marginUsed", d3, this.marginUsed);
    }

    public double getPositionValue() {
        return this.positionValue;
    }

    public void setPositionValue(double d2) {
        double d3 = this.positionValue;
        this.positionValue = d2;
        this.firePropertyChange("positionValue", d3, this.positionValue);
    }

    public double getCurrentRequirement() {
        return this.currentRequirement;
    }

    public void setCurrentRequirement(double d2) {
        double d3 = this.currentRequirement;
        this.currentRequirement = d2;
        this.firePropertyChange("currentRequirement", d3, this.currentRequirement);
    }

    public double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(double d2) {
        double d3 = this.marketValue;
        this.marketValue = d2;
        this.firePropertyChange("marketValue", d3, this.marketValue);
    }

    public double getTotalEquity() {
        return this.totalEquity;
    }

    public void setTotalEquity(double d2) {
        double d3 = this.totalEquity;
        this.totalEquity = d2;
        this.firePropertyChange("totalEquity", d3, this.totalEquity);
    }

    public double getNetEquity() {
        return this.netEquity;
    }

    public void setNetEquity(double d2) {
        double d3 = this.netEquity;
        this.netEquity = d2;
        this.firePropertyChange("netEquity", d3, this.netEquity);
    }

    public double getOpenTradeEquity() {
        return this.openTradeEquity;
    }

    public void setOpenTradeEquity(double d2) {
        double d3 = this.openTradeEquity;
        this.openTradeEquity = d2;
        this.firePropertyChange("openTradeEquity", d3, this.openTradeEquity);
    }

    public double getTradableFunds() {
        return this.tradableFunds;
    }

    public void setTradableFunds(double d2) {
        double d3 = this.tradableFunds;
        this.tradableFunds = d2;
        this.firePropertyChange("tradableFunds", d3, this.tradableFunds);
    }

    public double getTotalMarginRequirement() {
        return this.totalMarginRequirement;
    }

    public void setTotalMarginRequirement(double d2) {
        double d3 = this.totalMarginRequirement;
        this.totalMarginRequirement = d2;
        this.firePropertyChange("totalMarginRequirement", d3, this.totalMarginRequirement);
    }

    public double getPendingCash() {
        return this.pendingCash;
    }

    public void setPendingCash(double d2) {
        double d3 = this.pendingCash;
        this.pendingCash = d2;
        this.firePropertyChange("pendingCash", d3, this.pendingCash);
    }

    public int getPendingOrders() {
        return this.pendingOrders;
    }

    public void setPendingOrders(int n2) {
        int n3 = this.pendingOrders;
        this.pendingOrders = n2;
        this.firePropertyChange("pendingOrders", n3, this.pendingOrders);
    }

    public boolean supportsInstrument(MWInstrument mWInstrument) {
        if (h.a((Collection)this.supportedTypes)) {
            return true;
        }
        return this.supportedTypes.contains((Object)mWInstrument.getType());
    }

    public boolean supportsInstrument(Enums$InstrumentType enums$InstrumentType) {
        if (h.a((Collection)this.supportedTypes)) {
            return true;
        }
        return this.supportedTypes.contains((Object)enums$InstrumentType);
    }

    public void addSupportedType(Enums$InstrumentType enums$InstrumentType) {
        if (!this.supportedTypes.contains((Object)enums$InstrumentType)) {
            this.supportedTypes.add(enums$InstrumentType);
        }
    }

    public String toString() {
        if (ae.v().size() <= 1 || this.isSimulatedAccount() || this.isReplay()) {
            return this.isUseAccountName() ? this.accountName : this.id;
        }
        as as2 = ae.a(this);
        if (as2 == null) {
            return this.isUseAccountName() ? this.accountName : this.id;
        }
        return as2.a().getName() + " - " + (this.isUseAccountName() ? this.accountName : this.id);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            Account account = (Account)object;
            return h.a((Object)this.id, (Object)account.id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFcmId() {
        return this.fcmId;
    }

    public void setFcmId(String string) {
        this.fcmId = string;
    }

    public double getOpen() {
        return this.open;
    }

    public void setOpen(double d2) {
        double d3 = this.open;
        this.open = d2;
        this.firePropertyChange("open", d3, this.open);
    }

    public double getClosed() {
        return this.closed;
    }

    public void setClosed(double d2) {
        double d3 = this.closed;
        this.closed = d2;
        this.firePropertyChange("closed", d3, this.closed);
    }

    public double getLossLimit() {
        return this.lossLimit;
    }

    public void setLossLimit(double d2) {
        double d3 = this.lossLimit;
        this.lossLimit = d2;
        this.firePropertyChange("lossLimit", d3, this.lossLimit);
    }

    public int getBuyLimit() {
        return this.buyLimit;
    }

    public void setBuyLimit(int n2) {
        int n3 = this.buyLimit;
        this.buyLimit = n2;
        this.firePropertyChange("buyLimit", n3, this.buyLimit);
    }

    public int getSellLimit() {
        return this.sellLimit;
    }

    public void setSellLimit(int n2) {
        int n3 = this.sellLimit;
        this.sellLimit = n2;
        this.firePropertyChange("sellLimit", n3, this.sellLimit);
    }

    public boolean isDayTrading() {
        return this.dayTrading;
    }

    public void setDayTrading(boolean bl2) {
        boolean bl3 = this.dayTrading;
        this.dayTrading = bl2;
        this.firePropertyChange("dayTrading", bl3, this.dayTrading);
    }

    public boolean isLongOnly() {
        return this.longOnly;
    }

    public void setLongOnly(boolean bl2) {
        boolean bl3 = this.longOnly;
        this.longOnly = bl2;
        this.firePropertyChange("longOnly", bl3, this.longOnly);
    }

    public boolean isInterestFree() {
        return this.interestFree;
    }

    public void setInterestFree(boolean bl2) {
        boolean bl3 = this.interestFree;
        this.interestFree = bl2;
        this.firePropertyChange("interestFree", bl3, this.interestFree);
    }

    public int getFreeTradeBalance() {
        return this.freeTradeBalance;
    }

    public void setFreeTradeBalance(int n2) {
        int n3 = this.freeTradeBalance;
        this.freeTradeBalance = n2;
        this.firePropertyChange("freeTradeBalance", n3, this.freeTradeBalance);
    }

    public boolean isIncludeCommission() {
        if (this.isSimulatedAccount()) {
            return Account.isIncludeCommissions();
        }
        return this.includeCommission;
    }

    public static Account getSimulatedAccount() {
        return simAccount;
    }

    public static boolean isSimulatedAccount(String string) {
        if (simAccount == null) {
            return false;
        }
        return h.a((Object)simAccount.getAccountID(), (Object)string);
    }

    public static boolean isSimulatedEnabled() {
        return simulatedEnabled;
    }

    public static void setSimulatedEnabled(boolean bl2) {
        simulatedEnabled = bl2;
    }

    public static boolean isFillMarketImmediate() {
        return fillMarketImmediate;
    }

    public static void setFillMarketImmediate(boolean bl2) {
        fillMarketImmediate = bl2;
    }

    public static boolean isIncludeCommissions() {
        return includeCommissions;
    }

    public static void setIncludeCommissions(boolean bl2) {
        includeCommissions = bl2;
    }

    public static void save() {
        h.c(new File(Workspace.findDir("account"), "account.json"), Account.write());
    }

    public static void write(File file) {
        h.a(file, Account.write());
    }

    private static String write() {
        a a2 = new a();
        List list = h.b(new String[]{a2.a("simEnabled", simulatedEnabled, false), a2.b("defaultAcct", defaultAccountId), a2.a_("idCounter", uniqueCounter), a2.b("baseCurrency", Account.simAccount.baseCurrency), a2.a("cash", simAccount.getCashBalance()), a2.a("totalPL", simAccount.getTotalPL()), a2.a("fillMarketImmediate", fillMarketImmediate), a2.a("includeCommissions", includeCommissions)});
        List list2 = h.b(new q[0]);
        for (Position position : PositionDirectory.getByAccount(simAccount.getAccountID())) {
            list2.add(position);
        }
        list.add(a2.a("positions", (Collection)list2));
        return a2.a((Collection)list);
    }

    public static void read() {
        Account.read(Workspace.findFile("account"));
    }

    private static void read(File file) {
        try {
            simAccount = new Account("simulated");
            Account.simAccount.simulatedAccount = true;
            Account.simAccount.accountName = ai.a("LBL_SIMULATED_ACCOUNT", new Object[0]);
            simAccount.setBalance(100000.0);
            simAccount.setBaseCurrency("USD");
            simAccount.setInitialCashBalance(100000.0);
            simAccount.setCashBalance(100000.0);
            simulatedEnabled = !ae.o();
            simAccount.setDefault(simulatedEnabled);
            if (file != null && file.exists()) {
                JSONObject jSONObject = new JSONObject(h.a(file));
                simulatedEnabled = jSONObject.is("simEnabled", false);
                defaultAccountId = jSONObject.str("defaultAcct");
                uniqueCounter = jSONObject.getLong("idCounter");
                simAccount.setBaseCurrency(jSONObject.str("baseCurrency"));
                simAccount.setBalance(jSONObject.getDouble("cash"));
                simAccount.setCashBalance(jSONObject.getDouble("cash"));
                simAccount.setTotalPL(jSONObject.getDouble("totalPL"));
                fillMarketImmediate = jSONObject.is("fillMarketImmediate");
                includeCommissions = jSONObject.is("includeCommissions");
                if (simulatedEnabled) {
                    List list = jSONObject.getObjList("positions");
                    for (JSONObject jSONObject2 : list) {
                        try {
                            Position position = new Position(jSONObject2);
                            PositionDirectory.created(position);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            } else {
                Account.read(Workspace.get("simulated_account"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadTrades() {
        if (!Account.isSimulatedEnabled()) {
            return;
        }
        List list = TradeHistoryDirectory.loadByAccount(Account.getSimulatedAccount());
        TradeHistoryDirectory.register(list);
    }

    private static void read(String string) {
        Object object;
        Node node;
        if (h.g(string)) {
            return;
        }
        Element element = g.a(string).getDocumentElement();
        simulatedEnabled = h.a((Object)element.getAttribute("enabled"));
        fillMarketImmediate = h.a((Object)element.getAttribute("fillMarketImmediate"));
        includeCommissions = h.a((Object)element.getAttribute("includeCommisions"));
        simAccount.setBaseCurrency(element.getAttribute("baseCurrency"));
        simAccount.setCashBalance(h.a(element.getAttribute("cash")));
        simAccount.setBalance(h.a(element.getAttribute("cash")));
        simAccount.setTotalPL(h.a(element.getAttribute("totalPL")));
        uniqueCounter = h.b(element.getAttribute("idCounter"));
        String string2 = element.getAttribute("defaultAccountID");
        if (h.g(string2)) {
            string2 = element.getAttribute("primaryAccountID");
        }
        if (!h.g(string2)) {
            defaultAccountId = string2;
        }
        if ((node = g.b("positions", element)) != null) {
            object = g.c("position", node).iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                Object object2 = Position.read(element2);
                if (object2 == null) continue;
                PositionDirectory.created((Position)object2);
            }
        }
        if ((object = g.b("orders", element)) != null) {
            for (Object object2 : g.c("order", (Node)object)) {
                MWOrder mWOrder = MWOrder.read((Element)object2);
                if (mWOrder == null) continue;
                mWOrder.setSimulatedOrder(true);
                OrderDirectory.createOrder(mWOrder);
                mWOrder.createHandler();
            }
        }
    }

    public static String genUniqueID() {
        return "SIM-" + uniqueCounter++;
    }

    public static String genUniqueReplayID() {
        return "RPLY-" + uniqueReplayCounter++;
    }

    public static String getDefaultAccountID() {
        return defaultAccountId;
    }

    public static void setDefaultAccountID(String string) {
        defaultAccountId = string;
    }

    static {
        fillMarketImmediate = true;
        includeCommissions = true;
        uniqueCounter = 1L;
        uniqueReplayCounter = 1L;
    }
}

