/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.common;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums;

public enum Enums$InstrumentType {
    STOCK("TYPE_STOCK", "S"),
    FUTURE("TYPE_FUTURE", "F"),
    INDEX("TYPE_INDEX", "I"),
    INDICATOR("TYPE_INDICATOR", "IND"),
    CASH("TYPE_CASH", "FX"),
    CURRENCY_OPTION("TYPE_CURRENCY_OPTION", "CO"),
    OPTION("TYPE_STOCK_OPTION", "O"),
    FUTURE_OPTION("TYPE_FUTURE_OPTION", "FO"),
    INDEX_OPTION("TYPE_INDEX_OPTION", "IO"),
    COMMODITY("TYPE_COMMODITY", "CMDY"),
    MUTUAL_FUND("TYPE_MUTUAL_FUND", "MF"),
    ASSET("TYPE_ASSET", "A"),
    BOND("TYPE_BOND", "B"),
    CORP_BOND("TYPE_CORP_BOND", "CB"),
    GOV_BOND("TYPE_GOV_BOND", "GB"),
    MM_FUND("TYPE_MMFUND", "MMF"),
    STRATEGY("TYPE_STRATEGY", "STRAT"),
    MKTSTATS("TYPE_MKTSTATS", "MS"),
    SPREAD("TYPE_SPREAD", "SP"),
    RATIO("TYPE_RATIO", "R"),
    SPOT("TYPE_SPOT", "SPT"),
    FORWARD("TYPE_FORWARD", "FWD"),
    CALC("TYPE_CALC", "CAL"),
    STRIP("TYPE_STRIP", "STRP"),
    SS_FUTURE("TYPE_SSFUTURE", "SSF"),
    FUTDEPTH("TYPE_FUTDEPTH", "FD"),
    PRECMTL("TYPE_PRECMTL", "P"),
    SPRDEPTH("TYPE_SPRDEPTH", "SD"),
    EQTYDEPTH("TYPE_EQTYDEPTH", "ED"),
    ICSSPREAD("TYPE_ICSSPREAD", "IS"),
    STRATSPREAD("TYPE_STRATSPREAD", "SS"),
    TREASURIES("TYPE_TREASURIES", "T"),
    SWAPS("TYPE_SWAPS", "SW"),
    CFD("TYPE_CFD", "CFD"),
    WARRANT("TYPE_WARRANT", "W"),
    GLOBAL_INDEX("TYPE_GLOBAL_INDEX", "GI"),
    CUSTOM("TYPE_CUSTOM", "CUST"),
    RIGHT("TYPE_RIGHT", "RI"),
    GOLD("TYPE_GOLD", "G"),
    CRYPTO_CURRENCY("TYPE_CRYPTO_CURRRENCY", "CC"),
    CONT_FUTURE("TYPE_CONT_FUTURE", "CT"),
    UNKNOWN("TYPE_UNKNOWN", "U");

    private String label;
    private String shortCode;

    /*
     * WARNING - void declaration
     */
    private Enums$InstrumentType() {
        void var4_1;
        void var3_2;
        this.label = Enums.a((String)var3_2, new Object[0]);
        this.shortCode = var4_1;
    }

    public Enums$InstrumentType getOptionRoot() {
        switch (this) {
            case OPTION: {
                return STOCK;
            }
            case FUTURE_OPTION: {
                return FUTURE;
            }
            case CURRENCY_OPTION: {
                return CASH;
            }
            case INDEX_OPTION: {
                return INDEX;
            }
        }
        return this;
    }

    public Enums$InstrumentType getOptionType() {
        switch (this) {
            case STOCK: {
                return OPTION;
            }
            case OPTION: {
                return OPTION;
            }
            case FUTURE: {
                return FUTURE_OPTION;
            }
            case FUTURE_OPTION: {
                return FUTURE_OPTION;
            }
            case CURRENCY_OPTION: {
                return CURRENCY_OPTION;
            }
            case CASH: {
                return CURRENCY_OPTION;
            }
            case INDEX_OPTION: {
                return INDEX_OPTION;
            }
            case INDEX: {
                return INDEX_OPTION;
            }
        }
        return null;
    }

    public boolean isOption() {
        return this == OPTION || this == FUTURE_OPTION || this == CURRENCY_OPTION || this == INDEX_OPTION;
    }

    public boolean isFuture() {
        return this == FUTURE || this == CONT_FUTURE;
    }

    public boolean hasExpiry() {
        return h.a((Object)this, new Object[]{FUTURE, CONT_FUTURE, OPTION, FUTURE_OPTION, CURRENCY_OPTION, INDEX_OPTION});
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public String toString() {
        return this.label;
    }

    public static Enums$InstrumentType fromShortCode(String string) {
        switch (string) {
            case "S": {
                return STOCK;
            }
            case "F": {
                return FUTURE;
            }
            case "I": {
                return INDEX;
            }
            case "IND": {
                return INDICATOR;
            }
            case "FX": {
                return CASH;
            }
            case "O": {
                return OPTION;
            }
            case "CO": {
                return CURRENCY_OPTION;
            }
            case "FO": {
                return FUTURE_OPTION;
            }
            case "IO": {
                return INDEX_OPTION;
            }
            case "CMDY": {
                return COMMODITY;
            }
            case "MF": {
                return MUTUAL_FUND;
            }
            case "A": {
                return ASSET;
            }
            case "B": {
                return BOND;
            }
            case "CB": {
                return CORP_BOND;
            }
            case "GB": {
                return GOV_BOND;
            }
            case "MMF": {
                return MM_FUND;
            }
            case "STRAT": {
                return STRATEGY;
            }
            case "MS": {
                return MKTSTATS;
            }
            case "SP": {
                return SPREAD;
            }
            case "R": {
                return RATIO;
            }
            case "SPT": {
                return SPOT;
            }
            case "FWD": {
                return FORWARD;
            }
            case "CAL": {
                return CALC;
            }
            case "STRP": {
                return STRIP;
            }
            case "SSF": {
                return SS_FUTURE;
            }
            case "FD": {
                return FUTDEPTH;
            }
            case "P": {
                return PRECMTL;
            }
            case "SD": {
                return SPRDEPTH;
            }
            case "ED": {
                return EQTYDEPTH;
            }
            case "IS": {
                return ICSSPREAD;
            }
            case "SS": {
                return STRATSPREAD;
            }
            case "T": {
                return TREASURIES;
            }
            case "SW": {
                return SWAPS;
            }
            case "CFD": {
                return CFD;
            }
            case "W": {
                return WARRANT;
            }
            case "GI": {
                return GLOBAL_INDEX;
            }
            case "CUST": {
                return CUSTOM;
            }
            case "RI": {
                return RIGHT;
            }
            case "G": {
                return GOLD;
            }
            case "CC": {
                return CRYPTO_CURRENCY;
            }
            case "CT": {
                return CONT_FUTURE;
            }
            case "U": {
                return UNKNOWN;
            }
        }
        h.a.warning("Enums.InstrumentType::fromShortCode() unmapped short code: " + string);
        return UNKNOWN;
    }
}

